/*
 * Decompiled with CFR 0.152.
 */
package org.yriarte.math;

public class Matrix {
    protected int nLines;
    protected int nCols;
    protected double[][] cell;

    public Matrix() {
        this.nLines = 0;
        this.nCols = 0;
    }

    public Matrix(int lines, int cols) {
        this.nLines = lines;
        this.nCols = cols;
        this.cell = new double[this.nLines][this.nCols];
        this.toZero();
    }

    public Matrix(int lines, int cols, double[][] cell) {
        this.nLines = lines;
        this.nCols = cols;
        this.cell = cell;
    }

    public String toString() {
        String str = "[";
        int i = 0;
        while (i < this.nLines) {
            if (i > 0) {
                str = str.concat(",");
            }
            str = str.concat("[");
            int j = 0;
            while (j < this.nCols) {
                if (j > 0) {
                    str = str.concat(",");
                }
                str = str.concat(new Double(this.cell[i][j]).toString());
                ++j;
            }
            str = str.concat("]");
            ++i;
        }
        str = str.concat("]");
        return str;
    }

    public double[][] getCell() {
        return this.cell;
    }

    public Matrix setCell(double[][] cell) {
        this.cell = cell;
        return this;
    }

    public int getNCols() {
        return this.nCols;
    }

    public int getNLines() {
        return this.nLines;
    }

    public boolean isZero() {
        int i = 0;
        while (i < this.nLines) {
            int j = 0;
            while (j < this.nCols) {
                if (this.cell[i][j] != 0.0) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public Matrix toZero() {
        int i = 0;
        while (i < this.nLines) {
            int j = 0;
            while (j < this.nCols) {
                this.cell[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        return this;
    }

    public boolean isId() {
        int i = 0;
        while (i < this.nLines) {
            int j = 0;
            while (j < this.nCols) {
                if (this.cell[i][j] != 0.0 && (i != j || this.cell[i][j] != 1.0)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public Matrix toId() {
        this.toZero();
        int i = 0;
        while (i < this.nLines) {
            this.cell[i][i] = 1.0;
            ++i;
        }
        return this;
    }

    public Matrix mul(Matrix aMatrix) {
        Matrix mResult = new Matrix(this.nLines, aMatrix.nCols);
        int i = 0;
        while (i < mResult.nLines) {
            int j = 0;
            while (j < mResult.nCols) {
                mResult.cell[i][j] = 0.0;
                int k = 0;
                while (k < this.nCols) {
                    double[] dArray = mResult.cell[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.cell[i][k] * aMatrix.cell[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return mResult;
    }

    public Matrix add(Matrix aMatrix) {
        Matrix mResult = new Matrix(this.nLines, this.nCols);
        int i = 0;
        while (i < mResult.nLines) {
            int j = 0;
            while (j < mResult.nCols) {
                mResult.cell[i][j] = this.cell[i][j] + aMatrix.cell[i][j];
                ++j;
            }
            ++i;
        }
        return mResult;
    }

    public Matrix addThis(Matrix aMatrix) {
        int i = 0;
        while (i < this.nLines) {
            int j = 0;
            while (j < this.nCols) {
                this.cell[i][j] = this.cell[i][j] + aMatrix.cell[i][j];
                ++j;
            }
            ++i;
        }
        return this;
    }

    public Matrix sub(Matrix aMatrix) {
        Matrix mResult = new Matrix(this.nLines, this.nCols);
        int i = 0;
        while (i < mResult.nLines) {
            int j = 0;
            while (j < mResult.nCols) {
                mResult.cell[i][j] = this.cell[i][j] - aMatrix.cell[i][j];
                ++j;
            }
            ++i;
        }
        return mResult;
    }

    public Matrix subThis(Matrix aMatrix) {
        int i = 0;
        while (i < this.nLines) {
            int j = 0;
            while (j < this.nCols) {
                this.cell[i][j] = this.cell[i][j] - aMatrix.cell[i][j];
                ++j;
            }
            ++i;
        }
        return this;
    }

    public Matrix mulNum(double aNumber) {
        Matrix mResult = new Matrix(this.nLines, this.nCols);
        int i = 0;
        while (i < mResult.nLines) {
            int j = 0;
            while (j < mResult.nCols) {
                mResult.cell[i][j] = this.cell[i][j] * aNumber;
                ++j;
            }
            ++i;
        }
        return mResult;
    }

    public Matrix addNum(double aNumber) {
        Matrix mResult = new Matrix(this.nLines, this.nCols);
        int i = 0;
        while (i < mResult.nLines) {
            int j = 0;
            while (j < mResult.nCols) {
                mResult.cell[i][j] = this.cell[i][j] + aNumber;
                ++j;
            }
            ++i;
        }
        return mResult;
    }

    public Matrix mulNumThis(double aNumber) {
        int i = 0;
        while (i < this.nLines) {
            int j = 0;
            while (j < this.nCols) {
                this.cell[i][j] = this.cell[i][j] * aNumber;
                ++j;
            }
            ++i;
        }
        return this;
    }

    public Matrix addNumThis(double aNumber) {
        int i = 0;
        while (i < this.nLines) {
            int j = 0;
            while (j < this.nCols) {
                this.cell[i][j] = this.cell[i][j] + aNumber;
                ++j;
            }
            ++i;
        }
        return this;
    }

    public Matrix addMulNumThis(Matrix aMatrix, double aNumber) {
        int i = 0;
        while (i < this.nLines) {
            int j = 0;
            while (j < this.nCols) {
                double[] dArray = this.cell[i];
                int n = j;
                dArray[n] = dArray[n] + aMatrix.cell[i][j] * aNumber;
                ++j;
            }
            ++i;
        }
        return this;
    }

    public Matrix transpose() {
        Matrix mResult = new Matrix(this.nCols, this.nLines);
        int i = 0;
        while (i < mResult.nLines) {
            int j = 0;
            while (j < mResult.nCols) {
                mResult.cell[i][j] = this.cell[j][i];
                ++j;
            }
            ++i;
        }
        return mResult;
    }

    public Matrix minor(int iM, int jM) {
        int j;
        Matrix mResult = new Matrix(this.nLines - 1, this.nCols - 1);
        int i = 0;
        while (i < iM) {
            j = 0;
            while (j < jM) {
                mResult.cell[i][j] = this.cell[i][j];
                ++j;
            }
            j = jM + 1;
            while (j < this.nCols) {
                mResult.cell[i][j - 1] = this.cell[i][j];
                ++j;
            }
            ++i;
        }
        i = iM + 1;
        while (i < this.nLines) {
            j = 0;
            while (j < jM) {
                mResult.cell[i - 1][j] = this.cell[i][j];
                ++j;
            }
            j = jM + 1;
            while (j < this.nCols) {
                mResult.cell[i - 1][j - 1] = this.cell[i][j];
                ++j;
            }
            ++i;
        }
        return mResult;
    }

    public double det() {
        if (this.nLines == 2) {
            return this.cell[0][0] * this.cell[1][1] - this.cell[0][1] * this.cell[1][0];
        }
        if (this.nLines == 1) {
            return this.cell[0][0];
        }
        double determinant = 0.0;
        double sign = 1.0;
        int j = 0;
        while (j < this.nCols) {
            Matrix minorIJ = this.minor(0, j);
            double detIJ = minorIJ.det();
            determinant += sign * detIJ * this.cell[0][j];
            sign = -sign;
            ++j;
        }
        return determinant;
    }

    public Matrix cofactors() {
        if (this.nLines == 1) {
            return this;
        }
        Matrix mResult = new Matrix(this.nCols, this.nLines);
        int i = 0;
        while (i < mResult.nLines) {
            int j = 0;
            while (j < mResult.nCols) {
                Matrix minorIJ = this.minor(i, j);
                double detIJ = minorIJ.det();
                mResult.cell[i][j] = detIJ * Math.pow(-1.0, i + j);
                ++j;
            }
            ++i;
        }
        return mResult;
    }

    public Matrix inv() {
        double determinant = this.det();
        Matrix mResult = this.cofactors();
        mResult = mResult.transpose();
        mResult = mResult.mulNum(1.0 / determinant);
        return mResult;
    }
}

