#R course, lesson 1, 5/26/09
#creating objects
x <- 7

8 -> y

#exponents
N <- 2.1e23

#playing with modes, coercing modes
nothing <-NA
false <- FALSE
is.numeric(nothing); is.numeric(false)
is.logical(nothing); is.logical(false)
as.numeric(nothing); as.numeric(false)
as.character(nothing); as.character(false)


name <- "Carmen"; n1 <- 10; n2 <- 100; m <- 0.5
M <- data.frame(n1, n2, m)

# displaying information about objects

x; y	# show values
#show different modes
A <- "Gomphotherium"; compar <- TRUE; z <- 1i
mode(A); mode(compar); mode(z)

attributes(M)


#ls function

ls()
ls.str()



#Examples
.Ob <- 1
ls(pattern = "O")
ls(pattern= " O", all.names = TRUE)    # also shows ".[foo]"

#shows an empty list because inside myfunc no variables are defined
myfunc <- function() {ls()}
myfunc()

#now define a local variable inside myfunc
myfunc <- function() {temp <- 1; ls()}
myfunc()		# shows "temp" -- but,
ls()			# does not show "temp" because it was defined with in myfunc

#read in data from file
#to standard output
read.csv("0208_data_sum.csv")
#to object (data.frame)

baso <- read.csv("0208_data_sum.csv")

ls()		#now see that 'baso' object is present in working memory

#get information about new object

dim(baso); attributes(baso)

#working with data within objects '$'

names(baso)
ls.str(pat="baso")


summary(baso$fMLP)	#fMLP is numeric
levels(baso$wash_status)	#wash_status is a factor


#example for baso paper
# create table for comparison of groups accross stimulants using ech visitID as unique -- note some duplicate patients at multiple time points

# use only wash_status 'no' data
baso_washless <- subset(baso, wash_status == "n")
# exclude non-responders
baso_washless <- subset(baso_washless, Responder==1)

tmp <- data.frame(ID=baso_washless$visit_ID, group=baso_washless$STATUS, stim=c(array("E1", length(baso_washless$E1)), array("E2", length(baso_washless$E2)),array("E3", length(baso_washless$E3)), array("E4", length(baso_washless$E4)), array("E5", length(baso_washless$E5)), array("E6", length(baso_washless$E6))), CD63=c(baso_washless$E1, baso_washless$E2, baso_washless$E3, baso_washless$E4, baso_washless$E5, baso_washless$E6), HMCD63=c(baso_washless$HM_E1, baso_washless$HM_E2, baso_washless$HM_E3, baso_washless$HM_E4, baso_washless$HM_E5, baso_washless$HM_E6))

# define factors
groupf <- tmp$group
stimf <- tmp$stim
agg <- by(tmp$CD63, list(stimf, groupf), fivenum)

# plot figure 1A
quartz(,10,5)
boxplot(agg, ylab="%CD63", cex.lab=1.4, names=array(c("E1", "E2", "E3", "E4", "E5", "E6"),24), outline=FALSE); abline(v=c(6.5, 12.5, 18.5), lty=3)
mtext("Allergic", 3, line=1, at=3.5)
mtext("Control", 3, line=1, at=9.5)
mtext("HM tolerant", 3, line=1, at=15.5)
mtext("Outgrown", 3, line=1, at=21.5)
mtext("A", cex=4, at=-1)

# removing objects

ls()
ls()[5]

rm()[5]
rm(list=ls())
