% 
% mM to gram conversions
% 
mm2gGlu    = 0.18018;     
mm2gAmm    = 0.018038;
percentAmm = 36/132;

%
% dilution rate
%
q   = 0.03;
%
% feed rates for the four cases
%
uu  = [25;25;46;46];
vv  = [5;5;0.65;0.65]*percentAmm; % corrected for actual feed in Tai
%
% growth rate found by Leanne in the literature and verified in DL
% Values of K and L from optimization
%
rv = [0.08;0.46;0.08;0.46];
K  = 0.8;
% L  = 0.04;
L  = 0.04;

%
% case names
%
experimentCase    = cell(4,1);
experimentCase{1} = '12 degree Glucose limited';
experimentCase{2} = '30 degree Glucose limited';
experimentCase{3} = '12 degree Ammonium limited';
experimentCase{4} = '30 degree Ammonium limited';
%
% residual concentrations from Tai et al (2007)
%
rG = [2.8;0.3;90;85.1]*mm2gGlu
rA = [65.2;61.3;1.5;0.2]*mm2gAmm

%
% new E(y)
%

%
% yields from Tai et al (2007)
%
Y  = [0.07;0.07;0.05;0.04];
E  = 0.363*rG + 14.11; %for 12 degrees C
% E = 0.7y + 14.25 use this instead for 30 degrees C
%
% steady state biomass
%
bioMass = (uu-rG)./E
%
% rate parameters estimated from modeling
%
F = (vv-rA)./bioMass

