from psychopy import *
from random import random
import numpy
import pygame.mixer
mixer = pygame.mixer
import wave
import sys
from numpy import sin, cos, pi

HZ=160

#set up sound stuff
#choose a desired audio format
mixer.init(11025) #raises exception on fail
#end setting up sound stuff
#load the sound    
file = '1500Hz_10ms.wav'
sound = mixer.Sound(file)

#make a text file to save the data
fileName = 'nom'
dataFile = open(fileName+'.txt', 'w')
dataFile.write('subj\t trial\t orflash\t orresp\t   freq\t number\t direction\t radius\t window\t error\n')

#create window and stimuli
trialClock = core.Clock()
win = visual.Window(monitor='G810',fullscr=1,rgb=-1,units ='deg')
#win = visual.Window([800,600],allowGUI=True,monitor="g810", units="deg")
win.setMouseVisible(False)
#win = visual.Window([500,768],allowGUI=False,monitor="sony", units="deg")
#win = visual.Window([1024,768],allowGUI=False,monitor="sony", units="deg")

# stimuli
fixation = visual.PatchStim(win, rgb=1, tex=None,mask='circle', size=0.4,depth=-1)
fixation2 = visual.PatchStim(win, rgb=[1,-1,-1], tex=None,mask='circle', size=40,depth=-1)
sti1 = visual.PatchStim(win,mask='gauss', rgb=1, size=1.5,tex=None)

#trials
stimList = []
#for freq in [0.5, 0.75, 1, 1.25, 1.5, 2.5, 3.5]:
for freq in [2.5,3.5]:
  for window in [0,0.25,0.5,0.75,1]:
    for number in [1]:
        for direction in [1,-1]:
          for radius in [2]:
            stimList.append( 
                        {'freq':freq, 'window':window, 'number':number, 'direction':direction, 'radius':radius }
                       )
   
trials = data.TrialHandler(stimList,15)

nDone=1
core.wait(1)

for thisTrial in trials:
    #### MOVEMENT ########################################################
    INITIAL_ANGLE=random()*360
    T_SIGNAL=1
    T_AIR=T_SIGNAL+1+thisTrial['window']
    T_RESP=T_AIR+1
    t0=trialClock.getTime()
    t=0
    frame=0
    FLASH=False
    while t<T_RESP:
        t=trialClock.getTime()-t0
            
        Orientation = INITIAL_ANGLE + thisTrial['direction']*360*frame/HZ*thisTrial['freq']
            
        for index in range(thisTrial['number']):
            x=thisTrial['radius']*cos( (360/thisTrial['number']*index+Orientation)/180*pi )
            y=thisTrial['radius']*sin( (360/thisTrial['number']*index+Orientation)/180*pi )   
            sti1.setPos([x,y])
            sti1.draw()

        if t>T_AIR and FLASH==False:
        	#fixation.setRGB([1,-1,-1])
        	FLASH=True
        	#play sound (temporal cue)
        	channel = sound.play()
        	
        	OrientationFlash=Orientation%360
	

        if t>T_AIR:
        	#fixation.draw()
        	fixation2.draw()
        else:
        	fixation.draw()
			
        win.update()
        frame +=1
        
        for key in event.getKeys():
            if key in ['escape','q']:
                dataFile.close()
                core.quit() 

    #### RESPONSE ######################################################## 
    OrientationResponse=random()*360
    mouse_dX,mouse_dY = event.mouse.get_rel()
    STOP=False
    Response=-1
    fixation.setRGB([1,1,1])
    xx=0
      
    while not STOP:
        mouse_dX,mouse_dY = event.mouse.get_rel()
        mouse1, mouse2, mouse3 = event.mouse.get_pressed()
        
        if mouse1:
          
          for index in range(thisTrial['number']):

            Or=360/thisTrial['number']*index+OrientationResponse
              
            if Or>OrientationFlash:
                if Or-OrientationFlash<180:
                    ResponseProvisional=Or-OrientationFlash
                else:
                    ResponseProvisional=-(360-Or+OrientationFlash)
            else:
                if OrientationFlash-Or<180:
                    ResponseProvisional=-(OrientationFlash-Or)
                else:
                    ResponseProvisional=360-OrientationFlash+Or

            if thisTrial['direction']==-1:
                ResponseProvisional=-ResponseProvisional

            if index==0:
                Response=ResponseProvisional
            elif abs(ResponseProvisional)<abs(Response):
                Response=ResponseProvisional


                           
          dataFile.write('%s\t %i\t %f\t %f\t %f\t %f\t %f\t %f\t %f\t %f\n' %(fileName,
                                                             nDone,
                                                             OrientationFlash,
                                                             OrientationResponse,
                                                             thisTrial['freq'],
                                                             thisTrial['number'],
                                                             thisTrial['direction'],
                                                             thisTrial['radius'],
                                                             thisTrial['window'],
                                                             Response))
          STOP=True
          nDone +=1
          event.clearEvents()
          

        OrientationResponse+=mouse_dY
        OrientationResponse=OrientationResponse%360

        for index in range(thisTrial['number']):

            x=thisTrial['radius']*cos( (360/thisTrial['number']*index+OrientationResponse)/180*pi )
            y=thisTrial['radius']*sin( (360/thisTrial['number']*index+OrientationResponse)/180*pi )   
            sti1.setPos([x,y])
            sti1.draw()
            
        fixation.draw()
        win.update()
        

#closing the file
dataFile.close()
core.quit()

