package bicat.base;

import java.io.File;
//File Manipulation
import java.io.BufferedInputStream;
import java.io.DataInputStream;
//import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
//java.io.PrintWriter
import java.io.PrintWriter;
import java.io.FileWriter;
import java.io.BufferedWriter;
//import util
import java.util.*;

import bicat.preprocessor.Preprocessor;
import bicat.preprocessor.PreprocessOption;
import bicat.preprocessor.FileOffsetException;
import bicat.biclustering.*;
import bicat.run_machine.*;

public class BimaxBicluster{

    //BiCluster
    public static Preprocessor pre;
    //public Preprocessor pre;
    //public static PreprocessOption preprocessOptions;
    public PreprocessOption preprocessOptions;
    //public static int logBaseSetting;
    public int logBaseSetting;
    //public static boolean preprocessComplete;
    public boolean preprocessComplete;
    //public static boolean preprocessExtended;
    public boolean preprocessExtended;
    //public static boolean processExtended;
    public boolean processExtended;
    //static boolean discretizeExtended;
    boolean discretizeExtended;
    //static boolean discretizeComplete;
    boolean discretizeComplete;
    //public static Dataset currentDataset = null;
    public Dataset currentDataset = null;
    //public static int currentDatasetIdx = 0;
    public int currentDatasetIdx = 0;
    public static float[][] rawData;
    //public float[][] rawData;
    //public static LinkedList datasetList = null;
    public LinkedList datasetList = null;
    public static double discretizationThreshold;
    public static String currentDirectoryPath;
    public static boolean dataAndChipInformationLoaded;
    public static int gpDistanceThreshold;

    public static float hammingDistance;
    public static int fileOffset;

    public static boolean debug = true;
    boolean norm_gs;

    /** Used to perform biclustering: RunMachine for BiMax */
    public static RunMachine_BiMax runMachineBiMax;

    public BimaxBicluster() {
		// main window
		//super("BicAT");

		// Set the default settings:

		try {
			File f = new File(".");
			currentDirectoryPath = f.getCanonicalPath();
		} catch (Exception e) {
			System.out.println(e.getMessage());
			// System.exit(10);
		}

		datasetList = new LinkedList();
		preprocessOptions = new PreprocessOption();

		dataAndChipInformationLoaded = false; // mada konnte schon auch true -
		// default sein! boh
		// (02.06.2004)

		discretizeComplete = false;
		preprocessComplete = false;

		discretizeExtended = false;
		preprocessExtended = false;
		processExtended = false;

		fileOffset = 1; // assuming the data file has BOTH the column and row
		// headers
		logBaseSetting = 2;
		//discretizationThreshold = (float) 2.0; // 1.0 <=> 2-fold change (when
		// Log Base is 2)
		discretizationThreshold = 2.0;
		// post-processing stuff:
		gpDistanceThreshold = 0; // correct this! (so to have only the
		// induced subgraph (degree should be
		// thresholded, as well!))
		hammingDistance = (float) 0.8; // should be user-input, though! (20 %)

		/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
    }

    /*public static void main(String argv[]) {
        final BimaxBicluster frame = new BimaxBicluster();
        //BimaxBicluster bb=new BimaxBicluster();
        pre = new Preprocessor(frame);
        //LoadData ldw = new LoadData(this);

        frame.loadData("dataSample_1.txt",1,1);
        frame.setPreprocessRun();
        frame.runBiMax();
    }*/
	//BiCluster LoadData
	//public void loadData(File file, int colOffset, int rowOffset) {
        public void loadData(String fileName, int colOffset, int rowOffset) {

		try {

                        File file = new File(fileName); // BicatGui.currentDirectoryPath

			if (debug)
				System.out.println("Opening: " + file.getName() + ".");

			//pre = new Preprocessor();
			pre.readMainDataFile(file, colOffset, rowOffset);

			// get the last loaded dataset be the current one ...
                        /*if(pre.getOriginalData()==null) System.out.println("pre.getOriginalData is null");
                        if(pre.getDiscreteData()==null) System.out.println("pre.getDiscreteData is null");
                        if(pre.getGeneNames()==null) System.out.println("pre.getGeneNames is null");
                        if(pre.getChipNames()==null) System.out.println("pre.getChipNames is null");
                        if(pre.getWorkingChipNames()==null) System.out.println("pre.getWorkingChipNames is null");
                        if(pre.getHeaderColumnLabels()==null) System.out.println("pre.getHeaderColumnLabels is null");
                        if(pre.getHeaderColumns()==null) System.out.println("pre.getHeaderColumns is null");*/
			System.out.println("addDataset");
                        addDataset(pre.getOriginalData(), pre.getOriginalData(), pre
				.getDiscreteData(), // (true) ?
				pre.getGeneNames(), pre.getChipNames(), pre
						.getWorkingChipNames(),
				pre.getHeaderColumnLabels(), pre.getHeaderColumns());
			System.out.println("finish addDataset");
			// make sure BicaGUI has the data and display it in the PicturePane
			/*setData(currentDataset.getOrigData());
			pp.setData(rawData);
			readjustPictureSize();
			pp.repaint();*/

			/*
			 * ... add the new labels... labels = pre.getHeaderColumnLabels();
			 * for(int i = 0; i < labels.size(); i++) { JMenuItem mi = new
			 * JMenuItem("Label by \""+(String)labels.get(i)+"\"");
			 * mi.setActionCommand(""+i); mi.addActionListener(this);
			 * labelMenu.add(mi); }
			 */

			//updateColumnHeadersMenu(); // does the same twice?

			/*buildTree();
			tree.setSelectionPath(originalPath);*/
		} catch (FileOffsetException ee) {
			//BicatError.wrongOffsetError();
		}
	}//BiCluster loadData

	//BiCluster setPreprocessRun
	//public void setPreprocessRun(PreprocessOption po) {
	public void setPreprocessRun() {

		boolean bNormal=true;
		/*if (debug)
			System.out.println("What current Dataset is it? "
					+ currentDatasetIdx);*/
		//double discretizationThreshold=2.0;
                //discretizationThreshold=2;
		//preprocessOptions = new PreprocessOption(po);
		preprocessOptions = new PreprocessOption("default");
		preprocessOptions = new PreprocessOption();

		//set gene normalization
		if (bNormal){
			norm_gs = true;
			preprocessOptions.setNormalization();
			preprocessOptions.setGeneNormalization();
			//set normalization scheme
			preprocessOptions.setNormalizationScheme(PreprocessOption.PREPROCESS_OPTIONS_NORMALIZATION_MEAN_CENTRING);
		}
		//set discretization
		preprocessOptions.setDiscretizationTrue();
		preprocessOptions.setDiscretizationScheme(PreprocessOption.PREPROCESS_OPTIONS_DISCRETIZATION_UP);
		preprocessOptions.setDiscretizationThreshold(discretizationThreshold);
		preprocessOptions.setDiscretizationMode("threshold");
		//ones percentage
		//preprocessOptions.setOnesPercentage(onesPercentage);
		//preprocessOptions.setOnesPercentage(10);
		//preprocessOptions.setDiscretizationMode("onesPercentage");

		System.out.println("APPLY preprocessing");

		preprocessOptions.setLogarithmBase(new Integer(2));

		//if (po.do_compute_logarithm)
		if (preprocessOptions.do_compute_logarithm)
			logBaseSetting = preprocessOptions.logarithmBase;

		if (preprocessOptions.do_normalize) { /* ... */
		}

		if (preprocessOptions.do_discretize) {

			if (preprocessOptions.discretizationScheme == PreprocessOption.PREPROCESS_OPTIONS_DISCRETIZATION_COEXPRESSED)
				preprocessExtended = true;
			else
				preprocessExtended = false;
		}

		// ....
		System.out.println("point 1");
		//pre.resetData(currentDataset.getOrigData());
		System.out.println("point 2");
		pre.preprocessData(preprocessOptions);
		System.out.println("point 3");
		System.out.println("Preprocessing with setup: \n" + preprocessOptions.toString());

		// ....
		if (preprocessOptions.discretizationScheme == PreprocessOption.PREPROCESS_OPTIONS_DISCRETIZATION_COEXPRESSED) {
			processExtended = true;
			discretizeExtended = true;
		}

		discretizeComplete = true;
		preprocessComplete = true; // preprocessed data are now available

		// show results to user
		/*setData(pre.getPreprocessedData());
		pp.setData(rawData);
		readjustPictureSize();
		pp.repaint();*/

		// ... update the just-processed data
		if (preprocessExtended)
			currentDataset.setExtended();
		else
			currentDataset.resetExtended();

		currentDataset.setPreData(pre.getPreprocessedData());

		if (preprocessOptions.do_discretize) {
			currentDataset.setDiscrData(pre.getDiscreteData());
		} // binary,
		// or
		// discrete
		// currentDataset.setVisualDiscrData(pre.getDiscreteData()); // discrete
		currentDataset.setPreprocessComplete();
		/*float[][] ppd=pre.getPreprocessedData();

		for (int i=0;i<ppd.length;i++)
			for(int j=0;j<ppd[0].length;j++)
				System.out.println(ppd[i][j]);*/
		int[][] disd=currentDataset.getDiscrData();

		for (int i=0;i<disd.length;i++)
			for(int j=0;j<disd[0].length;j++)
				System.out.println(disd[i][j]);

	}//BiCluster setPreprocessRun

        public void runBiMax(){
            int genes = 2;//DEFAULT_GENES_VALUE;
            int chips = 2;//DEFAULT_CHIPS_VALUE;

			System.out.println("runBiMax");
            runMachineBiMax = new RunMachine_BiMax(this);

            ArgumentsBiMax bmxa = new ArgumentsBiMax();

            float[][] data = currentDataset.getPreData();
            int[][] discreteData = currentDataset.getDiscrData();
            // correct the discrete matrix into binary matrix (needed
            // for BiMax)
            for (int i = 0; i < discreteData.length; i++)
                for (int j = 0; j < discreteData[0].length; j++)
                    if (discreteData[i][j] == -1)
                        discreteData[i][j] = 1;

            bmxa.setBinaryData(discreteData);
            if (data.length == discreteData.length)
				bmxa.setExtended(false);
            else
            	bmxa.setExtended(true);

            bmxa.setGeneNumber(data.length);
            bmxa.setChipNumber(data[0].length);

            bmxa.setDatasetIdx(currentDatasetIdx);
            bmxa.setPreprocessOptions(preprocessOptions);

            bmxa.setMinGenes(genes);
            bmxa.setMinChips(chips);

			if (bmxa.getBinaryDataAsVector()==null) System.out.println("bmxa.getBinaryDataAsVector() is null");
			//if (bmxa.getGeneNumber()==null)
			System.out.println("bmxa.getGeneNumber()"+ bmxa.getGeneNumber());
			//if (bmxa.getChipNumber()==null)
			System.out.println("bmxa.getChipNumber()"+ bmxa.getChipNumber());
			//if (bmxa.getMinGenes()==null)
			System.out.println("bmxa.getMinGenes() "+ bmxa.getMinGenes());
			//if (bmxa.getMinChips()==null)
			System.out.println("bmxa.getMinChips() "+ bmxa.getMinChips());


            for (int i = 0; i < 300000000; i++) {} // wait a bit
				runMachineBiMax.runBiclustering(bmxa);

        }

        public static void setData(int[][] dataMatrix) {

		float[][] intDataMatrix = new float[dataMatrix.length][dataMatrix[0].length];
		for (int i = 0; i < dataMatrix.length; i++)
			for (int j = 0; j < dataMatrix[0].length; j++)
				intDataMatrix[i][j] = (float) dataMatrix[i][j];

		//setData(intDataMatrix);
		/**
		 * TEST, 30.03.2005: rawData = new
		 * float[dataMatrix.length][dataMatrix[0].length]; for(int i=0; i<dataMatrix.length;
		 * i++) for(int j=0; j<dataMatrix[0].length; j++) { rawData[i][j] =
		 * (float)dataMatrix[i][j]; //if(Preprocessor.DISCRETE_MISSING_VALUE ==
		 * dataMatrix[i][j]) //rawData[i][j] = (float)0.5; }
		 */
	}

	/**
	 * Hands a <code>float</code> data matrix for display.<br>
	 *
	 * Normalization of the values for display is needed, because of the color
	 * mapping.
	 *
	 */

	static float[][] rawData_for_GP;

	public static void setData(float[][] dataMatrix) {

		rawData = new float[dataMatrix.length][dataMatrix[0].length];

		rawData_for_GP = new float[dataMatrix.length][dataMatrix[0].length];
		for (int i = 0; i < dataMatrix.length; i++)
			for (int j = 0; j < dataMatrix[0].length; j++)
				rawData_for_GP[i][j] = dataMatrix[i][j];

		float minValue = Float.MAX_VALUE;
		float maxValue = Float.MIN_VALUE;

		for (int i = 0; i < dataMatrix.length; i++)
			for (int j = 0; j < dataMatrix[0].length; j++) {
				if (maxValue < dataMatrix[i][j])
					maxValue = dataMatrix[i][j];
				if (minValue > dataMatrix[i][j])
					minValue = dataMatrix[i][j];
			}

		// squeeze the values of the matrix, for visualization purposes:
		if (maxValue == minValue)
			for (int i = 0; i < dataMatrix.length; i++)
				for (int j = 0; j < dataMatrix[0].length; j++)
					rawData[i][j] = (float) 0.5;
		else
			for (int i = 0; i < dataMatrix.length; i++)
				for (int j = 0; j < dataMatrix[0].length; j++)
					rawData[i][j] = (dataMatrix[i][j] - minValue)
							/ (maxValue - minValue);

		/*
		 * if(debug) { System.out.println("Dimensions, 1: "+dataMatrix.length+",
		 * "+dataMatrix[0].length); System.out.println("Dimensions, 2:
		 * "+rawData.length+", "+rawData[0].length);
		 * System.out.println("Dimensions, 3: "+rawData_for_GP.length+",
		 * "+rawData_for_GP[0].length); System.out.flush(); }
		 */
	}

        /** Add dataset to the central management list (is done after loading data). */
	public void addDataset(float[][] data, boolean withCtrl, int[] dep,
			Vector gNames, Vector chipNames, Vector workCNames,
			Vector colLabels, Vector colInfo) {
		datasetList.add(new Dataset(data, withCtrl, dep, gNames, chipNames,
				workCNames, colLabels, colInfo));
		updateCurrentDataset(datasetList.size() - 1);

		if (debug)
			System.out.println("New dataset added [" + datasetList.size()
					+ "]. ");
	}

	public void addDataset(float[][] data, float[][] dataPre,
			int[][] dataDiscr, Vector gN, Vector cN, Vector wCN, Vector cL,
			Vector cI) {
		datasetList.add(new Dataset(data, dataPre, dataDiscr, gN, cN, wCN, cL,
				cI));
		updateCurrentDataset(datasetList.size() - 1);

		if (debug)
			System.out.println("New dataset added [" + datasetList.size()
					+ "]. ");
	}

        /** Set the current dataset to <code>datasetList.get(x)</code>. */
	public void updateCurrentDataset(int x) {
		if (debug)
			System.out.println("Update the \"current\" dataset! (" + x + ")");
		currentDataset = (Dataset) datasetList.get(x);
		currentDatasetIdx = x;
	}

	/** Set the current dataset to <code>br</code>. */
	public void updateCurrentDataset(Dataset br) {
		currentDataset = br;
	}

        public void finishUpRun(int datasetIdx, LinkedList result,
			PreprocessOption preOpts, String algo) {

            int ALGO = 0;
            if (algo.equals("BiMax"))
                ALGO = RunMachine.BIMAX_ID;
            else if (algo.equals("CC"))
		ALGO = RunMachine.CC_ID;
            else if (algo.equals("ISA"))
            	ALGO = RunMachine.ISA_ID;
            else if (algo.equals("xMotif"))
            	ALGO = RunMachine.XMOTIF_ID;
            else if (algo.equals("OPSM"))
            	ALGO = RunMachine.OPSM_ID;
            ;
            updateCurrentDataset(datasetIdx);
            //addBiclusters(currentDataset, result, ALGO);
            //addPreprocessOptions(currentDataset, preOpts);

            //updatePreprocessOptionsMenu();
            //updateBiclusterMenu();
            //buildTree();
	}
}

