package bicat.base;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
//File Manipulation
import java.io.BufferedInputStream;
import java.io.DataInputStream;
//import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
//java.io.PrintWriter
import java.io.PrintWriter;
import java.io.FileWriter;
import java.io.BufferedWriter;
//Import sql
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.*;
//import util
import java.util.*;
import bicat.preprocessor.Preprocessor;
import javax.swing.JOptionPane;

public class BTreeBicluster {

 public static void main(String argv[]) {

  int intGOCnt=0;
  int intGCnt=0;
  int intMpGOCnt=0;
  String strFName="";
  try {
  System.out.println("Start processing on : "+ DateUtils.now("yyyy-MM-dd HH:mm:ss"));
  File file = new File("c:\\dev\\data\\go_daily-termdb.obo-xml");

  LinkNode h=new LinkNode();
  LinkNode t=new LinkNode();
  LinkNode y=new LinkNode();
  h.next=t;
  t.next=t;
  y=h;

  //obo-flat
  //flat
  //obo-xml
  //rdf-xml
  //mysql
  //owl
  String strRun="flat";
  strRun=JOptionPane.showInputDialog(null,"What type of file?\n1 - Flat\n2 - OBO-flat\n3 - OBO-XML\n4 - RDF-XML\n5 - MySQL\n6 - OWL",
  	"BTreeBicluster",JOptionPane.QUESTION_MESSAGE);
  switch(Integer.parseInt(strRun)){
	  case 1:strRun="flat";break;
	  case 2:strRun="obo-flat";break;
	  case 3:strRun="obo-xml";break;
	  case 4:strRun="rdf-xml";break;
	  case 5:strRun="mysql";break;
	  case 6:strRun="owl";break;
  }

  //System.out.println(strRun);
  //System.exit(0);
  //pre
  //level
  //post
  String strTravMet="level";
  strTravMet=JOptionPane.showInputDialog(null,"What type of traversal method?\n1 - Pre-order\n2 - Level-order\n3 - Post-order",
  	"BTreeBicluster",JOptionPane.QUESTION_MESSAGE);
  switch(Integer.parseInt(strTravMet)){
  	  case 1:strTravMet="pre";break;
  	  case 2:strTravMet="level";break;
  	  case 3:strTravMet="post";break;
  }
  System.out.println(strRun);
  System.out.println(strTravMet);
  //System.exit(0);
  //INFORMATION_MESSAGE
  //JOptionPane.showInputDialog(null,"What file?","File Dialog",JOptionPane.QUESTION_MESSAGE);
  //System.exit(0);
  if (strRun.compareTo("rdf-xml")==0){
  /*************************************************************************************/
  //Reading RDF-XML file
  System.out.println("Reading from RDF-XML file.....");
  strFName=JOptionPane.showInputDialog(null,"What RDF-XML file?","BTreeBicluster",JOptionPane.QUESTION_MESSAGE);
  File filego = new File(strFName);
  //File filego = new File("..\\data\\go_daily-termdb.rdf-xml");
  FileInputStream fisgo = null;
  BufferedInputStream bisgo = null;
  DataInputStream disgo = null;

  try {
      fisgo = new FileInputStream(filego);

      // Here BufferedInputStream is added for fast reading.
      bisgo = new BufferedInputStream(fisgo);
      disgo = new DataInputStream(bisgo);

      // dis.available() returns 0 if the file does not have more lines.
      String[] elements=new String[10];
      String[] hold=new String[10];
      int intFlag=0;
      int intFlag2=0;
      String val="",val_id="";

      while (disgo.available() != 0) {

      // this statement reads the line from the file and print it to
        // the console.

	String str;

	int intIndex=0;

	str=disgo.readLine();

	//if str is empty
	if (str.trim().compareTo("")==0)
		continue;

	//if not a new term
	if ((intFlag==0) && (!str.trim().startsWith("<go:term")))
		continue;

	//if new owl class(go term) is found
	//int intIndex=0;
	//GO id
	str=str.trim();
	if (str.startsWith("<go:term")){
		intIndex=str.indexOf("go#GO");
		if (intIndex!=-1){
			val_id=str.substring(intIndex+3,intIndex+13);
			//val_id=val_id.replace('_',':');
			/*if (val_id.compareTo("GO:0008150")==0){
				intFlag=0;
				continue;
			}*/
			intFlag=1;
		}
		continue;
	}


	//GO namespace

	//GO is_a relationship
	else if (str.startsWith("<go:is_a")){
		intIndex=str.indexOf("go#GO");

		if (intIndex!=-1){
			val=str.substring(intIndex+3,intIndex+13);
			//val=val.replace('_',':');
			LinkNode x=new LinkNode();
			x.id=val_id;
			x.isa=val;

			x.next=t;
			y.next=x;
			y=x;
		}else{
			intIndex=str.indexOf("go#all");
			val="all";
			if (intIndex!=-1){
				LinkNode x=new LinkNode();
				x.id=val_id;
				x.isa=val;

				x.next=t;
				y.next=x;
				y=x;
			}
		}

	}
	//GO part_of relationship

	else if (str.startsWith("<go:part_of")){
		intIndex=str.indexOf("go#GO");

		if (intIndex!=-1){
			val=str.substring(intIndex+3,intIndex+13);
			//val=val.replace('_',':');
			LinkNode x=new LinkNode();
			x.id=val_id;
			x.isa=val;

			x.next=t;
			y.next=x;
			y=x;
		}else{
			intIndex=str.indexOf("go#all");
			val="all";
			if (intIndex!=-1){
				LinkNode x=new LinkNode();
				x.id=val_id;
				x.isa=val;

				x.next=t;
				y.next=x;
				y=x;
			}
		}

	}

	else{
		continue;
	}

      }//while

      //add all the most general term
      LinkNode b=new LinkNode();
      b.id="all";
      b.isa="general_term";
      b.next=h.next;
      h.next=b;

      // dispose all the resources after using them.
      fisgo.close();
      bisgo.close();
      disgo.close();

    } catch (FileNotFoundException e) {
      e.printStackTrace();
    } catch (IOException e) {
      e.printStackTrace();
    }


  /*************************************************************************************/

  }//rdf-xml
  //GO:0008150:biological_process
  //GO:0003674:molecular_function
  //GO:0005575:cellular_component
  else if (strRun.compareTo("owl")==0){
  /*************************************************************************************/
  //Reading OBO-flat file
  System.out.println("Reading from OWL file.....");
  strFName=JOptionPane.showInputDialog(null,"What OWL file?","BTreeBicluster",JOptionPane.QUESTION_MESSAGE);
  File filego = new File(strFName);
  //File filego = new File("..\\data\\go_daily-termdb.owl");
  FileInputStream fisgo = null;
  BufferedInputStream bisgo = null;
  DataInputStream disgo = null;

  try {
      fisgo = new FileInputStream(filego);

      // Here BufferedInputStream is added for fast reading.
      bisgo = new BufferedInputStream(fisgo);
      disgo = new DataInputStream(bisgo);

      // dis.available() returns 0 if the file does not have more lines.
      String[] elements=new String[10];
      String[] hold=new String[10];
      int intFlag=0;
      int intFlag2=0;
      String val="",val_id="";

      while (disgo.available() != 0) {

      // this statement reads the line from the file and print it to
        // the console.

	String str;

	int intIndex=0;

	str=disgo.readLine();

	//if str is empty
	if (str.trim().compareTo("")==0)
		continue;

	//if not a new term
	if ((intFlag==0) && (!str.trim().startsWith("<owl:Class")))
		continue;

	//if new owl class(go term) is found
	//int intIndex=0;
	//GO id
	str=str.trim();
	if (str.startsWith("<owl:Class")){
		intIndex=str.indexOf("GO#GO_");
		if (intIndex!=-1){
			val_id=str.substring(intIndex+3,intIndex+13);
			val_id=val_id.replace('_',':');
			if (val_id.compareTo("GO:0008150")==0 || val_id.compareTo("GO:0005575")==0 || val_id.compareTo("GO:0003674")==0){
				LinkNode x=new LinkNode();
				x.id=val_id;
				x.isa="all";

				x.next=t;
				y.next=x;
				y=x;

				intFlag=0;
				continue;
			}
			intFlag=1;
		}
		continue;
	}

	//GO namespace
	/*else if (str.startsWith("<oboInOwl:hasOBONamespace>")){
		if (str.compareTo("<oboInOwl:hasOBONamespace>biological_process</oboInOwl:hasOBONamespace>")!=0)
			intFlag=0;
			continue;
	}*/
	//GO is_a relationship
	else if (str.startsWith("<rdfs:subClassOf")){
		intIndex=str.indexOf("GO#GO_");

		if (intIndex!=-1){
			val=str.substring(intIndex+3,intIndex+13);
			val=val.replace('_',':');
			LinkNode x=new LinkNode();
			x.id=val_id;
			x.isa=val;

			x.next=t;
			y.next=x;
			y=x;
		}else{
			intFlag=0;
			continue;
		}

	}
	//GO part_of relationship
	else if (str.startsWith("<owl:ObjectProperty")){
		intIndex=str.indexOf("obo#part_of");
		if (intIndex!=-1){
			intFlag2=1;
		}
	}
	else if (str.startsWith("<owl:someValuesFrom")){
		if (intFlag2==1){
			intIndex=str.indexOf("GO#GO_");

			if (intIndex!=-1){
				val=str.substring(intIndex+3,intIndex+13);
				val=val.replace('_',':');
				LinkNode x=new LinkNode();
				x.id=val_id;
				x.isa=val;

				x.next=t;
				y.next=x;
				y=x;
			}

			intFlag2=0;
		}

	}
	else{
		continue;
	}

      }//while

      //add biological_process
      LinkNode b=new LinkNode();
      b.id="all";
      b.isa="general_term";
      b.next=h.next;
      h.next=b;

      // dispose all the resources after using them.
      fisgo.close();
      bisgo.close();
      disgo.close();

    } catch (FileNotFoundException e) {
      e.printStackTrace();
    } catch (IOException e) {
      e.printStackTrace();
    }


  /*************************************************************************************/

  }//owl


  else if (strRun.compareTo("obo-flat")==0){
  /*************************************************************************************/
  //Reading OBO-flat file
  System.out.println("Reading from OBO flat file.....");
  strFName=JOptionPane.showInputDialog(null,"What OBO-flat file?","BTreeBicluster",JOptionPane.QUESTION_MESSAGE);
  File filego = new File(strFName);
  //File filego = new File("..\\data\\gene_ontology_edit.obo");
  FileInputStream fisgo = null;
  BufferedInputStream bisgo = null;
  DataInputStream disgo = null;

  try {
      fisgo = new FileInputStream(filego);

      // Here BufferedInputStream is added for fast reading.
      bisgo = new BufferedInputStream(fisgo);
      disgo = new DataInputStream(bisgo);

      // dis.available() returns 0 if the file does not have more lines.
      String[] elements=new String[10];
      String[] hold=new String[10];
      int intFlag=0;
      String val="",val_id="";

      while (disgo.available() != 0) {

      // this statement reads the line from the file and print it to
        // the console.

	String str;

	int intIndex=0;

	str=disgo.readLine();

	//if (str.startsWith("!"))
	//if str is empty
	if (str.trim().compareTo("")==0){
		intFlag=0;
		continue;
	}
	//if not a new term

	if ((intFlag==0) && (!str.trim().startsWith("[Term]")))
		continue;

	//if new term is found
	if (str.trim().startsWith("[Term]")){
		intFlag=1;
		continue;
	}

	if (str.startsWith("id:")){
		val_id=str.substring(4,14);
		if (val_id.compareTo("GO:0008150")==0 || val_id.compareTo("GO:0003674")==0 || val_id.compareTo("GO:0005575")==0){
			LinkNode x=new LinkNode();
			x.id=val_id;
			x.isa="all";

			x.next=t;
			y.next=x;
			y=x;

			intFlag=0;
			continue;
		}
	}
	/*else if (str.startsWith("namespace:")){
		if (str.substring(10).trim().compareTo("biological_process")!=0)
			intFlag=0;
			continue;
	}*/
	else if (str.startsWith("is_a:")){
		val=str.substring(6,16);

		//System.out.println("val_id : "+ val_id);
		//System.out.println("val : "+ val);

		LinkNode x=new LinkNode();
		x.id=val_id;
		x.isa=val;

		x.next=t;
		y.next=x;
		y=x;
	}
	else if (str.startsWith("relationship: part_of")){
		val=str.substring(22,32);

		LinkNode x=new LinkNode();
        	x.id=val_id;
		x.isa=val;

		x.next=t;
		y.next=x;
		y=x;

	}else{
		continue;
	}

	//x.next=t;
	//y.next=x;
	//y=x;

      }//while

      //add biological_process
      LinkNode b=new LinkNode();
      b.id="all";
      b.isa="general_term";
      b.next=h.next;
      h.next=b;

      // dispose all the resources after using them.
      fisgo.close();
      bisgo.close();
      disgo.close();

    } catch (FileNotFoundException e) {
      e.printStackTrace();
    } catch (IOException e) {
      e.printStackTrace();
    }


  /*************************************************************************************/

  }//obo-flat

  else if (strRun.compareTo("mysql")==0){
  /*************************************************************************************/
  //Reading from MySQL data
  System.out.println("Reading from MySQL database.....");
  // Notice, do not import com.mysql.jdbc.*
  // or you will have problems!
  //public class LoadDriver {
  //public static void main(String[] args) {
  Statement stmt = null;
  ResultSet rs = null;
  String strSql="";

  try {
  	// The newInstance() call is a work around for some
  	// broken Java implementations
  	Class.forName("com.mysql.jdbc.Driver").newInstance();

	Connection conn =
	DriverManager.getConnection("jdbc:mysql://localhost/go?" +
	"user=root&password=password");

	// assume that conn is an already created JDBC connection

	stmt = conn.createStatement();
	//rs = stmt.executeQuery("SELECT foo FROM bar");
/*	strSql="SELECT "+
		"b.acc AS node,b.name AS node_name,b.is_obsolete AS obsolete, "+
		"c.name AS relationship, "+
		"a.acc AS parent,a.name AS parent_name "+
		"FROM term2term "+
		"LEFT JOIN "+
		"(term a CROSS JOIN term b CROSS JOIN term c) ON (term1_id=a.id AND term2_id=b.id AND relationship_type_id=c.id) "+
		"WHERE b.is_obsolete=0 AND b.term_type='biological_process' AND b.name<>'biological_process' ORDER BY b.acc";*/
	strSql="SELECT "+
		"b.acc AS node,b.name AS node_name,b.is_obsolete AS obsolete, "+
		"c.name AS relationship, "+
		"a.acc AS parent,a.name AS parent_name "+
		"FROM term2term "+
		"LEFT JOIN "+
		"(term a CROSS JOIN term b CROSS JOIN term c) ON (term1_id=a.id AND term2_id=b.id AND relationship_type_id=c.id) "+
		"WHERE b.is_obsolete=0 ORDER BY b.acc";

	// or alternatively, if you don't know ahead of time that
	// the query will be a SELECT...
	if (stmt.execute(strSql)) {
		rs = stmt.getResultSet();
		while(rs.next()){
			LinkNode x=new LinkNode();
			x.id=rs.getString("node");
			x.isa=rs.getString("parent");

			x.next=t;
			y.next=x;
        		y=x;
			//System.out.print("Node inserted");
			/*System.out.println(rs.getString("node") + " "+
					rs.getString("relationship") + " "+
					rs.getString("parent"));*/
		}
		//add biological_process
		  LinkNode b=new LinkNode();
		  b.id="all";
		  b.isa="general_term";
		  b.next=h.next;
		  h.next=b;
	}//if (stmt.execute(strSql))

	if (rs != null) {
		//try {
			rs.close();
		//} catch (SQLException sqlEx) { // ignore }
	rs = null;
	}//if (rs != null)
	if (stmt != null) {
		//try {
			stmt.close();
		//} catch (SQLException sqlEx) { // ignore }
	stmt = null;
	}//if (stmt != null)

	}//try
	catch (SQLException ex) {
		// handle any errors
		System.out.println("SQLException: " + ex.getMessage());
		System.out.println("SQLState: " + ex.getSQLState());
		System.out.println("VendorError: " + ex.getErrorCode());
	}//catch (SQLException ex)
	catch (Exception ex) {
	// handle the error
	//System.out.println("Other error: " + ex.getErrorCode());
	}//catch (Exception ex)

	// Now do something with the ResultSet ....
	//finally {
	// it is a good idea to release
	// resources in a finally{} block
	// in reverse-order of their creation
	// if they are no-longer needed
	/*if (rs != null) {
		try {
			rs.close();
		} catch (SQLException sqlEx) { // ignore }
	rs = null;
	}//if (rs != null)
	if (stmt != null) {
		try {
			stmt.close();
		} catch (SQLException sqlEx) { // ignore }
	stmt = null;
	}//if (stmt != null)

}*/

  /*************************************************************************************/
  //System.exit(0);
  }
  else if (strRun.compareTo("flat")==0){
  /*************************************************************************************/
  String flatfile[]={"function.ontology","component.ontology"};
  //for (int i=0;i<flatfile.length;i++){
  //Reading flat file
  System.out.println("Reading from GO flat file.....");
  strFName=JOptionPane.showInputDialog(null,"What GO flat file?","BTreeBicluster",JOptionPane.QUESTION_MESSAGE);
  File filego = new File(strFName);
  //File filego = new File("..\\data\\GO.ontology");
  FileInputStream fisgo = null;
  BufferedInputStream bisgo = null;
  DataInputStream disgo = null;

  try {
      fisgo = new FileInputStream(filego);

      // Here BufferedInputStream is added for fast reading.
      bisgo = new BufferedInputStream(fisgo);
      disgo = new DataInputStream(bisgo);

      // dis.available() returns 0 if the file does not have more lines.
      String[] elements=new String[10];
      String[] hold=new String[10];

      while (disgo.available() != 0) {

      // this statement reads the line from the file and print it to
        // the console.
	//String[] str;
	String str;
	String val="",val_id="",rhip;
	int intIndex=0;
	//str=disgo.readLine().split("\t");
	str=disgo.readLine();
	if (str.startsWith("!"))
		continue;
	//System.out.println(str);

	String str2=str;
	int intSpcCnt=0;
	//count spaces
	while (str2.startsWith(" ")){
		intSpcCnt+=1;
		str2=str.substring(intSpcCnt);
	}

	//added for reading 3 flat files
	//if (intSpcCnt==0 && i>0) continue;

	System.out.println(str2);

	if (intSpcCnt>=elements.length){
		hold=new String[elements.length];
		System.arraycopy(elements,0,hold,0,elements.length);
		elements=new String[intSpcCnt+1];
		System.arraycopy(hold,0,elements,0,hold.length);
	}

	//System.out.println(str2.substring(0,10) + " "+ str2.substring(1,10));

	if (str2.charAt(0)=='%'){
		//System.out.println("%");
		intIndex=str2.indexOf("GO:");
		val_id=str2.substring(intIndex,intIndex+10);
	}else if (str2.charAt(0)=='<'){
		//System.out.println("<");
		intIndex=str2.indexOf("GO:");
		val_id=str2.substring(intIndex,intIndex+10);
	}else if (str2.charAt(0)=='$'){
		//System.out.println("$");
		intIndex=str2.indexOf("GO:");
		val_id=str2.substring(intIndex,intIndex+10);
	}
//	System.out.println("val_id : " + val_id +" val : "+ val);

	elements[intSpcCnt]=val_id;
	if (intSpcCnt>0)
		val=elements[intSpcCnt-1];

	//System.out.println("val_id : " + val_id +" val : "+ val);

	LinkNode x=new LinkNode();

	x.id=val_id;

      	//val=((Node) lstNm.item(0)).getNodeValue() ;
	x.isa=val;

        boolean boolNodeExisted=false;

	for(LinkNode ln=h.next;ln!=t;ln=ln.next)
	{
		//System.out.println(ln.id + ":" + ln.isa);
		if (x.id.compareTo(ln.id)==0 && x.isa.compareTo(ln.isa)==0){
			//continue while;
			boolNodeExisted=true;
			System.out.println("Node existed");
			break;
		}
  	}
	if (boolNodeExisted){
		continue;
	}else{
		x.next=t;
		y.next=x;
        	y=x;
		System.out.print("Node inserted");
	}
	System.out.println("val_id : " + val_id +" val : "+ val);
	//process parent

	while (str2.length()>10	){
		str2=str2.substring(intIndex+10);
		str2=str2.trim();

		if (str2.length()==0)
			break;

		if (str2.charAt(0)=='%'){
			System.out.println("%");
			intIndex=str2.indexOf("GO:");
			val=str2.substring(intIndex,intIndex+10);
		}else if (str2.charAt(0)=='<'){
			System.out.println("<");
			intIndex=str2.indexOf("GO:");
			val=str2.substring(intIndex,intIndex+10);
		}else if (str2.indexOf('%')>=0){
			System.out.println("%");
			str2=str2.substring(str2.indexOf('%'));
			intIndex=str2.indexOf("GO:");
			val=str2.substring(intIndex,intIndex+10);
		}else if (str2.indexOf('<')>=0){
			System.out.println("<");
			str2=str2.substring(str2.indexOf('<'));
			intIndex=str2.indexOf("GO:");
			val=str2.substring(intIndex,intIndex+10);
		}else{
			break;
		}

		System.out.println("val_id : " + val_id +" val : "+ val);

		LinkNode w=new LinkNode();

		w.id=val_id;

      		//val=((Node) lstNm.item(0)).getNodeValue() ;
		w.isa=val;
		w.next=t;
		y.next=w;
        	y=w;


	}

	//System.out.println(str[1] + " : "+ str[4]);
	//tr.map(str[1],str[4]);
	/*if (tr.mapped)
	{
		intMpGOCnt+=1;
		tr.mapped=false;
        }*/
	//System.out.println(dis.readLine());
	//myCnt+=1;
	//intGCnt+=1;
      }
      //intGCnt=myCnt;
      // dispose all the resources after using them.
      fisgo.close();
      bisgo.close();
      disgo.close();

    } catch (FileNotFoundException e) {
      e.printStackTrace();
    } catch (IOException e) {
      e.printStackTrace();
    }
//  }//for reading 3 flat files

  /*************************************************************************************/

  }
  //Reading from OBO XML file
  //System.exit(0);
	else{
  System.out.println("Reading from OBO XML file.....");
  strFName=JOptionPane.showInputDialog(null,"What OBO-XML file?","BTreeBicluster",JOptionPane.QUESTION_MESSAGE);
  file = new File(strFName);
  DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
  DocumentBuilder db = dbf.newDocumentBuilder();
  Document doc = db.parse(file);
  doc.getDocumentElement().normalize();
  System.out.println("Root element " + doc.getDocumentElement().getNodeName());
  NodeList nodeLst = doc.getElementsByTagName("term");
  System.out.println("Information of all gene ontology terms");

  /*LinkNode h=new LinkNode();
  LinkNode t=new LinkNode();
  LinkNode y=new LinkNode();
  h.next=t;
  t.next=t;
  y=h;*/

  for (int s = 0; s < nodeLst.getLength(); s++) {

    Node fstNode = nodeLst.item(s);

    if (fstNode.getNodeType() == Node.ELEMENT_NODE) {

	String val,val_id;
	String nsp;

	//LinkNode x=new LinkNode();

      Element fstElmnt = (Element) fstNode;

      //check namespace
      NodeList nspNmElmntLst = fstElmnt.getElementsByTagName("namespace");
      Element nspNmElmnt = (Element) nspNmElmntLst.item(0);
      NodeList nspNm = nspNmElmnt.getChildNodes();
      nsp=((Node) nspNm.item(0)).getNodeValue();
      //omit namespace
      //if (!nsp.equals("biological_process")) continue;

      //get term id
      NodeList fstNmElmntLst = fstElmnt.getElementsByTagName("id");
      Element fstNmElmnt = (Element) fstNmElmntLst.item(0);
      NodeList fstNm = fstNmElmnt.getChildNodes();
      val_id=((Node) fstNm.item(0)).getNodeValue();

      if (val_id.compareTo("GO:0008150")==0 || val_id.compareTo("GO:0003674")==0 || val_id.compareTo("GO:0005575")==0){
		LinkNode x=new LinkNode();

		x.id=val_id;
		x.isa="all";
		x.next=t;
		y.next=x;
	        y=x;
		continue;
      }

      NodeList lstNmElmntLst = fstElmnt.getElementsByTagName("is_a");
      //Reading is_a relationship
      for(int l=0;l<lstNmElmntLst.getLength(); l++)
      {
	LinkNode x=new LinkNode();

	x.id=val_id;
      	Element lstNmElmnt = (Element) lstNmElmntLst.item(l);
	NodeList lstNm = lstNmElmnt.getChildNodes();

      	val=((Node) lstNm.item(0)).getNodeValue() ;
	x.isa=val;
	x.next=t;
	y.next=x;
        y=x;

      }

      NodeList lstNmElmntLst2 = fstElmnt.getElementsByTagName("relationship");
      //Reading part_of relationship
      for(int l=0;l<lstNmElmntLst2.getLength(); l++)
      {
	LinkNode x=new LinkNode();

	x.id=val_id;
      	Element lstNmElmnt2 = (Element) lstNmElmntLst2.item(l);

	NodeList lstNmElmnt2Lst = lstNmElmnt2.getElementsByTagName("to");
	Element lstNmElmnt2E = (Element) lstNmElmnt2Lst.item(0);

	NodeList lstNm2 = lstNmElmnt2E.getChildNodes();
      	val=((Node) lstNm2.item(0)).getNodeValue() ;
	x.isa=val;
	x.next=t;
	y.next=x;
        y=x;

      }//for

    }//if fstNode

  }//for int s

  //add biological_process
  LinkNode b=new LinkNode();
  b.id="all";
  b.isa="general_term";
  b.next=h.next;
  h.next=b;
  }//if strRun.compareTo("flat")==0

  //System.exit(0);

  for(LinkNode ln=h.next;ln!=t;ln=ln.next)
  {
	System.out.println(ln.id + ":" + ln.isa);

  }
//  System.exit(0);
  //System.out.println("t is not null"+ t.id +":"+ t.isa +":"+ t.next);
  TreeNode ht=new TreeNode();

  //tree generating
	System.out.println("\nReading & building gene ontology tree");
	System.out.println("Start processing on : "+ DateUtils.now("yyyy-MM-dd HH:mm:ss"));
	int myCnt=0;
	int i=0;
	MyTree tr=new MyTree();
	LinkNode ln=h.next;
	LinkNode pn=h;
	if (t==null) System.out.println("t is null");
	//System.out.println("t is not null"+ t.id +":"+ t.isa +":"+ t.next);
	//thetest:
	while(h.next!=t)
	{
		if (myCnt==13619) break;
		if (ln==t)
		{
			ln=h.next;
			pn=h;
			//System.out.println("new h.next : "+ ln.id);
			//System.out.println("new ln.next : "+ ln.next.id);
			i=i+1;
			//if (i==2) break;
		}
		//System.out.print("Inserting : "+ ln.id);
			//tr.insert(new MyNode(ln.id,ln.isa));
		tr.insert(ln);

		if (tr.inserted)
		{
			if (pn==h)
			{
				//pn=h;
				h.next=ln.next;
				//System.out.println("pn==h");
			}
			//else
			//	pn=ln;
			///System.out.println(" - Node inserted");
			tr.inserted=false;
			myCnt+=1;
		}
		else
		{
			pn=ln;
			//System.out.println(" - Node not inserted");
		}
		//System.out.println("PN : "+ pn.id);
		//System.out.println("LN : "+ ln.id);
		pn.next=ln.next;
		ln=ln.next;
		//System.out.println("LN NEXT: "+ ln.id);
		//System.out.println("recursive call="+ tr.recur);
	}
	//tr.print();
	intGOCnt=myCnt;
	System.out.println("Finish processing : "+ myCnt);
        System.out.println("Finish generating tree on : "+ DateUtils.now("yyyy-MM-dd HH:mm:ss"));

	/*for(LinkNode mn=h.next;mn!=t;mn=mn.next)
  	{
		System.out.println(mn.id + ":" + mn.isa);

	}*/

	//System.exit(0);
    //GO-gene mapping
    myCnt=0;
    System.out.println("Start mapping gene to GO on : "+ DateUtils.now("yyyy-MM-dd HH:mm:ss"));
    System.out.println("\nReading genes reference from file");
    //File file2 = new File("generef.txt");
    File file2 = new File("..\\data\\yeast.sgd");
    FileInputStream fis = null;
    BufferedInputStream bis = null;
    DataInputStream dis = null;

    try {
      fis = new FileInputStream(file2);

      // Here BufferedInputStream is added for fast reading.
      bis = new BufferedInputStream(fis);
      dis = new DataInputStream(bis);

      // dis.available() returns 0 if the file does not have more lines.
      while (dis.available() != 0) {

      // this statement reads the line from the file and print it to
        // the console.
	String[] str;
	String[] tmpstr=null;
	str=dis.readLine().split("\t");
	System.out.println(str[1] + " : "+ str[4]);
	str[10]=str[10].replace("|","-");
	tmpstr=str[10].split("-");
	//tr.map(str[1],str[4]);
	tr.map(tmpstr[0],str[4]);
	if (tr.mapped)
	{
		intMpGOCnt+=1;
		tr.mapped=false;
        }
	//System.out.println(dis.readLine());
	myCnt+=1;
	//intGCnt+=1;
      }
      intGCnt=myCnt;
      // dispose all the resources after using them.
      fis.close();
      bis.close();
      dis.close();

    } catch (FileNotFoundException e) {
      e.printStackTrace();
    } catch (IOException e) {
      e.printStackTrace();
    }
	System.out.println("Gene counts : "+ myCnt);
	System.out.println("\nMapping genes to ontology");
	//pre-order
	if (strTravMet.compareTo("pre")==0){
		tr.printmap();
	}
	//level order
	else if (strTravMet.compareTo("level")==0){
		tr.printmaplevel();
	}
	//post-order
	else if (strTravMet.compareTo("post")==0){
		tr.printmappost();
	}
	System.out.println("Finish mapping gene to GO on : "+ DateUtils.now("yyyy-MM-dd HH:mm:ss"));
	System.out.println("Total GO Term : "+ intGOCnt);
	System.out.println("Total Gene : "+ intGCnt);
	System.out.println("Total GO Term Mapped with Gene : "+ intMpGOCnt);

	tr.findmapgene();

	//tr.loadData("..\\data\\go_daily-termdb.rdf-xml",1,1);

  } catch(Exception e) {

	System.out.println(e.toString());

  }
 }//main

}

class MyTree{

	public MyTree(){
		root=nullNode;
	}//MyTree constructor

	public MyNode root;
	public static MyNode nullNode;
	public boolean inserted;
	public boolean mapped;
	public static int recur=0;

	//BiCluster
	//public static Preprocessor pre;
	//public Preprocessor pre;
	//public static PreprocessOption preprocessOptions;
	//public PreprocessOption preprocessOptions;
	//public static int logBaseSetting;
	//public int logBaseSetting;
	//public static boolean preprocessComplete;
	//public boolean preprocessComplete;
	//public static boolean preprocessExtended;
	//public boolean preprocessExtended;
	//public static boolean processExtended;
	//public boolean processExtended;
	//static boolean discretizeExtended;
	//boolean discretizeExtended;
	//static boolean discretizeComplete;
	//boolean discretizeComplete;
	//public static Dataset currentDataset = null;
	//public Dataset currentDataset = null;

	static{
		nullNode=new MyNode(null,null);
		nullNode.left=nullNode.right=nullNode;
		nullNode.level=0;
	}//static initializer

	public void insert(LinkNode x){
		//root=insert(x,root);
		root=insert(x,root);
	}//MyTree insert

	private MyNode insert(LinkNode x,MyNode t){

		recur+=1;
		if((t==nullNode) && (t.level<1))
		{
			System.out.print("Inserting : "+ x.id + ": "+ x.isa);
			System.out.print(" - Inserting for the 1st time...");
			t=new MyNode(x.id,x.isa);
			inserted=true;
			System.out.println(" - Node inserted");
			return t;
		}
		else if(t==null)
		{
			return t;
		}
		//if t is parent of x
		else if(x.isa.equals(t.id))
		{
			System.out.print("Inserting : "+ x.id + ": "+ x.isa);
			System.out.print(" - Inserting child...");

			MyNode z=new MyNode(x.id,x.isa);
			z.right=t.left;
			t.left=z;
			z.level=t.level+1;
			inserted=true;
			System.out.println(" - Node inserted - level - "+z.level);

			return t;
		}

		t.left=insert(x,t.left);
		t.right=insert(x,t.right);
		return t;
	}//MyTree insert

	public void insertlevel(LinkNode x){
		root=insert(x,root);
	}//MyTree insert

	private MyNode insertlevel(LinkNode x,MyNode t){

		recur+=1;
		if((t==nullNode) && (t.level<1))
		{
			System.out.print("Inserting : "+ x.id + ": "+ x.isa);
			System.out.print(" - Inserting for the 1st time...");
			t=new MyNode(x.id,x.isa);
			inserted=true;
			System.out.println(" - Node inserted");
			return t;
		}
		else if(t==null)
		{
			return t;
		}
		//if t is parent of x
		else if(x.isa.equals(t.id))
		{
			System.out.print("Inserting : "+ x.id + ": "+ x.isa);
			System.out.print(" - Inserting child...");

			MyNode z=new MyNode(x.id,x.isa);
			z.right=t.left;
			t.left=z;
			z.level=t.level+1;
			inserted=true;
			System.out.println(" - Node inserted");

			return t;
		}

		t.left=insert(x,t.left);
		t.right=insert(x,t.right);
		return t;
	}//MyTree insert

	public void print()
	{
		print(root);
	}

	private void print(MyNode t)
	{
		if (t==null) return;
		System.out.println("Node : "+ t.id +" is a : "+ t.isa);
		print(t.left);
		print(t.right);
	}

	public void printlevel()
	{
		printlevel(root);
	}

	private void printlevel(MyNode t)
	{
		if (t==null) return;
		System.out.println("Node : "+ t.id +" is a : "+ t.isa);
		printlevel(t.right);
		printlevel(t.left);

	}

	public void map(String gid,String gr)
	{
		map(gid,gr,root);
	}

	private void map(String gid,String gr,MyNode t)
	{
		if (t==null) return;
		if (gr.equals(t.id))
		{
			t.mapg=t.mapg+gid+",";
			mapped=true;
			return;
		}
		map(gid,gr,t.left);
		map(gid,gr,t.right);
	}

	public void printmap()
	{
		printmap(root);
	}

	private void printmap(MyNode t)
	{
		if (t==null) return;
		System.out.print("Node : "+ t.id +" is a : "+ t.isa);
		if (!t.mapg.equals(""))
			System.out.println(" map to gene : "+ t.mapg);
		else
			System.out.println("");
		printmap(t.left);
		printmap(t.right);
	}

	public void printmaplevel()
	{
		printmaplevel(root);
	}

	private void printmaplevel(MyNode t)
	{

		Queue queue=new ArrayDeque();

		queue.add(t);

		while(queue.peek()!=null){
			MyNode tnode=(MyNode)queue.element();
			System.out.println("Element :: "+ tnode.id + " is a :: "+ tnode.isa +" map to gene :: "+ tnode.mapg);
			//node has children(s)
			if (tnode.left!=null){
				queue.add(tnode.left);
				MyNode cnode=tnode.left;
				while(cnode.right!=null){
					queue.add(cnode.right);
					cnode=cnode.right;
				}

			}//if tnode.left!=null
			queue.remove();
		}

	}

	public void printmappost()
	{
		printmappost(root);
	}

	private void printmappost(MyNode t)
	{
		//if (t==null) return;
		if (t.left!=null) printmappost(t.left);
		System.out.print("Node : "+ t.id +" is a : "+ t.isa);
		if (!t.mapg.equals(""))
			System.out.println(" map to gene : "+ t.mapg);
		else
			System.out.println("");
		if (t.right!=null) printmappost(t.right);
	}

	public void findmapgene()
	{
		findmapgene(root);
	}

	private void findmapgene(MyNode t)
	{
		String strGO="GO:0008150";

		Queue queue=new ArrayDeque();

		queue.add(t);

		while(queue.peek()!=null){
			MyNode tnode=(MyNode)queue.element();
			System.out.println("Element :: "+ tnode.id + " is a :: "+ tnode.isa +" map to gene :: "+ tnode.mapg);
			//node has children(s)

			/////System.out.println("findmapgene:tnode:"+tnode.id);
			//if (tnode.id.compareTo(strGO)==0){
			if (tnode.clustered==0 && tnode.mapg.trim().compareTo("")!=0){
				finddesgo(tnode);
				//return;
			}

			if (tnode.left!=null){
				queue.add(tnode.left);
				MyNode cnode=tnode.left;
				while(cnode.right!=null){
					/*check clustered*/
					/////System.out.println("findmapgene:cnode:"+cnode.id);
					//if (tnode.id.compareTo("GO:0007154")==0){
					if (cnode.clustered==0 && cnode.mapg.trim().compareTo("")!=0){
						finddesgo(cnode);
					//	return;
					}
					queue.add(cnode.right);
					cnode=cnode.right;
				}

			}//if tnode.left!=null
			queue.remove();
		}//while

	}//private void mapgene

	public void finddesgo()
	{
		finddesgo(root);
	}

	private void finddesgo(MyNode t)
	{
		int geneCnt,clusId=0;
		double msrs;
		double thold;

		String[] temp=null;
		Queue queue=new ArrayDeque();

		queue.add(t);

		while(queue.peek()!=null){
			MyNode tnode=(MyNode)queue.element();
			/*Find gene in gene expression data file*/
			//System.out.println("tnode : "+ tnode.mapg);

			//System.out.println(temp.length);
			/////System.out.println("finddesgo:tnode:"+ tnode.id +":"+ tnode.mapg);
			if (tnode.mapg.trim().compareTo("")!=0){
				temp=tnode.mapg.split(",");
				/////System.out.println("tnode.mapg.trim():"+ temp.length);

				try{
					PrintWriter out= new PrintWriter(new BufferedWriter(new FileWriter("geneexpro.txt")));
					out.close();
				}catch (FileNotFoundException e) {
					e.printStackTrace();
				}catch (IOException e) {
					e.printStackTrace();
    			}

				for (int i = 0 ; i < temp.length ; i++) {
			        /*Calculate msrs*/
			        findgofile(temp[i]);
				}
    		}

			//node has children(s)
			temp=null;
			if (tnode.left!=null){
				queue.add(tnode.left);
				MyNode cnode=tnode.left;
				while(cnode.right!=null){
					/*Find gene in gene expression data file*/
					/////System.out.println("finddesgo:cnode:"+ cnode.id +":"+ cnode.mapg);
					if (cnode.mapg.trim().compareTo("")!=0){
						//System.out.println("cnode : "+ cnode.mapg);
						temp=cnode.mapg.split(",");
						/////System.out.println("cnode.mapg.trim():"+ temp.length);

						try{
							PrintWriter out1= new PrintWriter(new BufferedWriter(new FileWriter("geneexpro.txt")));
							out1.close();
						}catch (FileNotFoundException e) {
							e.printStackTrace();
						}catch (IOException e) {
						    e.printStackTrace();
    					}

						for (int i = 0 ; i < temp.length ; i++) {
						        /////System.out.println(temp[i]);
						        //String msrs=findgofile(temp[i]);
						        findgofile(temp[i]);
						        //System.out.println(msrs);
    					}
    					temp=null;
    					//cnode.clustered=1;
					}
					/**/
					queue.add(cnode.right);
					cnode=cnode.right;
				}

			}//if tnode.left!=null
			queue.remove();
		}//while

		geneCnt=findunion();
		System.out.println("geneCnt:"+ geneCnt);

		///msrs=calMsrs(geneCnt);
		//**Before biclustering**//
		/*File fileBId = new File("BiClusterId.txt");
		FileInputStream fisBId = null;
		BufferedInputStream bisBId = null;
		DataInputStream disBId = null;
		String strBIdB="";

		try {
			fisBId = new FileInputStream(fileBId);

		    // Here BufferedInputStream is added for fast reading.
		    bisBId = new BufferedInputStream(fisBId);
		    disBId = new DataInputStream(bisBId);

			strBIdB=disBId.readLine();//.split("\t");

		    // dispose all the resources after using them.
		    fisBId.close();
		    bisBId.close();
			disBId.close();
			fileBId=null;

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
		    e.printStackTrace();
    	}*/

		//**End before biclustering**//
		calBimaxBicluster();
		//**After biclustering**//
		/*String strBIdA="";
		try {
			fileBId = new File("BiClusterId.txt");
			fisBId = new FileInputStream(fileBId);

		    // Here BufferedInputStream is added for fast reading.
		    bisBId = new BufferedInputStream(fisBId);
		    disBId = new DataInputStream(bisBId);

			strBIdA=disBId.readLine();//.split("\t");

		    // dispose all the resources after using them.
		    fisBId.close();
		    bisBId.close();
			disBId.close();
			fileBId=null;

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
		    e.printStackTrace();
    	}*/

		//**End after biclustering**//

		thold=0.21;
		//if (strBIdB.compareTo(strBIdA)==0) return;
		//if (thold>msrs) return;
		///if (Double.compare(msrs,thold)>0) return;
		/////System.out.println("comparing treshold and msrs");
		//Get cluster id from file
		/*File file = new File("ClusterId.txt");
		FileInputStream fis = null;
		BufferedInputStream bis = null;
		DataInputStream dis = null;
		String fstr="";
		String[] temp2=null;
		File file2 = new File("geneexpro-union.txt");
		FileInputStream fis2 = null;
		BufferedInputStream bis2 = null;
		DataInputStream dis2 = null;

		try {
			fis = new FileInputStream(file);

			// Here BufferedInputStream is added for fast reading.
			bis = new BufferedInputStream(fis);
			dis = new DataInputStream(bis);

			// dis.available() returns 0 if the file does not have more lines.
			//while (dis.available() != 0) {

			// this statement reads the line from the file and print it to
			// the console.

			fstr=dis.readLine();
			clusId=Integer.parseInt(fstr);

			PrintWriter out= new PrintWriter(new BufferedWriter(new FileWriter("ClusterId.txt")));

			out.println(clusId+1);
			out.close();

			fis2 = new FileInputStream(file2);

			// Here BufferedInputStream is added for fast reading.
			bis2 = new BufferedInputStream(fis2);
			dis2 = new DataInputStream(bis2);
			PrintWriter out2= new PrintWriter(new BufferedWriter(new FileWriter("MyCluster"+ Integer.toString(clusId+1) +".txt",true)));

			while (dis2.available() != 0) {
				fstr=dis2.readLine();
				out2.println(fstr);
			}

			out2.close();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
		    e.printStackTrace();
    	}//try-catch*/

    	/********************************************************************/
    	/*					Mark go term as clustered						*/
    	/********************************************************************/

		queue.add(t);

		while(queue.peek()!=null){
			MyNode tnode=(MyNode)queue.element();
			//System.out.println("Element :: "+ tnode.id + " is a :: "+ tnode.isa +" map to gene :: "+ tnode.mapg);
			//node has children(s)

			//System.out.println("findmapgene:tnode:"+tnode.id);
			//if (tnode.id.compareTo(strGO)==0){
			if (tnode.mapg.trim().compareTo("")!=0){
				tnode.clustered=clusId+1;
				//finddesgo(tnode);
				//return;
			}

			if (tnode.left!=null){
				queue.add(tnode.left);
				MyNode cnode=tnode.left;
				while(cnode.right!=null){
					/*check clustered*/
					//System.out.println("findmapgene:cnode:"+cnode.id);
					//if (tnode.id.compareTo("GO:0007154")==0){
					if (cnode.mapg.trim().compareTo("")!=0){
						cnode.clustered=clusId+1;
						//finddesgo(cnode);
					//	return;
					}
					queue.add(cnode.right);
					cnode=cnode.right;
				}
			}//if tnode.left!=null
			queue.remove();
		}//while

    	/********************************************************************/

	}//finddesgo

	//
	private void findgofile(String gene)
	{
			//File file2 = new File("..\\data\\Eisen.txt");
		    //File file2 = new File("..\\data\\svd_ica.txt");
		    //File file2 = new File("..\\data\\svdEisen_filled_ica.txt");
		    //File file2 = new File("..\\data\\svdcho_filled_ica.txt");
		    //File file2 = new File("..\\data\\svdcho_ica.txt");
		    File file2 = new File("..\\data\\cho.txt");
		    //File file2 = new File("..\\data\\new\\Eisen.txt");
		    FileInputStream fis = null;
		    BufferedInputStream bis = null;
		    DataInputStream dis = null;
			String retstr="";
			String fstr="";
			//String strGOFile="GO-0030154";

		    try {
			//PrintWriter out1= new PrintWriter(new BufferedWriter(new FileWriter("geneexpro.txt")));
			//out1.close();

		      fis = new FileInputStream(file2);

		      // Here BufferedInputStream is added for fast reading.
		      bis = new BufferedInputStream(fis);
		      dis = new DataInputStream(bis);

		      // dis.available() returns 0 if the file does not have more lines.
		      while (dis.available() != 0) {

		      	// this statement reads the line from the file and print it to
		        // the console.

				String[] str;
				String[] tmpstr=null;

				retstr="";
				fstr=dis.readLine();
				str=fstr.split("\t");

				if (gene.compareTo(str[0])==0){
					retstr=fstr;
					//fstr+="\n";
					PrintWriter out= new PrintWriter(new BufferedWriter(new FileWriter("geneexpro.txt",true)));
					//out.write(fstr,0,fstr.length());
					out.println(fstr);
					//out.println();
					//out.newLine();
					//out.println("close file");
					out.close();
					break;
				}

		      }//while

			  //cannot find gene expresion profile in file
			  //write it anyway with a 0 value
			  //if (retstr.compareTo("")==0){
			  if (retstr.compareTo("")==0){
				  	gene=gene + "\t0";
			  		PrintWriter out= new PrintWriter(new BufferedWriter(new FileWriter("geneexpro.txt",true)));
					//out.write(gene,0,gene.length());
					out.println(gene);
					//out.println();
					//out.newLine();
					//out.println("close file");
					out.close();
			  }
		      // dispose all the resources after using them.
		      fis.close();
		      bis.close();
		      dis.close();
		      //out.println("close file");
		      //out.close();

		    } catch (FileNotFoundException e) {
		      e.printStackTrace();
		    } catch (IOException e) {
		      e.printStackTrace();
    		}
    		//return retstr;
	}

	//public void findunion()
	private int findunion()
	{
		//String strGOFile="GO-0030154";
		File file2 = new File("geneexpro.txt");
		FileInputStream fis = null;
		BufferedInputStream bis = null;
		DataInputStream dis = null;
		String fstr="",fstr2="";
		File file3 = new File("geneexpro-union.txt");
		FileInputStream fis3 = null;
		BufferedInputStream bis3 = null;
		DataInputStream dis3 = null;
		//File file4 = new File("..\\data\\Eisen.txt");
		//File file4 = new File("..\\data\\svdEisen_ica.txt");
		//File file4 = new File("..\\data\\svdEisen_filled_ica.txt");
		//File file4 = new File("..\\data\\svdcho_filled_ica.txt");
		//File file4 = new File("..\\data\\svdcho_ica.txt");
		File file4 = new File("..\\data\\cho.txt");
		FileInputStream fis4 = null;
		BufferedInputStream bis4 = null;
		DataInputStream dis4 = null;
		String fstr4="";
		int geneCnt=0;

		try {
			fis4 = new FileInputStream(file4);

			// Here BufferedInputStream is added for fast reading.
			bis4 = new BufferedInputStream(fis4);
		    dis4 = new DataInputStream(bis4);

			fstr4=dis4.readLine();

			fis4.close();
			bis4.close();
			dis4.close();

			//PrintWriter out1= new PrintWriter(new BufferedWriter(new FileWriter("geneexpro-union.txt",true)));
			PrintWriter out1= new PrintWriter(new BufferedWriter(new FileWriter("geneexpro-union.txt")));
			out1.println(fstr4);
			out1.close();

			fis = new FileInputStream(file2);

		    // Here BufferedInputStream is added for fast reading.
		    bis = new BufferedInputStream(fis);
		    dis = new DataInputStream(bis);
		    // dis.available() returns 0 if the file does not have more lines.
		    while (dis.available() != 0) {
			   	// this statement reads the line from the file and print it to
			    // the console.

				String[] tmpstr=null;

				//retstr="";
				fstr=dis.readLine();
				//str=fstr.split("\t");

				fis3 = new FileInputStream(file3);
				// Here BufferedInputStream is added for fast reading.
				bis3 = new BufferedInputStream(fis3);
		    	dis3 = new DataInputStream(bis3);

				boolean genefound=false;

				while (dis3.available() != 0) {
					fstr2=dis3.readLine();

					if (fstr.compareTo(fstr2)==0){
						genefound=true;
						break;
					}
				}

				fis3.close();
				bis3.close();
			  	dis3.close();

				if (!genefound){
					PrintWriter out= new PrintWriter(new BufferedWriter(new FileWriter("geneexpro-union.txt",true)));
					out.println(fstr);
					out.close();
					geneCnt+=1;
				}

		      }//while

			  // dispose all the resources after using them.
			  fis.close();
			  bis.close();
			  dis.close();
			  //out.println("close file");
			  //out.close();

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
		    e.printStackTrace();
		}

		return geneCnt;
	}//findunion

	//Calculate Msrs
	//public void calMsrs(){
	private double calMsrs(int geneCnt){
		//183
		//Eisen lab data condition = 79 2
		//ZFhang data condition = 80 1
		int condCnt=79;
		double a[][]=new double[geneCnt][condCnt];
		double aiJ[]=new double[geneCnt];
		double aIj[]=new double[condCnt];
		//double aIJ[]=new double[4];
		double aIJ;
		double hij,temp;
		int in,jm;
		int i=0,j=0;

		for(i=0;i<geneCnt;i++){
			for(j=0;j<condCnt;j++){
				a[i][j]=0;
			}//for j
			//aiC=
		}//for i

		/****************/
		//Read from file
		//String strGOFile="GO-0030154";
		File file = new File("geneexpro-union.txt");
		FileInputStream fis = null;
		BufferedInputStream bis = null;
		DataInputStream dis = null;

		try {
			fis = new FileInputStream(file);

		    // Here BufferedInputStream is added for fast reading.
		    bis = new BufferedInputStream(fis);
		    dis = new DataInputStream(bis);

		    // dis.available() returns 0 if the file does not have more lines.
		    i=0;j=0;
		    while (dis.available() != 0) {

		    	// this statement reads the line from the file and print it to
		    	// the console.
				String[] str;
				String[] tmpstr=null;
				str=dis.readLine().split("\t");
				System.out.println(i);
				//for(j=1;j<str.length;j++){
				for(j=1;j<str.length-1;j++){
					if (str[j].equals(null) || str[j].equals("")){
						str[j]="0";
					}
					a[i][j-1]=Double.parseDouble(str[j]);
				}

				i++;
			}
		    //intGCnt=myCnt;
		    // dispose all the resources after using them.
		    fis.close();
		    bis.close();
			dis.close();

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
		    e.printStackTrace();
    	}

		/****************/
		//System.exit(0);

		in=geneCnt;
		jm=condCnt;

		/*for(i=0;i<183;i++){
			for(j=0;j<79;j++){
				a[i][j]=i*j;
			}//for j
			//aiC=
		}//for i*/

		for(i=0;i<in;i++){
			aiJ[i]=0;
		}

		for(j=0;j<jm;j++){
			aIj[j]=0;
		}

		cal_aIj(a,aIj,in,jm);
		cal_aiJ(a,aiJ,in,jm);

		for(i=0;i<in;i++){
			for(j=0;j<jm;j++){
				System.out.println("a["+ i +"]["+ j +"] : "+ a[i][j]);
			}//for j
			//aiC=
		}//for i

		for(j=0;j<jm;j++){
			System.out.println("aIj["+ j +"] : "+ aIj[j]);
		}//for j

		aIJ = 0;
		   for (i=0;i<in;i++)
		      aIJ += aiJ[i];
   		aIJ /= in;

   		hij =0;
		for(i=0;i<in;i++){
			for(j=0;j<jm;j++){
		       //temp = *(a+I[i]*m+J[j]) - *(aiJ+i)- *(aIj+j)+aIJ;
		       temp = a[i][j]-aiJ[i]-aIj[j]+aIJ;
		       temp *= temp;
		       hij  += temp;
		    }
		}
   		hij /=(in*jm);

   		System.out.println("Msrs : "+ hij);

   		return hij;

	}//calMsrs

	private void cal_aiJ(double[][] a,double[] arriJ,int in,int jm){

			int i,j;

			for(i=0;i<in;i++){
		    	arriJ[i] = 0;
			    for(j=0;j<jm;j++)
		    		arriJ[i] += a[i][j];//*(a+I[i]*m+J[j]);
		    	arriJ[i] /= jm;
     		}

	}

	private void cal_aIj(double[][] a,double[] arrIj,int in,int jm){

		int i,j;

		for(j=0;j<jm;j++){
        		arrIj[j] = 0;
		        for(i=0;i<in;i++)
          			arrIj[j] += a[i][j];//*(a+I[i]*m+J[j]);
        		arrIj[j] /= in;
     		}

	}
	//End Calculate Msrs

	//calBimaxBicluster
	private void calBimaxBicluster(){
		Preprocessor pre;

		final BimaxBicluster frame = new BimaxBicluster();

		pre = new Preprocessor(frame);

		//frame.loadData("dataSample_1.txt",1,1);
		System.out.println("load data");
		frame.loadData("geneexpro-union.txt",1,1);
		System.out.println("preprocess data");
		frame.setPreprocessRun();
		System.out.println("run bimax");
        frame.runBiMax();
	}

	//BiCluster LoadData
	//public void loadData(File file, int colOffset, int rowOffset) {
        /*public void loadData(String fileName, int colOffset, int rowOffset) {

		try {

			/*if (debug)
				System.out.println("Opening: " + file.getName() + ".");*/
        /*                File file = new File(fileName); // BicatGui.currentDirectoryPath

			pre = new Preprocessor();
			pre.readMainDataFile(file, colOffset, rowOffset);

			// get the last loaded dataset be the current one ...
			/*addDataset(pre.getOriginalData(), pre.getOriginalData(), pre
				.getDiscreteData(), // (true) ?
				pre.getGeneNames(), pre.getChipNames(), pre
						.getWorkingChipNames(),
				pre.getHeaderColumnLabels(), pre.getHeaderColumns());*/

			// make sure BicaGUI has the data and display it in the PicturePane
			/*setData(currentDataset.getOrigData());
			pp.setData(rawData);
			readjustPictureSize();
			pp.repaint();*/

			/*
			 * ... add the new labels... labels = pre.getHeaderColumnLabels();
			 * for(int i = 0; i < labels.size(); i++) { JMenuItem mi = new
			 * JMenuItem("Label by \""+(String)labels.get(i)+"\"");
			 * mi.setActionCommand(""+i); mi.addActionListener(this);
			 * labelMenu.add(mi); }
			 */

			//updateColumnHeadersMenu(); // does the same twice?

			/*buildTree();
			tree.setSelectionPath(originalPath);*/
		/*} catch (FileOffsetException ee) {
			//BicatError.wrongOffsetError();
		}
	}//BiCluster loadData

	//BiCluster setPreprocessRun
	//public void setPreprocessRun(PreprocessOption po) {
	public void setPreprocessRun() {

		/*if (debug)
			System.out.println("What current Dataset is it? "
					+ currentDatasetIdx);*/
		/*double discretizationThreshold=2.0;
		//preprocessOptions = new PreprocessOption(po);
		preprocessOptions = new PreprocessOption();

		preprocessOptions.setDiscretizationTrue();
		preprocessOptions.setDiscretizationThreshold(discretizationThreshold);
		preprocessOptions.setDiscretizationMode("threshold");
		preprocessOptions.setDiscretizationScheme(PreprocessOption.PREPROCESS_OPTIONS_DISCRETIZATION_UP);

		//if (po.do_compute_logarithm)
		if (preprocessOptions.do_compute_logarithm)
			logBaseSetting = preprocessOptions.logarithmBase;

		if (preprocessOptions.do_normalize) { /* ... */
		/*}

		if (preprocessOptions.do_discretize) {

			if (preprocessOptions.discretizationScheme == PreprocessOption.PREPROCESS_OPTIONS_DISCRETIZATION_COEXPRESSED)
				preprocessExtended = true;
			else
				preprocessExtended = false;
		}

		// ....

		pre.resetData(currentDataset.getOrigData());
		pre.preprocessData(preprocessOptions);
		System.out.println("Preprocessing with setup: \n" + preprocessOptions.toString());

		// ....
		if (preprocessOptions.discretizationScheme == PreprocessOption.PREPROCESS_OPTIONS_DISCRETIZATION_COEXPRESSED) {
			processExtended = true;
			discretizeExtended = true;
		}

		discretizeComplete = true;
		preprocessComplete = true; // preprocessed data are now available

		// show results to user
		/*setData(pre.getPreprocessedData());
		pp.setData(rawData);
		readjustPictureSize();
		pp.repaint();*/

		// ... update the just-processed data
		/*if (preprocessExtended)
			currentDataset.setExtended();
		else
			currentDataset.resetExtended();

		currentDataset.setPreData(pre.getPreprocessedData());

		if (preprocessOptions.do_discretize) {
			currentDataset.setDiscrData(pre.getDiscreteData());
		} // binary,
		// or
		// discrete
		// currentDataset.setVisualDiscrData(pre.getDiscreteData()); // discrete
		currentDataset.setPreprocessComplete();

	}//BiCluster setPreprocessRun*/

}//MyTree

class MyNode{
	MyNode(String theId,String theIsa){
		id=theId;
		isa=theIsa;
		left=right=null;
		level=0;
		mapg="";
		clustered=0;
		//mapped=false;
	}//MyNode constructor

	String id;
	String isa;
	MyNode left;
	MyNode right;
	int level;
	String mapg;
	int clustered;
	//boolean mapped;
}//MyNode


