library(ggplot2)
#load the RData_rna file to get all the other variables

wdat<-read.csv('weak_mash.csv')
rwdat<-read.csv('rweak_mash.csv')

pub_theme<-opts(panel.grid.minor= theme_blank(), panel.grid.major= theme_blank(),
                panel.background=theme_blank(),panel.border=theme_blank(),
                axis.line=theme_segment(),legend.key=theme_blank())
                
pub_ltheme<-opts(panel.grid.minor= theme_blank(), panel.grid.major= theme_blank(),
                panel.background=theme_blank(),panel.border=theme_blank(),
                axis.line=theme_segment())
                
pub_ltheme2<-opts(panel.grid.minor= theme_blank(), panel.grid.major= theme_blank(),
                panel.background=theme_blank(),
                axis.line=theme_segment())


lh_df<-data.frame(w=lhw,u=h1u)
lh_km<-data.frame(u=c(h1u,h1u),km=c(exp(-h1u*atop_lhrd_fd),exp(-atot_lhrd_fd*h1u)),
                   Legend=factor(rep(c('db','dn'),each=length(h1u)),levels=c('dn','db')))          

g<-qplot(h1u,lhw)+geom_line(data=lh_km,aes(x=u,y=km,linetype=Legend))
#g<-g+opts(axis.text.x=theme_text(lineheight=10),axis.text.y=theme_text(lineheight=10))
g<-g+scale_linetype('',breaks=c('dn','db'),labels=c("Estimate using " ~ D[n],"Estimate using "~ D[b]))
g<-g+theme_bw(28)+pub_theme+opts(legend.position=c(.8,.9),legend.key=theme_blank())
g<-g+xlab('Genomic mutation rate')+ylab('Relative fitness')
g<-g+coord_trans(y='log')+ylim(.25,1)+xlim(0,2) 
g<-g+opts(axis.title.x=theme_text(vjust=0,size=28),axis.title.y=theme_text(hjust=0.25,angle=90,size=28))
#g<-g+opts(axis.title.x=theme_text(size=28),axis.title.y=theme_text(size=28))
postscript('fitvu_steep.ps', onefile=FALSE,horizontal=FALSE,paper="special",width=8,height=7,pointsize=16)
#pdf('fitvu_steep.pdf',width=8,height=7)
print(g)          
dev.off()

l2_df<-data.frame(w=exp(-al2_fd_tot*l2u),u=l2u,lab=rep('dn',length(l2u)))
g<-qplot(l2u,l2w)+geom_line(data=l2_df,aes(x=u,y=w,linetype=lab))
#g<-g+scale_linetype_manual('',values=c("Estimate using " ~ D[n]))
g<-g+scale_linetype('',breaks=c('dn'),labels=c('Estimate using ' ~D[n]))
g<-g+xlab('Genomic mutation rate')+ylab('Relative fitness')
g<-g+coord_trans(y='log')+ylim(.24,1)+xlim(0,2.6)
g<-g+theme_bw(28)+pub_theme+opts(legend.position=c(.8,.9),legend.key=theme_blank())
g<-g+opts(axis.title.x=theme_text(vjust=0,size=28),axis.title.y=theme_text(hjust=0.25,angle=90,size=28))
postscript('fitvu_shallow.ps',onefile=FALSE,horizontal=FALSE,paper="special",width=8,height=7,pointsize=16)
#pdf('fitvu_shallow.pdf',width=8,height=7)
print(g)
dev.off()

tbl_df<-data.frame(tm=rep(tm,4),w=c(tbl2[,1],tbl2[,4],tbl2[,7],tbl2[,10])/100,ulev=factor(rep(1:4,each=500)))
tl_df<-data.frame(tm=rep(tm,4),w=c(tl2[,1],tl2[,4],tl2[,7],tl2[,10])/100,ulev=factor(rep(1:4,each=500,2)))
text_df<-data.frame(tm=rep(4500,4),w=c(1,.86,.70,.54),words=c('U=0.05','U=0.29','U=0.65','U=1.06'),ulev=1:4)
g<-qplot(tm,w,data=tbl_df,group=ulev,geom='line')+geom_line(data=tl_df,aes(tm,w,group=ulev),linetype=3)
g<-g+geom_text(data=text_df,aes(x=tm,y=w,label=words))
g<-g+geom_text(data=data.frame(tm=2500,w=1,word="Shallow Landscape",ulev=1),aes(tm,w,label=word,size=7))
g<-g+scale_size(legend=FALSE)
g<-g+xlab('Generation')+ylab('Relative fitness')
g<-g+theme_bw(20)+pub_theme
postscript('l2_fit_time.ps',onefile=FALSE,horizontal=FALSE,paper="special",width=8,height=7)
print(g)
dev.off()


st_sl<-data.frame(w=c(lhw,l2w),u=c(h1u,l2u),Landscape=factor(c(rep('Steep',13),rep('Shallow',14)),levels=c('Steep','Shallow')))
gf<-qplot(u,w,data=st_sl,shape=Landscape,size=I(3))
gf<-gf+xlab('Genomic mutation rate')+ylab('Relative fitness')
gf<-gf+coord_trans(y='log')+ylim(.24,1)+xlim(0,2.6)
gf<-gf+theme_bw(20)+pub_theme+opts(legend.position=c(.8,.9),legend.key=theme_blank())
gf<-gf+opts(axis.title.x=theme_text(vjust=0,size=20),axis.title.y=theme_text(hjust=0.5,angle=90,size=20))
postscript('fitvu_cmp.ps', onefile=FALSE,horizontal=FALSE,paper="special",width=8,height=7)
#pdf('fitvu_cmp.pdf',width=8,height=7)
print(gf)
dev.off()

    
fd_df<-data.frame(u=rep(l2u,3),frac=c(l2_fd_final,1-l2_fd_final-l2_fb_final,l2_fb_final),mut_type=factor(rep(c('Deleterious','Neutral','Beneficial'),each=length(l2u)),levels=c('Deleterious','Neutral','Beneficial')))
text_labs<-data.frame(u=c(1.25,1.25,1.25),frac=c(.65,.35,.08),mut_type=c('Deleterious','Neutral','Beneficial'))
g<-qplot(u,frac,data=fd_df,geom='line',linetype=mut_type)+scale_linetype(legend=FALSE)
g<-g+geom_text(data=text_labs,aes(x=u,y=frac,label=mut_type))
g<-g+geom_text(data=data.frame(u=1.25,frac=.9,mut_type="Shallow Landscape"),aes(x=u,y=frac,label=mut_type,size=8))
g<-g+scale_size(legend=F)
g<-g+xlab('Genomic mutation rate')+ylab('Freq. of new Mutation Types at Equil.')
g<-g+ylim(0,1)+theme_bw(20)+pub_theme+opts(axis.title.y=theme_text(hjust=0.25,size=20,angle=90,vjust=.35))
postscript('fdel_fben_shallow.ps', onefile=FALSE, horizontal=FALSE, paper="special",width=8,height=7)
print(g)
dev.off()                

lh_df<-data.frame(w=lhw,u=h1u)
lh_km<-data.frame(u=c(h1u,h1u),km=c(exp(-h1u*atop_lhrd_fd),exp(-atot_lhrd_fd*h1u)),
                   Legend=factor(rep(c('db','dn'),each=length(h1u)),levels=c('dn','db')))          
dat<-read.csv('mut_vals.csv')
cols<-c(4,5,7)
vnames<-c('harmonic_s','delta_g','Db')
for (val in 1:3) {
    tmp<-with(dat,tapply(dat[,cols[val]],list(gen,mut_rate),mean))
    tmp<-as.data.frame(tmp)
    tmp$gen<-rownames(tmp)
    print(tmp)
    tmp2<-melt(tmp,id="gen")
    print(tmp2)
    if (val==1) {
        df<-cbind(tmp2,vname=vnames[val])
        }
    else {
        df<-rbind(df,cbind(tmp2,vname=vnames[val]))
        }
    }
df$variable<-factor(df$variable,levels=c('low','mid','high'))
df
init_harmonic<-0.73429602888086631
init_dg<- -27.100000000000001
init_db<-0.76094276094276092

df2<-data.frame(gen=rep(0,9),variable=rep(c('low','mid','high'),each=3),value=rep(c(init_harmonic,init_dg,init_db),3),vname=rep(c('Db','delta_g','harmonic_s'),3))

df3<-rbind(df,df2)


pub_ltheme<-opts(panel.grid.minor= theme_blank(), panel.grid.major= theme_blank(),
                panel.background=theme_blank(),
                axis.line=theme_segment(),legend.position='none')

g<-qplot(gen,value,data=df3[df3$vname=="harmonic_s",],size=4,legend=FALSE)+facet_grid(.~variable)
g<-g+ylab(expression(bar(s)))+xlab('Generation')+theme_bw(20)+pub_ltheme+opts(axis.text.x=theme_text(angle=45,hjust=1,size=16))
postscript('harm_s.ps',onefile=FALSE,horizontal=FALSE,paper="special",width=8,height=7,pointsize=16)
#pdf('harm_s.pdf',width=5.5,height=4)
print(g)
dev.off()

g<-qplot(gen,value,data=df3[df3$vname=="Db",],size=4)+facet_grid(.~variable)
g<-g+ylab(expression(D[b]))+xlab('Generation')+theme_bw(20)+pub_ltheme+opts(axis.text.x=theme_text(angle=45,hjust=1,size=16))
g<-g+ylim(.5,1)
postscript('Db.ps',onefile=FALSE,horizontal=FALSE,paper="special",width=8,height=7,pointsize=16)
#pdf('Db.pdf',width=5.5,height=4)
print(g)
dev.off()

g<-qplot(gen,value,data=df3[df3$vname=="delta_g",],size=4)+facet_grid(.~variable)
g<-g+ylab(expression(Delta * G))   +xlab('Generation')+theme_bw(20)+pub_ltheme+opts(axis.text.x=theme_text(angle=45,hjust=1,size=16))
postscript('delta_g.ps',onefile=FALSE,horizontal=FALSE,paper="special",width=8,height=7,pointsize=16)
#pdf('delta_g.pdf',width=5.5,height=4)
print(g)
dev.off()

ml2_dis<-read.csv('ml2_fit_dis.csv')
g<-qplot(U,fitness,data=ml2_dis,fill=num_ind,width=width,geom='tile')
g<-g+scale_fill_continuous('Individuals',low='white',high='black')
g<-g+xlab('Genomic mutation rate')+ylab('Relative fitness')
g<-g+coord_cartesian(xlim=c(0,2.562),ylim=c(0,1))
#g<-g+opts(legend.title=theme_text(angle=90))
g<-g+theme_bw(28)+pub_theme
postscript('ml2_fit_dis.ps',onefile=FALSE,horizontal=FALSE,paper="special",width=8,height=7,pointsize=16)
#pdf('ml2_fit_dis.pdf',width=8,pointsize=16)
print(g)
dev.off()

mlhrd_dis<-read.csv('mlhrd_fit_dis.csv')
g<-qplot(U,fitness,data=mlhrd_dis,fill=num_ind,width=width,geom='tile')
g<-g+scale_fill_continuous('Individuals',low='white',high='black')
g<-g+xlab('Genomic mutation rate')+ylab('Relative fitness')
g<-g+coord_cartesian(xlim=c(0,1.936),ylim=c(0,1))
#g<-g+opts(legend.title=theme_text(angle=90))
g<-g+theme_bw(28)+pub_theme
postscript('mlhrd_fit_dis.ps',onefile=FALSE,horizontal=FALSE,paper="special",width=8,height=7,pointsize=16)
#pdf('mlhrd_fit_dis.pdf',width=8,pointsize=16)
print(g)
dev.off()



ml2_fit_dis_new<-read.csv('ml2_fit_mashup3.csv')

p1<-ggplot(ml2_fit_dis_new)
p1<-p1+geom_histogram(aes(x=w,y=..density..),binwidth=0.025)
p1<-p1+facet_grid(U~.)
p1<-p1+xlab('Fitness')+ylab('Density')+theme_bw(18)+pub_ltheme2

print(p1)

mlhrd_fit_dis_new<-read.csv('mlhrd_fit_mashup3.csv')
p2<-ggplot(mlhrd_fit_dis_new,aes(x=w))
p2<-p2+geom_histogram(aes(y=..density..))
p2<-p2+facet_grid(U~.)
p2<-p2+xlab('Fitness')+ylab('Density')+theme_bw(18)+pub_ltheme2
print(p2)

g<-qplot(h1u,lhw)+geom_line(data=lh_km,aes(x=u,y=km,linetype=Legend))
#g<-g+opts(axis.text.x=theme_text(lineheight=10),axis.text.y=theme_text(lineheight=10))
g<-g+scale_linetype('',breaks=c('dn','db'),labels=c("Estimate using " ~ D[n],"Estimate using "~ D[b]))
g<-g+theme_bw(28)+pub_theme+opts(legend.position=c(.8,.9),legend.key=theme_blank())
g<-g+xlab('Genomic mutation rate')+ylab('Relative fitness')
g<-g+coord_trans(y='log')+ylim(.25,1)+xlim(0,2) 
g<-g+opts(axis.title.x=theme_text(vjust=0,size=28),axis.title.y=theme_text(hjust=0.25,angle=90,size=28))
#g<-g+opts(axis.title.x=theme_text(size=28),axis.title.y=theme_text(size=28))
postscript('fitvu_steep.ps', onefile=FALSE,horizontal=FALSE,paper="special",width=8,height=7,pointsize=16)
#pdf('fitvu_steep.pdf',width=8,height=7)
print(g) 

postscript('fit_merged_steep.ps',width=18,height=7,pointsize=16)
grid.newpage()
pushViewport(viewport(height=.9,layout=grid.layout(1,2)))
p2<-p2+opts(axis.title.x=theme_text(vjust=0,size=28),axis.title.y=theme_text(hjust=0.25,angle=90,size=28))
print(g, vp= vplayout(1,1))
print(p2, vp=vplayout(1,2))
grid.text('A',0.05,-.025,gp=gpar(fontsize=20))
grid.text('B',0.55,-.025,gp=gpar(fontsize=20))
dev.off()

vplayout <- function(x,y) viewport(layout.pos.row=x,layout.pos.col = y)
postscript('fit_dis_merged.ps',width=8,height=7,pointsize=16)
grid.newpage()
pushViewport(viewport(height=.9,layout=grid.layout(1,2)))
print(p2, vp= vplayout(1,1))
print(p1,vp=vplayout(1,2))
grid.text('A',0.05,0,gp=gpar(fontsize=18))
grid.text('B',0.55,0,gp=gpar(fontsize=18))
dev.off()

g<-qplot(l2u,l2w)+geom_line(data=l2_df,aes(x=u,y=w,linetype=lab))
#g<-g+scale_linetype_manual('',values=c("Estimate using " ~ D[n]))
g<-g+scale_linetype('',breaks=c('dn'),labels=c('Estimate using ' ~D[n]))
g<-g+xlab('Genomic mutation rate')+ylab('Relative fitness')
g<-g+coord_trans(y='log')+ylim(.24,1)+xlim(0,2.6)
g<-g+theme_bw(28)+pub_theme+opts(legend.position=c(.8,.9),legend.key=theme_blank())
g<-g+opts(axis.title.x=theme_text(vjust=0,size=28),axis.title.y=theme_text(hjust=0.25,angle=90,size=28))


postscript('fit_merged_shallow.ps',width=18,height=7,pointsize=16)
grid.newpage()
pushViewport(viewport(height=.9,layout=grid.layout(1,2)))
p1<-p1+opts(axis.title.x=theme_text(vjust=0,size=28),axis.title.y=theme_text(hjust=0.25,angle=90,size=28))
print(g, vp= vplayout(1,1))
print(p1, vp=vplayout(1,2))
grid.text('A',0.05,-.025,gp=gpar(fontsize=20))
grid.text('B',0.55,-.025,gp=gpar(fontsize=20))
dev.off()

ml_mid<-read.csv('ml_mid_mash2.csv')
ml_mid_df<-data.frame(w=exp(-ml_mid$fdel*h1u),u=h1u,lab=rep('dn',length(h1u)))
g<-qplot(h1u,ml_mid$w/100)+geom_line(data=ml_mid_df,aes(x=u,y=w,linetype=lab))
g<-g+scale_linetype('',breaks=c('dn'),labels=c('Estimate using ' ~D[n]))
g<-g+theme_bw(28)+pub_theme+opts(legend.position=c(.8,.9),legend.key=theme_blank())
g<-g+xlab('Genomic mutation rate')+ylab('Relative fitness')
g<-g+coord_trans(y='log')+ylim(.25,1)+xlim(0,2) 
g<-g+opts(axis.title.x=theme_text(vjust=0,size=28),axis.title.y=theme_text(hjust=0.25,angle=90,size=28))

ml_mid_fit<-read.csv('ml_mid_fit_mashup3.csv')
p3<-ggplot(ml_mid_fit,aes(x=w))
p3<-p3+geom_histogram(aes(y=..density..))
p3<-p3+facet_grid(U~.)
p3<-p3+xlab('Fitness')+ylab('Density')+theme_bw(18)+pub_ltheme2

postscript('fit_merged_mid.ps',width=18,height=7,pointsize=16)
grid.newpage()
pushViewport(viewport(height=.9,layout=grid.layout(1,2)))
p3<-p3+opts(axis.title.x=theme_text(vjust=0,size=28),axis.title.y=theme_text(hjust=0.25,angle=90,size=28))
print(g, vp= vplayout(1,1))
print(p3, vp=vplayout(1,2))
grid.text('A',0.05,-.025,gp=gpar(fontsize=20))
grid.text('B',0.55,-.025,gp=gpar(fontsize=20))
dev.off()

mlhrd_sm_df<-data.frame(w=exp(-alh_sm_fd_tot*h1u[1:12]),u=h1u[1:12],lab=rep('dn',12))
g<-qplot(h1u[1:12],lh_sm_w)+geom_line(data=mlhrd_sm_df,aes(x=u,y=w,linetype=lab))
g<-g+scale_linetype('',breaks=c('dn'),labels=c('Estimate using ' ~D[n]))
g<-g+theme_bw(28)+pub_theme+opts(legend.position=c(.8,.9),legend.key=theme_blank())
g<-g+xlab('Genomic mutation rate')+ylab('Relative fitness')
g<-g+coord_trans(y='log')+ylim(.25,1)+xlim(0,1.6) rarp
g<-g+opts(axis.title.x=theme_text(vjust=0,size=28),axis.title.y=theme_text(hjust=0.25,angle=90,size=28))
print(g)

ml2_sm_fit<-read.csv('ml2_sm_fit_mashup2.csv')
p4<-ggplot(ml2_sm_fit,aes(x=w))
p4<-p4+geom_histogram(aes(y=..density..))
p4<-p4+facet_grid(U~.)
p4<-p4+xlab('Fitness')+ylab('Density')+theme_bw(18)+pub_ltheme2

mlhrd_sm_fit<-read.csv('mlhrd_sm_fit_mashup2.csv')
p5<-ggplot(mlhrd_sm_fit,aes(x=w))
p5<-p5+geom_histogram(aes(y=..density..))
p5<-p5+facet_grid(U~.)
p5<-p5+xlab('Fitness')+ylab('Density')+theme_bw(18)+pub_ltheme2
print(p5)

postscript('fit_merged_mid.ps',width=18,height=7,pointsize=16)
grid.newpage()
pushViewport(viewport(height=.9,layout=grid.layout(1,2)))
p3<-p3+opts(axis.title.x=theme_text(vjust=0,size=28),axis.title.y=theme_text(hjust=0.25,angle=90,size=28))
print(g, vp= vplayout(1,1))
print(p3, vp=vplayout(1,2))
grid.text('A',0.05,-.025,gp=gpar(fontsize=20))
grid.text('B',0.55,-.025,gp=gpar(fontsize=20))
dev.off()

mlhrd_sm<-read.csv('mlhrd_sm_mash.csv')
mlh_cmp<-data.frame(U=c(h1u,h1u[1:12]),W=c(lhw,mlhrd_sm$w/100),popsize=factor(c(rep('N=1000',13),rep('N=100',12))))
g<-qplot(data=mlh_cmp,x=U,y=W,shape=popsize)
g<-g+xlab('Genomic mutation rate')+ylab('Relative fitness')
g<-g+coord_trans(y='log')+ylim(.24,1)+xlim(0,2.6)+scale_shape_discrete(name='Population size')
g<-g+theme_bw(20)+pub_theme+opts(legend.position=c(.8,.9),legend.key=theme_blank())
g<-g+opts(axis.title.x=theme_text(vjust=0,size=20),axis.title.y=theme_text(hjust=0.5,angle=90,size=20))
#g<-g+geom_text(dat=data.frame(u=1.75,w=0.65,txt="Steep Landscape",popsize="small"),aes(x=u,y=w,label=txt,size=7))
g<-g+geom_text(aes(x=1.75,y=0.65,label="Steep Landscape",size=7))
g<-g+scale_size(legend=FALSE)
print(g)
postscript('fitvu_cmp.ps', onefile=FALSE,horizontal=FALSE,paper="special",width=8,height=7)
#pdf('fitvu_cmp.pdf',width=8,height=7)
print(g)
dev.off()

ml2_sm<-read.csv('ml2_sm_mash.csv')
ml2_cmp<-data.frame(U=c(l2u,l2u[1:13]),W=c(l2w,ml2_sm$w/100),popsize=factor(c(rep('N=1000',14),rep('N=100',13))))
g2<-qplot(data=ml2_cmp,x=U,y=W,shape=popsize)
g2<-g2+xlab('Genomic mutation rate')+ylab('Relative fitness')
g2<-g2+coord_trans(y='log')+ylim(.24,1)+xlim(0,2.6)+scale_shape_discrete(name='Population size')
g2<-g2+theme_bw(20)+pub_theme+opts(legend.position=c(.8,.9),legend.key=theme_blank())
#g2<-g2+geom_text(dat=data.frame(u=1.75,w=0.65,txt="Shallow Landscape",popsize="small"),aes(x=u,y=w,label=txt,size=7))
g2<-g2+geom_text(aes(x=1.75,y=0.65,label="Shallow Landscape",size=7))
g2<-g2+scale_size(legend=FALSE)
g2<-g2+opts(axis.title.x=theme_text(vjust=0,size=20),axis.title.y=theme_text(hjust=0.5,angle=90,size=20))
print(g2)
postscript('fitvu_cmp.ps', onefile=FALSE,horizontal=FALSE,paper="special",width=8,height=7)
#pdf('fitvu_cmp.pdf',width=8,height=7)
print(g)
dev.off()

ml2_sm_fit<-read.csv('ml2_sm_fit_mashup2.csv')
p4<-ggplot(ml_mid_fit,aes(x=w))
p4<-p4+geom_histogram(aes(y=..density..))
p4<-p4+facet_grid(U~.)
p4<-p4+xlab('Fitness')+ylab('Density')+theme_bw(18)+pub_ltheme2


postscript('popsize_cmp.ps',width=18,height=7,pointsize=16)
grid.newpage()
pushViewport(viewport(height=.9,layout=grid.layout(1,2)))
p3<-p3+opts(axis.title.x=theme_text(vjust=0,size=28),axis.title.y=theme_text(hjust=0.25,angle=90,size=28))
print(g, vp= vplayout(1,1))
print(g2, vp=vplayout(1,2))
grid.text('A',0.05,-.025,gp=gpar(fontsize=20))
grid.text('B',0.55,-.025,gp=gpar(fontsize=20))
dev.off()

postscript('num_ben.ps',onefile=F,horizontal=F,paper="special",width=8,height=7)
g<-qplot(h1u,num_ben)
g<-g+xlab('Genomic mutation rate')+ylab('Number of Beneficial Mutations')
g<-g+theme_bw(20)+pub_theme
g<-g+opts(axis.title.x=theme_text(vjust=0,size=20),axis.title.y=theme_text(hjust=0.5,angle=90,size=20))
print(g)
dev.off()