import numpy as np
cimport numpy as np
import sys
import globs
DTYPE = np.float64
DTYPE2 = np.int32
ctypedef np.float64_t DTYPE_t
ctypedef np.int32_t DTYPE2_t
cdef extern from "fold.h":
    float fold(char *seq,char *structure)
    void free_arrays()
cdef extern from "inverse.h":
    float inverse_fold(char *start, char *target)
cdef extern from "fold_vars.h":
    int dangles
cdef extern from "stdlib.h":
    ctypedef unsigned int size_t
    size_t strlen(char *s)
def hamming(char *gtype, char *targ):
    cdef int d,slen,i
    d=0
    slen=strlen(targ)
    for i from 0<=i<slen:
        if gtype[i] != targ[i]:
            d+=1
    return d
    
def fold_params():
    dangles=2
def pyfold(char *s):  
    cdef char structure[130]
    fold(s,structure)
    return structure
cdef char * bases='ACGU'
def mutc(char *seq):
    cdef int i,mutated
    #cdef char bases[4],mcod
    cdef char mutseq[130]
    cdef char mcod
    cdef DTYPE_t fidel = globs.fidelity
    mutated=0
    mutseq[globs.glength]=0
    cdef np.ndarray[DTYPE_t,ndim=1] rnums = np.random.random(globs.glength)
    for i from 0<=i<globs.glength:
        if rnums[i]>fidel:
            if mutated ==0:
                mutated=1
            mcod=bases[np.random.randint(0,4)]
            while mcod == seq[i] :
                mcod=bases[np.random.randint(0,4)]
            mutseq[i]=mcod
        else:
            mutseq[i]=seq[i]
    return mutseq if mutated else None
    
def bias_mut(char *seq):
    cdef int i, mutated
    cdef char mutseq[130]
    cdef char mcod
    cdef DTYPE_t fidel = globs.fidelity
    mutated=0
    mutseq[globs.glength]=0
    cdef np.ndarray[DTYPE_t,ndim=1] rnums = np.random.random(globs.glength)
    for i from 0<=i<globs.glength:
        if rnums[i]>fidel:
            if mutated ==0:
                mutated=1
            mcod=bases[np.random.randint(0,4)]
            while mcod == seq[i] :
                mcod=bases[np.random.randint(0,4)]
            mutseq[i]=mcod
        else:
            mutseq[i]=seq[i]
    return mutseq if mutated else None
    
def mutchrom(char *seq1, char * seq2):
    cdef int i,mutated
    #cdef char bases[4],mcod
    cdef char mutseq1[130],mutseq2[130]
    cdef char mcod
    cdef float fidel
    fidel=globs.fidelity
    mutated1=0
    mutated2=0
    mutseq1[globs.glength]=0
    mutseq2[globs.glength]=0
    rnums1=np.random.random(globs.glength)
    rnums2=np.random.random(globs.glength)
    for i from 0<=i<globs.glength:
        if rnums1[i]>fidel:
            if mutated1==0:
                mutated1=1
            mcod=bases[np.random.randint(0,4)]
            while mcod == seq1[i] :
                mcod=bases[np.random.randint(0,4)]
            mutseq1[i]=mcod
        else:
            mutseq1[i]=seq2[i]
    for i from 0<=i<globs.glength:
            if rnums2[i]>fidel:
                if mutated2==0:
                    mutated2=1
                mcod=bases[np.random.randint(0,4)]
                while mcod == seq2[i] :
                    mcod=bases[np.random.randint(0,4)]
                mutseq2[i]=mcod
            else:
                mutseq2[i]=seq2[i]
    return (mutseq1,mutseq2) if (mutated1 or mutated2) else None
    
def choose_finite(np.ndarray[DTYPE2_t,ndim=1] offspringvec,int tot, int veclen):
    cdef int i
    cdef DTYPE2_t rv=np.random.randint(0,tot)
    for i from 0<=i<veclen:
        rv-=offspringvec[i]
        if rv<0:
            return int(i)

def inverse(char *start, char * target):
    inverse_fold(start,target)
    return start
def pyfreemem():
    free_arrays()
    