# -*- coding: utf-8 -*-
import numpy as np
import sys
from pyrna import *
import globs
from Bio.Nexus import Trees
def getfit(shape,targ=None,fitpar=None):
    #doesn't use hyperbolic anymore, can probably ditch
    if targ:
        if fitpar:
            fitness=globs.lin_scale-fitpar*hamming(shape,targ)
        else:
            fitness=globs.lin_scale-globs.lin_coeff*hamming(shape,targ)
        if fitness<0.0:
            fitness=0.0
    else:
        if globs.fitfun is 'h':
            fitness=1.0/(globs.alpha+(float(hamming(shape,globs.target))/globs.glength)**globs.beta)
        elif globs.fitfun is 'l':
            if fitpar:
                fitness=globs.lin_scale-fitpar*hamming(shape,globs.target)
            else:
                fitness=globs.lin_scale-globs.lin_coeff*hamming(shape,globs.target)
            if fitness<0.0:
                fitness=0.0
    return fitness

    
def fit_dom(shp1,shp2):
    '''
    replaces old seg fit of geometric mean. kept for relic's sake
    np.sqrt(getfit(self.shp1)*getfit(self.shp2,globs.add_targs[0]))
    '''
    fit1=getfit(shp1)
    fit2=getfit(shp2,globs.add_targs[0],globs.c2_fitpar)
    '''
    if globs.h !=0.5:
        comb_fit=max((fit1,fit2))-globs.h*(100-min((fit1,fit2)))
    else:
        comb_fit=(fit1+fit2)/2.0
    '''
    comb_fit=max((fit1,fit2))*(1-globs.h) + globs.h*min((fit1,fit2))
    if comb_fit<0.0:
        comb_fit=0
    return comb_fit
    
class onechrom(object):
    def __init__(self,gtype,id,count,par_id,par_fit=None,depth=0,gen=0,shp=None,fit=None):
        self.p_id=par_id
        self.id=id
        if shp:
            self.shape=shp
        else:
            self.shape=pyfold(gtype)
        self.prev_copies=0
        self.cur_copies=count
        self.gen=gen
        if fit:
            self.fitness=fit
        else:
            self.fitness=getfit(self.shape)
        self.sel_coeff=(self.fitness-par_fit)/par_fit if par_fit else 0
        
class segchroms(object):
    def __init__(self,gtype,id,count,par_id,par_fit=None,depth=0,gen=0,shp=None,fit=None):
        self.p_id=par_id
        self.id=id
        self.prev_copies=0
        self.cur_copies=count
        self.gen=gen
        if shp:
            self.shp1=shp[0]
            self.shp2=shp[1]
        else:
            self.shp1=pyfold(gtype[0])
            self.shp2=pyfold(gtype[1])
        self.shps=(self.shp1,self.shp2)
        if fit:
            self.fitness=fit
        else:
            self.fitness=fit_dom(self.shp1,self.shp2)
        self.sel_coeff=(self.fitness-par_fit)/par_fit if par_fit else 0

if globs.chroms == 1:
    genotype=onechrom
else:
    genotype=segchroms
    
class population(object):
    def __init__(self,init_gtypes=None):
        self.num_new_seqs=1
        self.pop=dict()
        self.mean_fit=0.0
        self.gtype_in_pop=0
        self.fdel=0.0
        self.fben=0.0
        self.avg_del=0.0
        self.avg_ben=0.0
        self.avg_adel=0.0
        self.avg_aben=0.0
        self.num_mut=0
        self.gtypes=[]
        self.offspringvect=[]
        self.maxfit=0.0
        self.rec_chamber=False
        self.totoffspring=0
        self.wfdel=0.0
        self.wfben=0.0
        self.muttotw=0.0
        self.optonly=0.0
        self.ofdel=0.0
        self.avg_rs=0.0
        self.psize=0
        #TRY TO FIGURE OUT ANCESTRY WITH REC LEAVE OUT FOR NOW
        #self.ancestry={}
        #self.ancestry_tree=Trees.Tree()
        #self.ancestry_map={}
        #self.node_ancestry_map={}
        if init_gtypes:
            if not globs.evpop:
                for gtype,num_copies in init_gtypes:
                    self.psize+=int(num_copies)
                    if globs.comp_freq:
                        if globs.ploidy==1:
                            if len(gtype.split(','))==1:
                                self.pop[(gtype,globs.rs_val)]=genotype(gtype,self.num_new_seqs,int(int(num_copies)*globs.comp_freq),0,0)                        
                                self.num_new_seqs+=1
                                self.pop[(gtype,0)]=genotype(gtype,self.num_new_seqs,int(int(num_copies)*(1-globs.comp_freq)),0,0)
                                self.num_new_seqs+=1
                            else:
                                fgtype=tuple(gtype.split(','))
                                self.pop[(fgtype,globs.rs_val)]=genotype(fgtype,self.num_new_seqs,int(int(num_copies)*globs.comp_freq),0,0)
                                
                                self.pop[(fgtype,0)]=genotype(fgtype,self.num_new_seqs,int(int(num_copies)*(1-globs.comp_freq)),0,0)
                        else:
                            temp=gtype.split(',')
                            fgtype=[]
                            for i in range(0,len(temp),2):
                                fgtype.append(tuple(temp[i],temp[i+1]))
                            fgtype=tuple(fgtype)
                            self.pop[(fgtype,(globs.rs_val,globs.rs_val))]=genotype(fgtype,self.num_new_seqs,int(int(num_copies)*globs.comp_freq),0,0)
                            
                            self.pop[(fgtype,(0,0))]=genotype(fgtype,self.num_new_seqs,int(int(num_copies)*(1-globs.comp_freq)),0,0)
                    else:
                        if globs.ploidy==1:
                            if len(gtype.split(','))==1:
                                self.pop[(gtype,globs.rs_val)]=genotype(gtype,self.num_new_seqs,int(num_copies),0,0)
                            else:
                                fgtype=tuple(gtype.split(','))
                                self.pop[(fgtype,globs.rs_val)]=genotype(fgtype,self.num_new_seqs,int(num_copies),0,0)
                        else:
                            temp=gtype.split(',')
                            fgtype=[]
                            for i in range(0,len(temp),2):
                                fgtype.append(tuple(temp[i],temp[i+1]))
                            fgtype=tuple(fgtype)
                            self.pop[(fgtype,(globs.rs_val,globs.rs_val))]=genotype(fgtype,self.num_new_seqs,int(num_copies),0,0)
                    #self.ancestry[gtype]=onechrom(gtype,self.num_new_seqs,int(num_copies),0,0)
                    #self.node_ancestry_map[add_ancestry(gtype)]=gtype
                        self.num_new_seqs+=1
                
                #print gtype
                #print self.pop[gtype].shapex
            else:
                #NO IDEA HOW TO DEAL WITH EVOLVED   
                #NOT DONE YET, FIX TO INCLUDE EVOLVED POP INPUT
                if globs.comp == 'r':
                    #DO SOMETHING 
                    for gt,num_copies,no_rec in init_gtypes:
                        gtype=eval(gt)[0]
                        #print gtype
                        if int(no_rec):
                            self.pop[(gtype,0)]=genotype(gtype,self.num_new_seqs,int(num_copies),0,0)
                        else:
                            self.pop[(gtype,globs.rs_val)]=genotype(gtype,self.num_new_seqs,int(num_copies),0,0)
                        self.num_new_seqs+=1
                else:
                    #DO SOMETHING ELSE
                    for gt,num_copies,no_rec in init_gtypes:
                        gtype=eval(gt)
                        if int(no_rec):
                            self.pop[(gtype,0)]=genotype(gtype,self.num_new_seqs,int(num_copies),0,0)
                        else:
                            self.pop[(gtype,globs.rs_val)]=genotype(gtype,self.num_new_seqs,int(num_copies),0,0)
                        self.num_new_seqs+=1
        else:
            for _ in range(popsize):
                gtype=[globs.bases[np.random.randint(0,4)] for _ in range(globs.glength)]
                gtype=''.join(gtype)
                while gtype in self.pop:
                    gtype=[globs.bases[np.random.randint(0,4)] for _ in range(globs.glength)]
                    gtype=''.join(gtype)
                self.pop[gtype]=genotype(gtype,self.num_new_seqs,1,0,0)
                #self.ancestry[gtype]=onechrom(gtype,self.num_new_seqs,int(num_copies),0,0)
                #add_ancestry(gtype,self.ancestry,self.ancestry_tree)
                self.num_new_seqs+=1
        #pop test
        #for gtype in self.pop:
            #print gtype
            #print self.pop[gtype].cur_copies,self.pop[gtype].fitness,self.pop[gtype].shape
        #print globs.target
    
    def add_ancestry(newgtype,parent=None):
        if parent:
            pnode=self.ancestry_map[parent]
        else:
            pnode=0
        new_node=self.ancestry_tree.node(pnode).split(1)[0]
        self.ancestry_map[newgtype]=new_node
        self.node_ancestry_map[new_node]=newgtype
        
    def cull_ancestry(dead_gtype,ancestry,ancestry_tree,ancestry_map,node_ancestry_map):
        nid=self.ancestry_map[dead_gtype]
        prev=self.ancestry_tree.unlink(nid)
        self.ancestry_tree.kill(nid)
        descendents_left=self.ancestry_tree.node(prev).succ
        self.ancestry.pop(dead_gtype)
        self.node_ancestry_map.pop(nid)
        while not descendents_left:
            nid=prev
            prev=self.ancestry_tree.unlink(nid)
            self.ancestry_tree.kill(nid)
            dead_gtype=self.node_ancestry_map.pop(nid)
            self.ancestry.pop(dead_gtype)
            descendents_left=self.ancestry_tree.node(prev).succ
            
    def recomb(self,seq1,seq2):
        """
        simple uniform recombination function, using a maximum recombination length given in the input file
        """
        rec_point=np.random.randint(globs.glength)
        rec_len=np.random.randint(globs.max_rec)
        if np.random.random<0.5:
            #rec_start=max(rec_point-rec_len,0) 
            rec_end=rec_point
        else:
            rec_start=rec_point
            rec_end=min(rec_point+rec_len,globs.glength)
        rec_seq1=''.join([seq1[:rec_start],seq2[rec_start:rec_end],seq1[rec_end:]])
        rec_seq2=''.join([seq2[:rec_start],seq1[rec_start:rec_end],seq2[rec_end:]])
        return rec_seq1,rec_seq2
        
    def recomb2(self,seq1,seq2):
        '''
        the way I was doing recombination is kinda fucked up. redo as true crossover of variable length.
        not with a max bit as currently.
        '''
        rec_seq1,r1=seq1 
        rec_seq2,r2=seq2
        rands=np.random.random(len(seq1))
        #has_rec=False
        min_rec=min(r1,r2)/globs.glength
        for i in range(len(seq1)):
            if rands[i]<min_rec:
        #        if not has_rec:
        #            has_rec=True
                rec_seq1=''.join([rec_seq1[:i],rec_seq2[i:]])
                rec_seq2=''.join([rec_seq2[:i],rec_seq1[i:]])
        '''
        if has_rec:
            self.num_rec+=1
            
            if seq1 != rec_seq1:
                print seq1[0], rec_seq2
            if seq1 != rec_seq2:
                print seq1[0],rec_seq2
        '''
        if np.random.random()<globs.rs_linkage:
            t=r2
            r2=r1
            r1=t
        return rec_seq1,rec_seq2,r1,r2
        
    def seg(self,gtype1,gtype2):
        """
        basic junk function for segregation, expanded to handle any level of loci, or ploidy
        """
        #print gtype1,gtype2
        seg1=[]
        seg2=[]
        shps1=[]
        shps2=[]
        g1,s1=gtype1
        g2,s2=gtype2
        if globs.ploidy==1:
            seg_rate=min(s1,s2)
        else:
            seg_rate=min(min(s1),min(s2))
        if globs.ploidy==1:
            for i in range(len(g1)):

                if np.random.random()<=seg_rate:
                    if np.random.random()<0.5:
                        seg1.append(g1[i])
                        seg2.append(g2[i])
                        shps1.append(self.pop[gtype1].shps[i])
                        shps2.append(self.pop[gtype2].shps[i])
                    else:
                        seg1.append(g2[0])
                        seg2.append(g1[0])
                        shps1.append(self.pop[gtype2].shps[i])
                        shps2.append(self.pop[gtype1].shps[i])
                        
                    if np.random.random()<0.5:
                        seg1.append(g2[0])
                        seg2.append(g2[1])
                        shps1.append(self.pop[gtype2].shps[0])
                        shps2.append(self.pop[gtype2].shps[1])
                    else:
                        seg1.append(g2[1])
                        seg2.append(g2[0])
                        shps1.append(self.pop[gtype2].shps[1])
                        shps2.append(self.pop[gtype2].shps[0])
        else:
            #diploidy
            #ugly, worth fixing?
            for i in range(len(g1)):
                cgt1=[]
                cshp1=[]
                cgt2=[]
                cshp2=[]
                if np.random.random()<0.5:
                    cgt1.append(g1[i][0])
                    cgt2.append(g1[i][1])
                    cshp1.append(self.pop[gtype1].shps[i][0])
                    cshp2.append(self.pop[gtype1].shps[i][1])
                else:
                    cgt1.append(g1[i][1])
                    cgt2.append(g1[i][0])
                    cshp1.append(self.pop[gtype1].shps[i][1])
                    cshp2.append(self.pop[gtype1].shps[i][0])
                
                if np.random.random()<0.5:
                    cgt1.append(g2[i][0])
                    cgt2.append(g2[i][1])
                    cshp1.append(self.pop[gtype2].shps[0])
                    cshp2.append(self.pop[gtype2].shps[1])
                else:
                    cgt1.append(g2[1])
                    cgt2.append(g2[0])
                    cshp1.append(self.pop[gtype2].shps[1])
                    cshp2.append(self.pop[gtype2].shps[0])
                seg1.append(tuple(cgt1))
                seg2.append(tuple(cgt2))
                shps1.append(tuple(cshp1))
                shps2.append(tuple(cshp2))
        #FIGURE OUT WHERE THIS CRAP GOES
            if np.random.random()<seg_rate:
                t=s2
                s2=s1
                s1=t
            return tuple(seg1),tuple(seg2),tuple(shps1),tuple(shps2),s1,s2  
        else:
            if np.random.random()<globs.rs_linkage:
                t=s2
                s2=s1
                s1=t
            return g1,g2,self.pop[gtype1].shps,self.pop[gtype2].shps,s1,s2
                
    def add_to_next_gen(self,indiv,gen,recparent=None,shps=None):
        """
        ultimate worker function, goes through and mutates given individual, keeps track of recombination and segreation 
        """
        if np.random.random()<=globs.rs_mut:
            #change var for recombination vs segregation
            newval=max(0,np.random.normal(indiv[1],.1))
            indiv=(indiv[0],newval)
        if globs.chroms==1:
            mutseq=mutc(indiv[0])
            '''
            if recparent:
                rec_shp1=pyfold(recparent)
                rec_shp2=pyfold(indiv)
                if mutseq:
                    rec_shp3=pyfold(mutseq)
                else:
                    rec_shp3=0
                #print getfit(rec_shp1),getfit(rec_shp2), (getfit(rec_shp3) if rec_shp3 else '')
            '''
            if mutseq:
                self.num_mut+=1
                mshp=pyfold(mutseq)
                mfit=getfit(mshp)
                mutseq=(mutseq,indiv[1])
                if globs.noben:
                    if (mfit-self.pop[indiv].fitness)>0.0:
                        #beneficial mutation switch
                        if indiv in self.pop:
                            self.pop[indiv].cur_copies+=1
                            if self.pop[indiv].fitness>self.maxfit:
                                self.maxfit=self.pop[indiv].fitness
                            self.mean_fit+=self.pop[indiv].fitness
                            return
                    else:
                        #neutral/deleterious switch
                        if mutseq in self.pop:
                            self.pop[mutseq].cur_copies+=1
                            if self.pop[mutseq].fitness>self.maxfit:
                                self.maxfit=self.pop[mutseq].fitness
                            self.mean_fit+=self.pop[mutseq].fitness
                            return
                        else:
                            if recparent:
                                indiv=recparent
                            self.pop[mutseq]=genotype(mutseq[0],self.num_new_seqs,1,
                                                        self.pop[indiv].id,self.pop[indiv].fitness,shp=mshp,fit=mfit,gen=gen)
                            #self.ancestry[mutseq]=genotype(mutseq,self.num_new_seqs,1,
                            #                            self.pop[indiv].id,self.pop[indiv].fitness,shp=mshp,fit=mfit,gen=gen)
                            
                            #self.node_ancestry_map[add_ancestry(gtype)]=gtype
                            
                            self.num_new_seqs+=1
                    
                    #think about how to fit in recomb with no beneficials
                    '''
                    else:
                        self.pop[indiv]=genotype(indiv,self.num_new_seqs,1,
                                                    self.pop[recparent].id,fit=self.pop[recparent].fitness,gen=gen)
                        self.num_new_seqs+=1
                        if self.pop[indiv].sel_coeff<-1.0/min(globs.popsize,self.totoffspring):
                            self.fdel+=1
                            self.avg_del+=self.pop[indiv].sel_coeff
                        elif self.pop[indiv].sel_coeff>1.0/min(globs.popsize,self.totoffspring):
                            self.fben+=1
                            self.avg_ben+=self.pop[indiv].sel_coeff
                    if self.pop[indiv].fitness>self.maxfit:
                        self.maxfit=self.pop[indiv].fitness
                    '''
                else:
                    #beneficials allowed
                    if mutseq in self.pop:
                            self.pop[mutseq].cur_copies+=1
                            if self.pop[mutseq].fitness>self.maxfit:
                                self.maxfit=self.pop[mutseq].fitness
                            self.mean_fit+=self.pop[mutseq].fitness
                            return
                    else:
                        if recparent:
                            indiv=recparent
                        self.pop[mutseq]=genotype(mutseq[0],self.num_new_seqs,1,
                                                    self.pop[indiv].id,self.pop[indiv].fitness,shp=mshp,fit=mfit,gen=gen)
                        #self.ancestry[mutseq]=genotype(mutseq,self.num_new_seqs,1,
                        #                            self.pop[indiv].id,self.pop[indiv].fitness,shp=mshp,fit=mfit,gen=gen)
                        
                        #self.node_ancestry_map[add_ancestry(gtype)]=gtype
                        
                        self.num_new_seqs+=1

                    
                self.mean_fit+=self.pop[mutseq].fitness
                self.muttotw+=self.pop[indiv].fitness
                if self.pop[mutseq].shape==globs.target:
                    self.optonly+=1
                if self.pop[mutseq].fitness>self.maxfit:
                    self.maxfit=self.pop[mutseq].fitness
                if self.pop[mutseq].sel_coeff<-1.0/min(globs.popsize,self.totoffspring):
                    self.fdel+=1
                    if self.pop[indiv].shape==globs.target:
                        self.ofdel+=1
                    self.wfdel+=self.pop[indiv].fitness
                    self.avg_del+=self.pop[mutseq].sel_coeff
                    self.avg_adel+=self.pop[mutseq].fitness-self.pop[indiv].fitness
                elif self.pop[mutseq].sel_coeff>1.0/min(globs.popsize,self.totoffspring):
                    self.fben+=1
                    self.wfben+=self.pop[indiv].fitness
                    self.avg_ben+=self.pop[mutseq].sel_coeff
                    self.avg_aben+=self.pop[mutseq].fitness-self.pop[indiv].fitness
            else:
                if indiv in self.pop:
                    self.pop[indiv].cur_copies+=1
                else:
                    
                    self.pop[indiv]=genotype(indiv[0],self.num_new_seqs,1,
                                                self.pop[recparent].id,self.pop[recparent].fitness,gen=gen)
                    self.num_new_seqs+=1
                    if self.pop[indiv].sel_coeff<-1.0/min(globs.popsize,self.totoffspring):
                        self.fdel+=1
                        self.avg_del+=self.pop[indiv].sel_coeff
                    elif self.pop[indiv].sel_coeff>1.0/min(globs.popsize,self.totoffspring):
                        self.fben+=1
                        self.avg_ben+=self.pop[indiv].sel_coeff
                if self.pop[indiv].fitness>self.maxfit:
                    self.maxfit=self.pop[indiv].fitness
                self.mean_fit+=self.pop[indiv].fitness
        else:
            #EXPERIMENTAL SEGREGATION CODE
            mutseq1=mutc(indiv[0][0])
            mutseq2=mutc(indiv[0][1])
            if mutseq1 or mutseq2:
                self.num_mut+=1
                if mutseq1:
                    mshp1=pyfold(mutseq1)
                else:
                    mshp1=shps[0]
                    mutseq1=indiv[0][0]
                if mutseq2:
                    mshp2=pyfold(mutseq2)
                else:
                    mshp2=shps[1]
                    mutseq2=indiv[0][1]
                mindiv=((mutseq1,mutseq2),indiv[1])
                mfit=fit_dom(mshp1,mshp2)
                if globs.noben:
                    if (mfit-self.pop[indiv].fitness)>0.0:
                        #beneficial mutation switch
                        if indiv in self.pop:
                            self.pop[indiv].cur_copies+=1
                            if self.pop[indiv].fitness>self.maxfit:
                                self.maxfit=self.pop[indiv].fitness
                            self.mean_fit+=self.pop[indiv].fitness
                            return
                    else:
                        #neutral/deleterious switch
                        if mindiv in self.pop:
                            self.pop[mindiv].cur_copies+=1
                            if self.pop[mindiv].fitness>self.maxfit:
                                self.maxfit=self.pop[mindiv].fitness
                            self.mean_fit+=self.pop[mindiv].fitness
                            return
                        else:
                            if recparent:
                                indiv=recparent
                            self.pop[mindiv]=genotype(mindiv[0],self.num_new_seqs,1,
                                                        self.pop[indiv].id,self.pop[indiv].fitness,shp=(mshp1,mshp2),fit=mfit,gen=gen)
                            #self.ancestry[mutseq]=genotype(mutseq,self.num_new_seqs,1,
                            #                            self.pop[indiv].id,self.pop[indiv].fitness,shp=mshp,fit=mfit,gen=gen)
                            
                            #self.node_ancestry_map[add_ancestry(gtype)]=gtype
                            
                            self.num_new_seqs+=1
                            if self.pop[mindiv].fitness>self.maxfit:
                                self.maxfit=self.pop[mindiv].fitness
                            self.mean_fit+=self.pop[mindiv].fitness
                            return
                    
                    #think about how to fit in recomb with no beneficials
                    '''
                    else:
                        self.pop[indiv]=genotype(indiv,self.num_new_seqs,1,
                                                    self.pop[recparent].id,fit=self.pop[recparent].fitness,gen=gen)
                        self.num_new_seqs+=1
                        if self.pop[indiv].sel_coeff<-1.0/min(globs.popsize,self.totoffspring):
                            self.fdel+=1
                            self.avg_del+=self.pop[indiv].sel_coeff
                        elif self.pop[indiv].sel_coeff>1.0/min(globs.popsize,self.totoffspring):
                            self.fben+=1
                            self.avg_ben+=self.pop[indiv].sel_coeff
                    if self.pop[indiv].fitness>self.maxfit:
                        self.maxfit=self.pop[indiv].fitness
                    '''
                else:
                    #beneficials allowed
                    if mindiv in self.pop:
                            self.pop[mindiv].cur_copies+=1
                            if self.pop[mindiv].fitness>self.maxfit:
                                self.maxfit=self.pop[mindiv].fitness
                            self.mean_fit+=self.pop[mindiv].fitness
                            return
                    else:
                        if recparent:
                            indiv=recparent
                        self.pop[mindiv]=genotype(mindiv[0],self.num_new_seqs,1,
                                                    self.pop[indiv].id,self.pop[indiv].fitness,shp=(mshp1,mshp2),fit=mfit,gen=gen)
                        #self.ancestry[mutseq]=genotype(mutseq,self.num_new_seqs,1,
                        #                            self.pop[indiv].id,self.pop[indiv].fitness,shp=mshp,fit=mfit,gen=gen)
                        
                        #self.node_ancestry_map[add_ancestry(gtype)]=gtype
                        
                        self.num_new_seqs+=1

                    
                self.mean_fit+=self.pop[mindiv].fitness
                self.muttotw+=self.pop[mindiv].fitness
                if self.pop[mindiv].shp1==globs.target and self.pop[mindiv]:
                    self.optonly+=1
                if self.pop[mindiv].fitness>self.maxfit:
                    self.maxfit=self.pop[mindiv].fitness
                if self.pop[mindiv].sel_coeff<-1.0/min(globs.popsize,self.totoffspring):
                    self.fdel+=1
                    if self.pop[indiv].fitness==100.0:
                        self.ofdel+=1
                    self.wfdel+=self.pop[indiv].fitness
                    self.avg_del+=self.pop[mindiv].sel_coeff
                    self.avg_adel+=self.pop[mindiv].fitness-self.pop[indiv].fitness
                elif self.pop[mindiv].sel_coeff>1.0/min(globs.popsize,self.totoffspring):
                    self.fben+=1
                    self.wfben+=self.pop[indiv].fitness
                    self.avg_ben+=self.pop[mindiv].sel_coeff
                    self.avg_aben+=self.pop[mindiv].fitness-self.pop[indiv].fitness
            else:
                if indiv in self.pop:
                    self.pop[indiv].cur_copies+=1
                else:
                    
                    self.pop[indiv]=genotype(indiv[0],self.num_new_seqs,1,
                                                self.pop[recparent].id,self.pop[recparent].fitness,gen=gen)
                    self.num_new_seqs+=1
                    if self.pop[indiv].sel_coeff<-1.0/min(globs.popsize,self.totoffspring):
                        self.fdel+=1
                        self.avg_del+=self.pop[indiv].sel_coeff
                    elif self.pop[indiv].sel_coeff>1.0/min(globs.popsize,self.totoffspring):
                        self.fben+=1
                        self.avg_ben+=self.pop[indiv].sel_coeff
                if self.pop[indiv].fitness>self.maxfit:
                    self.maxfit=self.pop[indiv].fitness
                self.mean_fit+=self.pop[indiv].fitness

    def reproduce(self,indiv,gen):
        """
        generic function for reproduction. checks for recombination and maybe later more exotic possibilities?"""
        if globs.comp=='r':
            if not self.rec_chamber:
                self.rec_chamber=indiv
                return
            else:
                #print 'recombine time!'
                rec1,rec2,r1,r2=self.recomb2(self.rec_chamber,indiv)
                if rec1 != self.rec_chamber[0] or rec1 != indiv[0]:
                    #print 'recombination works'
                    rs1=pyfold(rec1)
                    rs2=pyfold(rec2)
                    old1=pyfold(self.rec_chamber[0])
                    old2=pyfold(indiv[0])
                    hamsum=0
                    for rs in [rs1,rs2]:
                        for old in [old1,old2]:
                            hamsum+=hamming(rs,old)
                    print hamsum/4.0
                #else:
                #    print 'no change in genotype'
                self.add_to_next_gen((rec1,r1),gen,self.rec_chamber)
                self.add_to_next_gen((rec2,r2),gen,indiv)
                self.rec_chamber=False
                return
                
        else:
            #SEG CODE
            if not self.rec_chamber:
                self.rec_chamber=indiv
            else:
                rec1,rec2,shps1,shps2,s1,s2=self.seg(self.rec_chamber,indiv)
                self.add_to_next_gen((rec1,s1),gen,self.rec_chamber,shps=shps1)
                self.add_to_next_gen((rec2,s2),gen,indiv,shps=shps2)
                self.rec_chamber=False
            return

    def nextgen(self,gen):
        """
        basic function that does selection and replication over one generation. First number of offspring
        each parent genotype produces is calculated (for loop with np.random.poisson). If this number exceeds popcap, randomly choose offspring to represent next generation without replacement. Picked offspring mutate with per-site rate 1-fidelity. Otherwise, all offspring go into next generation. Regardless, various population statistics calculated every gen.
        """
        self.gtypes=self.pop.keys()
        self.totoffspring=0
        self.mean_fit=0.0
        self.fdel=0.0
        self.fben=0.0
        self.avg_del=0.0
        self.avg_ben=0.0
        self.avg_adel=0.0
        self.avg_aben=0.0
        self.num_mut=0
        self.maxfit=0.0
        self.wfdel=0.0
        self.wfben=0.0
        self.muttotw=0.0
        self.optonly=0
        self.ofdel=0.0
        self.rec_chamber=False
        self.num_rec=0
        num_perfect=0
        self.avg_rs=0.0
        self.psize=0
        for gtype in self.gtypes:
            self.pop[gtype].prev_copies=np.random.poisson(self.pop[gtype].cur_copies*globs.rep_val* \
                                                         self.pop[gtype].fitness/100.)
            self.pop[gtype].cur_copies=0
            self.totoffspring+=self.pop[gtype].prev_copies
            if self.pop[gtype].fitness==100.0:
                num_perfect+=self.pop[gtype].prev_copies
        if self.totoffspring<5:
            self.mean_fit=None
            return
        self.offspringvec=np.array([self.pop[gtype].prev_copies for gtype in self.gtypes],dtype=np.int32)
        osveclen=len(self.offspringvec)
        maxsize=self.totoffspring
        for _ in range(min(globs.popsize,self.totoffspring)):
            #tmp=time.time()
            i=choose_finite(self.offspringvec,maxsize,osveclen)
            indiv=self.gtypes[i]
            self.offspringvec[i]-=1
            maxsize-=1
            self.reproduce(indiv,gen)
        self.mean_fit /=min(globs.popsize,self.totoffspring)
        if self.fdel>0:
            self.avg_del /=self.fdel
            self.avg_adel /=self.fdel
        if self.fben>0:
            self.avg_ben /=self.fben
            self.avg_aben /=self.fben
        if self.num_mut:
            self.fdel /= self.num_mut
            self.fben /= self.num_mut
            self.wfdel /= self.muttotw
            self.wfben /= self.muttotw
        if self.optonly:
            self.ofdel /= self.optonly
            #start+=time.time()-tmp
            
        #print time.time()-tmp
        #print start
        '''
        
        for gtype in self.pop.keys():
            if self.pop[gtype].cur_copies and self.pop[gtype].fitness==100.0:
                self.num_opt+=1
        if self.num_opt==0:
            return True
        '''
        for gtype in self.gtypes:
            
            if not self.pop[gtype].cur_copies:
                self.pop.pop(gtype)

        self.gtype_in_pop=len(self.pop)
        self.num_opt=0
        
        self.rec_indivs=0
        self.no_rec_indivs=0
        for gtype in self.pop.keys():
            self.avg_rs+=self.pop[gtype].cur_copies*gtype[1]
            self.psize+=self.pop[gtype].cur_copies
            if gtype[1]:
                self.rec_indivs+=self.pop[gtype].cur_copies
            else:
                self.no_rec_indivs+=self.pop[gtype].cur_copies
            if self.pop[gtype].cur_copies and self.pop[gtype].fitness==100.0:
                self.num_opt+=1
        self.avg_rs/=self.psize
        '''
        if self.num_opt==0:
            return True
        '''
        #print self.rec_indivs,self.no_rec_indivs
        #print self.rec_indivs
        if globs.comp_freq:
            if self.rec_indivs==0:
                return 2
            if self.no_rec_indivs==0:
                return 1

def mon_pop(gen,pop):
    """
    Dumps summary statistics of population to the monitor file, like mean_fit, fdel,fben etc.
    """
    globs.mon.write('%i,%i,%i,%i,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%i\n' % 
        (gen,min(globs.popsize,pop.totoffspring),
         pop.gtype_in_pop,pop.num_new_seqs,pop.mean_fit,pop.avg_rs,pop.maxfit,pop.fdel,
         pop.fben,pop.avg_del,pop.avg_ben,pop.avg_adel,pop.avg_aben,pop.wfdel,pop.wfben,pop.ofdel,pop.optonly))

def pop_dump(gen,pop):
    """
    dumps detailed information for every genotype in population.
    format is :
    gtype
    shape,id,parent_id,# copies,fitness,selection coefficient
    """
    f=open('%s_%i' % (globs.runname,gen), 'w')
    dat=np.random.get_state()
    f.write('%s\n'% dat[0])
    for num in dat[1]:
        f.write('%i,'% int(num))
    f.write('\n%i\n\n'%dat[2])
    if globs.chroms==1:
        for gtype in pop.pop.keys():
            f.write('%s\n%s,%i,%i,%i,%.3f,%.3f,%i\n' % (gtype,pop.pop[gtype].shape,pop.pop[gtype].id,pop.pop[gtype].p_id,
                                                    pop.pop[gtype].cur_copies,pop.pop[gtype].fitness,
                                                    pop.pop[gtype].sel_coeff,pop.pop[gtype].gen) )
    else:
        for gtype in pop.pop.keys():
            f.write('%s,%s\n%s,%s,%i,%i,%i,%.3f,%.3f,%i\n' % (gtype[0],gtype[1],pop.pop[gtype].shp1,pop.pop[gtype].shp2,pop.pop[gtype].id,pop.pop[gtype].p_id,
                                                    pop.pop[gtype].cur_copies,pop.pop[gtype].fitness,
                                                    pop.pop[gtype].sel_coeff,pop.pop[gtype].gen) )
    f.close()
