# -*- coding: utf-8 -*-
import sys
from pyrna import *
import optparse

def get_params():
    usage = 'Usage: %prog [options] input_file selcoeff'
    parser=optparse.OptionParser(usage=usage)
    parser.add_option('-n','--noben',action='store_true')
    parser.add_option('-m','--rs_mut',type='float', default=0.0)
    parser.add_option('-e','--ext',action='store_true')
    parser.add_option('--fitfun',default='l')
    parser.add_option('-t','--comp_freq',type='float')
    parser.add_option('-f','--fidelity',type='float')
    parser.add_option('-r','--rec',type='float')
    parser.add_option('-s','--seg',type='float')
    parser.add_option('-o','--output',type='string')
    parser.add_option('-p','--popfile',type='string')
    parser.add_option('-c','--chrom_num', type='int')
    parser.add_option('-d','--dom',type='float')
    parser.add_option('-l','--rs_linkage',type='float', default=0.0)
    parser.add_option('-v','--evpop',action='store_true')
    parser.add_option('-x','--c2_fitpar',type='float')
    parser.add_option('--ploidy',type='int')
    parser.add_option(
    options,args=parser.parse_args()
    f=open(args[0])
    dat=f.readlines()
    f.close()
    if options.output:
        runname=options.output
    else:
        runname=dat[0].strip()
    if options.popfile:
        f=open(options.popfile)
    else:
        f=open(dat[1].strip())
    popdat=f.readlines()
    f.close()
    init_pop=[indiv.split() for indiv in popdat]
    if options.chrom_num:
        chroms=options.chrom_num
    else:
        chroms=int(dat[2])
    popsize=int(dat[3])
    maxgens=int(dat[4])
    dumpint=int(dat[5])
    monint=int(dat[6])
    if options.fidelity:
        fidelity=options.fidelity
    else:
        fidelity=float(dat[7])
    repval=float(dat[8])

    if options.rec != None:
        rec=options.rec
    else:
        rec=float(dat[9])
    target=dat[11].strip()
    add_targs=[]
    for lin in dat[12:]:
        add_targs.append(lin.strip())
    fitpar=float(args[1])
    if options.c2_fitpar != None:
        c2_fitpar=options.c2_fitpar
    else:
        c2_fitpar=fitpar
    if options.seg !=None:
        seg_rate=float(options.seg)
    else:
        seg_rate=float(dat[10])
    comp=args[2]
    rs_val= (rec if comp=='r' else seg_rate)
    return (runname,init_pop,target,popsize,maxgens,dumpint,monint,fidelity,repval,options.fitfun,fitpar,chroms,
            options.seg,options.rec,options.noben,seg_rate,add_targs,options.dom,options.rs_mut,options.comp_freq,options.evpop,rs_val,comp,options.rs_linkage,c2_fitpar,ploidy)
runname,init_pop,target,popsize,maxgens,dumpint,monint,fidelity,rep_val,fitfun,fitpar,chroms,seg,rec,noben,seg_rate,add_targs,h,rs_mut,comp_freq,evpop,rs_val,comp,rs_linkage,c2_fitpar,ploidy=get_params()
lin_scale=100.0
bases=('A','C','G','U')
alpha=.01
mon=''
if fitfun is 'h':
    beta=fitpar
else:
    lin_coeff=fitpar
glength=len(target)
