# -*- coding: utf-8 -*-
from __future__ import with_statement
import pyfold as pf
import tarfile as t
import os
import numpy as np
dpath='/home/thomas/pymut/pymut_dat/'
import math
import sys
import time as tm
import pylab as p
def mutlevels(maxfit,minfit,steps):
    d=(maxfit-minfit)/(steps-1)
    return [minfit+i*d for i in range(steps-1,-1,-1)]
expected_fit=mutlevels(.95,.01,15)
ulist=[(-math.log(x)) for x in expected_fit]

def get_f_dat(urange,mutdat,valreps):
    for j in range(1,urange+1):
        try:
            f=open(dpath+'pymut_%i_run_5000'%j)
            dat=f.readlines()[4:]
            f.close()
            valreps[j-1]+=1
            for i in range(0,len(dat),2):
                indivs=int(dat[i+1].strip().split(',')[3])
                fitness=float(dat[i+1].strip().split(',')[4])
                if math.ceil(fitness) in mutdat[j-1]:
                    mutdat[j-1][math.ceil(fitness)]+=indivs
                else:
                    mutdat[j-1][math.ceil(fitness)]=indivs
        except IOError:
            continue

hamdat=[]
for i in range(15):
    hamdat.append({})
valreps=np.zeros(15)
for rep in range(1,26):
    fz=t.open(dpath+'p1_g1_ml2_r%i.tar.gz'%rep)
    #fz=t.open(dpath+'p1_g1_mlhrd-%i.tar.gz'%rep)
    fnames=fz.getnames()
    mnames=[fl for fl in fnames if fl.find('_5000') is not int(-1)]

    for nam in mnames:
        fz.extract(nam,dpath)
    fz.close()
    a=tm.time()
    get_f_dat(15,hamdat,valreps)
    for nam in mnames:
        os.remove(dpath+nam)
print tm.time()-a
htomat=[]
for ulev in hamdat:
    k=ulev.keys()
    abunlist=[ulev[key] for key in k]
    tval=np.repeat(k,abunlist)
    if len(tval):
        htomat.append(np.histogram(tval,bins=20,range=(0,100))[0])
f=open('ml2_fit_dis.csv','w')
f.write('U,fitness,num_ind,width\n')
val=1
for i,dat in enumerate(htomat):
    #print i
    diff=ulist[i]-ulist[i-1] if i>0 else ulist[i]
    #print len(dat)
    upos=(ulist[i]+ulist[i-1])/2 if i>0 else ulist[i]/2
    for j,num_ind in enumerate(dat):
        f.write('%i,%f,%f,%f,%f\n'%(val,upos,.025+(j*.05),num_ind/25.0,diff))
        val+=1
f.close()
