# -*- coding: utf-8 -*-
import tarfile as t
import numpy as np
import os

def mutlevels(maxfit,minfit,steps):
    d=(maxfit-minfit)/(steps-1)
    return [minfit+i*d for i in range(steps-1,-1,-1)]
expected_fit=mutlevels(.95,.01,15)
ulist=-np.log(expected_fit)

os.chdir('adjfdel_rec')
rlevs=['none','low','med','high']
for rec in ['segd','sega','segr','rec'][:2]:
    fdels=np.zeros((15,4))
    fbens=np.zeros((15,4))
    reps=np.zeros((15,4))
    for r_i,rlev in enumerate(rlevs):
        for rep in range(1,26):
            fname='adjfdel_l2_%s_%s-%i.tar.gz'%(rec,rlev,rep)
            #print fname
            f=t.open(fname)
            f.extract('fdel_avgs.csv')
            f.close()
            dat=open('fdel_avgs.csv').readlines()[1:]
            os.remove('fdel_avgs.csv')
            for i,lin in enumerate(dat):
                ds=lin.split(',')
                reps[i,r_i]+=1
                fdels[i,r_i]+=float(ds[3])
                fbens[i,r_i]+=float(ds[4])
    reps[reps==0]=1
    fbens/=reps
    fdels/=reps

    f=open('adjfdel_%s.csv'%rec,'w')
    f.write('U,rlev,fdel,fben,fneut\n')
    num=1
    for j in range(4):
        for i in range(15):
            fneut=1-fdels[i,j]-fbens[i,j] if fdels[i,j] else 0
            f.write('%i,%f,%s,%f,%f,%f\n'%(num,ulist[i],rlevs[j],fdels[i,j],fbens[i,j],fneut))
            num+=1
    f.close()
    