# -*- coding: utf-8 -*-
import pyfold as pf
import tarfile as t
import os
import numpy as np
dpath='/home/thomas/pymut/pymut_dat/'
import math
import sys
import time as tm

'''
USAGE: takes 4 (5) arguments. 1:output replicate number 2: run-name 3: selection coefficient 4: type of sex (r is easiest unless segregation is going on), also generalizes to null case of no sex.
'''
rep=int(sys.argv[1])
rname=sys.argv[2]
linc=float(sys.argv[3])
rec_type=sys.argv[4]
if rec_type=='s':
    d=float(sys.argv[5])
else:
    d=0
inigt='UUGGUUAUAAUUUCGCUGGGUGGCGCCCCAUAUGGCGAACUGCAUCAAUGUGACUGUCGAAGGUCGGGACCGAUAUAGACGUUGGGUACCUCUAACCUG'
targ='..(((((....(((((((.((((....)))).))))))).(((.(((((((..((((....(((....)))...))))))))))))))....)))))..'
glen=len(inigt)
cods=['A','C','G','U']
beta=1.0
def mutlevels(maxfit,minfit,steps):
    d=(maxfit-minfit)/(steps-1)
    return [minfit+i*d for i in range(steps-1,-1,-1)]
expected_fit=mutlevels(.95,.01,15)
ulist=[(-math.log(x)) for x in expected_fit]
def getf(gtype):
    gshape=pf.pyfold(gtype)
    return 1.0/(.01+(float(pf.hamming(gshape,targ)) / (glen))**beta),gshape
def getfl(gtype):
    gshape=pf.pyfold(gtype)
    f=100 - linc*pf.hamming(gshape,targ)
    return (f if f>0 else 0),gshape
    
def fit_dom(gtype,shp2):
    '''
    replaces old seg fit of geometric mean. kept for relic's sake
    np.sqrt(getfit(self.shp1)*getfit(self.shp2,globs.add_targs[0]))
    '''
    fit1,shp1=getfl(gtype)
    fit2=100 - linc*pf.hamming(shp2,targ)
    if fit2<0:
        fit2=0
    comb_fit=max((fit1,fit2))-d*(100-min((fit1,fit2)))
    if comb_fit<0.0:
        comb_fit=0
    return comb_fit,shp1
    
getf=getfl
totpos=3*len(inigt)
pf.fold_params()
def get_f_dat(urange,mutdat):
    for j in range(1,urange+1):
        try:
            f=open('pymut_%i_run_5000'%j)
            dat=f.readlines()[4:]
            f.close()
            totfit=0.0
            totindivs=0
            fit_dis=[]
            weighting=[]
            conseq=[]
            totham=0.0
            fben=0.0
            fdel=0.0
            adel=0.0
            aben=0.0
            '''for i in range(0,len(dat),2):
                gtype=dat[i].strip()
                shape=dat[i+1].strip().split(',')[0]
                indivs=int(dat[i+1].strip().split(',')[3])
                fitness=float(dat[i+1].strip().split(',')[4])
                
                if shape == targ:
                    totindivs+=indivs
                    totham+=pf.hamming(gtype,inigt)*indivs
                    for k in range(glen):
                        for cod in cods:
                            if gtype[k] is cod:
                                continue
                            else:
                                mutg=gtype[:k]+cod+gtype[k+1:]
                                mfit,mshape=getf(mutg)
                                if mshape != shape:
                                    rel_fit=(mfit-fitness)/fitness if fitness else 0
                                    rel_fit=rel_fit if abs(rel_fit)>.001 else 0
                                    if rel_fit<0:
                                        fdel+=indivs
                                        adel+=indivs*(mfit-fitness)
            print i,totindivs'''
            if totindivs:
                normf=3*glen*totindivs
                mutdat[j-1].append((totham/totindivs,fdel/normf,0,adel/normf,0))
            else:
                fben=0.0
                adel=0.0
                aben=0.0
                normf=0
                for i in range(0,len(dat),2):
                    if rec_type=='r':
                        #dont need to fix yet
                        gtype=eval(dat[i].strip())[0]
                        shape=dat[i+1].strip().split(',')[0]
                        indivs=int(dat[i+1].strip().split(',')[3])
                        fitness=float(dat[i+1].strip().split(',')[4])
                        totindivs+=indivs
                        totham+=pf.hamming(gtype,inigt)*indivs
                        normf+=indivs*fitness*3*glen
                        for k in range(glen):
                            for cod in cods:
                                if gtype[k] is cod:
                                    continue
                                else:
                                    mutg=gtype[:k]+cod+gtype[k+1:]
                                    mfit,mshape=getf(mutg)
                                    if mshape != shape:
                                        rel_fit=(mfit-fitness)/fitness if fitness else 0
                                        rel_fit=rel_fit if abs(rel_fit)>.001 else 0
                                        if rel_fit<0:
                                            fdel+=indivs*fitness
                                            adel+=indivs*fitness*(mfit-fitness)
                                        elif rel_fit>0:
                                            fben+=indivs*fitness
                                            aben+=indivs*fitness*(mfit-fitness)
                    else:
                        
                        gtemp=eval('(%s)'%dat[i].strip())
                        shp1=dat[i+1].strip().split(',')[0]
                        shp2=dat[i+1].strip().split(',')[1]
                        shps=(shp1,shp2)
                        indivs=int(dat[i+1].strip().split(',')[4])
                        fitness=float(dat[i+1].strip().split(',')[5])
                        totindivs+=indivs
                        normf+=indivs*fitness*3*glen*2
                        for g_i,gtype in enumerate(gtemp[0]):
                            shape_unmut=gtemp[0][1-g_i]
                            for k in range(glen):
                                for cod in cods:
                                    if gtype[k] is cod:
                                        continue
                                    else:
                                        mutg=gtype[:k]+cod+gtype[k+1:]
                                        mfit,mshape=fit_dom(mutg,shape_unmut)
                                        if mshape != shps[g_i]:
                                            rel_fit=(mfit-fitness)/fitness if fitness else 0
                                            rel_fit=rel_fit if abs(rel_fit)>.001 else 0
                                            if rel_fit<0:
                                                fdel+=indivs*fitness
                                                adel+=indivs*fitness*(mfit-fitness)
                                            elif rel_fit>0:
                                                fben+=indivs*fitness
                                                aben+=indivs*fitness*(mfit-fitness)
                #normf=3*glen*totindivs
            	mutdat[j-1].append((totham/totindivs,fdel/normf,fben/normf,adel/normf,aben/normf))
            print j
        except IOError:
            continue

hamdat=[]
for i in range(15):
    hamdat.append([])
fz=t.open('%s-%i.tar.gz'%(rname,rep))
fnames=fz.getnames()
mnames=[fl for fl in fnames if fl.find('_5000') is not int(-1)]

for nam in mnames:
    fz.extract(nam)
fz.close()
a=tm.time()
get_f_dat(15,hamdat)
print tm.time()-a
f=open('fdel_avgs.csv','w')
f.write('U,avg_ham,fdel,fben,adel,aben\n')
num=1
for i,lin in enumerate(hamdat):
    for rep in lin:
        f.write('%i,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f\n'%(num,ulist[i],rep[0],rep[1],rep[2],rep[3],rep[4]))
        num+=1
for i in range(1,16):
    try:
        os.remove('pymut_%i_run_5000'%i)
    except OSError:
        continue
pf.pyfreemem()
