clear all
 
t0  = 0;      % initial time
t1  = 100;    % final time
x0  = 1;     % initial cell population
y0  = 2;     % initial glucose concentration
z0  = 1.11;     % initial ammonium concentration
%
% NOT SURE HOW x0, y0, AND z0 ARE SUPPOSED TO BE FOUND
% initial state for use in DE solver.
%
S0  = [x0;y0;z0];
%
% rate constants and problem parameters
%
q    = 0.03;
u    = 25;
v    = 5;
r    = 0.46; % not sure how to determine
K    = 0.778; % not sure how to determine
L    = 15.91; % not sure how to determine
ep   = 14.3;
fp   = 2.23;
%
% rate constants into parameter vector
%
params(1) = q;
params(2) = u;
params(3) = v;
params(4) = r;
params(5) = K;
params(6) = L;
params(7) = ep;
params(8) = fp;
%
% define function for fixed parameter values
%
chemostat_dynamics_params = @(t,S)chemostat_dynamics_TwoNutrient(t,S,params);
%
% call the matlab function to solve the DE for us.
%
[t,St] = ode45(chemostat_dynamics_params,[t0 t1],S0);
%
% Plot the results.
%
plot(t,St,'LineWidth',3)

legend('cells','glucose','ammonium')
xlabel('time')
ylabel('states')
