function [ dSdt ] = chemostat_dynamics_TwoNutrient(t,S,params)
% this function defines the chemostat differential equation
%
% get the individual parameters from the vector
%
q    = params(1);
u    = params(2);
v    = params(3);
r    = params(4);
K    = params(5);
L    = params(6);
ep   = params(7);
fp   = params(8);
%
% initialize the state's derivative
%
dSdt = zeros(size(S));
%
% put things in terms of individual variables
%
x = S(1); % cells
y = S(2); % glucose
z = S(3); % ammonium
%
% form the differential equation formulae
%
ryz   = r*(y/(K+y))*(z/(L+z));
dxdt  = (ryz)*x - q*x;
dydt  = q*(u - y) - ep*ryz*x;
dzdt  = q*(v - z) - fp*ryz*x;
%
% put things back in terms of state vector variable
%
dSdt(1) = dxdt;
dSdt(2) = dydt;
dSdt(3) = dzdt;
end