clear all; close all;

% constants
% filestodo = ['0mM KCl 20 bp','5mm 10507', '20bp comp 50 mM KCl 10207',
% '20bp comp 100mM KCl 10207']


% 0mm
filename = '0mM KCl 20 bp';
window = 16;
decay = 8;

rawdata = importdata(filename);

[rtd,pd] = filterdata(rawdata,window,decay);

pd = relativefluoro(pd);
svdata = [rtd,pd];
svdata = singlevalue2(svdata);
time = (1:length(svdata));
rtd = svdata(:,1);
pd = svdata(:,2);
temp = relativetemp(rtd);
dpd_dt = deriv(temp,pd,window,decay);
[tm,index2] = tmelt(temp,dpd_dt);
figure(1);
plot(temp,pd,'b');
hold on;
xlabel('Temperature (^{o}C)');
ylabel('Relative fluorescence');
% text(temp(index2),pd(index2),['T_m = ' num2str(tm) '^{\circ} C']);
figure(2);
hold on;
plot(temp(1:end-1),dpd_dt,'b');
xlabel('Temperature (^{o}C)');
ylabel('{dF}/{dT}');

% 5mm
filename = '5mm 10507';
window = 16;
decay = 8;

rawdata = importdata(filename);

[rtd,pd] = filterdata(rawdata,window,decay);

pd = relativefluoro(pd);
svdata = [rtd,pd];
svdata = singlevalue2(svdata);
time = (1:length(svdata));
rtd = svdata(:,1);
pd = svdata(:,2);
temp = relativetemp(rtd);
dpd_dt = deriv(temp,pd,window,decay);
[tm,index2] = tmelt(temp,dpd_dt);
figure(1);
plot(temp,pd,'c');
xlabel('Temperature (^{o}C)');
ylabel('Relative fluorescence');
% text(temp(index2),pd(index2),['T_m = ' num2str(tm) '^{\circ} C']);
figure(2);
plot(temp(1:end-1),dpd_dt,'c');
xlabel('Temperature (^{o}C)');
ylabel('{dF}/{dT}');

% 50mm
filename = '20bp comp 50 mM KCl 10207';
window = 16;
decay = 8;

rawdata = importdata(filename);

[rtd,pd] = filterdata(rawdata,window,decay);

pd = relativefluoro(pd);
svdata = [rtd,pd];
svdata = singlevalue2(svdata);
time = (1:length(svdata));
rtd = svdata(:,1);
pd = svdata(:,2);
temp = relativetemp(rtd);
dpd_dt = deriv(temp,pd,window,decay);
[tm,index2] = tmelt(temp,dpd_dt);
figure(1);
plot(temp,pd,'g');
xlabel('Temperature (^{o}C)');
ylabel('Relative fluorescence');
% text(temp(index2),pd(index2),['T_m = ' num2str(tm) '^{\circ} C']);
figure(2);
plot(temp(1:end-1),dpd_dt,'g');
xlabel('Temperature (^{o}C)');
ylabel('{dF}/{dT}');

% 100mm
filename = '20bp comp 100mM KCl 10207';
window = 16;
decay = 8;

rawdata = importdata(filename);

[rtd,pd] = filterdata(rawdata,window,decay);

pd = relativefluoro(pd);
svdata = [rtd,pd];
svdata = singlevalue(svdata);
time = (1:length(svdata));
rtd = svdata(:,1);
pd = svdata(:,2);
temp = relativetemp(rtd);
dpd_dt = deriv(temp,pd,window,decay);
[tm,index2] = tmelt(temp,dpd_dt);
figure(1);
plot(temp,pd,'r');
xlabel('Temperature (^{o}C)');
ylabel('Relative fluorescence');
title('20 base pair oligonucleotides in varying ionic strength');
legend('0mm','5mm','50mm','100mm',0);
% text(temp(index2),pd(index2),['T_m = ' num2str(tm) '^{\circ} C']);
figure(2);
plot(temp(1:end-1),dpd_dt,'r');
title('Derivative of fluorescence with respect to temperature (time)');
xlabel('Temperature (^{o}C)');
ylabel('{dF}/{dT}');
legend('0mm','5mm','50mm','100mm',0);