clear all; close all;

% constants
filename = '20bp AAA 10507';
window = 16;
decay = 8;

rawdata = importdata(filename);

[rtd,pd] = filterdata(rawdata,window,decay);

pd = relativefluoro(pd);
svdata = [rtd,pd];
svdata = singlevalue(svdata);
time = (1:length(svdata));
rtd = svdata(:,1);
pd = svdata(:,2);
temp = relativetemp(rtd);
dpd_dt = deriv(temp,pd,window,decay);
[tm,index2] = tmelt(temp,dpd_dt);
figure(1);
plot(temp,pd);
xlabel('Temperature (^{o}C)');
ylabel('Relative fluorescence');
text(temp(index2),pd(index2),['T_m = ' num2str(tm) '^{\circ} C']);
figure(2);
plot(temp(1:end-1),dpd_dt,'r');
xlabel('Temperature (^{o}C)');
ylabel('{dF}/{dT}');