clear all; close all;
window = 16;
decay = 8;

% 40bp
filename = '40bp comp perfect -good data';

rawdata = importdata(filename);

[rtd,pd] = filterdata(rawdata,window,decay);

pd = relativefluoro(pd);
svdata = [rtd,pd];
svdata = singlevalue(svdata);
time = (1:length(svdata));
rtd = svdata(:,1);
pd = svdata(:,2);
temp = relativetemp(rtd);
dpd_dt = deriv(temp,pd,window,decay);
[tm,index2] = tmelt(temp,dpd_dt);
figure(1);
plot(temp,pd,'b');
hold on;
xlabel('Temperature (^{o}C)');
ylabel('Relative fluorescence');
% text(temp(index2),pd(index2),['T_m = ' num2str(tm) '^{\circ} C']);
figure(2);
hold on;
plot(temp(1:end-1),dpd_dt,'b');
xlabel('Temperature (^{o}C)');
ylabel('{dF}/{dT}');

% 20bp
filename = '0mM KCl 20 bp';

rawdata = importdata(filename);

[rtd,pd] = filterdata(rawdata,window,decay);

pd = relativefluoro(pd);
svdata = [rtd,pd];
svdata = singlevalue2(svdata);
time = (1:length(svdata));
rtd = svdata(:,1);
pd = svdata(:,2);
temp = relativetemp(rtd);
dpd_dt = deriv(temp,pd,window,decay);
[tm,index2] = tmelt(temp,dpd_dt);
figure(1);
plot(temp,pd,'r');
xlabel('Temperature (^{o}C)');
ylabel('Relative fluorescence');
title('40 base pair versus 20 base pair oligonucleotides, perfect match');
legend('40bp','20bp');
% text(temp(index2),pd(index2),['T_m = ' num2str(tm) '^{\circ} C']);
figure(2);
plot(temp(1:end-1),dpd_dt,'r');
title('Derivative of fluorescence with respect to temperature (time)');
xlabel('Temperature (^{o}C)');
ylabel('{dF}/{dT}');
legend('40bp','20bp');