clear all; close all;

% constants
% filestodo = ['20bp AAA 10507','20bp BBB 10207', 'CCC2 10507']
window = 24;
decay = 16;

% A
filename = '20bp AAA 10507';

rawdata = importdata(filename);

[rtd,pd] = filterdata(rawdata,window,decay);

pd = relativefluoro(pd);
svdata = [rtd,pd];
svdata = singlevalue2(svdata);
time = (1:length(svdata));
rtd = svdata(:,1);
pd = svdata(:,2);
temp = relativetemp(rtd);
dpd_dt = deriv(temp,pd,window,decay);
[tm,index2] = tmelt(temp,dpd_dt);
figure(1);
plot(temp,pd,'b');
hold on;
xlabel('Temperature (^{o}C)');
ylabel('Relative fluorescence');
% text(temp(index2),pd(index2),['T_m = ' num2str(tm) '^{\circ} C']);
figure(2);
hold on;
plot(temp(1:end-1),dpd_dt,'b');
xlabel('Temperature (^{o}C)');
ylabel('{dF}/{dT}');

% B
filename = '20bp BBB 10207';

rawdata = importdata(filename);

[rtd,pd] = filterdata(rawdata,window,decay);

pd = relativefluoro(pd);
svdata = [rtd,pd];
svdata = singlevalue(svdata);
time = (1:length(svdata));
rtd = svdata(:,1);
pd = svdata(:,2);
temp = relativetemp(rtd);
dpd_dt = deriv(temp,pd,window,decay);
[tm,index2] = tmelt(temp,dpd_dt);
figure(1);
plot(temp,pd,'g');
xlabel('Temperature (^{o}C)');
ylabel('Relative fluorescence');
% text(temp(index2),pd(index2),['T_m = ' num2str(tm) '^{\circ} C']);
figure(2);
plot(temp(1:end-1),dpd_dt,'g');
xlabel('Temperature (^{o}C)');
ylabel('{dF}/{dT}');

% C
filename = 'CCC2 10507';

rawdata = importdata(filename);

[rtd,pd] = filterdata(rawdata,window,decay);

pd = relativefluoro(pd);
svdata = [rtd,pd];
svdata = singlevalue2(svdata);
time = (1:length(svdata));
rtd = svdata(:,1);
pd = svdata(:,2);
temp = relativetemp(rtd);
dpd_dt = deriv(temp,pd,window,decay);
[tm,index2] = tmelt(temp,dpd_dt);
figure(1);
plot(temp,pd,'r');
xlabel('Temperature (^{o}C)');
ylabel('Relative fluorescence');
legend('A','B','C',0);
title('Determining number of mismatches in unknown oligonucleotide samples');
% text(temp(index2),pd(index2),['T_m = ' num2str(tm) '^{\circ} C']);
figure(2);
plot(temp(1:end-1),dpd_dt,'r');
title('Derivative of fluorescence with respect to temperature (time)');
xlabel('Temperature (^{o}C)');
ylabel('{dF}/{dT}');
legend('A','B','C',0);