

import fileinput # (1)
import numpy
from matplotlib import pylab

import fileinput # (1)
import numpy
from matplotlib import pylab
 
def plot(filename):
    """Read single-column numbers in filename and plot zero-mean cumulative sum"""
 
    numbers = []
    for line in fileinput.input(filename): # (2)
        numbers.append(float(line.split('\n')[0]))
 
    mean = numpy.mean(numbers) # (3)
    cumulative_sum = numpy.cumsum([number - mean for number in numbers])
 
    pylab.plot(cumulative_sum[0::10],'k-') # (4)
    pylab.xlabel('i')
    pylab.title('Zero Mean Cumulative Sum')
 
    pylab.savefig(filename+'.png') # (5)
    pylab.show()

# (1) We use several python community modules to plot the zero-mean cumulative sum.  As part of the python standard library, fileinput can be used as a quick an easy solution to reading in a file containing a column of entries.  numpy is a comprehensive python project aimed at providing numerical routines for scientific applications (reference).  Finally we import the matplotlib.pylab module which provides a Matlab-like plotting environment.

# (2) Here we use fileinput to read successive lines of the input file, which  takes care of opening and closing the input file automatically.  Notice that we split each line by the newline character '\n', and take everything to the left of it, assuming that each line contains a single number.

# (3) The numpy module provides many convenient methods such as mean to compute the mean of a list of numbers, and cumsum which computes the cumulative sum.  To shift the input numbers by the mean, we use a python list comprehension to subtract the mean from each number, and then input the shifted list to numpy.cumsum.

# (4) The pylab module presents a Matlab-like plotting environment.  Here we use several methods to create a basic line plot with an xlabel and title.

# (5) To view the plot, we use pylab.show(), after we have saved the figure as a PNG file using pylab.savefig.

if __name__ == '__main__':
    plot('NC_001416.GC')
