# module discrete_distribution.py - drawing numbers from a discrete probability distribution
 
import random # (1)
 
def seed(): # (2)
    random.seed()
 
def draw(distribution): # (3)
	'''Drawing an index according to distribution.
 
	distribution is a list of floating point numbers,
	one for each index number, representing the probability 
	of drawing that index number.
 
	Example: [0.5, 0.5] would represent equal probabilities
	of returning a 0 or 1.
	'''
	sum = 0 # (4)
	r = random.random()
	for i in range(0,len(distribution)):
		sum += distribution[i]
		if r < sum:
			return i
 
# (1) Import the random number generator. 

# (2) We use the discrete_distribution.seed() method to seed the random number generator. If no arguments are supplied to random.seed(), the system time is used to seed the number generator [20]. 

# (3) The draw function takes an argument distribution, which is a list of floating point numbers. 

# (4) The algorithm for drawing a number according to a discrete distribution is to draw a number, r, from a uniform distribution on [0,1]; compute a cumulative sum of the probabilities in the discrete distribution for successive indices of the distribution; when r is less than this cumulative sum, return the index that the cumulative sum is at. 

if __name__ == '__main__':
    seed()
    print sum([draw([0.2,0.2,0.3,0.3]) for x in range(10000)])/10000. 
