// c_discrete_distribution.i - A Swig interface file for the c_discrete_distribution module // (8)
 
%module c_discrete_distribution // (9)
 
// Grab a 4 element array as a Python 4-list // (10)
%typemap(in) float[4](float temp[4]) {   // temp[4] becomes a local variable
  int i;
  if (PyList_Check($input)) {
    PyObject* input_to_tuple = PyList_AsTuple($input);
    if (!PyArg_ParseTuple(input_to_tuple,"ffff",temp,temp+1,temp+2,temp+3)) {
      PyErr_SetString(PyExc_TypeError,"tuple must have 4 elements");
      return NULL;
    }
    $1 = &temp[0];
  } else {
    PyErr_SetString(PyExc_TypeError,"expected a tuple.");
    return NULL;
  }
}
 
void seed(); // (11)
int draw(float distribution[4]); 

// (8) To use SWIG, we create a swig interface file that describes how to translate python inputs to the C code, and C outputs to the python code. 

// (9) SWIG directives are preceded by the % sign. Here we declare that the module we are going to make is called c_discrete_distribution. In general, the module name, the C source name, and the interface file name should all be the same outside of the file extension. 

// (10) SWIG will automatically handle the conversion of many data-types from python to C and C to python. For illustration purposes, we create an explicit typemap which converts a 4-element python list into a 4 element C list of floats. Since we are using the typemap(in) directive, SWIG knows that we are converting python to C. The rest of the code checks that a list was passed from python to C, and the list has 4 elements. If these conditions are not met, python errors are thrown. If they are met, an array of floats called temp is called, and passed to C. This conversion is adapted from the SWIG reference manual [4]. 

// (11) The last thing to do in the SWIG interface file is to declare the function signatures of the C implementation.
