//c_discrete_distribution.c - A C implementation of the discrete_distribution.py module
 
#include <stdlib.h> // (6)
#include <stdio.h>
#include <time.h>
 
void seed() {
    srand((unsigned) time(NULL) * getpid()); 
}
 
int draw(float distribution[4]) { // (7)
    float r= ((float) rand() / (float) RAND_MAX);
    float sum = 0.;
    int i = 0;
    for(i = 0; i < 4; i++) {
        sum += distribution[i];
	if (r < sum) {
            return i;
	}
    }
}

// (6) Here we define two functions, seed and draw, which correspond to the python methods in discrete_distribution.py. Note that the python implementation of discrete_distribution.draw() worked with distributions of arbitrary numbers of elements. For simplicity, we are restricting the C implementation to work with distributions of length 4. 

// (7) The draw routine is implemented using the same algorithm as in the python implementation. For simplicity, we use the C standard library rand() routine, although there are more advanced random number generators that would be more appropriate for scientific applications
