clear all;
close all;

diameter = 120;       % normalized worm diameter you want to have(I set 120 for 3hrs worms).
halfwidth = 2*60;

Nmax = 1024;
file = 'alexa';
file2 = 'dapi';
ext = '.tif';
dir = 'E:\van Oudenaarden Lab\data\wnt\mig-14_mom-1\073109_A\';
subdir = '3d\';


for j=28:1:29

close all;
series = sprintf('%03d', j);
file = 'alexa';
fname1=[dir subdir file series '_mRNA_processed'];
%fname1=[dir subdir file series '_whole_body_directly_counted'];

load(fname1);

im = tiffread2([dir file series ext]);   %open cy5
n = length(im);           %counts the number of images in stack
ims = cat(3, im.data);    %construct 3d array with stack images
ims = double(ims);
clear im;
maxproj = max(ims, [], 3); 

dapi = tiffread2([dir file2 series ext]);   %open dapi
m = length(dapi);           %counts the number of images in stack
ims4 = cat(3, dapi.data);    %construct 3d array with stack images
ims4 = uint16(ims4);
clear dapi;
dapi_maxproj = max(ims4, [], 3);    


file = 'alexa';
fname1=[dir subdir file series '_mRNA_processed'];
load(fname1);
[bodyxyz, bodyxyz_raw, body_yz, vcn_yz, ellipse, section_maxproj] = body_xyz(ims, ims4, m, halfwidth, Nmax);
[coord] = get_coord_2(bodyxyz, spotxyz, body_yz, vcn_yz, ellipse, diameter);
cd([dir subdir]);
save([file series '_spot_straighten_all'], 'bodyxyz', 'bodyxyz_raw', 'body_yz', 'vcn_yz', 'ellipse', 'section_maxproj', 'dapi_maxproj', 'coord'); 
cd(['e:\van Oudenaarden Lab\protocol\3d\']);      % change directory to continue loop


% file = 'alexa';
% fname1=[dir subdir file series '_mRNA_processed'];
% load(fname1);
% [coord] = get_coord_2(bodyxyz, spotxyz, body_yz, vcn_yz, ellipse, diameter);
% 
% cd([dir subdir]);
% save([file series '_spot_straighten_all'], 'bodyxyz', 'bodyxyz_raw', 'body_yz', 'vcn_yz', 'ellipse', 'section_maxproj', 'dapi_maxproj', 'coord'); 
% cd(['e:\van Oudenaarden Lab\protocol\3d\']);      % change directory to continue loop


% file = 'tmr';
% fname1=[dir subdir file series '_mRNA_processed'];
% load(fname1);
% [coord] = get_coord_2(bodyxyz, spotxyz, body_yz, vcn_yz, ellipse, diameter);
% 
% cd([dir subdir]);
% save([file series '_spot_straighten_all'], 'bodyxyz', 'bodyxyz_raw', 'body_yz', 'vcn_yz', 'ellipse', 'section_maxproj', 'dapi_maxproj', 'coord'); 
%cd(['e:\van Oudenaarden Lab\protocol\3d\']);      % change directory to continue loop
clear ims;
clear ims4;


end