function[spot_xyz, tx] = spot_analyzer(spot, maxproj, ims2, bodymask)

close all;
bodymask = uint16(bodymask);

for i=1:1:20

plot(spot);
title(['Number of mRNA spots vs. pixel value threshold']);
xlim([0 100]);
ylim([0 1000]);
[tx ty] = ginput(1);
thresh = sprintf('%d', tx);


ims3 = ims2 > (round(tx)./100).*max(ims2(:));                %create a binary 3-d array using the chosen threshold

ims3 = bwareaopen(ims3, 1);


[ims3, spot_num] = bwlabeln(ims3);
spot_pos = regionprops(ims3, 'centroid');     %find the coordinates of each of the spot

spot_xyz = NaN(spot_num,3);
for s=1:1:spot_num
    
    spot_xyz(s,1) = (spot_pos(s).Centroid(1,1));
    spot_xyz(s,2) = (spot_pos(s).Centroid(1,2));
    spot_xyz(s,3) = (spot_pos(s).Centroid(1,3));
    
end

figure(1);
subplot(1,2,1)
title('This is your maximum projection image');
maxproj = immultiply(maxproj, bodymask);         %maximum Z-projection with bodymask
imshow(maxproj, []);


subplot(1,2,2)
%maxproj = mat2gray(maxproj);         %maximum Z-projection
imshow(maxproj, []);
title(['Check how your threshold value works. Your threshold is ' thresh]);
hold on;
scatter(spot_xyz(:,1), spot_xyz(:,2), 3, 'bo');


reply = input('If satisfied, hit ENTER. If not, type any letter and hit ENTER : ', 's');
if isempty(reply)
    break;
end

close all;
end