function[mrna2 s] = rotation(mrna)     


dim = size(mrna);


clear im;


% rotate the 3d array along the y-axis so that I'm looking at the worm's cross section
% from the tail  --> mrna2

for i=1:1:dim(1,1)
    
    for j=1:1:dim(1,3)
        
        for k=1:1:dim(1,2)
            
            mrna2(i,j,k) = mrna(i,k,dim(1,3)-j+1);   % rotate the 3d array 90 degrees to the right
            
        end
    end
end


s = dim(1,2);               % s is the number of images of worm cross section in our new angle


