clear all;
close all;

diameter = 120;       % normalized worm diameter you want to have(I set 120 for 3hrs worms).
halfwidth = 2*50;

Nmax = 1024;
file = 'cy5';
file2 = 'dapi';
ext = '.tif';
dir = 'E:\van Oudenaarden Lab\data\wnt\mig-14_mom-1\090109_C\';
subdir = '3d\';


for j=28:1:29

close all;
series = sprintf('%03d', j);

im = tiffread2([dir file series ext]);   %open cy5
n = length(im);           %counts the number of images in stack
ims = cat(3, im.data);    %construct 3d array with stack images
ims = double(ims);
clear im;

maxproj = max(ims, [], 3);         %maximum Z-projection
maxproj = mat2gray(maxproj);
clear ims;

figure;
title('Create a mask and hit enter');
imshow(maxproj, []);
[bodymask, xi, yi ] = roipoly(maxproj);
bodymask = uint16(bodymask);

fprintf('Selected mask for file %03d',j);
fprintf('\n');

cd([dir subdir]);
save([file series '_bodymask'], 'bodymask'); 
cd(['e:\van Oudenaarden Lab\protocol\3d\']);      % change directory to continue loop


end