clear all;
close all;


series1='028';
series2='029';
file = 'alexa';
file2 = 'dapi';
ext = '.tif';
dir = 'E:\van Oudenaarden Lab\data\wnt\mig-14_mom-1\073109_A\';
subdir = '3d\';
norm_length = 1600;        % the normalized worm length you'd like to have(I set 1600 for 3hrs worms).


fname1=[dir subdir file series1 '_spot_straighten_all'];
fname2=[dir subdir file series2 '_spot_straighten_all'];


load(fname1);
coord1 = coord;
bodyxyz_1 = bodyxyz;
dapi_maxproj_1 = dapi_maxproj;
clear coord;
clear bodyxyz;
clear dapi_maxproj;

load(fname2);
coord2 = coord;
bodyxyz_2 = bodyxyz;
dapi_maxproj_2 = dapi_maxproj;
clear coord;
clear bodyxyz;
clear dapi_maxproj;


[coord_conn, coord_conn_norm, wormlength, xy1, xy2] = connect2_beta(coord1, coord2, bodyxyz_1, bodyxyz_2, dapi_maxproj_1, dapi_maxproj_2, norm_length);
s = size(coord_conn_norm);

cd([dir subdir]);
save([file series1 series2 '_processed_final'], 'coord_conn', 'coord_conn_norm', 'wormlength', 'xy1', 'xy2'); 

close all;

figure;
polar(coord_conn_norm(:,2),coord_conn_norm(:,1),'ro');

figure;
scatter3(coord_conn_norm(:,1), coord_conn_norm(:,2), coord_conn_norm(:,3), 'b.');
axis vis3d;
axis equal;
xlim([-200 norm_length]); 



cd(['e:\van Oudenaarden Lab\protocol\3d\']);      % change directory to continue loop

