clear all;
close all;


series='001';
norm_length = 1600;        % the normalized worm length you'd like to have(I set 1600 for 3hrs worms).
file = 'cy5';
file2 = 'dapi';
ext = '.tif';
dir = 'E:\van Oudenaarden Lab\data\wnt\mig-14_mom-1\090109_C\';
subdir = '3d\';


fname=[dir subdir file series '_spot_straighten_all'];

load(fname);

s1 = size(bodyxyz);
n1 = s1(1,1);


% now let's find the two end points of the worm.

figure(1);
title('Click on the two end points - hit ENTER');
imshow(dapi_maxproj);
xy = ginput(2);



for m=1:1:n1    
    dt(m,1) = ((xy(1,1)-bodyxyz(m,1)).^2+(xy(1,2)-bodyxyz(m,2)).^2).^0.5;    
end
[dt_min dt_min_ind] = min(dt(:));

for n=1:1:n1    
    dh(n,1) = ((xy(2,1)-bodyxyz(n,1)).^2+(xy(2,2)-bodyxyz(n,2)).^2).^0.5;   
end
[dh_min dh_min_ind] = min(dh(:));


wormlength = (dh_min_ind - dt_min_ind);

coord(:,4) = (coord(:,4) - dt_min_ind);
s = size(coord);


% now let's re-map the straight worm so that the tail starts at x=0.
coord_norm = NaN(size(coord));
coord_norm(:,1) = coord(:,4).*(norm_length./wormlength);
coord_norm(:,2) = coord(:,5);
coord_norm(:,3) = coord(:,6);



cd([dir subdir]);
save([file series 'processed_final'], 'coord', 'coord_norm', 'wormlength', 'xy'); 

close all;

figure;
polar(coord_norm(:,2),coord_norm(:,1),'ro');

figure;
scatter3(coord_norm(:,1), coord_norm(:,2), coord_norm(:,3), 'b.');
axis vis3d;
axis equal;
xlim([-200 norm_length]); 



cd(['e:\van Oudenaarden Lab\protocol\3d\']);      % change directory to continue loop
