function [coord] = get_coord(bodyxyz, spotxyz, body_yz, vcn_yz, ellipse, diameter)

% the z-value of all three coordinate arrays has to be scaled to the real lengthscale!!
% the z-value of bodyxyz will be a constant, which is reasonable assumption!


s1 = size(spotxyz);
s2 = size(bodyxyz);

n1 = s1(1,1);
n2 = s2(1,1);


% the spot coordinates(3rd column of "spotxyz" has to be rescaled
for y=1:1:n1
   spotxyz(y,3) = (spotxyz(y,3)-body_yz(1,3)).*(ellipse(1,1)/ellipse(1,2))+body_yz(1,3);
end



coord = [];



for i=1:1:n1
    
    coord_spot = NaN(1,6);
    dist = zeros(n2,1);    
    for j=1:1:n2
    
    dist(j,1) = ((spotxyz(i,1)-bodyxyz(j,1)).^2 + (spotxyz(i,2)-bodyxyz(j,2)).^2 + (spotxyz(i,3)-bodyxyz(j,3)).^2).^0.5;
    
    end
    [min_dist min_index] = min(dist(:));
    minivec = [(bodyxyz(min_index+1,1)-bodyxyz(min_index,1)) (bodyxyz(min_index+1,2)-bodyxyz(min_index,2)) (bodyxyz(min_index+1,3)-bodyxyz(min_index,3))];
    vert = [0 0 1];
    spotvec = [spotxyz(i,1)-bodyxyz(min_index,1) spotxyz(i,2)-bodyxyz(min_index,2) spotxyz(i,3)-bodyxyz(min_index,3)];
    refvec = cross(minivec, vert);
    
    if (((refvec(1,1).^2+refvec(1,2).^2+refvec(1,3).^2).^0.5).*(spotvec(1,1).^2+spotvec(1,2).^2+spotvec(1,3).^2).^0.5) ~= 0
    theta = acos(dot(refvec, spotvec)./(((refvec(1,1).^2+refvec(1,2).^2+refvec(1,3).^2).^0.5).*(spotvec(1,1).^2+spotvec(1,2).^2+spotvec(1,3).^2).^0.5));
    else
        theta = pi/2;
    end
    
    coord_spot(1,1) = min_dist.*(diameter./ellipse(1,1));
    
    if spotxyz(i,3)-bodyxyz(min_index,3) >= 0
        coord_spot(1,2) = theta;
    else
        coord_spot(1,2) = -theta;
    end
    
    coord_spot(1,4) = min_index;
    coord = cat(1, coord, coord_spot);
        
end




% for k=1:1:n3
%         
%     dist2 = zeros(n2,1);
%     dist_2d_2 = zeros(n2,1);
%     for l=1:1:n2
%         
%         dist2(l,1) = ((bodyxyz(l,1)-vcnxyz(k,1)).^2 + (bodyxyz(l,2)-vcnxyz(k,2)).^2 + (bodyxyz(l,3)-vcnxyz(k,3)).^2).^0.5;
%         
%     end
%     [min_dist2 min_index2] = min(dist2);
%     dist_2d_2(min_index2,1) = bodyxyz(min_index2,3)-spotxyz(min_index2,3);
%     theta2 = acos(min_dist2./dist_2d_2);
%     coord(min_index2, 4) = k;
%     coord(min_index2, 5) = min_dist2;
%     
%         if vcnxyz(k,3)-bodyxyz(min_index2,3) >= 0
%         coord(min_index2, 6) = theta2;
%         else
%         coord(min_index2, 6) = -theta2;
%         end
%    
% end



w = ((vcn_yz(1,2)-body_yz(1,2)).^2 + (vcn_yz(1,3)-body_yz(1,3)).^2).^0.5;
y = body_yz(1,2) - vcn_yz(1,2);
w = double(w);
y = double(y);
theta2 = acos(y/w);

if vcn_yz(1,3) < body_yz(1,3)
    theta2 = -theta2;
end

coord(:,3) = theta2;

% make corrections in theta by subtracting theta2 to have VCN at 0 degrees.
coord(:,2) = coord(:,2) - theta2;

coord_length = size(coord);
for c=1:1:coord_length(1,1)
    
    coord(c,5) = coord(c,1).*cos(coord(c,2));
    coord(c,6) = coord(c,1).*sin(coord(c,2));
    
end

    