clear all;
close all;

diameter = 120;       % normalized worm diameter you want to have(I set 120 for 3hrs worms).
halfwidth = 2*50;

Nmax = 1024;
file = 'cy5';
file2 = 'dapi';
ext = '.tif';
dir = 'E:\van Oudenaarden Lab\data\wnt\mig-14_mom-1\090109_C\';
subdir = '3d\';


for j=28:1:29

close all;
series = sprintf('%03d', j);
fname1=[dir subdir file series '_filtering_processed'];
fname2=[dir subdir file series '_bodymask'];

load(fname1);
load(fname2);
s = size(ims2);
n = s(1,3);

ims3 = [];
for i=1:1:n-1
    
    g = ims2(:,:,1);    
    g = immultiply(g, bodymask);
    ims2 = ims2(:,:,2:end);
    ims3 = cat(3, ims3, g);
    
end

spot = multithreshstack_2(ims3);
fprintf('Multi-threshold applied to masked file %03d',j);
fprintf('\n');

cd([dir subdir]);
save([file series '_spot_curve_processed'], 'ims3', 'spot'); 
cd(['e:\van Oudenaarden Lab\protocol\3d\']);      % change directory to continue loop


end