clear all;
close all;

diameter = 120;       % normalized worm diameter you want to have(I set 120 for 3hrs worms).
halfwidth = 2*50;

Nmax = 1024;
file = 'cy5';
file2 = 'dapi';
ext = '.tif';
dir = 'E:\van Oudenaarden Lab\data\wnt\mig-14_mom-1\090109_C\';
subdir = '3d\';

w1 = [ 1 4 7 4 1; 4 16 26 16 4; 7 26 41 26 7; 4 16 26 16 4; 1 4 7 4 1;];    % a 5x5 2-d guassian filter
w1 = w1./273;
w2 = [0 -1 0; -1 4 -1; 0 -1 0];     % a 3x3 2-d filter

% w1 = [-1 -1 -1; -1 12 -1; -1 -1 -1];     %sharpen image
% w2 = [1 1 1; 1 1 1; 1 1 1];              %smooth image
se = strel('disk', 3);


for j=28:1:29

close all;
series = sprintf('%03d', j);
fprintf('Filtering file %03d',j);
fprintf('\n');


im = tiffread2([dir file series ext]);   %open cy5
n = length(im);           %counts the number of images in stack
ims = cat(3, im.data);    %construct 3d array with stack images
ims = uint16(ims);
clear im;

ims2 = [];
for i=1:1:n-1
    
    g = imfilter(ims(:,:,1), w1, 'replicate');
    g = imfilter(g, w2, 'replicate');
    g = imfilter(g, w1, 'replicate');
    g = imfilter(g, w2, 'replicate');
    g = imtophat(g, se);
    g = imfilter(g, w1, 'replicate');
    g = imfilter(g, w2, 'replicate');
    
    ims = ims(:,:,2:end);
    ims2 = cat(3, ims2, g);
    
end

clear ims;
ims2 = uint16(ims2);

cd([dir subdir]);
save([file series '_filtering_processed'], 'ims2'); 
cd(['e:\van Oudenaarden Lab\protocol\3d\']);      % change directory to continue loop
clear ims2;

end