function[coord_conn, coord_conn_norm, wormlength, xy1, xy2] = connect2_beta(coord1, coord2, bodyxyz_1, bodyxyz_2, im_1, im_2, norm_length)


s1 = size(bodyxyz_1);
s2 = size(bodyxyz_2);
n1 = s1(1,1);
n2 = s2(1,1);

ss1 = size(coord1);
ss2 = size(coord2);
nn1 = ss1(1,1);
nn2 = ss2(1,1);


% im_1 and im2 are dapi images

im_1_maxproj = max(im_1, [], 3);
im_2_maxproj = max(im_2, [], 3);


figure(1);
title('Click on a point which you would like to connect the worm - hit ENTER');
imshow(im_1_maxproj);
hold on;
plot(bodyxyz_1(:,1),bodyxyz_1(:,2),'.');
xy1 = ginput(1);


figure(2);
title('Click on a point which you would like to connect the worm - hit ENTER');
imshow(im_2_maxproj);
hold on;
plot(bodyxyz_2(:,1),bodyxyz_2(:,2),'.');
xy2 = ginput(1);



for i=1:1:n1    
    d1(i,1) = ((xy1(1,1)-bodyxyz_1(i,1)).^2+(xy1(1,2)-bodyxyz_1(i,2)).^2).^0.5;    
end
[d1_min d1_min_ind] = min(d1(:));

for j=1:1:n2    
    d2(j,1) = ((xy2(1,1)-bodyxyz_2(j,1)).^2+(xy2(1,2)-bodyxyz_2(j,2)).^2).^0.5;   
end
[d2_min d2_min_ind] = min(d2(:));


for ii=1:1:nn1
    
    if coord1(ii,4)>d1_min_ind
        coord1(ii,:)=NaN;
    else
    end
end

for jj=1:1:nn2
    
    if coord2(jj,4)<=d2_min_ind
        coord2(jj,:)=NaN;
    else
    end
end

coord2(:,4) = (coord2(:,4) - d2_min_ind + d1_min_ind); 

coord_conn = cat(1, coord1, coord2);



% now let's find the two end points of the worm.

figure(3);
title('Click on the tail end point - hit ENTER');
imshow(im_1_maxproj);
xy3 = ginput(1);


figure(4);
title('Click on the head end point - hit ENTER');
imshow(im_2_maxproj);
xy4 = ginput(1);



for m=1:1:n1    
    d3(m,1) = ((xy3(1,1)-bodyxyz_1(m,1)).^2+(xy3(1,2)-bodyxyz_1(m,2)).^2).^0.5;    
end
[d3_min d3_min_ind] = min(d3(:));

for n=1:1:n2    
    d4(n,1) = ((xy4(1,1)-bodyxyz_2(n,1)).^2+(xy4(1,2)-bodyxyz_2(n,2)).^2).^0.5;   
end
[d4_min d4_min_ind] = min(d4(:));


wormlength = (d1_min_ind - d3_min_ind) + (d4_min_ind - d2_min_ind) ;

coord_conn(:,4) = (coord_conn(:,4) - d3_min_ind);

% now let's re-map the straight worm so that the tail starts at x=0.
coord_conn_norm = NaN(size(coord_conn));
coord_conn_norm(:,1) = coord_conn(:,4).*(norm_length./wormlength);
coord_conn_norm(:,2) = coord_conn(:,5);
coord_conn_norm(:,3) = coord_conn(:,6);
    
 

