function[bodyxyz_rd, bodyxyz, body_yz, vcn_yz, ellipse, section_maxproj] = body_xyz(ims, ims4, n, halfwidth, Nmax)
close all;


maxprojd = max(ims, [], 3);         %maximum Z-projection
maxprojd = mat2gray(maxprojd);
maxprojd_4 = max(ims4, [], 3);         %maximum Z-projection
maxprojd_4 = mat2gray(maxprojd_4);


figure(1);
title('Click on antero-posterior axis starting **from posterior side** - hit ENTER');
imshow(maxprojd, []);
xybody = ginput;
hold on;


x=xybody(:,1);        
y=xybody(:,2);
yy=[x';y'];               %transpose columns to rows and create a 2 by ? matrix
xx=1:length(x);
plot(xybody(:,1),xybody(:,2),'o')
xxx=1:0.0001:length(x);
pp=spline(xx,yy,xxx);
dx=diff(pp(1,:));
dy=diff(pp(2,:));

dr=sqrt(dx.^2+dy.^2);
wormlength=cumsum(dr);
totalwormlength=round(sum(dr));


for i=1:totalwormlength
    minvec=abs(i-wormlength);
    [mindis j]=min(minvec);
    X(i)=pp(1,j);
    Y(i)=pp(2,j);
end;
plot(X,Y,'.');


dr_long=[diff(X); diff(Y)];
dr_trans=[];                                       %start with an empty matrix dr_trans
for j=1:size(dr_long,2)                            %size of the 2nd row of dr_long
    veclong=[dr_long(:,j);0];                      %create infinitesimal vectors along the body axis (in 3-d)
    vecZ=[0; 0; 1];                                %vecZ is a vector sticking out of the image plane
    vectrans=cross(vecZ,veclong);                  %generate vectors perpendicular to the body axis via cross product
    dr_trans=[dr_trans vectrans(1:2,:)];           %dr_trans is a 3 by ? matrix with each 'vectrans' as each column

 end;

sss = size(X);
 straight = [];
 for kk = 1:1:n
     
 I = ims4(:,:,kk);

    strpln = [];  
    for k=1:(round(double(sss(1,2))./100)):size(dr_long,2)
        for l=1:halfwidth
            Xoff1(k,l)=l*dr_trans(1,k)+X(k);           %Cartesian coordinates of the points to be mapped in the original image
            Yoff1(k,l)=l*dr_trans(2,k)+Y(k);
            Xoff2(k,l)=-l*dr_trans(1,k)+X(k);
            Yoff2(k,l)=-l*dr_trans(2,k)+Y(k);
            if (round(Xoff1(k,l))<Nmax && round(Yoff1(k,l))<Nmax && round(Xoff1(k,l))>0 && round(Yoff1(k,l))>0)
                repix1(l)=double(I(round(Yoff1(k,l)),round(Xoff1(k,l))));
            else
                repix1(l)=0;
            end
            if (round(Xoff2(k,l))<Nmax && round(Yoff2(k,l))<Nmax && round(Xoff2(k,l))>0 && round(Yoff2(k,l))>0)
                repix2(halfwidth-l+1)=double(I(round(Yoff2(k,l)),round(Xoff2(k,l))));
            else
                repix2(l)=0;
            end

        end
        repix=[repix2'; repix1'];
        strpln = cat(2, strpln, repix);
        clear repix;
     end;
 
     
straight = cat(3, straight, strpln);

 end
 
[section c] = rotation(straight);             %the function "rotation" rotates the 3d array "straight" to see the straight worm's cross section


section_maxproj = max(section, [], 3);
section_maxproj = mat2gray(section_maxproj);

show_stack(section);


figure(3);
imshow(maxprojd, []);


figure(4);
title('Draw a polygon around the worm cross section to find the center - hit ENTER');
camzoom(3);
mask = roipoly(section_maxproj);
mask2 = bwlabel(mask,4);
center = regionprops(mask2, 'Centroid', 'MajorAxisLength', 'MinorAxisLength');
body_z = center.Centroid;
ellipse = [center.MajorAxisLength center.MinorAxisLength;];
body_yz = [NaN body_z(1,2) (n - body_z(1,1))];

bodyxyz = NaN(sss(1,2), 3);
for t=1:1:sss(1,2)
    bodyxyz(t,1)=X(t);
    bodyxyz(t,2)=Y(t);
    bodyxyz(t,3)=body_yz(1,3);
end
    

bodyxyz_rd = round(bodyxyz);


% s=size(section);
% s=s(1,3);

% sumproj = section(:,:,1);
% for u=2:1:s-1
%     sumproj = imadd(sumproj, section(:,:,u));
% end
% 
% sumproj = mat2gray(sumproj);


figure(5);
imshow(maxprojd_4, []);

figure(4);
camzoom(3);
imshow(section_maxproj, []);
title('Click on VCN - hit ENTER');
vcn_z = ginput(1);
close all;

vcn_yz = [NaN vcn_z(1,2) (n-vcn_z(1,1))];