clear all;
close all;

diameter = 120;       % normalized worm diameter you want to have(I set 120 for 3hrs worms).
halfwidth = 2*50;

Nmax = 1024;
file = 'cy5';
file2 = 'dapi';
ext = '.tif';
dir = 'E:\van Oudenaarden Lab\data\wnt\mig-14_mom-1\090109_C\';
subdir = '3d\';


for j=5:1:5

close all;
series = sprintf('%03d', j);
im = tiffread2([dir file series ext]);   %open cy5
n = length(im);           %counts the number of images in stack
ims = cat(3, im.data);    %construct 3d array with stack images
ims = uint16(ims);
clear im;
maxproj = max(ims, [], 3); 

fname1=[dir subdir file series '_spot_curve_processed'];
fname2=[dir subdir file series '_bodymask'];
%fname3=[dir subdir file series '_sharpen_smooth_filtered'];

load(fname1);
load(fname2);
%load(fname3);

[spotxyz, tx] = spot_analyzer(spot, maxproj, ims3, bodymask);
[spotxyz] = show_spot(n, spotxyz, ims);


cd([dir subdir]);
save([file series '_mRNA_processed'], 'ims3', 'spotxyz', 'tx'); 
cd(['e:\van Oudenaarden Lab\protocol\3d\']);      % change directory to continue loop


end