worm_length = 1800;
bin_size = 20;

Negl20 = 13;
Nlin44 = 13;
Ncwn1 = 10;
Ncwn2 = 13;
Nmom2 = 6;


egl20 = [];
for i=1:Negl20
    
    series = sprintf('%1d', i);
    fname = ['egl20_' series];
    dat = eval(fname);
    dat(:,1) = dat(:,1) + 200;
    ss = size(dat);
    s = ss(1,1);
    
    count = zeros(worm_length/bin_size, 1);
    for ii=1:s
        
       for j=0:bin_size:worm_length
           
           if dat(ii,1)>=j && dat(ii,1)<j+bin_size
               
                  count(j/bin_size) = count(j/bin_size) + 1;
                  
           end
           
       end
       
    end
    egl20 = [egl20 count];
    
end

mean_egl20 = zeros(worm_length/bin_size, 1);
stdev_egl20 = zeros(worm_length/bin_size, 1);
sem_egl20 = zeros(worm_length/bin_size, 1);
for y=1:worm_length/bin_size
    stdev_egl20(y) = std(egl20(y,:));
    mean_egl20(y) = mean(egl20(y,:));
    sem_egl20(y) = stdev_egl20(y)./sqrt(Negl20-1);
end




lin44 = [];
for i=1:Nlin44
    
    series = sprintf('%1d', i);
    fname = ['lin44_' series];
    dat = eval(fname);
    dat(:,1) = dat(:,1) + 200;
    ss = size(dat);
    s = ss(1,1);
    
    count = zeros(worm_length/bin_size, 1);
    for ii=1:s
        
       for j=0:bin_size:worm_length
           
           if dat(ii,1)>=j && dat(ii,1)<j+bin_size
               
                  count(j/bin_size) = count(j/bin_size) + 1;
                  
           end
           
       end
       
    end
    lin44 = [lin44 count];
    
end
mean_lin44 = zeros(worm_length/bin_size, 1);
stdev_lin44 = zeros(worm_length/bin_size, 1);
sem_lin44 = zeros(worm_length/bin_size, 1);
for y=1:worm_length/bin_size
    stdev_lin44(y) = std(lin44(y,:));
    mean_lin44(y) = mean(lin44(y,:));
    sem_lin44(y) = stdev_lin44(y)./sqrt(Nlin44-1);
end


mom2 = [];
for i=1:Nmom2
    
    series = sprintf('%1d', i);
    fname = ['mom2_' series];
    dat = eval(fname);
    dat(:,1) = dat(:,1) + 200;
    ss = size(dat);
    s = ss(1,1);
    
    count = zeros(worm_length/bin_size, 1);
    for ii=1:s
        
       for j=0:bin_size:worm_length
           
           if dat(ii,1)>=j && dat(ii,1)<j+bin_size
               
                  count(j/bin_size) = count(j/bin_size) + 1;
                  
           end
           
       end
       
    end
    mom2 = [mom2 count];
    
end
mean_mom2 = zeros(worm_length/bin_size, 1);
stdev_mom2 = zeros(worm_length/bin_size, 1);
sem_mom2 = zeros(worm_length/bin_size, 1);
for y=1:worm_length/bin_size
    stdev_mom2(y) = std(mom2(y,:));
    mean_mom2(y) = mean(mom2(y,:));
    sem_mom2(y) = stdev_mom2(y)./sqrt(Nmom2-1);
end


cwn1 = [];
for i=1:Ncwn1
    
    series = sprintf('%0d', i);
    fname = ['cwn1_' series];
    dat = eval(fname);
    dat(:,1) = dat(:,1) + 200;
    ss = size(dat);
    s = ss(1,1);
    
    count = zeros(worm_length/bin_size, 1);
    for ii=1:s
        
       for j=0:bin_size:worm_length
           
           if dat(ii,1)>=j && dat(ii,1)<j+bin_size
               
                  count(j/bin_size) = count(j/bin_size) + 1;
                  
           end
           
       end
       
    end
    cwn1 = [cwn1 count];
    
end
mean_cwn1 = zeros(worm_length/bin_size, 1);
stdev_cwn1 = zeros(worm_length/bin_size, 1);
sem_cwn1 = zeros(worm_length/bin_size, 1);
for y=1:worm_length/bin_size
    stdev_cwn1(y) = std(cwn1(y,:));
    mean_cwn1(y) = mean(cwn1(y,:));
    sem_cwn1(y) = stdev_cwn1(y)./sqrt(Ncwn1-1);
end



cwn2 = [];
for i=1:Ncwn2
    
    series = sprintf('%0d', i);
    fname = ['cwn2_' series];
    dat = eval(fname);
    dat(:,1) = dat(:,1) + 200;
    ss = size(dat);
    s = ss(1,1);
    
    count = zeros(worm_length/bin_size, 1);
    for ii=1:s
        
       for j=0:bin_size:worm_length
           
           if dat(ii,1)>=j && dat(ii,1)<j+bin_size
               
                  count(j/bin_size) = count(j/bin_size) + 1;
                  
           end
           
       end
       
    end
    cwn2 = [cwn2 count];
    
end

mean_cwn2 = zeros(worm_length/bin_size, 1);
stdev_cwn2 = zeros(worm_length/bin_size, 1);
sem_cwn2 = zeros(worm_length/bin_size, 1);
for y=1:worm_length/bin_size
    stdev_cwn2(y) = std(cwn2(y,:));
    mean_cwn2(y) = mean(cwn2(y,:));
    sem_cwn2(y) = stdev_cwn2(y)./sqrt(Ncwn2-1);
end


figure;
errorbar(mean_egl20, sem_egl20, 'b');
hold on;
errorbar(mean_lin44, sem_lin44, 'r');
errorbar(mean_mom2, sem_mom2, 'g');
errorbar(mean_cwn1, sem_cwn1, 'c');
errorbar(mean_cwn2, sem_cwn2, 'm');
           
           