/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolox.util.MutablePoints;
import edu.umd.cs.piccolox.util.Points;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class XYArray
implements MutablePoints {
    private double[] points = null;
    private int numPoints = 0;

    public int getPointCount() {
        return this.numPoints;
    }

    private int i(int n) {
        if (n < 0) {
            n = this.numPoints + n;
        }
        if (n >= this.numPoints) {
            throw new IllegalArgumentException("The point index " + n + " is not below " + this.numPoints);
        }
        return n;
    }

    public double getX(int n) {
        n = this.i(n);
        return this.points[n * 2];
    }

    public double getY(int n) {
        n = this.i(n);
        return this.points[n * 2 + 1];
    }

    public Point2D getPoint(int n, Point2D point2D) {
        n = this.i(n);
        point2D.setLocation(this.points[n * 2], this.points[n * 2 + 1]);
        return point2D;
    }

    public void setX(int n, double d) {
        n = this.i(n);
        this.points[n * 2] = d;
    }

    public void setY(int n, double d) {
        n = this.i(n);
        this.points[n * 2 + 1] = d;
    }

    public void setPoint(int n, double d, double d2) {
        n = this.i(n);
        this.points[n * 2] = d;
        this.points[n * 2 + 1] = d2;
    }

    public void setPoint(int n, Point2D point2D) {
        this.setPoint(n, point2D.getX(), point2D.getY());
    }

    public void transformPoints(AffineTransform affineTransform) {
        affineTransform.transform(this.points, 0, this.points, 0, this.numPoints);
    }

    public Rectangle2D getBounds(Rectangle2D rectangle2D) {
        int n = 0;
        if (rectangle2D.isEmpty() && this.getPointCount() > 0) {
            rectangle2D.setRect(this.getX(n), this.getY(n), 1.0, 1.0);
            ++n;
        }
        while (n < this.getPointCount()) {
            rectangle2D.add(this.getX(n), this.getY(n));
            ++n;
        }
        return rectangle2D;
    }

    public static double[] initPoints(double[] dArray, int n, double[] dArray2) {
        if (dArray == null || n * 2 > dArray.length) {
            dArray = new double[n * 2];
        }
        if (dArray2 != null && dArray != dArray2) {
            System.arraycopy(dArray2, 0, dArray, 0, Math.min(dArray2.length, n * 2));
        }
        return dArray;
    }

    private void initPoints(double[] dArray, int n) {
        this.points = XYArray.initPoints(dArray, n, this.points);
        this.numPoints = dArray != null ? dArray.length / 2 : 0;
    }

    public XYArray(double[] dArray) {
        this.initPoints(dArray, dArray.length / 2);
    }

    public XYArray(int n) {
        this.initPoints(null, n);
    }

    public XYArray() {
        this(0);
    }

    public void addPoints(int n, Points points, int n2, int n3) {
        if (n3 < 0) {
            n3 = points.getPointCount() + n3 + 1;
        }
        int n4 = this.numPoints + n3 - n2;
        this.points = XYArray.initPoints(this.points, n4, this.points);
        int n5 = n * 2;
        int n6 = (n + n3 - n2) * 2;
        int n7 = (this.numPoints - n) * 2;
        System.arraycopy(this.points, n5, this.points, n6, n7);
        this.numPoints = n4;
        if (points == null) {
            return;
        }
        int n8 = 0;
        while (n2 < n3) {
            this.setPoint(this.numPoints + n8, points.getX(n2), points.getY(n2));
            ++n8;
            ++n2;
        }
    }

    public void addPoints(int n, Points points) {
        this.addPoints(n, points, 0, points.getPointCount());
    }

    public void appendPoints(Points points) {
        this.addPoints(this.numPoints, points);
    }

    public static XYArray copyPoints(Points points) {
        XYArray xYArray = new XYArray(points.getPointCount());
        xYArray.appendPoints(points);
        return xYArray;
    }

    public void addPoint(int n, double d, double d2) {
        this.addPoints(n, null, 0, 1);
        this.setPoint(n, d, d2);
    }

    public void addPoint(int n, Point2D point2D) {
        this.addPoint(n, point2D.getX(), point2D.getY());
    }

    public void removePoints(int n, int n2) {
        if ((n2 = Math.min(n2, this.numPoints - n)) <= 0) {
            return;
        }
        System.arraycopy(this.points, (n + n2) * 2, this.points, n * 2, (this.numPoints - (n + n2)) * 2);
        this.numPoints -= n2;
    }

    public void removeAllPoints() {
        this.removePoints(0, this.numPoints);
    }

    public Object clone() {
        XYArray xYArray = null;
        try {
            xYArray = (XYArray)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (xYArray != null) {
            xYArray.points = XYArray.initPoints(xYArray.points, this.numPoints, this.points);
            xYArray.numPoints = this.numPoints;
        }
        return xYArray;
    }
}

