/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.stem;

import edu.cmu.cs.sb.core.GoAnnotations;
import edu.cmu.cs.sb.core.MultiLineHeaderRenderer;
import edu.cmu.cs.sb.core.TableModelST;
import edu.cmu.cs.sb.core.TableSorter;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.stem.DefineGeneSet;
import edu.cmu.cs.sb.stem.MAINGUI2;
import edu.cmu.cs.sb.stem.STEM_DataSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class SortTable
extends JPanel
implements ActionListener {
    private boolean DEBUG = false;
    STEM_DataSet theDataSet;
    int nprofile;
    JTable table = null;
    JScrollPane scrollPane = null;
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    String[][] tabledata = null;
    String[] columnNames = null;
    ArrayList clusterArray = null;
    MAINGUI2 maingui;
    GoAnnotations tga;
    TableSorter sorter;
    JFrame theFrame;
    JRadioButton actualButton;
    JRadioButton expectedButton;
    ListSelectionModel rowSM;
    JFrame defineframe;

    public SortTable(JFrame jFrame, MAINGUI2 mAINGUI2, GoAnnotations goAnnotations, STEM_DataSet sTEM_DataSet) {
        JButton jButton;
        JButton jButton2;
        Object object;
        Object object2;
        int n;
        Object object3;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bg);
        this.setForeground(fg);
        this.theFrame = jFrame;
        this.maingui = mAINGUI2;
        this.tga = goAnnotations;
        this.theDataSet = sTEM_DataSet;
        if (goAnnotations.bcluster) {
            this.columnNames = new String[3];
            this.columnNames[0] = "Category ID";
            this.columnNames[1] = "Category Name";
            this.columnNames[2] = "Min p-value";
            object3 = goAnnotations.theClusterRecIDpval;
            this.tabledata = new String[((Object[])object3).length][this.columnNames.length];
            for (n = 0; n < ((Object[])object3).length; ++n) {
                this.tabledata[n][0] = ((GoAnnotations.RecIDpval)object3[n]).szid;
                this.tabledata[n][2] = Util.doubleToSz(((GoAnnotations.RecIDpval)object3[n]).dpval);
                object2 = "";
                object = ((GoAnnotations.Rec)goAnnotations.htGO.get((Object)this.tabledata[n][0])).sztermName;
                if (object != null) {
                    object2 = object;
                }
                this.tabledata[n][1] = object2;
            }
        } else {
            object3 = goAnnotations.theRecIDpval;
            if (sTEM_DataSet.bkmeans) {
                this.columnNames = new String[3];
            } else {
                this.columnNames = new String[4];
                this.columnNames[3] = "Min p-value\n(expected size)";
            }
            this.columnNames[0] = "Category ID";
            this.columnNames[1] = "Category Name";
            this.columnNames[2] = "Min p-value\n(actual size)";
            this.tabledata = new String[((Object[])object3).length][this.columnNames.length];
            for (n = 0; n < ((Object[])object3).length; ++n) {
                this.tabledata[n][0] = ((GoAnnotations.RecIDpval2)object3[n]).szid;
                this.tabledata[n][2] = Util.doubleToSz(((GoAnnotations.RecIDpval2)object3[n]).dpvalhyper);
                if (!sTEM_DataSet.bkmeans) {
                    this.tabledata[n][3] = Util.doubleToSz(((GoAnnotations.RecIDpval2)object3[n]).dpvalbinom);
                }
                object2 = "";
                object = ((GoAnnotations.Rec)goAnnotations.htGO.get((Object)this.tabledata[n][0])).sztermName;
                if (object != null) {
                    object2 = object;
                }
                this.tabledata[n][1] = object2;
            }
        }
        this.sorter = new TableSorter(new TableModelST(this.tabledata, this.columnNames));
        this.table = new JTable(this.sorter);
        object3 = this.table.getColumnModel().getColumn(0);
        ((TableColumn)object3).setPreferredWidth(100);
        object3 = this.table.getColumnModel().getColumn(1);
        ((TableColumn)object3).setPreferredWidth(250);
        object3 = this.table.getColumnModel().getColumn(2);
        ((TableColumn)object3).setPreferredWidth(100);
        if (!goAnnotations.bcluster && !sTEM_DataSet.bkmeans) {
            object3 = this.table.getColumnModel().getColumn(3);
            ((TableColumn)object3).setPreferredWidth(100);
        }
        MultiLineHeaderRenderer multiLineHeaderRenderer = new MultiLineHeaderRenderer(this.sorter);
        object2 = this.table.getColumnModel().getColumns();
        while (object2.hasMoreElements()) {
            ((TableColumn)object2.nextElement()).setHeaderRenderer(multiLineHeaderRenderer);
        }
        this.sorter.setTableHeader(this.table.getTableHeader());
        this.scrollPane = new JScrollPane(this.table);
        this.add(this.scrollPane);
        this.table.setSelectionMode(0);
        this.rowSM = this.table.getSelectionModel();
        object = sTEM_DataSet;
        boolean bl = goAnnotations.bcluster;
        MAINGUI2 mAINGUI22 = mAINGUI2;
        this.rowSM.addListSelectionListener(new ListSelectionListener((STEM_DataSet)object, bl, mAINGUI22){
            final /* synthetic */ STEM_DataSet val$finaltheDataSet;
            final /* synthetic */ boolean val$bfcluster;
            final /* synthetic */ MAINGUI2 val$finalmaingui;
            {
                this.val$finaltheDataSet = sTEM_DataSet;
                this.val$bfcluster = bl;
                this.val$finalmaingui = mAINGUI2;
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                String string;
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    return;
                }
                int n = listSelectionModel.getMinSelectionIndex();
                this.val$finaltheDataSet.tga.szSelectedGO = string = (String)SortTable.this.sorter.getValueAt(n, 0);
                this.val$finaltheDataSet.tga.bcluster = this.val$bfcluster;
                this.val$finaltheDataSet.tga.szsortcommand = this.val$finaltheDataSet.bkmeans || this.val$bfcluster || SortTable.this.actualButton.isSelected() ? "go" : "expgo";
                this.val$finalmaingui.drawmain();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        if (!sTEM_DataSet.bkmeans) {
            jButton2 = new JButton("Default Order");
            jButton2.setActionCommand("default");
            jButton2.addActionListener(this);
            jPanel.add(jButton2);
        }
        jButton2 = new JButton("Define Gene Set...");
        jButton2.setActionCommand("define");
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton("Copy Table", Util.createImageIcon("Copy16.gif"));
        jButton3.setActionCommand("copy");
        jButton3.setMinimumSize(new Dimension(800, 20));
        jButton3.addActionListener(this);
        JButton jButton4 = new JButton("Save Table", Util.createImageIcon("Save16.gif"));
        jButton4.setActionCommand("save");
        jButton4.addActionListener(this);
        if (!sTEM_DataSet.tga.bcluster) {
            Serializable serializable;
            JPanel jPanel2 = new JPanel();
            if (!sTEM_DataSet.bkmeans) {
                jPanel2.setBackground(Color.white);
                this.actualButton = new JRadioButton("actual size");
                this.actualButton.setBackground(Color.white);
                this.actualButton.setSelected(true);
                this.actualButton.setActionCommand("actualgo");
                this.actualButton.addActionListener(this);
                this.expectedButton = new JRadioButton("expected size");
                this.expectedButton.setBackground(Color.white);
                this.expectedButton.setActionCommand("expectedgo");
                this.expectedButton.addActionListener(this);
                serializable = new ButtonGroup();
                ((ButtonGroup)serializable).add(this.actualButton);
                ((ButtonGroup)serializable).add(this.expectedButton);
                jPanel2.add(new JLabel("Order using enrichment p-values based on a profile's"));
                jPanel2.add(this.actualButton);
                jPanel2.add(this.expectedButton);
                jPanel2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 200));
                this.add(jPanel2);
            }
            serializable = new JPanel();
            ((JComponent)serializable).setBackground(Color.white);
            jButton = sTEM_DataSet.bkmeans ? new JButton("Cluster ID") : new JButton("Profile ID");
            jButton.setActionCommand("id");
            jButton.addActionListener(this);
            ((Container)serializable).add(jButton);
            if (!sTEM_DataSet.bkmeans) {
                JButton jButton5 = new JButton("Significance");
                jButton5.setActionCommand("sig");
                jButton5.addActionListener(this);
                ((Container)serializable).add(jButton5);
            }
            JButton jButton6 = new JButton("Number of Genes");
            jButton6.setActionCommand("num");
            jButton6.addActionListener(this);
            ((Container)serializable).add(jButton6);
            if (!sTEM_DataSet.bkmeans) {
                JButton jButton7 = new JButton("Expected Number");
                jButton7.setActionCommand("exp");
                jButton7.addActionListener(this);
                ((Container)serializable).add(jButton7);
            }
            ((JComponent)serializable).setMaximumSize(new Dimension(Integer.MAX_VALUE, 200));
            this.add((Component)serializable);
            this.table.setPreferredScrollableViewportSize(new Dimension(450, Math.min((this.table.getRowHeight() + this.table.getRowMargin()) * this.table.getRowCount(), 250)));
        } else {
            this.table.setPreferredScrollableViewportSize(new Dimension(450, 300));
        }
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jPanel.add(jButton4);
        jButton = new JButton(Util.createImageIcon("Help16.gif"));
        jButton.addActionListener(this);
        jButton.setActionCommand("help");
        jPanel.add(jButton);
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel);
    }

    public void closeDefineWindows() {
        if (this.defineframe != null) {
            this.defineframe.setVisible(false);
            this.defineframe.dispose();
            this.defineframe = null;
        }
    }

    public void printFile(PrintWriter printWriter) {
        int n;
        if (this.tga.bcluster) {
            printWriter.println("Minimum p-value of GO enrichment in any cluster");
        } else {
            printWriter.println("Minimum p-value of GO enrichment in any profile");
        }
        printWriter.println("-------");
        for (n = 0; n < this.columnNames.length; ++n) {
            String string = this.columnNames[n];
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\n') {
                    printWriter.print(" ");
                    continue;
                }
                printWriter.print(c);
            }
            if (n >= this.columnNames.length - 1) continue;
            printWriter.print("\t");
        }
        printWriter.println();
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                printWriter.print(this.tabledata[n][i] + "\t");
            }
            printWriter.println(this.tabledata[n][this.tabledata[n].length - 1]);
        }
    }

    public void writeToClipboard() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.columnNames.length; ++n) {
            String string = this.columnNames[n];
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\n') {
                    stringBuffer.append(" ");
                    continue;
                }
                stringBuffer.append(c);
            }
            if (n >= this.columnNames.length - 1) continue;
            stringBuffer.append("\t");
        }
        stringBuffer.append("\n");
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                stringBuffer.append(this.tabledata[n][i] + "\t");
            }
            stringBuffer.append(this.tabledata[n][this.tabledata[n].length - 1] + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        int n;
        String string = actionEvent.getActionCommand();
        if (string.equals("actualgo") || string.equals("expectedgo")) {
            this.theDataSet.tga.bcluster = false;
            this.theDataSet.tga.bactual = this.actualButton.isSelected();
            if (this.theDataSet.tga.szsortcommand.equals("define") && string.equals("expectedgo")) {
                this.theDataSet.tga.szsortcommand = "expdefine";
                this.maingui.drawmain();
            } else if (this.theDataSet.tga.szsortcommand.equals("expdefine") && string.equals("actualgo")) {
                this.theDataSet.tga.szsortcommand = "define";
                this.maingui.drawmain();
            } else if ((this.theDataSet.tga.szsortcommand.equals("expgo") && string.equals("actualgo") || this.theDataSet.tga.szsortcommand.equals("go") && string.equals("expectedgo")) && (n = this.rowSM.getMinSelectionIndex()) >= 0) {
                this.theDataSet.tga.szSelectedGO = object = (String)this.sorter.getValueAt(n, 0);
                this.theDataSet.tga.bcluster = false;
                this.theDataSet.tga.szsortcommand = string.equals("actualgo") ? "go" : "expgo";
                this.maingui.drawmain();
            }
        }
        if (string.equals("default")) {
            this.rowSM.clearSelection();
            this.theDataSet.tga.szSelectedGO = null;
            this.theDataSet.tga.szsortcommand = "default";
            this.maingui.drawmain();
        } else if (string.equals("sig")) {
            this.rowSM.clearSelection();
            this.theDataSet.tga.szSelectedGO = null;
            this.theDataSet.tga.szsortcommand = "sig";
            this.maingui.drawmain();
        } else if (string.equals("num")) {
            this.rowSM.clearSelection();
            this.theDataSet.tga.szSelectedGO = null;
            this.theDataSet.tga.szsortcommand = "num";
            this.maingui.drawmain();
        } else if (string.equals("exp")) {
            this.rowSM.clearSelection();
            this.theDataSet.tga.szSelectedGO = null;
            this.theDataSet.tga.szsortcommand = "exp";
            this.maingui.drawmain();
        } else if (string.equals("id")) {
            this.rowSM.clearSelection();
            this.theDataSet.tga.szSelectedGO = null;
            this.theDataSet.tga.szsortcommand = "id";
            this.maingui.drawmain();
        } else if (string.equals("define")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (SortTable.this.defineframe == null) {
                        SortTable.this.defineframe = new JFrame("Define Gene Set");
                        SortTable.this.defineframe.setDefaultCloseOperation(2);
                        SortTable.this.defineframe.setLocation(400, 200);
                        DefineGeneSet defineGeneSet = new DefineGeneSet(SortTable.this.defineframe, SortTable.this.maingui, SortTable.this.tga, SortTable.this.rowSM, SortTable.this.theDataSet.bkmeans);
                        defineGeneSet.setOpaque(true);
                        SortTable.this.defineframe.setContentPane(defineGeneSet);
                        SortTable.this.defineframe.pack();
                    } else {
                        SortTable.this.defineframe.setExtendedState(0);
                    }
                    SortTable.this.defineframe.setVisible(true);
                }
            });
        } else if (string.equals("copy")) {
            this.writeToClipboard();
        } else if (string.equals("save")) {
            try {
                n = Util.theChooser.showSaveDialog(this);
                if (n == 0) {
                    object = Util.theChooser.getSelectedFile();
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream((File)object));
                    this.printFile(printWriter);
                    printWriter.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                object = fileNotFoundException;
                SwingUtilities.invokeLater(new Runnable((FileNotFoundException)object){
                    final /* synthetic */ FileNotFoundException val$fex;
                    {
                        this.val$fex = fileNotFoundException;
                    }

                    public void run() {
                        JOptionPane.showMessageDialog(null, this.val$fex.getMessage(), "Exception thrown", 0);
                    }
                });
                fileNotFoundException.printStackTrace(System.out);
            }
        } else if (string.equals("help")) {
            if (this.theDataSet.bkmeans) {
                String string2 = "K-means clusters boxes are ordered on the screen from top to bottom and left to right.  By default profiles clusters are ordered by ID.\n\nCluster boxes can be reordered from top to bottom and left to right by one of several criteria: \n*  GO Category Gene Enrichment -- the K-means clusters can be reordered by gene enrichment of genes annotated as belonging to any GO Category.  The GO category can be selected by clicking on its row in the list.  The p-value GO category enrichment for K-means clusters are computed based on the cluster's actual size. \n*  User Defined Gene Set Enrichment -- this is similar to GO Category enrichment except that the set of genes can be arbitrarily defined.\n*  Cluster ID -- reorders K-means clusters by their ID number, that is the number in the top left hand corner of the cluster  box.\n*  Number of Genes -- reorders profiles based on the number of genes assigned to the profile; also displays this value in the bottom left hand corner of the cluster box.\n\nNote: The table can be sorted by any of the columns by clicking on the column's header.  Using the 'Copy Table' the entire table can be copied to the clipboard.\nUsing the 'Save Table' button the table can be saved to a file.";
                Util.renderDialog(this.theFrame, string2, -90, -15);
            } else if (this.theDataSet.tga.bcluster) {
                String string3 = "Clusters, similar significant profiles that are colored the same, are ordered on the screen from top to bottom and left to right.  By default clusters are ordered by number of genes assigned.  Non-significant profiles, which are not clustered come last.  Clusters are ordered by size.  Within each cluster, and among the non-significant profiles, the profiles are ordered in increasing order of the p-value of the number of genes assigned to the profile as compared to the number expected based on a permutation test.\n\nClusters can be reordered from top to bottom and left to right by one of several criteria: \n*  GO Category Gene Enrichment -- the clusters can be reordered by gene enrichment of genes annotated as belonging to any GO Category.  The GO category can be selected by clicking on its row in the list.  The p-value GO category enrichment for profiles can be computed based on only the cluster's actual size, unlike profiles which are defined independent of the data clusters do not have an expected size.  The table contains for each GO Category the minimum p-value enrichment for any profile.\n*  User Defined Gene Set Enrichment -- this is similar to GO Category enrichment except that the set of genes can be arbitrarily defined.\n*  Default Order --  reorders the profiles to their original order.\n\nNote: The table can be sorted by any of the columns by clicking on the column's header.  Using the 'Copy Table' the entire table can be copied to the clipboard.\nUsing the 'Save Table' button the table can be saved to a file.";
                Util.renderDialog(this.theFrame, string3, -90, -15);
            } else {
                String string4 = "Profiles are ordered on the screen from top to bottom and left to right.  By default profiles of the same cluster are placed next to each other, with the non-significant profiles coming last.  Within each cluster, and among the non-significant profiles, the profiles are ordered in increasing order of the p-value of the number of genes assigned to the profile as compared to the number expected based on a permutation test.\n\nProfiles can be reordered from top to bottom and left to right by one of several criteria: \n*  GO Category Gene Enrichment -- the profiles can be reordered by gene enrichment of genes annotated as belonging to any GO Category.  The GO category can be selected by clicking on its row in the list.  The p-value GO category enrichment for profiles can be computed based on either a profile's actual or expected size.  For instance consider a profile with many more genes assigned than expected, but given the number of genes assigned to profile the number of genes that belong to the profile and the GO Category is what is expected.  In this case the profile will be enriched by computing p-values based on the profile's expected size, but not based on its actual size.  The table contains for each GO Category and both methods of computing p-values the minimum p-value enrichment for any profile.\n*  User Defined Gene Set Enrichment -- this is similar to GO Category enrichment except that the set of genes can be arbitrarily defined.\n*  Profile ID -- reorders profiles by their ID number, that is the number in the top left hand corner of the profile  box.\n*  Significance -- reorders profiles by the p-value significance of the number of genes assigned to the profile compared to what was expected; also displays this p-value in the bottom  left-hand corner of each profile box.\n*  Number of Genes -- reorders profiles based on the number of genes assigned to the profile; also displays this value in the bottom left hand corner of the profile box.\n*  Expected Number -- reorders profiles based on the expected number of genes assigned to this profile based on a permutation test; also displays this value in the bottom left hand corner of the profile box.\n*  Default Order --  reorders the profiles to their original order.\n\nNote: +The table can be sorted by any of the columns by clicking on the column's header.\n+Using the 'Copy Table' the entire table can be copied to the clipboard.\n+Using the 'Save Table' button the table can be saved to a file.";
                Util.renderDialog(this.theFrame, string4, -200, -100);
            }
        }
    }
}

