/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.stem;

import edu.cmu.cs.sb.chromviewer.ChromFrame;
import edu.cmu.cs.sb.core.GoAnnotations;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.stem.GOGeneTable;
import edu.cmu.cs.sb.stem.GOTable;
import edu.cmu.cs.sb.stem.GenePlotPanel;
import edu.cmu.cs.sb.stem.GeneTable;
import edu.cmu.cs.sb.stem.MAINGUI2;
import edu.cmu.cs.sb.stem.ST;
import edu.cmu.cs.sb.stem.STEM_DataSet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ProfileGui
extends JFrame
implements MouseListener,
ComponentListener {
    Object sizeLock = new Object();
    int nnewheight = -1;
    int nnewwidth = -1;
    ChromFrame cf;
    String szprofilecluster;
    String szprofileclusterCAP;
    Dimension totalSize;
    Graphics2D g2;
    STEM_DataSet theDataSet;
    int nprofile;
    int ncluster;
    String szAssignInfo;
    String szGene;
    String szSpot;
    GoAnnotations.ProfileGORankingRec pgrr;
    boolean bshowcluster;
    HashSet inames;
    int ncompareprofile;
    String szIntersect;
    boolean bonlyorder;
    int noffset;
    boolean bcheckonly;
    boolean bgosorttable;
    int[] ranklookup;
    int nmidpoint;
    GoAnnotations.Rec gar;
    boolean bautomatic;
    double dminfixed;
    double dmaxfixed;
    double dtickinterval;
    GenePlotPanel thegeneplotpanel;
    int SCREENWIDTH = MAINGUI2.SCREENWIDTH;
    int SCREENHEIGHT = MAINGUI2.SCREENHEIGHT;
    static int SPACETOP = 70;
    static int SPACEBOT2 = 20;
    static int SPACEBOT = 50;
    static int SPACELEFT = 40;
    static int SPACERIGHT = 40;
    int ncolwidth;
    int nrowheight;
    int numcols;
    int numrows;
    int profiletablex;
    int clustertablex;
    int querytabley;
    int tabley;
    int tablewid;
    int tableheight;
    int nonlyx;
    int nonlyy;
    int ngosorttabley;
    int nonlytablewid;
    int ngosorttablewid;
    int ngosorttablex;
    int profilegox;
    int clustergox;
    ArrayList colorlist = new ArrayList();
    static final int maxCharHeight = 15;
    static final int minFontSize = 6;
    static final int BSPACING = 15;
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    static final Color red = Color.red;
    static final Color white = Color.white;
    static final BasicStroke stroke = new BasicStroke(2.0f);
    static final BasicStroke wideStroke = new BasicStroke(8.0f);
    static final float[] dash1 = new float[]{10.0f};
    static final BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);

    public ProfileGui(STEM_DataSet sTEM_DataSet, int n, int[] nArray, HashSet hashSet, int n2, String string, String string2, String string3, GenePlotPanel genePlotPanel, ChromFrame chromFrame) {
        super((sTEM_DataSet.bkmeans ? "Cluster" : "Profile") + " " + n);
        this.thegeneplotpanel = genePlotPanel;
        if (sTEM_DataSet.bkmeans) {
            this.szprofilecluster = "cluster";
            this.szprofileclusterCAP = "Cluster";
        } else {
            this.szprofilecluster = "profile";
            this.szprofileclusterCAP = "Profile";
        }
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.theDataSet = sTEM_DataSet;
        this.nprofile = n;
        this.inames = hashSet;
        this.ncompareprofile = n2;
        this.szIntersect = string;
        this.bonlyorder = false;
        this.ranklookup = nArray;
        this.szGene = string2;
        this.szSpot = string3;
        this.cf = chromFrame;
        this.ncluster = -1;
        boolean bl = false;
        for (int i = 0; i < sTEM_DataSet.clustersofprofilesnum.size() && !bl; ++i) {
            ArrayList arrayList = (ArrayList)sTEM_DataSet.clustersofprofilesnum.get(i);
            for (int j = 0; j < arrayList.size() && !bl; ++j) {
                STEM_DataSet.ProfileRec profileRec = (STEM_DataSet.ProfileRec)arrayList.get(j);
                if (profileRec.nprofileindex != n) continue;
                this.ncluster = i;
                bl = true;
            }
        }
        this.bshowcluster = this.ncluster >= 0 && ((ArrayList)sTEM_DataSet.clustersofprofilesnum.get(this.ncluster)).size() > 1;
        this.init();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void componentResized(ComponentEvent componentEvent) {
        Object object = this.sizeLock;
        synchronized (object) {
            int n = this.getHeight();
            int n2 = this.getWidth();
            if (!(n == this.SCREENHEIGHT && n2 == this.SCREENWIDTH || n == this.nnewheight && n2 == this.nnewwidth)) {
                this.nnewheight = n;
                this.nnewwidth = n2;
                this.repaint();
            }
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public String enrichedToSz(double d) {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(1);
        numberFormat.setMaximumFractionDigits(1);
        numberFormat.setGroupingUsed(false);
        String string = numberFormat.format(d);
        double d2 = Double.parseDouble(string);
        if (d2 > 0.0) {
            string = "+" + string;
        } else if (d2 == 0.0) {
            string = "0.0";
        }
        return string;
    }

    public void init() {
        this.setBackground(bg);
        this.setForeground(fg);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    void drawprofiletable(Color color) {
        this.g2.setColor(color);
        this.g2.fill(new Rectangle2D.Double(this.profiletablex, this.tabley, this.tablewid, this.tableheight));
        this.g2.setColor(Color.black);
        this.g2.draw(new Rectangle2D.Double(this.profiletablex, this.tabley, this.tablewid, this.tableheight));
        if (this.theDataSet.bkmeans) {
            this.g2.drawString("Cluster Gene Table", this.profiletablex + 24, this.tabley + 15);
        } else {
            this.g2.drawString("Profile Gene Table", this.profiletablex + 27, this.tabley + 15);
        }
    }

    void drawclustertable(Color color) {
        this.g2.setColor(color);
        this.g2.fill(new Rectangle2D.Double(this.clustertablex, this.tabley, this.tablewid, this.tableheight));
        this.g2.setColor(Color.black);
        this.g2.draw(new Rectangle2D.Double(this.clustertablex, this.tabley, this.tablewid, this.tableheight));
        this.g2.drawString("Cluster Gene Table", this.clustertablex + 24, this.tabley + 15);
    }

    void drawprofilego(Color color) {
        this.g2.setColor(color);
        this.g2.fill(new Rectangle2D.Double(this.profilegox, this.tabley, this.tablewid, this.tableheight));
        this.g2.setColor(Color.black);
        if (this.theDataSet.bkmeans) {
            this.g2.drawString("Cluster GO Table", this.profilegox + 30, this.tabley + 15);
        } else {
            this.g2.drawString("Profile GO Table", this.profilegox + 33, this.tabley + 15);
        }
        this.g2.draw(new Rectangle2D.Double(this.profilegox, this.tabley, this.tablewid, this.tableheight));
    }

    void drawonlyorder() {
        int n;
        this.g2.setColor(ST.buttonColor);
        FontMetrics fontMetrics = this.g2.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds("Click to plot all " + this.szprofilecluster + " genes", this.g2);
        int n2 = (int)Math.ceil(rectangle2D.getMaxX());
        String string = "Click to plot ";
        if (this.bonlyorder) {
            string = string + "all " + this.szprofilecluster + " genes";
        } else if (this.inames != null) {
            string = string + "only genes in intersection";
        } else if (this.szSpot != null) {
            string = string + "only gene " + this.szGene;
        } else if (this.pgrr != null && (this.theDataSet.tga.szsortcommand.equals("expgo") || this.theDataSet.tga.szsortcommand.equals("go"))) {
            this.gar = (GoAnnotations.Rec)this.theDataSet.tga.htGO.get(this.theDataSet.tga.szSelectedGO);
            string = string + "only " + this.szprofilecluster + " " + this.gar.sztermName + " genes";
        } else {
            string = string + "only " + this.szprofilecluster + " query set genes";
        }
        int n3 = 15;
        if (!this.bonlyorder) {
            fontMetrics = this.g2.getFontMetrics();
            rectangle2D = fontMetrics.getStringBounds(string, this.g2);
            this.nonlytablewid = Math.max((int)Math.ceil(rectangle2D.getMaxX()), n2) + n3;
            this.nonlyx = this.nmidpoint - this.nonlytablewid / 2;
            n = (int)Math.ceil((double)n3 / 2.0);
        } else {
            n = (int)Math.ceil((double)(this.nonlytablewid - n2) / 2.0);
        }
        this.g2.fill(new Rectangle2D.Double(this.nonlyx, this.nonlyy, this.nonlytablewid, this.tableheight));
        this.g2.fill(new Rectangle2D.Double(this.nonlyx, this.nonlyy, this.nonlytablewid, this.tableheight));
        this.g2.setColor(Color.black);
        this.g2.drawString(string, this.nonlyx + n, this.nonlyy + n3);
        this.g2.draw(new Rectangle2D.Double(this.nonlyx, this.nonlyy, this.nonlytablewid, this.tableheight));
    }

    void drawgosorttable() {
        this.g2.setColor(ST.buttonColor);
        GoAnnotations.Rec rec = (GoAnnotations.Rec)this.theDataSet.tga.htGO.get(this.theDataSet.tga.szSelectedGO);
        String string = this.szprofileclusterCAP + " " + rec.sztermName + " Gene Table";
        FontMetrics fontMetrics = this.g2.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, this.g2);
        this.ngosorttablewid = (int)Math.ceil(rectangle2D.getMaxX()) + 15;
        this.ngosorttablex = this.nmidpoint - this.ngosorttablewid / 2;
        this.g2.fill(new Rectangle2D.Double(this.ngosorttablex, this.ngosorttabley, this.ngosorttablewid, this.tableheight));
        this.g2.fill(new Rectangle2D.Double(this.ngosorttablex, this.ngosorttabley, this.ngosorttablewid, this.tableheight));
        this.g2.setColor(Color.black);
        this.g2.drawString(string, this.ngosorttablex + 8, this.ngosorttabley + 15);
        this.g2.draw(new Rectangle2D.Double(this.ngosorttablex, this.ngosorttabley, this.ngosorttablewid, this.tableheight));
    }

    void drawclustergo(Color color) {
        this.g2.setColor(color);
        this.g2.fill(new Rectangle2D.Double(this.clustergox, this.tabley, this.tablewid, this.tableheight));
        this.g2.setColor(Color.black);
        this.g2.draw(new Rectangle2D.Double(this.clustergox, this.tabley, this.tablewid, this.tableheight));
        this.g2.drawString("Cluster GO Table", this.clustergox + 30, this.tabley + 15);
    }

    void drawprofilequerytable(Color color) {
        this.g2.setColor(color);
        this.g2.fill(new Rectangle2D.Double(this.profiletablex, this.querytabley, this.tablewid, this.tableheight));
        this.g2.setColor(Color.black);
        this.g2.draw(new Rectangle2D.Double(this.profiletablex, this.querytabley, this.tablewid, this.tableheight));
        if (this.theDataSet.bkmeans) {
            this.g2.drawString("Cluster Query Gene Table", this.profiletablex + 7, this.querytabley + 15);
        } else {
            this.g2.drawString("Profile Query Gene Table", this.profiletablex + 9, this.querytabley + 15);
        }
    }

    void drawclusterquerytable(Color color) {
        this.g2.setColor(color);
        this.g2.fill(new Rectangle2D.Double(this.clustertablex, this.querytabley, this.tablewid, this.tableheight));
        this.g2.setColor(Color.black);
        this.g2.draw(new Rectangle2D.Double(this.clustertablex, this.querytabley, this.tablewid, this.tableheight));
        this.g2.drawString("Cluster Query Gene Table", this.clustertablex + 7, this.querytabley + 15);
    }

    void drawprofilequerygo(Color color) {
        this.g2.setColor(color);
        this.g2.fill(new Rectangle2D.Double(this.profilegox, this.querytabley, this.tablewid, this.tableheight));
        this.g2.setColor(Color.black);
        if (this.theDataSet.bkmeans) {
            this.g2.drawString("Cluster Query GO Table", this.profilegox + 12, this.querytabley + 15);
        } else {
            this.g2.drawString("Profile Query GO Table", this.profilegox + 15, this.querytabley + 15);
        }
        this.g2.draw(new Rectangle2D.Double(this.profilegox, this.querytabley, this.tablewid, this.tableheight));
    }

    void drawclusterquerygo(Color color) {
        this.g2.setColor(color);
        this.g2.fill(new Rectangle2D.Double(this.clustergox, this.querytabley, this.tablewid, this.tableheight));
        this.g2.setColor(Color.black);
        this.g2.draw(new Rectangle2D.Double(this.clustergox, this.querytabley, this.tablewid, this.tableheight));
        this.g2.drawString("Cluster Query GO Table", this.clustergox + 12, this.querytabley + 15);
    }

    void drawintersecttable(Color color) {
        this.g2.setColor(color);
        this.g2.fill(new Rectangle2D.Double(this.profiletablex, this.querytabley, this.tablewid, this.tableheight));
        this.g2.setColor(Color.black);
        this.g2.draw(new Rectangle2D.Double(this.profiletablex, this.querytabley, this.tablewid, this.tableheight));
        if (this.theDataSet.bkmeans) {
            this.g2.drawString("Cluster Intersect Gene Table", this.profiletablex, this.querytabley + 15);
        } else {
            this.g2.drawString("Profile Intersect Gene Table", this.profiletablex + 2, this.querytabley + 15);
        }
    }

    public void drawintersectgo(Color color) {
        this.g2.setColor(color);
        this.g2.fill(new Rectangle2D.Double(this.profilegox, this.querytabley, this.tablewid, this.tableheight));
        this.g2.setColor(Color.black);
        this.g2.draw(new Rectangle2D.Double(this.profilegox, this.querytabley, this.tablewid, this.tableheight));
        this.g2.drawString(this.szprofileclusterCAP + " Intersect GO Table", this.profilegox + 8, this.querytabley + 15);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            int n = mouseEvent.getY();
            int n2 = mouseEvent.getX();
            if (this.bgosorttable && this.ngosorttabley <= n && n <= this.ngosorttabley + this.tableheight && this.ngosorttablex <= n2 && n2 <= this.ngosorttablex + this.ngosorttablewid) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ProfileGui.this.gar = (GoAnnotations.Rec)ProfileGui.this.theDataSet.tga.htGO.get(ProfileGui.this.theDataSet.tga.szSelectedGO);
                        String string = ProfileGui.this.theDataSet.tga.szSelectedGO + " (" + ProfileGui.this.gar.sztermName + ")";
                        String string2 = "Gene List for " + string + " genes in " + ProfileGui.this.szprofileclusterCAP + " " + ProfileGui.this.nprofile;
                        JFrame jFrame = new JFrame(string2);
                        jFrame.setDefaultCloseOperation(2);
                        String string3 = "";
                        GOGeneTable gOGeneTable = new GOGeneTable(jFrame, ProfileGui.this.theDataSet, ProfileGui.this.theDataSet.tga.szSelectedGO, string, ProfileGui.this.nprofile, string3, null, false, null, string2, false, ProfileGui.this.cf);
                        gOGeneTable.setOpaque(true);
                        jFrame.setContentPane(gOGeneTable);
                        jFrame.setLocation(40, 150);
                        jFrame.pack();
                        jFrame.setVisible(true);
                    }
                });
            } else if (this.bcheckonly && this.nonlyy <= n && n <= this.nonlyy + this.tableheight && this.nonlyx <= n2 && n2 <= this.nonlyx + this.nonlytablewid) {
                this.bonlyorder = !this.bonlyorder;
                this.repaint();
            } else if (this.tabley <= n && n <= this.tabley + this.tableheight) {
                if (this.profiletablex <= n2 && n2 <= this.profiletablex + this.tablewid) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ProfileGui.this.drawprofiletable(Color.gray);
                            String string = "Gene Table for " + ProfileGui.this.szprofileclusterCAP + " " + ProfileGui.this.nprofile;
                            JFrame jFrame = new JFrame(string);
                            jFrame.setDefaultCloseOperation(2);
                            jFrame.setLocation(25, 100);
                            GeneTable geneTable = new GeneTable(jFrame, ProfileGui.this.theDataSet, ProfileGui.this.nprofile, ProfileGui.this.szAssignInfo, false, null, string, ProfileGui.this.cf);
                            geneTable.setOpaque(true);
                            jFrame.setContentPane(geneTable);
                            ProfileGui.this.drawprofiletable(ST.buttonColor);
                            jFrame.pack();
                            jFrame.setVisible(true);
                        }
                    });
                } else if (this.profilegox <= n2 && n2 <= this.profilegox + this.tablewid) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ProfileGui.this.drawprofilego(Color.gray);
                            String string = "GO Results for " + ProfileGui.this.szprofileclusterCAP + " " + ProfileGui.this.nprofile + " based on the actual number of genes assigned to the " + ProfileGui.this.szprofilecluster;
                            JFrame jFrame = new JFrame(string);
                            jFrame.setDefaultCloseOperation(2);
                            jFrame.setLocation(25, 100);
                            GOTable gOTable = new GOTable(jFrame, ProfileGui.this.theDataSet, ProfileGui.this.nprofile, null, false, null, string, false, ProfileGui.this.cf);
                            ProfileGui.this.drawprofilego(ST.buttonColor);
                            gOTable.setOpaque(true);
                            jFrame.setContentPane(gOTable);
                            jFrame.pack();
                            jFrame.setVisible(true);
                        }
                    });
                } else if (this.bshowcluster && this.clustergox <= n2 && n2 <= this.clustergox + this.tablewid) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ProfileGui.this.drawclustergo(Color.gray);
                            ArrayList arrayList = (ArrayList)ProfileGui.this.theDataSet.clustersofprofilesnum.get(ProfileGui.this.ncluster);
                            String string = ProfileGui.clusterArrayToString(arrayList);
                            String string2 = "GO Results for Cluster " + ProfileGui.this.ncluster + " " + string + " based on the actual number of genes assigned to the cluster";
                            JFrame jFrame = new JFrame(string2);
                            jFrame.setDefaultCloseOperation(2);
                            jFrame.setLocation(25, 100);
                            GOTable gOTable = new GOTable(jFrame, ProfileGui.this.theDataSet, ProfileGui.this.ncluster, arrayList, false, null, string2, false, ProfileGui.this.cf);
                            gOTable.setOpaque(true);
                            jFrame.setContentPane(gOTable);
                            ProfileGui.this.drawclustergo(ST.buttonColor);
                            jFrame.pack();
                            jFrame.setVisible(true);
                        }
                    });
                } else if (this.bshowcluster && this.clustertablex <= n2 && n2 <= this.clustertablex + this.tablewid) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ProfileGui.this.drawclustertable(Color.gray);
                            ArrayList arrayList = (ArrayList)ProfileGui.this.theDataSet.clustersofprofilesnum.get(ProfileGui.this.ncluster);
                            String string = ProfileGui.clusterArrayToString(arrayList);
                            String string2 = "Gene Table for Cluster " + ProfileGui.this.ncluster + " " + string;
                            JFrame jFrame = new JFrame(string2);
                            jFrame.setDefaultCloseOperation(2);
                            jFrame.setLocation(25, 100);
                            ProfileGui.this.szAssignInfo = "" + ProfileGui.this.ncluster;
                            GeneTable geneTable = new GeneTable(jFrame, ProfileGui.this.theDataSet, arrayList, ProfileGui.this.szAssignInfo, false, null, string2, ProfileGui.this.cf);
                            geneTable.setOpaque(true);
                            jFrame.setContentPane(geneTable);
                            ProfileGui.this.drawclustertable(ST.buttonColor);
                            jFrame.pack();
                            jFrame.setVisible(true);
                        }
                    });
                }
            } else if (this.querytabley <= n && n <= this.querytabley + this.tableheight && (this.inames != null || this.pgrr != null && (this.theDataSet.tga.szsortcommand.equals("define") || this.theDataSet.tga.szsortcommand.equals("expdefine")))) {
                if (this.profiletablex <= n2 && n2 <= this.profiletablex + this.tablewid) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JFrame jFrame;
                            if (ProfileGui.this.inames != null) {
                                ProfileGui.this.drawintersecttable(Color.gray);
                                String string = "Gene Table for Intersection of (row) " + ProfileGui.this.szprofileclusterCAP + " " + ProfileGui.this.ncompareprofile + " with (column) " + ProfileGui.this.szprofileclusterCAP + " " + ProfileGui.this.nprofile;
                                jFrame = new JFrame(string);
                                jFrame.setDefaultCloseOperation(2);
                                jFrame.setLocation(25, 100);
                                GeneTable geneTable = new GeneTable(jFrame, ProfileGui.this.theDataSet, ProfileGui.this.nprofile, ProfileGui.this.szAssignInfo, false, ProfileGui.this.inames, string, ProfileGui.this.cf);
                                geneTable.setOpaque(true);
                                jFrame.setContentPane(geneTable);
                                ProfileGui.this.drawintersecttable(ST.buttonColor);
                            } else {
                                ProfileGui.this.drawprofilequerytable(Color.gray);
                                String string = "Gene Table for Query Genes with " + ProfileGui.this.szprofileclusterCAP + " " + ProfileGui.this.nprofile;
                                jFrame = new JFrame(string);
                                jFrame.setDefaultCloseOperation(2);
                                jFrame.setLocation(25, 100);
                                GeneTable geneTable = new GeneTable(jFrame, ProfileGui.this.theDataSet, ProfileGui.this.nprofile, ProfileGui.this.szAssignInfo, true, null, string, ProfileGui.this.cf);
                                geneTable.setOpaque(true);
                                jFrame.setContentPane(geneTable);
                                ProfileGui.this.drawprofilequerytable(ST.buttonColor);
                            }
                            jFrame.pack();
                            jFrame.setVisible(true);
                        }
                    });
                } else if (this.profilegox <= n2 && n2 <= this.profilegox + this.tablewid) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            GOTable gOTable;
                            JFrame jFrame;
                            if (ProfileGui.this.inames != null) {
                                ProfileGui.this.drawintersectgo(Color.gray);
                                String string = "GO Results for Intersection of (row) " + ProfileGui.this.szprofileclusterCAP + " " + ProfileGui.this.ncompareprofile + " with (column) " + ProfileGui.this.szprofileclusterCAP + " " + ProfileGui.this.nprofile + " based on the actual number of genes in the intersection";
                                jFrame = new JFrame(string);
                                jFrame.setDefaultCloseOperation(2);
                                jFrame.setLocation(25, 100);
                                gOTable = new GOTable(jFrame, ProfileGui.this.theDataSet, ProfileGui.this.nprofile, null, false, ProfileGui.this.inames, string, false, ProfileGui.this.cf);
                                ProfileGui.this.drawintersectgo(ST.buttonColor);
                            } else {
                                ProfileGui.this.drawprofilequerygo(Color.gray);
                                String string = "GO Results for Query Genes with " + ProfileGui.this.szprofileclusterCAP + " " + ProfileGui.this.nprofile + " based on the actual number of genes in the set";
                                jFrame = new JFrame(string);
                                jFrame.setDefaultCloseOperation(2);
                                jFrame.setLocation(25, 100);
                                gOTable = new GOTable(jFrame, ProfileGui.this.theDataSet, ProfileGui.this.nprofile, null, true, null, string, false, ProfileGui.this.cf);
                                ProfileGui.this.drawprofilequerygo(ST.buttonColor);
                            }
                            gOTable.setOpaque(true);
                            jFrame.setContentPane(gOTable);
                            jFrame.pack();
                            jFrame.setVisible(true);
                        }
                    });
                } else if (this.bshowcluster && this.clustergox <= n2 && n2 <= this.clustergox + this.tablewid) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ProfileGui.this.drawclusterquerygo(Color.gray);
                            ArrayList arrayList = (ArrayList)ProfileGui.this.theDataSet.clustersofprofilesnum.get(ProfileGui.this.ncluster);
                            String string = ProfileGui.clusterArrayToString(arrayList);
                            String string2 = "GO Results for Query Genes in Cluster " + ProfileGui.this.ncluster + " " + string + " based on the actual number of genes in the cluster";
                            JFrame jFrame = new JFrame(string2);
                            jFrame.setDefaultCloseOperation(2);
                            jFrame.setLocation(25, 100);
                            GOTable gOTable = new GOTable(jFrame, ProfileGui.this.theDataSet, ProfileGui.this.ncluster, arrayList, true, null, string2, false, ProfileGui.this.cf);
                            gOTable.setOpaque(true);
                            jFrame.setContentPane(gOTable);
                            ProfileGui.this.drawclusterquerygo(ST.buttonColor);
                            jFrame.pack();
                            jFrame.setVisible(true);
                        }
                    });
                } else if (this.bshowcluster && this.clustertablex <= n2 && n2 <= this.clustertablex + this.tablewid) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ProfileGui.this.drawclusterquerytable(Color.gray);
                            ArrayList arrayList = (ArrayList)ProfileGui.this.theDataSet.clustersofprofilesnum.get(ProfileGui.this.ncluster);
                            String string = ProfileGui.clusterArrayToString(arrayList);
                            String string2 = "Gene Table for Query Genes in Cluster " + ProfileGui.this.ncluster + " " + string + " based on the actual number of genes in the cluster";
                            JFrame jFrame = new JFrame(string2);
                            jFrame.setDefaultCloseOperation(2);
                            jFrame.setLocation(25, 100);
                            ProfileGui.this.szAssignInfo = "" + ProfileGui.this.ncluster;
                            GeneTable geneTable = new GeneTable(jFrame, ProfileGui.this.theDataSet, arrayList, ProfileGui.this.szAssignInfo, true, null, string2, ProfileGui.this.cf);
                            geneTable.setOpaque(true);
                            jFrame.setContentPane(geneTable);
                            ProfileGui.this.drawclusterquerytable(ST.buttonColor);
                            jFrame.pack();
                            jFrame.setVisible(true);
                        }
                    });
                }
            }
        }
    }

    public static synchronized String clusterArrayToString(ArrayList arrayList) {
        String string;
        if (arrayList.size() == 1) {
            STEM_DataSet.ProfileRec profileRec = (STEM_DataSet.ProfileRec)arrayList.get(0);
            string = "(Profile " + profileRec.nprofileindex + ")";
        } else if (arrayList.size() == 2) {
            string = "(Profiles ";
            STEM_DataSet.ProfileRec profileRec = (STEM_DataSet.ProfileRec)arrayList.get(0);
            STEM_DataSet.ProfileRec profileRec2 = (STEM_DataSet.ProfileRec)arrayList.get(1);
            string = profileRec.nprofileindex < profileRec2.nprofileindex ? string + profileRec.nprofileindex + " and " + profileRec2.nprofileindex + ")" : string + profileRec2.nprofileindex + " and " + profileRec.nprofileindex + ")";
        } else {
            int n;
            int[] nArray = new int[arrayList.size()];
            StringBuffer stringBuffer = new StringBuffer("(Profiles ");
            for (n = 0; n < arrayList.size(); ++n) {
                STEM_DataSet.ProfileRec profileRec = (STEM_DataSet.ProfileRec)arrayList.get(n);
                nArray[n] = profileRec.nprofileindex;
            }
            Arrays.sort(nArray);
            for (n = 0; n < nArray.length - 1; ++n) {
                stringBuffer.append(nArray[n] + ", ");
            }
            stringBuffer.append("and " + nArray[nArray.length - 1] + ")");
            string = stringBuffer.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void plotgenevalues(Graphics2D graphics2D, double d, double d2, double d3, double[][] dArray, int[][] nArray, ArrayList[] arrayListArray, double[] dArray2, boolean[] blArray, ArrayList arrayList) {
        int n;
        double d4;
        Object object;
        int n2;
        String string;
        Object object2;
        double d5;
        String string2;
        String string3;
        double d6;
        double d7;
        double d8;
        double d9;
        int n3;
        int n4;
        graphics2D.setColor(Color.white);
        Object object3 = this.sizeLock;
        synchronized (object3) {
            this.SCREENWIDTH = this.getWidth();
            this.SCREENHEIGHT = this.getHeight();
        }
        graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, this.SCREENWIDTH, this.SCREENHEIGHT));
        int n5 = arrayList.size();
        double d10 = 0.0;
        double d11 = 0.0;
        if (this.bautomatic) {
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = (Integer)arrayList.get(n4);
                if (!(this.theDataSet.modelprofiles.length > 1 || !this.bonlyorder || this.inames != null && this.inames.contains(this.theDataSet.genenames[n3]) || this.szSpot != null && this.theDataSet.probenames[n3].equals(this.szSpot)) && (this.szSpot != null || this.inames != null || !this.theDataSet.tga.isOrder(this.theDataSet.genenames[n3]))) continue;
                for (int i = 0; i < dArray[n3].length; ++i) {
                    if (nArray[n3][i] <= 0 || !(Math.abs(dArray[n3][i]) > d10)) continue;
                    d10 = Math.abs(dArray[n3][i]);
                }
            }
            if (d10 == 0.0) {
                d10 = 1.0;
            }
            d11 = -d10;
        } else {
            d10 = this.dmaxfixed;
            d11 = this.dminfixed;
            if (d11 == 0.0 && d10 == 0.0) {
                d11 = -0.1;
                d10 = 0.1;
            }
        }
        n4 = 0;
        n3 = 0;
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        if (this.bautomatic) {
            if (d10 > 0.0) {
                n4 = (int)Math.floor(Math.log(d10) / Math.log(10.0));
            }
            if (d11 < 0.0) {
                n4 = Math.max(n4, (int)Math.floor(Math.log(-d11) / Math.log(10.0)));
            }
            if (n4 < 0) {
                numberFormat.setMaximumFractionDigits(-n4);
                numberFormat.setMinimumFractionDigits(-n4);
            } else {
                numberFormat.setMaximumFractionDigits(0);
                numberFormat.setMinimumFractionDigits(0);
            }
            d9 = Math.pow(10.0, n4);
            d8 = (int)Math.ceil(d10 / d9);
            d10 = d8 * d9;
            d7 = (int)Math.ceil(-d11 / d9);
            d11 = -d7 * d9;
            this.dtickinterval = d9;
        } else {
            d6 = this.dtickinterval;
            while (d6 - (double)((int)d6) > 1.0E-6) {
                --n3;
                d6 *= 10.0;
            }
            numberFormat.setMaximumFractionDigits(-n3);
            numberFormat.setMinimumFractionDigits(-n3);
            if (this.dtickinterval - (double)((int)this.dtickinterval) > 1.0E-6) {
                n4 = (int)Math.floor(Math.log(this.dtickinterval) / Math.log(10.0));
            }
            d8 = d10;
            d7 = -d11;
            d9 = 1.0;
        }
        d6 = d8 + d7;
        double d12 = this.bautomatic ? (double)(this.SCREENHEIGHT - (SPACETOP + SPACEBOT + SPACEBOT2)) / d6 : (double)(this.SCREENHEIGHT - (SPACETOP + SPACEBOT + SPACEBOT2)) / d6;
        int n6 = dArray[0].length;
        int n7 = (this.SCREENWIDTH - SPACELEFT - SPACERIGHT) / (n6 - 1);
        NumberFormat numberFormat2 = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat2.setMinimumFractionDigits(1);
        numberFormat2.setMaximumFractionDigits(1);
        int n8 = (int)((double)SPACETOP + d8 * d12);
        String string4 = Util.doubleToSz(d3);
        StringBuffer stringBuffer = new StringBuffer(this.szprofileclusterCAP + " #" + this.nprofile + ": (");
        for (int i = 0; i < dArray2.length - 1; ++i) {
            if (this.theDataSet.bkmeans) {
                stringBuffer.append(numberFormat2.format(dArray2[i]) + ", ");
                continue;
            }
            stringBuffer.append((int)dArray2[i] + ", ");
        }
        if (this.theDataSet.bkmeans) {
            stringBuffer.append(numberFormat2.format(dArray2[dArray2.length - 1]) + ")");
        } else {
            stringBuffer.append((int)dArray2[dArray2.length - 1] + ")");
        }
        String string5 = stringBuffer.toString();
        String string6 = blArray[this.nprofile] ? " (significant)" : " (not significant)";
        graphics2D.setColor(Color.black);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string5, graphics2D);
        int n9 = (int)Math.ceil(rectangle2D.getMaxX());
        graphics2D.drawString(string5, this.SCREENWIDTH / 2 - n9 / 2, 50);
        if (this.theDataSet.bkmeans) {
            this.szAssignInfo = numberFormat2.format(d);
            string3 = numberFormat2.format(d) + " Genes Assigned";
        } else {
            this.szAssignInfo = numberFormat2.format(d) + "\t" + numberFormat2.format(d2) + "\t" + string4 + "\t" + string6;
            string3 = numberFormat2.format(d) + " Genes Assigned; " + numberFormat2.format(d2) + " Genes Expected; p-value = " + string4 + string6;
        }
        rectangle2D = fontMetrics.getStringBounds(string3, graphics2D);
        int n10 = (int)Math.ceil(rectangle2D.getMaxX());
        graphics2D.drawString(string3, this.SCREENWIDTH / 2 - n10 / 2, 70);
        NumberFormat numberFormat3 = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat3.setMinimumFractionDigits(1);
        numberFormat3.setMaximumFractionDigits(1);
        numberFormat3.setGroupingUsed(false);
        this.bcheckonly = false;
        if (this.szSpot != null) {
            this.bcheckonly = true;
        }
        if (this.inames != null) {
            this.bcheckonly = true;
            graphics2D.drawString(this.szIntersect, this.SCREENWIDTH / 9, 90);
        } else if (this.pgrr != null && this.theDataSet.tga.szsortcommand.equals("define")) {
            string2 = Util.doubleToSz(this.pgrr.dpval);
            d5 = this.pgrr.dgenes - this.pgrr.dmaxselect * this.pgrr.dgenestotal / this.pgrr.dmaxselecttotal;
            String string7 = this.enrichedToSz(d5);
            object2 = "Query set " + this.szprofilecluster + " enrichment uncorrected p-value = " + string2 + " (" + numberFormat3.format(this.pgrr.dgenes) + "/" + numberFormat3.format(this.pgrr.dmaxselect) + " vs. " + (int)this.pgrr.dgenestotal + "/" + (int)this.pgrr.dmaxselecttotal + "; " + string7 + " genes)";
            graphics2D.drawString((String)object2, this.SCREENWIDTH / 7, 90);
            this.bcheckonly = true;
            if (this.theDataSet.tga.bcluster && this.pgrr.dclusterpval < 1.5) {
                string2 = Util.doubleToSz(this.pgrr.dclusterpval);
                d5 = this.pgrr.dgenescluster - this.pgrr.dmaxselectcluster * this.pgrr.dgenestotal / this.pgrr.dmaxselecttotal;
                string7 = this.enrichedToSz(d5);
                object2 = "Query set cluster enrichment uncorrected p-value = " + string2 + " (" + numberFormat3.format(this.pgrr.dgenescluster) + "/" + numberFormat3.format(this.pgrr.dmaxselectcluster) + " vs. " + (int)this.pgrr.dgenestotal + "/" + (int)this.pgrr.dmaxselecttotal + "; " + string7 + " genes)";
                graphics2D.drawString((String)object2, this.SCREENWIDTH / 7, 110);
            }
        } else if (this.pgrr != null && (this.theDataSet.tga.szsortcommand.equals("expgo") || this.theDataSet.tga.szsortcommand.equals("expdefine"))) {
            string2 = Util.doubleToSz(this.pgrr.dpval);
            d5 = this.theDataSet.expectedassignments[this.pgrr.nprofile];
            double d13 = this.pgrr.dgenes - this.pgrr.dgenestotal * d5 / this.pgrr.dmaxselecttotal;
            string = this.enrichedToSz(d13);
            this.bcheckonly = true;
            if (this.theDataSet.tga.szsortcommand.equals("expgo")) {
                GoAnnotations.Rec rec = (GoAnnotations.Rec)this.theDataSet.tga.htGO.get(this.theDataSet.tga.szSelectedGO);
                graphics2D.drawString("      " + this.theDataSet.tga.szSelectedGO + " (" + rec.sztermName + "):", this.SCREENWIDTH / 10, 90);
                n2 = 110;
            } else {
                n2 = 90;
            }
            object = "        " + this.szprofileclusterCAP + " expected size based enrichment uncorrected p-value = " + string2 + " (" + numberFormat3.format(this.pgrr.dgenes) + "/" + numberFormat3.format(d5) + " vs. " + (int)this.pgrr.dgenestotal + "/" + (int)this.pgrr.dmaxselecttotal + "; " + string + " genes)";
            graphics2D.drawString((String)object, this.SCREENWIDTH / 10, n2);
        } else if (this.pgrr != null && this.theDataSet.tga.szsortcommand.equals("go")) {
            string2 = Util.doubleToSz(this.pgrr.dpval);
            d5 = this.pgrr.dgenes - this.pgrr.dmaxselect * this.pgrr.dgenestotal / this.pgrr.dmaxselecttotal;
            String string8 = this.enrichedToSz(d5);
            this.bcheckonly = true;
            object2 = (GoAnnotations.Rec)this.theDataSet.tga.htGO.get(this.theDataSet.tga.szSelectedGO);
            graphics2D.drawString("       " + this.theDataSet.tga.szSelectedGO + " (" + ((GoAnnotations.Rec)object2).sztermName + "):", this.SCREENWIDTH / 10, 90);
            string = "          " + this.szprofileclusterCAP + " actual size based enrichment uncorrected p-value = " + string2 + " (" + numberFormat3.format(this.pgrr.dgenes) + "/" + numberFormat3.format(this.pgrr.dmaxselect) + " vs. " + (int)this.pgrr.dgenestotal + "/" + (int)this.pgrr.dmaxselecttotal + "; " + string8 + " genes)";
            graphics2D.drawString(string, this.SCREENWIDTH / 10, 110);
            if (this.theDataSet.tga.bcluster && this.pgrr.dclusterpval < 1.5) {
                string2 = Util.doubleToSz(this.pgrr.dclusterpval);
                d5 = this.pgrr.dgenescluster - this.pgrr.dmaxselectcluster * this.pgrr.dgenestotal / this.pgrr.dmaxselecttotal;
                string8 = this.enrichedToSz(d5);
                string = "          Cluster enrichment uncorrected p-value = " + string2 + " (" + numberFormat3.format(this.pgrr.dgenescluster) + "/" + numberFormat3.format(this.pgrr.dmaxselectcluster) + " vs. " + (int)this.pgrr.dgenestotal + "/" + (int)this.pgrr.dmaxselecttotal + "; " + string8 + " genes)";
                graphics2D.drawString(string, this.SCREENWIDTH / 10, 130);
            }
        }
        graphics2D.draw(new Line2D.Double(SPACELEFT, n8, (n6 - 1) * n7 + SPACELEFT, n8));
        graphics2D.draw(new Line2D.Double(SPACELEFT, (double)n8 - d8 * d12, SPACELEFT, (double)n8 + d7 * d12));
        boolean bl = false;
        d5 = n8;
        for (d4 = 0.0; d4 <= d10 + 1.0E-7; d4 += this.dtickinterval) {
            graphics2D.draw(new Line2D.Double(SPACELEFT - 22, d5, SPACELEFT, (int)d5));
            if (this.dtickinterval - (double)((int)this.dtickinterval) < 1.0E-8) {
                graphics2D.drawString("" + numberFormat.format(d4), SPACELEFT - 15 - 3 * n4, (int)d5 - 2);
            } else {
                graphics2D.drawString("" + numberFormat.format(d4), SPACELEFT - 18 + 3 * (n3 - Math.abs(n4)), (int)d5 - 2);
            }
            d5 -= this.dtickinterval * d12 / d9;
        }
        graphics2D.drawString("Expression Change", SPACELEFT + 3, 64);
        if (this.theDataSet.badd0) {
            graphics2D.drawString("v(i)", SPACELEFT + 3, 76);
        } else if (this.theDataSet.btakelog) {
            graphics2D.drawString("(log\u2082(v(i)/v(0)))", SPACELEFT + 3, 76);
        } else {
            graphics2D.drawString("(v(i)\u2212v(0))", SPACELEFT + 3, 76);
        }
        d5 = (double)n8 + this.dtickinterval * d12 / d9;
        for (d4 = -this.dtickinterval; d4 >= d11 - 1.0E-7; d4 -= this.dtickinterval) {
            graphics2D.draw(new Line2D.Double(SPACELEFT - 22, d5, SPACELEFT, d5));
            if (this.dtickinterval - (double)((int)this.dtickinterval) < 1.0E-8) {
                graphics2D.drawString("" + (int)d4, SPACELEFT - 19 - 3 * n4, (int)d5 - 2);
            } else {
                graphics2D.drawString("" + numberFormat.format(d4), SPACELEFT - 22 + 3 * (n3 - Math.abs(n4)), (int)d5 - 2);
            }
            d5 += this.dtickinterval * d12 / d9;
        }
        graphics2D.drawString("" + this.theDataSet.dsamplemins[0], SPACELEFT + 5, n8 + 20);
        for (n = 1; n < n6 - 1; ++n) {
            graphics2D.draw(new Line2D.Double((double)SPACELEFT + this.theDataSet.dwidthunitsCum[n] * (double)(n6 - 1) * (double)n7, n8 - 10, (double)SPACELEFT + this.theDataSet.dwidthunitsCum[n] * (double)(n6 - 1) * (double)n7, n8 + 10));
            graphics2D.drawString("" + this.theDataSet.dsamplemins[n], (int)((double)SPACELEFT + this.theDataSet.dwidthunitsCum[n] * (double)(n6 - 1) * (double)n7), n8 + 20);
        }
        n = n6 - 1;
        graphics2D.draw(new Line2D.Double(SPACELEFT + n * n7, n8 - 10, SPACELEFT + n * n7, n8 + 10));
        graphics2D.drawString("" + this.theDataSet.dsamplemins[n], SPACELEFT + n * n7, n8 + 20);
        graphics2D.drawString("TIME", SPACELEFT + n * n7 + 2, n8 - 5);
        this.noffset = 60;
        this.tablewid = 157;
        this.nmidpoint = (this.SCREENWIDTH + SPACELEFT - SPACERIGHT) / 2;
        int n11 = (int)((double)(this.SCREENWIDTH / 2 - 2 * this.tablewid) - 22.5);
        if (this.bshowcluster) {
            this.profiletablex = n11;
            this.profilegox = this.profiletablex + this.tablewid + 15;
            this.clustertablex = this.profilegox + this.tablewid + 15;
            this.clustergox = this.clustertablex + this.tablewid + 15;
        } else {
            this.profiletablex = n11 + this.tablewid + 15;
            this.profilegox = this.profiletablex + this.tablewid + 15;
        }
        this.tableheight = 20;
        if (this.szSpot != null || this.inames == null && !this.theDataSet.tga.szsortcommand.equals("define") && !this.theDataSet.tga.szsortcommand.equals("expdefine")) {
            this.tabley = this.SCREENHEIGHT - SPACEBOT - 3 + this.tableheight + 4;
            this.nonlyy = this.tabley - this.tableheight - 5;
        } else {
            this.querytabley = this.SCREENHEIGHT - SPACEBOT - 3;
            this.nonlyy = this.querytabley - this.tableheight - 5;
            this.tabley = this.querytabley + this.tableheight + 4;
        }
        if (this.inames == null && this.pgrr != null && this.pgrr.dgenes > 0.0 && (this.theDataSet.tga.szsortcommand.equals("go") || this.theDataSet.tga.szsortcommand.equals("expgo"))) {
            this.ngosorttabley = this.nonlyy - this.tableheight - 5;
            this.bgosorttable = true;
            this.drawgosorttable();
        } else {
            this.bgosorttable = false;
        }
        this.drawprofiletable(ST.buttonColor);
        this.drawprofilego(ST.buttonColor);
        if (this.inames != null) {
            this.drawintersecttable(ST.buttonColor);
            this.drawintersectgo(ST.buttonColor);
        } else if (this.pgrr != null && (this.theDataSet.tga.szsortcommand.equals("define") || this.theDataSet.tga.szsortcommand.equals("expdefine"))) {
            this.drawprofilequerytable(ST.buttonColor);
            this.drawprofilequerygo(ST.buttonColor);
        }
        if (this.bcheckonly) {
            this.drawonlyorder();
        }
        if (this.bshowcluster) {
            this.drawclustertable(ST.buttonColor);
            this.drawclustergo(ST.buttonColor);
            if (this.pgrr != null && (this.theDataSet.tga.szsortcommand.equals("define") || this.theDataSet.tga.szsortcommand.equals("expdefine"))) {
                this.drawclusterquerytable(ST.buttonColor);
                this.drawclusterquerygo(ST.buttonColor);
            }
        }
        n2 = 0;
        object = new Random();
        for (int i = 0; i < n5; ++i) {
            int n12 = (Integer)arrayList.get(i);
            if (n2 >= this.colorlist.size()) {
                this.colorlist.add(new Color(((Random)object).nextInt(226), ((Random)object).nextInt(226), ((Random)object).nextInt(226)));
            }
            graphics2D.setColor((Color)this.colorlist.get(n2));
            ++n2;
            if (!(!this.bonlyorder || this.szSpot != null && this.theDataSet.probenames[n12].equals(this.szSpot) || this.inames != null && this.inames.contains(this.theDataSet.genenames[n12])) && (this.szSpot != null || this.inames != null || !this.theDataSet.tga.isOrder(this.theDataSet.genenames[n12]))) continue;
            for (int j = 0; j < n6 - 1; ++j) {
                if (nArray[n12][j] <= 0 || nArray[n12][j + 1] <= 0) continue;
                graphics2D.draw(new Line2D.Double((double)SPACELEFT + this.theDataSet.dwidthunitsCum[j] * (double)n7 * (double)(n6 - 1), (double)n8 - d12 * dArray[n12][j] / d9, (double)SPACELEFT + this.theDataSet.dwidthunitsCum[j + 1] * (double)n7 * (double)(n6 - 1), (double)n8 - d12 * dArray[n12][j + 1] / d9));
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.thegeneplotpanel == null) {
            this.bautomatic = false;
        } else {
            this.bautomatic = this.thegeneplotpanel.automaticButton.isSelected();
            try {
                this.thegeneplotpanel.thespinnerminy.commitEdit();
                this.thegeneplotpanel.thespinnermaxy.commitEdit();
                this.thegeneplotpanel.thespinnertick.commitEdit();
            }
            catch (ParseException parseException) {
                System.out.println("Warning could not correctly parse y-axis parameters");
            }
            this.dminfixed = (Double)this.thegeneplotpanel.thespinnerminy.getValue();
            this.dmaxfixed = (Double)this.thegeneplotpanel.thespinnermaxy.getValue();
            this.dtickinterval = (Double)this.thegeneplotpanel.thespinnertick.getValue();
        }
        if ((this.theDataSet.tga.szsortcommand.equals("id") || this.theDataSet.tga.szsortcommand.equals("sig") || this.theDataSet.tga.szsortcommand.equals("num") || this.theDataSet.tga.szsortcommand.equals("default") || this.theDataSet.tga.szsortcommand.equals("exp")) && this.szSpot == null && this.inames == null) {
            this.bonlyorder = false;
        }
        this.g2 = (Graphics2D)this.getGraphics();
        this.pgrr = this.theDataSet.tga.tpgr != null && this.ranklookup != null ? this.theDataSet.tga.tpgr[this.ranklookup[this.nprofile]] : null;
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double[][] dArray = this.theDataSet.data;
        this.plotgenevalues(this.g2, this.theDataSet.countassignments[this.nprofile], this.theDataSet.expectedassignments[this.nprofile], this.theDataSet.pvaluesassignments[this.nprofile], dArray, this.theDataSet.pmavalues, this.theDataSet.bestassignments, this.theDataSet.modelprofiles[this.nprofile], this.theDataSet.significantnum, this.theDataSet.profilesAssigned[this.nprofile]);
    }
}

