/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.stem;

import edu.cmu.cs.sb.chromviewer.ChromFrame;
import edu.cmu.cs.sb.chromviewer.GenomeFileParser;
import edu.cmu.cs.sb.core.DataTable;
import edu.cmu.cs.sb.core.GoAnnotations;
import edu.cmu.cs.sb.core.ListDialog;
import edu.cmu.cs.sb.core.SpringUtilities;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.stem.CompareGui;
import edu.cmu.cs.sb.stem.CompareInfo;
import edu.cmu.cs.sb.stem.DefineGeneSet;
import edu.cmu.cs.sb.stem.FilteredTable;
import edu.cmu.cs.sb.stem.GenePlotPanel;
import edu.cmu.cs.sb.stem.MainTable;
import edu.cmu.cs.sb.stem.ProfileGui;
import edu.cmu.cs.sb.stem.ST;
import edu.cmu.cs.sb.stem.STEM_DataSet;
import edu.cmu.cs.sb.stem.SortTable;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.PFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class MAINGUI2
extends PFrame
implements ActionListener {
    static int SCREENWIDTH = 800;
    static int SCREENHEIGHT = 600;
    static int BUFFERLEFT = 30;
    static int BUFFERRIGHT = 30;
    static int BUFFERTOP = 25;
    static int BUFFERBOTTOM = 50;
    static final int maxCharHeight = 15;
    static final int minFontSize = 6;
    int[] profilelookup;
    int[] ranklookup;
    int[] cluster;
    ProfileSortRec[] theProfileSortRec;
    int ngenescale = 1;
    int ngenedisplay;
    boolean bscalevisible = ST.bscalevisibleDEF;
    PCanvas canvas;
    Color thegenecolor = new Color(ST.genecolorRDEF, ST.genecolorGDEF, ST.genecolorBDEF);
    JDialog theOptions;
    JFrame thegeneplotframe;
    JFrame profilesortframe;
    JFrame clustersortframe;
    GenePlotPanel thegeneplotpanel;
    CompareGui thecomparegui;
    PNode[] profilenodes;
    boolean bsaveprofile = true;
    Color[] savedcolors = null;
    ArrayList openProfiles = new ArrayList();
    boolean binvalidreal = false;
    ChromFrame cf;
    Color[] clustercolors = new Color[]{new Color(1.0f, 0.0f, 0.0f, 0.4f), new Color(0.0f, 1.0f, 0.0f, 0.4f), new Color(0.0f, 0.0f, 1.0f, 0.4f), new Color(1.0f, 1.0f, 0.0f, 0.4f), new Color(1.0f, 0.5019608f, 0.0f, 0.4f), new Color(1.0f, 0.0f, 1.0f, 0.4f), new Color(0.5019608f, 0.0f, 0.0f, 0.4f), new Color(0.0f, 0.0f, 0.5019608f, 0.4f), new Color(0.0f, 0.5019608f, 0.0f, 0.4f), new Color(0.5019608f, 0.0f, 0.5019608f, 0.4f), new Color(0.5019608f, 0.5019608f, 0.5019608f, 0.4f), new Color(1.0f, 0.5019608f, 0.5019608f, 0.4f), new Color(0.0f, 0.5019608f, 1.0f, 0.4f), new Color(0.5019608f, 0.5019608f, 0.0f, 0.4f), new Color(0.5019608f, 1.0f, 0.5019608f, 0.4f), new Color(0.5019608f, 0.0f, 1.0f, 0.4f), new Color(0.0f, 1.0f, 0.5019608f, 0.4f), new Color(0.5019608f, 0.5019608f, 1.0f, 0.4f), new Color(0.5019608f, 1.0f, 0.0f, 0.4f), new Color(0.0f, 1.0f, 1.0f, 0.4f), new Color(1.0f, 0.5019608f, 1.0f, 0.4f), new Color(0.0f, 0.5019608f, 0.5019608f, 0.4f), new Color(0.5019608f, 1.0f, 1.0f, 0.4f), new Color(1.0f, 0.0f, 0.5019608f, 0.4f), new Color(1.0f, 1.0f, 0.5019608f, 0.4f)};
    static ArrayList coloroverflow = new ArrayList();
    static int NUSED = 0;
    STEM_DataSet theDataSet = null;
    static Object datasetlock = new Object();
    static int nwindowcount = 1;
    static int nopen = 0;
    boolean buniformXaxis = ST.buniformXaxisDEF;
    boolean bautomaticYaxis = ST.bautomaticYDEF;
    boolean bdisplayID = ST.bdisplayIDDEF;
    boolean bdisplayprofileline = ST.bdisplayprofilelineDEF;
    boolean bdisplaymaintick = ST.bdisplaymaintickDEF;
    boolean bdisplaydetail = ST.bdisplaydetailDEF;
    double dtickintervalmain = ST.dtickmainDEF;
    SpinnerNumberModel snmsigLevel = new SpinnerNumberModel(new Double(ST.dCompareMinpvalDEF), new Double(0.0), new Double(1.0), new Double(0.001));
    SpinnerNumberModel snmnumgenes = new SpinnerNumberModel(new Integer(ST.nCompareMinGenesDEF), new Integer(1), null, new Integer(1));
    JSpinner thespinnersigLevel = new JSpinner(this.snmsigLevel);
    JSpinner thespinnernumgenes = new JSpinner(this.snmnumgenes);
    JButton browse1Button = new JButton("Browse...", Util.createImageIcon("Open16.gif"));
    JButton compareButtonDialog = new JButton("Compare");
    JLabel compare1Label = new JLabel("Comparison Data File:", 11);
    JLabel sigLevelLabel = new JLabel("Maximum uncorrected intersection p-value:", 11);
    JLabel numgenesLabel = new JLabel("Minimum number of genes in intersection:", 11);
    JTextField compare1Field = new JTextField(ST.szCompareDEF, 11);
    JButton executecompareHButton = new JButton(Util.createImageIcon("Help16.gif"));
    JButton compare1HButton = new JButton(Util.createImageIcon("Help16.gif"));
    JButton compare2HButton = new JButton(Util.createImageIcon("Help16.gif"));
    JButton sigLevelHButton = new JButton(Util.createImageIcon("Help16.gif"));
    JButton numgenesHButton = new JButton(Util.createImageIcon("Help16.gif"));
    JButton viewHButton = new JButton(Util.createImageIcon("Help16.gif"));
    JButton viewButton = new JButton("View Comparison Data File");
    JButton repeatButton = new JButton("Comparison Repeat Data...", Util.createImageIcon("Open16.gif"));
    ListDialog theCompareRepeatList = new ListDialog(this, ST.vRepeatCompareDEF, ST.bcomparealltimeDEF, this.repeatButton, ST.lightBlue, ST.defaultColor, ST.fc);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MAINGUI2(STEM_DataSet sTEM_DataSet) {
        super((sTEM_DataSet.bkmeans ? "All K-Means Clusters" : "All STEM Profiles") + " (" + nwindowcount + ")");
        Object object = datasetlock;
        synchronized (object) {
            this.theDataSet = sTEM_DataSet;
            this.ngenedisplay = ST.ngenedisplayDEF;
            this.ngenescale = sTEM_DataSet.bkmeans ? ST.ngenescalekmeansDEF : ST.ngenescaleDEF;
            ++nwindowcount;
            ++nopen;
            this.makeCompareDialog();
            this.cluster = new int[sTEM_DataSet.modelprofiles.length];
            this.theProfileSortRec = new ProfileSortRec[sTEM_DataSet.modelprofiles.length];
            this.profilelookup = new int[this.cluster.length];
            this.ranklookup = new int[this.cluster.length];
            datasetlock.notifyAll();
        }
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosing(WindowEvent windowEvent) {
                Object object = datasetlock;
                synchronized (object) {
                    if (--nopen == 0) {
                        nwindowcount = 1;
                        coloroverflow = new ArrayList();
                        NUSED = 0;
                    }
                }
            }
        });
    }

    public void chromViewInit(GenomeFileParser genomeFileParser) {
        this.cf = new ChromFrame(this.theDataSet.szGeneHeader, genomeFileParser, nwindowcount - 1);
    }

    public void beforeInitialize() {
        this.setSize(SCREENWIDTH, SCREENHEIGHT);
    }

    public void initialize() {
        this.drawmain();
    }

    public void closeSortWindows() {
        if (this.profilesortframe != null) {
            this.cf.setVisible(false);
            this.cf.dispose();
            this.cf = null;
        }
        if (this.profilesortframe != null) {
            this.profilesortframe.setVisible(false);
            this.profilesortframe.dispose();
            ((SortTable)this.profilesortframe.getContentPane()).closeDefineWindows();
            this.profilesortframe = null;
        }
        if (this.clustersortframe != null) {
            this.clustersortframe.setVisible(false);
            this.clustersortframe.dispose();
            ((SortTable)this.clustersortframe.getContentPane()).closeDefineWindows();
            this.clustersortframe = null;
        }
        if (this.thegeneplotframe != null) {
            this.thegeneplotframe.setVisible(false);
            this.thegeneplotframe.dispose();
            this.thegeneplotframe = null;
        }
        if (this.thegeneplotpanel != null) {
            this.thegeneplotpanel.themaingui = null;
            this.thegeneplotpanel = null;
        }
        if (this.cf != null) {
            this.cf.dispose();
            this.cf = null;
        }
    }

    public static String doubleToSz(double d) {
        String string;
        int n = 0;
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setMaximumFractionDigits(0);
        NumberFormat numberFormat2 = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat2.setMinimumFractionDigits(1);
        numberFormat2.setMaximumFractionDigits(1);
        if (d <= 0.0) {
            string = "0.0";
        } else if (d > 0.095) {
            string = numberFormat2.format(d);
        } else {
            double d2;
            for (d2 = d; d2 < 0.95 && d2 > 0.0; d2 *= 10.0) {
                --n;
            }
            d2 = Math.pow(10.0, Math.log(d) / Math.log(10.0) - (double)n);
            string = numberFormat.format(d2) + "e" + n;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawmain() {
        Object object = datasetlock;
        synchronized (object) {
            int n;
            int n2;
            int n3;
            boolean bl;
            PNode pNode;
            PPath pPath;
            PText pText;
            PText pText2;
            String string;
            double d;
            int n4;
            while (this.theDataSet == null) {
                try {
                    datasetlock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.theDataSet.tga.tpgr = null;
            int n5 = this.theDataSet.clustersofprofilesnum.size();
            for (n4 = 0; n4 < this.theDataSet.modelprofiles.length; ++n4) {
                this.cluster[n4] = n5;
                this.theProfileSortRec[n4] = new ProfileSortRec(n5, n4, this.theDataSet.pvaluesassignments[n4], this.theDataSet.countassignments[n4], this.theDataSet.expectedassignments[n4]);
            }
            for (n4 = 0; n4 < this.theDataSet.clustersofprofilesnum.size(); ++n4) {
                ArrayList arrayList = (ArrayList)this.theDataSet.clustersofprofilesnum.get(n4);
                for (int i = 0; i < arrayList.size(); ++i) {
                    STEM_DataSet.ProfileRec profileRec = (STEM_DataSet.ProfileRec)arrayList.get(i);
                    this.cluster[profileRec.nprofileindex] = n4;
                    this.theProfileSortRec[profileRec.nprofileindex] = new ProfileSortRec(n4, profileRec.nprofileindex, this.theDataSet.pvaluesassignments[profileRec.nprofileindex], this.theDataSet.countassignments[profileRec.nprofileindex], this.theDataSet.expectedassignments[profileRec.nprofileindex]);
                }
            }
            if (this.theDataSet.tga.szsortcommand.equals("exp")) {
                Arrays.sort(this.theProfileSortRec, new ProfileexpComparator());
            } else if (this.theDataSet.tga.szsortcommand.equals("num")) {
                Arrays.sort(this.theProfileSortRec, new ProfilenumComparator());
            } else if (this.theDataSet.tga.szsortcommand.equals("sig")) {
                Arrays.sort(this.theProfileSortRec, new ProfilesigComparator());
            } else if (this.theDataSet.tga.szsortcommand.equals("id") || this.theDataSet.tga.szsortcommand.equals("default") && this.theDataSet.bkmeans) {
                Arrays.sort(this.theProfileSortRec, new ProfileIDComparator());
            } else if (this.theDataSet.tga.szsortcommand.equals("default")) {
                Arrays.sort(this.theProfileSortRec, new ProfileComparator());
            } else {
                this.theDataSet.tga.getProfileRankings(this.theDataSet.clustersofprofilesnum, this.theDataSet.profilesAssigned, this.theDataSet.genenames, this.theDataSet.bestassignments, this.theDataSet.expectedassignments);
                ProfileSortRec[] profileSortRecArray = new ProfileSortRec[this.theProfileSortRec.length];
                for (int i = 0; i < this.theProfileSortRec.length; ++i) {
                    profileSortRecArray[i] = this.theProfileSortRec[this.theDataSet.tga.tpgr[i].nprofile];
                }
                this.theProfileSortRec = profileSortRecArray;
            }
            for (int i = 0; i < this.profilelookup.length; ++i) {
                this.profilelookup[i] = this.theProfileSortRec[i].nprofileindex;
                this.ranklookup[this.theProfileSortRec[i].nprofileindex] = i;
            }
            double d2 = SCREENWIDTH - BUFFERLEFT - BUFFERRIGHT;
            double d3 = SCREENHEIGHT - BUFFERTOP - BUFFERBOTTOM;
            double d4 = this.theDataSet.numcols;
            double d5 = d4 * d3 + d2 * d4;
            double d6 = Math.sqrt(Math.pow(d4 * d3 + d2 * d4, 2.0) - 4.0 * d3 * d2 * (Math.pow(d4, 2.0) - (double)this.theDataSet.modelprofiles.length * Math.pow(d4, 2.0)));
            if (this.theDataSet.modelprofiles.length > 1) {
                double d7 = 2.0 * (d4 * d4 * (double)(1 - this.theDataSet.modelprofiles.length));
                d = Math.max((d5 + d6) / d7, (d5 - d6) / d7);
            } else {
                d = d2 / (2.0 * d4);
            }
            int n6 = Math.max((int)Math.ceil(d2 / (d4 * d) - 1.0), 1);
            double d8 = d * (d4 - 1.0);
            double d9 = d * (d4 - 1.0);
            this.canvas = this.getCanvas();
            this.canvas.getLayer().removeAllChildren();
            String string2 = this.theDataSet.bkmeans ? "Clusters " : (this.theDataSet.tga.bcluster ? "Clusters and then profiles " : "Profiles ");
            if (this.theDataSet.tga.szSelectedGO == null) {
                string = this.theDataSet.tga.szsortcommand.equals("define") ? string2 + "ordered based on the actual size based p-value gene enrichment of " + "genes in the query gene set" : (this.theDataSet.tga.szsortcommand.equals("expdefine") ? string2 + "ordered based on the expected size based p-value gene enrichment of " + "genes in the query gene set" : (this.theDataSet.tga.szsortcommand.equals("id") || this.theDataSet.tga.szsortcommand.equals("default") && this.theDataSet.bkmeans ? string2 + "ordered based on " + (this.theDataSet.bkmeans ? "cluster" : "profile") + " ID" : (this.theDataSet.tga.szsortcommand.equals("num") ? string2 + "ordered based on the number of genes assigned" : (this.theDataSet.tga.szsortcommand.equals("sig") ? string2 + "ordered based on the p-value significance of number of " + "genes assigned versus expected" : (this.theDataSet.tga.szsortcommand.equals("exp") ? string2 + "ordered based on the expected number of genes based on " + "a permutation test" : "Clusters ordered based on number of genes and profiles ordered by significance (default)")))));
                pText2 = new PText(string);
                pText2.translate(BUFFERLEFT, 2.0);
            } else {
                string = this.theDataSet.tga.szsortcommand.equals("expgo") ? string2 + "ordered based on the expected size based p-value of gene enrichment of " : string2 + "ordered based on the actual size based p-value of gene enrichment of ";
                string = string + this.theDataSet.tga.szSelectedGO + " (" + ((GoAnnotations.Rec)this.theDataSet.tga.htGO.get((Object)this.theDataSet.tga.szSelectedGO)).sztermName + ") genes";
                pText2 = new PText(string);
                pText2.translate(BUFFERLEFT, 2.0);
            }
            pText2.setFont(new Font("times", 0, 14));
            this.canvas.getLayer().addChild(pText2);
            float f = 114.0f;
            int n7 = 100;
            int n8 = 5;
            PPath pPath2 = PPath.createRectangle(0.0f, 0.0f, f, 18.0f);
            pPath2.translate(2 * (SCREENWIDTH / 7 + n8) - n7, SCREENHEIGHT - 65);
            PText pText3 = new PText("Main Gene Table");
            pText3.setFont(new Font("times", 0, 12));
            pText3.translate(10.0, 2.0);
            pPath2.setPaint(ST.buttonColor);
            pPath2.addChild(pText3);
            PPath pPath3 = PPath.createRectangle(0.0f, 0.0f, f, 18.0f);
            pPath3.translate(SCREENWIDTH / 7 + n8 - n7, SCREENHEIGHT - 65);
            PText pText4 = new PText("Filtered Gene List");
            pText4.setFont(new Font("times", 0, 12));
            pText4.translate(8.0, 2.0);
            pPath3.setPaint(ST.buttonColor);
            pPath3.addChild(pText4);
            this.canvas.getLayer().addChild(pPath3);
            PPath pPath4 = PPath.createRectangle(0.0f, 0.0f, f, 18.0f);
            pPath4.translate(3 * (SCREENWIDTH / 7 + n8) - n7, SCREENHEIGHT - 65);
            PText pText5 = new PText("Interface Options...");
            pText5.setFont(new Font("times", 0, 12));
            pText5.translate(6.0, 2.0);
            pPath4.setPaint(ST.buttonColor);
            pPath4.addChild(pText5);
            this.canvas.getLayer().addChild(pPath4);
            PPath pPath5 = PPath.createRectangle(0.0f, 0.0f, f, 18.0f);
            pPath5.translate(4 * (SCREENWIDTH / 7 + n8) - n7, SCREENHEIGHT - 65);
            if (this.theDataSet.bkmeans) {
                pText = new PText("Order Clusters By...");
                pText.translate(1.0, 2.0);
            } else {
                pText = new PText("Order Profiles By...");
                pText.translate(3.0, 2.0);
            }
            pText.setFont(new Font("times", 0, 12));
            pPath5.setPaint(ST.buttonColor);
            pPath5.addChild(pText);
            this.canvas.getLayer().addChild(pPath5);
            final MAINGUI2 mAINGUI2 = this;
            if (!this.theDataSet.bkmeans) {
                pPath = PPath.createRectangle(0.0f, 0.0f, f, 18.0f);
                pPath.translate(5 * (SCREENWIDTH / 7 + n8) - n7, SCREENHEIGHT - 65);
                pNode = new PText("Order Clusters By...");
                ((PText)pNode).setFont(new Font("times", 0, 12));
                pNode.translate(2.0, 2.0);
                pPath.setPaint(ST.buttonColor);
                pPath.addChild(pNode);
                this.canvas.getLayer().addChild(pPath);
                pPath.addInputEventListener(new PBasicInputEventHandler(){

                    public void mousePressed(PInputEvent pInputEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                if (MAINGUI2.this.clustersortframe == null) {
                                    MAINGUI2.this.clustersortframe = new JFrame("Order Clusters and then Profiles by:");
                                    MAINGUI2.this.clustersortframe.setDefaultCloseOperation(2);
                                    MAINGUI2.this.clustersortframe.setLocation(400, 300);
                                    MAINGUI2.this.theDataSet.tga.bcluster = true;
                                    SortTable sortTable = new SortTable(MAINGUI2.this.clustersortframe, mAINGUI2, MAINGUI2.this.theDataSet.tga, MAINGUI2.this.theDataSet);
                                    sortTable.setOpaque(true);
                                    MAINGUI2.this.clustersortframe.setContentPane(sortTable);
                                    MAINGUI2.this.clustersortframe.pack();
                                } else {
                                    MAINGUI2.this.clustersortframe.setExtendedState(0);
                                }
                                MAINGUI2.this.clustersortframe.setVisible(true);
                            }
                        });
                    }
                });
            }
            pPath = PPath.createRectangle(0.0f, 0.0f, f, 18.0f);
            pNode = new PImage(Util.getImageURL("Help24.gif"));
            PImage pImage = new PImage(Util.getImageURL("Save24.gif"));
            if (this.theDataSet.bkmeans) {
                pPath.translate(5 * (SCREENWIDTH / 7 + n8) - n7, SCREENHEIGHT - 65);
                pImage.translate(5 * (SCREENWIDTH / 7 + n8) + 20, SCREENHEIGHT - 68);
                pNode.translate(5 * (SCREENWIDTH / 7 + n8) + 50, SCREENHEIGHT - 68);
            } else {
                pPath.translate(6 * (SCREENWIDTH / 7 + n8) - n7, SCREENHEIGHT - 65);
                pImage.translate(6 * (SCREENWIDTH / 7 + n8) + 20, SCREENHEIGHT - 68);
                pNode.translate(6 * (SCREENWIDTH / 7 + n8) + 50, SCREENHEIGHT - 68);
            }
            this.canvas.getLayer().addChild(pNode);
            this.canvas.getLayer().addChild(pImage);
            PText pText6 = new PText("Compare...");
            pText6.setFont(new Font("times", 0, 12));
            pText6.translate(23.0, 2.0);
            pPath.setPaint(ST.buttonColor);
            pPath.addChild(pText6);
            this.canvas.getLayer().addChild(pPath);
            final MAINGUI2 mAINGUI22 = this;
            pImage.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    try {
                        int n = Util.theChooser.showSaveDialog(mAINGUI22);
                        if (n == 0) {
                            File file = Util.theChooser.getSelectedFile();
                            String string = "";
                            String string2 = file.getName();
                            int n2 = string2.lastIndexOf(46);
                            if (n2 > 0 && n2 < string2.length() - 1) {
                                string = string2.substring(n2 + 1).toLowerCase(Locale.ENGLISH);
                            }
                            if (string.equalsIgnoreCase("svg")) {
                                DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
                                String string3 = "http://www.w3.org/2000/svg";
                                Document document = dOMImplementation.createDocument(string3, "svg", null);
                                SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(document);
                                sVGGraphics2D.setColor(Color.white);
                                MAINGUI2.this.canvas.paintComponent(sVGGraphics2D);
                                boolean bl = true;
                                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                                sVGGraphics2D.stream(outputStreamWriter, bl);
                            } else {
                                PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                                MAINGUI2.this.printDefaults(printWriter);
                                printWriter.close();
                            }
                        }
                    }
                    catch (IOException iOException) {
                        final IOException iOException2 = iOException;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                JOptionPane.showMessageDialog(null, iOException2.getMessage(), "Exception thrown", 0);
                            }
                        });
                        iOException.printStackTrace(System.out);
                    }
                }
            });
            pNode.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JDialog jDialog = new JDialog(mAINGUI2, "Help", false);
                            Container container = jDialog.getContentPane();
                            jDialog.setBackground(Color.white);
                            container.setBackground(Color.white);
                            String string = !MAINGUI2.this.theDataSet.bkmeans ? "The above image diagrams a model temporal expression profile.  The main screen contains all the model expression profiles.  Genes are assigned to the model profile that they most closely match.  The number of genes expected to be assigned to each profile is also computed based on a permuation test.  Model profiles which have a statistically significant number of genes assigned to it as compared to what was expected are colored non-white.  Significant model profiles which are similar to each other are grouped together as a cluster of profiles, and are given the same color.\n\nClicking on a profile box displays more information about the profile including a graph of the time series of the genes assigned to the profile.  One can also see a list of genes assigned to the profile, or perform a GO gene enrichment analysis on the set of genes assigned.\nIn addition to clicking on any profile, there are seven additional buttons on the main window: \n*'Main Gene Table' - displays a table containing the names of all genes that passed filter, their expression values, and model profile assignment.\n*'Filtered Gene List' - contains a list of all the genes that were filtered.\n*'Interface Options...' - Display a window to adjust various interface options.\n*'Order Profiles By...' -  Reorders profiles by enrichment of genes from a selected GO Category or user defined query set of genes, number of genes assigned or expected, significance of the profile, or ID number.  Displays additional information in the profile box based on the reordering chosen.\n*'Order Clusters By...' - Reorders the cluster of profiles based on enrichment of genes from a selected GO Category or a query set.  The p-value the enrichment for the cluster appears in the upper-right hand corner of any profile of the cluster.\n*'Compare...' - Allows one to specify a data set for a time series of the same length to compare against the current data set.  Profile pairs, one from this experiment and one from the comparison experiment, which have a significant overlap in genes assigned to them will be identified in a new window.  A display of all profiles in the comparison experiment will also appear in a new window. \n*Disk icon - This opens a window to specify a file to save the settings used to produce the current analysis to a specified file.  The settings can be opened using the 'Load Saved Settings' on the main interface or from the command line as a defaults file.\n\nNote also that the main interface is zoomable and pannable. Hold the right button down to zoom or the left to pan while moving the mouse." : "The above image contains a legend for a K-means cluster box.  The main screen contains boxes for all K-means cluster.  Clicking on a K-means cluster box displays more information about the cluster including a graph of the time series of the genes belonging to the cluster.  One can also see a list of genes belonging to the cluster, or perform a GO gene enrichment analysis on the set of genes.\nIn addition to clicking on any cluster box, there are five additional buttons on the main window: \n*'Main Gene Table' - displays a table containing the names of all genes that passed filter, their expression values, and cluster assignment.\n*'Filtered Gene List' - contains a list of all the genes that were filtered.\n*'Interface Options...' - Display a window to adjust various interface options.\n*'Order Clusters By...' -  Reorders clusters by enrichment of genes from a selected GO Category or user defined query set of genes, number of genes assigned  or ID number.  Displays additional information in the cluster box based on the reordering chosen.\n*'Compare...' - Allows one to specify a data set for a time series of the same length to compare against the current data set. Cluster pairs, one from this experiment and one from the comparison experiment, which have a significant overlap in genes assigned to them will be identified in a new window.  A display of all cluster in the comparison experiment will also appear in a new window. \n\n Note also that the main interface is zoomable and pannable. Hold the right button down to zoom or the left to pan while moving the mouse.";
                            JTextArea jTextArea = new JTextArea(string, 10, 70);
                            jTextArea.setLineWrap(true);
                            jTextArea.setWrapStyleWord(true);
                            jTextArea.setBackground(Color.white);
                            jTextArea.setEditable(false);
                            ImageIcon imageIcon = MAINGUI2.this.theDataSet.bkmeans ? Util.createImageIcon("p4.png") : Util.createImageIcon("p42.png");
                            JLabel jLabel = new JLabel(imageIcon);
                            JPanel jPanel = new JPanel();
                            jPanel.setLayout(new SpringLayout());
                            jPanel.setBackground(Color.white);
                            jPanel.add(jLabel);
                            JScrollPane jScrollPane = new JScrollPane(jTextArea);
                            jPanel.add(jScrollPane);
                            SpringUtilities.makeCompactGrid(jPanel, 2, 1, 0, 2, 0, 0);
                            JScrollPane jScrollPane2 = new JScrollPane(jPanel);
                            container.add(jScrollPane2);
                            container.setSize(820, 600);
                            container.validate();
                            jDialog.setLocation(mAINGUI2.getX() + 50, mAINGUI2.getY() + 25);
                            jDialog.setSize(820, 600);
                            jDialog.setDefaultCloseOperation(2);
                            jDialog.setVisible(true);
                        }
                    });
                }
            });
            pPath.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    MAINGUI2.this.theOptions.setVisible(true);
                }
            });
            pPath4.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (MAINGUI2.this.thegeneplotframe != null) {
                                MAINGUI2.this.thegeneplotframe.setExtendedState(0);
                                MAINGUI2.this.thegeneplotframe.setVisible(true);
                            }
                        }
                    });
                }
            });
            pPath5.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (MAINGUI2.this.profilesortframe == null) {
                                MAINGUI2.this.profilesortframe = MAINGUI2.this.theDataSet.bkmeans ? new JFrame("Order Clusters by:") : new JFrame("Order Profiles by:");
                                MAINGUI2.this.profilesortframe.setDefaultCloseOperation(2);
                                MAINGUI2.this.profilesortframe.setLocation(400, 300);
                                MAINGUI2.this.theDataSet.tga.bcluster = false;
                                SortTable sortTable = new SortTable(MAINGUI2.this.profilesortframe, mAINGUI2, MAINGUI2.this.theDataSet.tga, MAINGUI2.this.theDataSet);
                                sortTable.setOpaque(true);
                                MAINGUI2.this.profilesortframe.setContentPane(sortTable);
                                MAINGUI2.this.profilesortframe.pack();
                            } else {
                                MAINGUI2.this.profilesortframe.setExtendedState(0);
                            }
                            MAINGUI2.this.profilesortframe.setVisible(true);
                        }
                    });
                }
            });
            pPath3.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JFrame jFrame = new JFrame("Table of Genes Filtered");
                            jFrame.setDefaultCloseOperation(2);
                            jFrame.setLocation(20, 50);
                            FilteredTable filteredTable = new FilteredTable(jFrame, MAINGUI2.this.theDataSet);
                            filteredTable.setOpaque(true);
                            jFrame.setContentPane(filteredTable);
                            jFrame.pack();
                            jFrame.setVisible(true);
                        }
                    });
                }
            });
            pPath2.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JFrame jFrame = new JFrame("Table of Genes Passing Filter");
                            jFrame.setDefaultCloseOperation(2);
                            jFrame.setLocation(20, 50);
                            MainTable mainTable = new MainTable(jFrame, MAINGUI2.this.theDataSet, MAINGUI2.this.thegeneplotpanel, MAINGUI2.this.cf);
                            mainTable.setOpaque(true);
                            jFrame.setContentPane(mainTable);
                            jFrame.pack();
                            jFrame.setVisible(true);
                        }
                    });
                }
            });
            this.canvas.getLayer().addChild(pPath2);
            if (this.bsaveprofile) {
                this.profilenodes = new PNode[this.profilelookup.length];
            }
            int n9 = NUSED;
            if (this.savedcolors == null) {
                this.savedcolors = new Color[this.profilelookup.length];
                bl = true;
            } else {
                bl = false;
            }
            double[] dArray = new double[this.theDataSet.modelprofiles.length];
            double d10 = 0.0;
            for (int i = 0; i < this.theDataSet.modelprofiles.length; ++i) {
                dArray[i] = 0.0;
                for (int j = 0; j < this.theDataSet.modelprofiles[i].length; ++j) {
                    double d11 = Math.abs(this.theDataSet.modelprofiles[i][j]);
                    if (d11 > d10) {
                        d10 = d11;
                    }
                    if (!(d11 > dArray[i])) continue;
                    dArray[i] = d11;
                }
                dArray[i] = (double)(this.theDataSet.modelprofiles[0].length - 1) / dArray[i];
            }
            d10 = (double)(this.theDataSet.modelprofiles[0].length - 1) / d10;
            double d12 = 0.0;
            if (this.ngenescale == 2 && this.ngenedisplay >= 1) {
                for (int i = 0; i < this.profilelookup.length; ++i) {
                    int n10;
                    int n11 = this.profilelookup[i];
                    ArrayList arrayList = this.theDataSet.profilesAssigned[n11];
                    n3 = arrayList.size();
                    for (n10 = 0; n10 < n3; ++n10) {
                        n2 = (Integer)arrayList.get(n10);
                        if (this.bscalevisible && this.ngenedisplay != 2 && !this.theDataSet.tga.isOrder(this.theDataSet.genenames[n2])) continue;
                        for (n = 0; n < this.theDataSet.data[n2].length; ++n) {
                            if (this.theDataSet.pmavalues[n2][n] <= 0 || !(Math.abs(this.theDataSet.data[n2][n]) > d12)) continue;
                            d12 = Math.abs(this.theDataSet.data[n2][n]);
                        }
                    }
                    if (!this.theDataSet.bkmeans) continue;
                    for (n10 = 0; n10 < this.theDataSet.modelprofiles[i].length; ++n10) {
                        d12 = Math.max(d12, this.theDataSet.modelprofiles[i][n10]);
                    }
                }
                if (d12 > 0.0) {
                    d12 = (double)(this.theDataSet.data[0].length - 1) / d12;
                }
            }
            this.theDataSet.dwidthunitsCum = new double[this.theDataSet.dsamplemins.length];
            this.theDataSet.dwidthunitsCum[0] = 0.0;
            boolean bl2 = true;
            try {
                double d13 = Util.removeUnits(this.theDataSet.dsamplemins[0]);
                for (n3 = 0; n3 < this.theDataSet.dwidthunitsCum.length - 1 && bl2; ++n3) {
                    double d14 = Util.removeUnits(this.theDataSet.dsamplemins[n3 + 1]);
                    this.theDataSet.dwidthunitsCum[n3 + 1] = this.theDataSet.dwidthunitsCum[n3] + (d14 - d13);
                    if (d14 < d13) {
                        bl2 = false;
                        this.buniformXaxis = true;
                        this.binvalidreal = true;
                    }
                    d13 = d14;
                }
                double d15 = this.theDataSet.dwidthunitsCum[this.theDataSet.dwidthunitsCum.length - 1];
                for (n2 = 1; n2 < this.theDataSet.dwidthunitsCum.length; ++n2) {
                    this.theDataSet.dwidthunitsCum[n2] = this.theDataSet.dwidthunitsCum[n2] / d15;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                for (int i = 1; i < this.theDataSet.dwidthunitsCum.length; ++i) {
                    this.theDataSet.dwidthunitsCum[i] = (double)i / (double)(this.theDataSet.dsamplemins.length - 1);
                }
                this.buniformXaxis = true;
                this.binvalidreal = true;
            }
            if (this.buniformXaxis || !bl2) {
                for (int i = 1; i < this.theDataSet.dwidthunitsCum.length; ++i) {
                    this.theDataSet.dwidthunitsCum[i] = (double)i / (double)(this.theDataSet.dsamplemins.length - 1);
                }
            }
            int n12 = 0;
            while (n12 < this.profilelookup.length) {
                int n13;
                int n14;
                int n15;
                Object object2;
                PPath pPath6 = PPath.createRectangle(0.0f, 0.0f, (float)d8, (float)d9);
                double d16 = (double)BUFFERLEFT + d4 * d * (double)(n12 % n6);
                double d17 = (double)BUFFERTOP + d4 * d * (double)(n12 / n6);
                n = this.profilelookup[n12];
                if (bl) {
                    if (this.cluster[n] == n5) {
                        object2 = new Color(1.0f, 1.0f, 1.0f, 0.4f);
                        pPath6.setPaint((Paint)object2);
                    } else if (this.cluster[n] + n9 >= this.clustercolors.length) {
                        while (this.cluster[n] - this.clustercolors.length + n9 >= coloroverflow.size()) {
                            ++NUSED;
                            coloroverflow.add(new Color((float)(Math.random() * 0.8 + 0.05), (float)(Math.random() * 0.8 + 0.05), (float)(Math.random() * 0.8 + 0.05), 0.4f));
                        }
                        object2 = (Color)coloroverflow.get(this.cluster[n] + n9 - this.clustercolors.length);
                        pPath6.setPaint((Paint)object2);
                    } else {
                        if (this.cluster[n] + n9 >= NUSED) {
                            NUSED = this.cluster[n] + n9 + 1;
                        }
                        object2 = this.clustercolors[this.cluster[n] + n9];
                        pPath6.setPaint((Paint)object2);
                    }
                    this.savedcolors[n] = object2;
                } else {
                    pPath6.setPaint(this.savedcolors[n]);
                }
                object2 = new float[]{0.0f, 0.0f};
                float[] fArray = new float[]{0.0f, 0.0f};
                ArrayList arrayList = this.theDataSet.profilesAssigned[n];
                int n16 = arrayList.size();
                if (this.ngenescale == 1 && this.ngenedisplay >= 1) {
                    d12 = 0.0;
                    for (int i = 0; i < n16; ++i) {
                        int n17 = (Integer)arrayList.get(i);
                        if (this.ngenedisplay != 2 && this.bscalevisible && !this.theDataSet.tga.isOrder(this.theDataSet.genenames[n17])) continue;
                        for (n15 = 0; n15 < this.theDataSet.data[n17].length; ++n15) {
                            if (this.theDataSet.pmavalues[n17][n15] <= 0 || !(Math.abs(this.theDataSet.data[n17][n15]) > d12)) continue;
                            d12 = Math.abs(this.theDataSet.data[n17][n15]);
                        }
                    }
                    if (d12 > 0.0) {
                        d12 = (double)(this.theDataSet.data[0].length - 1) / d12;
                    }
                }
                double d18 = this.ngenescale >= 1 ? 1.0 : 0.75;
                n15 = 0;
                if (!(this.ngenedisplay < 1 || this.theDataSet.bkmeans && this.ngenescale < 1)) {
                    for (int i = 0; i < n16; ++i) {
                        n14 = (Integer)arrayList.get(i);
                        if (this.ngenedisplay != 2 && !this.theDataSet.tga.isOrder(this.theDataSet.genenames[n14])) continue;
                        if (this.ngenescale == 0) {
                            d12 = 0.0;
                            for (n13 = 0; n13 < this.theDataSet.data[n14].length; ++n13) {
                                if (this.theDataSet.pmavalues[n14][n13] <= 0 || !(Math.abs(this.theDataSet.data[n14][n13]) > d12)) continue;
                                d12 = Math.abs(this.theDataSet.data[n14][n13]);
                            }
                            if (d12 > 0.0) {
                                d12 = (double)(this.theDataSet.data[0].length - 1) / d12;
                            }
                        } else {
                            n15 = 1;
                        }
                        for (n13 = 0; n13 < this.theDataSet.data[0].length - 1; ++n13) {
                            if (this.theDataSet.pmavalues[n14][n13] <= 0 || this.theDataSet.pmavalues[n14][n13 + 1] <= 0) continue;
                            object2[0] = (float)(d * this.theDataSet.dwidthunitsCum[n13] * (double)(this.theDataSet.data[0].length - 1));
                            object2[1] = (float)(d * this.theDataSet.dwidthunitsCum[n13 + 1] * (double)(this.theDataSet.data[0].length - 1));
                            fArray[0] = (float)(d / 2.0 * ((double)(this.theDataSet.numcols - 1) - d18 * d12 * this.theDataSet.data[n14][n13]));
                            fArray[1] = (float)(d / 2.0 * ((double)(this.theDataSet.numcols - 1) - d18 * d12 * this.theDataSet.data[n14][n13 + 1]));
                            PPath pPath7 = PPath.createPolyline((float[])object2, fArray);
                            pPath7.setStrokePaint(this.thegenecolor);
                            pPath6.addChild(pPath7);
                        }
                    }
                }
                if ((n15 != 0 || this.theDataSet.bkmeans) && this.bdisplaymaintick) {
                    double d19 = this.theDataSet.bkmeans ? (this.ngenescale == 0 || d12 == 0.0 ? d10 : d12) : dArray[n];
                    d19 = n15 == 0 && this.theDataSet.bkmeans ? d10 : d12;
                    n13 = 1;
                    double d20 = 0.0;
                    while (n13 != 0) {
                        fArray[0] = (float)(d / 2.0 * ((double)(this.theDataSet.numcols - 1) - d18 * d19 * d20));
                        if (fArray[0] < 0.0f) {
                            n13 = 0;
                        } else {
                            object2[0] = 0.0f;
                            object2[1] = d20 == 0.0 ? (Object)((float)(0.2 * d8)) : (Object)((float)(0.1 * d8));
                            fArray[1] = fArray[0];
                            PPath pPath8 = PPath.createPolyline((float[])object2, fArray);
                            pPath8.setStrokePaint(Color.black);
                            pPath6.addChild(pPath8);
                            pPath8.setVisible(true);
                            fArray[0] = (float)(d / 2.0 * ((double)(this.theDataSet.numcols - 1) + d18 * d19 * d20));
                            fArray[1] = fArray[0];
                            PPath pPath9 = PPath.createPolyline((float[])object2, fArray);
                            pPath9.setStrokePaint(Color.black);
                            pPath6.addChild(pPath9);
                            pPath9.setVisible(true);
                        }
                        d20 += this.dtickintervalmain;
                    }
                }
                if (this.bdisplayprofileline) {
                    double[] dArray2 = this.theDataSet.modelprofiles[n];
                    for (n14 = 0; n14 < this.theDataSet.numcols; ++n14) {
                        object2[0] = object2[1];
                        fArray[0] = fArray[1];
                        object2[1] = (float)(d * this.theDataSet.dwidthunitsCum[n14] * (double)(this.theDataSet.data[0].length - 1));
                        fArray[1] = this.theDataSet.bkmeans ? (this.ngenescale == 0 || d12 == 0.0 ? (float)(d / 2.0 * ((double)(this.theDataSet.numcols - 1) - d10 * dArray2[n14])) : (float)(d / 2.0 * ((double)(this.theDataSet.numcols - 1) - d12 * dArray2[n14]))) : (float)(d / 2.0 * ((double)(this.theDataSet.numcols - 1) - 0.75 * dArray[n] * dArray2[n14]));
                        if (n14 < 1) continue;
                        PPath pPath10 = PPath.createPolyline((float[])object2, fArray);
                        pPath10.setStrokePaint(Color.black);
                        pPath10.setVisible(true);
                        pPath6.addChild(pPath10);
                    }
                }
                if (this.thegeneplotframe == null) {
                    this.thegeneplotframe = new JFrame("Interface Options");
                    this.thegeneplotframe.setDefaultCloseOperation(2);
                    this.thegeneplotframe.setLocation(400, 150);
                    this.thegeneplotpanel = new GenePlotPanel(this.thegeneplotframe, mAINGUI2, this.theDataSet.bkmeans);
                    this.thegeneplotpanel.setOpaque(true);
                    this.thegeneplotframe.setContentPane(this.thegeneplotpanel);
                    this.thegeneplotframe.pack();
                    this.thegeneplotframe.setVisible(false);
                }
                String string3 = "" + n;
                if (this.bdisplayID) {
                    PText pText7 = new PText(string3);
                    pText7.setFont(new Font("times", 0, (int)(0.85 * ((double)this.theDataSet.numcols / 5.0) * Math.ceil(d))));
                    pText7.setVisible(true);
                    pText7.translate(d / 8.0, -1.0);
                    pPath6.addChild(pText7);
                }
                if (this.bdisplaydetail) {
                    this.profilenodes[this.profilelookup[n12]] = (PNode)pPath6.clone();
                    if ((this.theDataSet.tga.szsortcommand.equals("go") || this.theDataSet.tga.szsortcommand.equals("define")) && this.theDataSet.tga.bcluster && this.theDataSet.tga.tpgr[n12].dclusterpval < 1.5) {
                        string3 = "" + MAINGUI2.doubleToSz(this.theDataSet.tga.tpgr[n12].dclusterpval);
                        PText pText8 = new PText(string3);
                        pText8.setFont(new Font("times", 0, (int)(0.8 * ((double)this.theDataSet.numcols / 5.0) * Math.ceil(d))));
                        double d21 = d8 - (double)string3.length() / 2.0 * (double)((int)(0.8 * ((double)this.theDataSet.numcols / 5.0) * Math.ceil(d)));
                        pText8.translate(d21, 0.0);
                        pPath6.addChild(pText8);
                        pText8.setVisible(true);
                    }
                    if (this.theDataSet.tga.szsortcommand.equals("expgo") || this.theDataSet.tga.szsortcommand.equals("go") || this.theDataSet.tga.szsortcommand.equals("expdefine") || this.theDataSet.tga.szsortcommand.equals("define")) {
                        string3 = "" + (int)Math.round(this.theDataSet.tga.tpgr[n12].dgenes) + ";" + MAINGUI2.doubleToSz(this.theDataSet.tga.tpgr[n12].dpval);
                        PText pText9 = new PText(string3);
                        pText9.setFont(new Font("times", 0, (int)(0.8 * ((double)this.theDataSet.numcols / 5.0) * Math.ceil(d))));
                        pText9.translate(d / 9.0, d9 - d * ((double)this.theDataSet.numcols / 5.0));
                        pPath6.addChild(pText9);
                        pText9.setVisible(true);
                    }
                    if (this.theDataSet.tga.szsortcommand.equals("sig")) {
                        string3 = "" + MAINGUI2.doubleToSz(this.theDataSet.pvaluesassignments[n]);
                        PText pText10 = new PText(string3);
                        pText10.setFont(new Font("times", 0, (int)(0.8 * ((double)this.theDataSet.numcols / 5.0) * Math.ceil(d))));
                        pText10.translate(d / 9.0, d9 - d * ((double)this.theDataSet.numcols / 5.0));
                        pPath6.addChild(pText10);
                        pText10.setVisible(true);
                    }
                    if (this.theDataSet.tga.szsortcommand.equals("exp")) {
                        string3 = "" + (int)Math.round(this.theDataSet.expectedassignments[n]);
                        PText pText11 = new PText(string3);
                        pText11.setFont(new Font("times", 0, (int)(0.8 * ((double)this.theDataSet.numcols / 5.0) * Math.ceil(d))));
                        pText11.translate(d / 9.0, d9 - d * ((double)this.theDataSet.numcols / 5.0));
                        pPath6.addChild(pText11);
                        pText11.setVisible(true);
                    }
                    if (this.theDataSet.tga.szsortcommand.equals("num")) {
                        string3 = "" + (int)Math.round(this.theDataSet.countassignments[n]);
                        PText pText12 = new PText(string3);
                        pText12.setFont(new Font("times", 0, (int)(0.8 * ((double)this.theDataSet.numcols / 5.0) * Math.ceil(d))));
                        pText12.translate(d / 9.0, d9 - d * ((double)this.theDataSet.numcols / 5.0));
                        pPath6.addChild(pText12);
                        pText12.setVisible(true);
                    }
                }
                n13 = n12++;
                pPath6.addInputEventListener(new PBasicInputEventHandler(){

                    public void mousePressed(PInputEvent pInputEvent) {
                        if (pInputEvent.getButton() == 1) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    ProfileGui profileGui = new ProfileGui(MAINGUI2.this.theDataSet, MAINGUI2.this.profilelookup[n13], MAINGUI2.this.ranklookup, null, -1, null, null, null, MAINGUI2.this.thegeneplotpanel, MAINGUI2.this.cf);
                                    MAINGUI2.this.openProfiles.add(profileGui);
                                    profileGui.addWindowListener(new WindowAdapter(){

                                        public void windowClosing(WindowEvent windowEvent) {
                                            int n = MAINGUI2.this.openProfiles.indexOf(windowEvent.getSource());
                                            if (n >= 0) {
                                                MAINGUI2.this.openProfiles.remove(n);
                                            }
                                        }
                                    });
                                    profileGui.setLocation(20, 50);
                                    profileGui.setDefaultCloseOperation(2);
                                    profileGui.pack();
                                    profileGui.setSize(new Dimension(SCREENWIDTH, SCREENHEIGHT));
                                    profileGui.setVisible(true);
                                }
                            });
                        }
                    }
                });
                pPath6.translate(d16, d17);
                this.canvas.getLayer().addChild(pPath6);
            }
            this.bsaveprofile = false;
            for (n12 = 0; n12 < this.openProfiles.size(); ++n12) {
                ((ProfileGui)this.openProfiles.get(n12)).repaint();
            }
            if (this.thecomparegui != null) {
                this.thecomparegui.drawcomparemain();
            }
        }
    }

    public void makeCompareDialog() {
        this.theOptions = new JDialog(this, "Compare ", false);
        Container container = this.theOptions.getContentPane();
        container.setBackground(Color.white);
        this.makeComparePanel(this.theOptions.getContentPane());
        this.theOptions.pack();
        this.theOptions.setDefaultCloseOperation(2);
        this.theOptions.setLocation(this.getX(), this.getY() + 200);
        this.theOptions.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                boolean bl = true;
                try {
                    MAINGUI2.this.thespinnersigLevel.commitEdit();
                    MAINGUI2.this.thespinnernumgenes.commitEdit();
                }
                catch (ParseException parseException) {
                    Toolkit.getDefaultToolkit().beep();
                    bl = false;
                }
                if (bl) {
                    MAINGUI2.this.theOptions.setVisible(false);
                }
            }
        });
    }

    public void makeHelpDialog(Component component) {
        JDialog jDialog = new JDialog(this, "Help", false);
        Container container = jDialog.getContentPane();
        jDialog.setBackground(Color.white);
        container.setBackground(Color.white);
        String string = "";
        JTextArea jTextArea = null;
        if (component == this.executecompareHButton) {
            string = this.theDataSet.bkmeans ? "Pressing this button will open two new windows.  One window contains the main K-means clusters interface for the comparison data, while the other window is the main comparison window which shows pairs of clusters one from each experiment with a significant number of genes in their intersection." : "Pressing this button will open two new windows.  One window contains the model profile overview for the comparison data, while the other window is the main comparison window which shows pairs of profiles one from each experiment with a significant number of genes in their intersection.";
        }
        if (component == this.compare1HButton) {
            string = "This field specifies a data file for the comparison experiment.  The data file needs to be in the same format as an original data set file and have the same number of time points.";
        } else if (component == this.compare2HButton) {
            string = "Pressing this button opens a dialog window through which to specify data for the repeat comparison experiments.  The data needs to be in the same format as an original data set file and have the same number of time points.  If the button is yellow then there is currently repeat data loaded, otherwise the button is gray.";
        } else if (component == this.sigLevelHButton) {
            string = this.theDataSet.bkmeans ? "The maximum uncorrected p-value (based on the hypergeometric distribution) of the intersection of genes assigned to two K-means clusters for the intersection to be considered significant.  One of the clusters is from the original data set (the currently displayed data set) and the other cluster comes from the comparison data set being specified." : "The maximum uncorrected p-value (based on the hypergeometric distribution) of the intersection of genes assigned to two profiles for the intersection to be considered significant.  One of the profiles is from the original data set (the currently displayed data set) and the other profile comes from the comparison data set being specified.";
        } else if (component == this.numgenesHButton) {
            string = this.theDataSet.bkmeans ? "The minimum number of genes required to be in the intersection of two K-means clusters for the intersection to be considered significant. One of the clusters is from the original data set (the currently displayed data set) and the other clusters comes from the comparison data set being specified." : "The minimum number of genes required to be in the intersection of two profiles for the intersection to be considered significant. One of the profiles is from the original data set (the currently displayed data set) and the other profile comes from the comparison data set being specified.";
        } else if (component == this.viewHButton) {
            string = "Pressing the 'View Comparison Data File' displays the contents of the file listed in the above textbox.";
        }
        jTextArea = new JTextArea(string, 7, 60);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBackground(Color.white);
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        container.add(jScrollPane);
        jDialog.setLocation(this.theOptions.getX() + 50, this.theOptions.getY() + 10);
        jDialog.pack();
        jDialog.setDefaultCloseOperation(2);
        jDialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final Object object = actionEvent.getSource();
        if (object == this.compare1HButton || object == this.compare2HButton || object == this.executecompareHButton || object == this.sigLevelHButton || object == this.viewHButton || object == this.numgenesHButton) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MAINGUI2.this.makeHelpDialog((Component)object);
                }
            });
        } else if (object == this.browse1Button) {
            int n = ST.fc.showOpenDialog(this);
            if (n == 0) {
                File file = ST.fc.getSelectedFile();
                this.compare1Field.setText(file.getAbsolutePath());
            }
        } else if (object == this.viewButton) {
            final String string = this.compare1Field.getText();
            final MAINGUI2 mAINGUI2 = this;
            if (new File(string).exists()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DataTable dataTable = new DataTable(mAINGUI2, string, false);
                        JFrame jFrame = new JFrame(string);
                        jFrame.setDefaultCloseOperation(2);
                        jFrame.setLocation(20, 50);
                        dataTable.setOpaque(true);
                        jFrame.setContentPane(dataTable);
                        jFrame.pack();
                        jFrame.setVisible(true);
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(mAINGUI2, "File '" + string + "' was not found.", "Error", 0);
                    }
                });
            }
        } else if (object == this.repeatButton) {
            this.theCompareRepeatList.setLocation(this.theOptions.getX() + 75, this.theOptions.getY());
            this.theCompareRepeatList.setVisible(true);
        } else if (object == this.compareButtonDialog) {
            String string = this.compare1Field.getText();
            String string2 = this.thespinnersigLevel.getValue().toString();
            String string3 = this.thespinnernumgenes.getValue().toString();
            try {
                boolean bl = this.theCompareRepeatList.allButton.isSelected();
                final CompareInfo compareInfo = new CompareInfo(this.theDataSet, string, string2, string3, this.theCompareRepeatList.data, bl, this.cf);
                compareInfo.comparesetfmnel.otherset = this.theDataSet;
                compareInfo.comparesetfmnel.bothersetorigset = true;
                this.theDataSet.otherset = compareInfo.comparesetfmnel;
                this.theDataSet.bothersetorigset = false;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            DefineGeneSet defineGeneSet;
                            SortTable sortTable;
                            compareInfo.compareframe.thecomparegui = MAINGUI2.this.thecomparegui = new CompareGui(compareInfo, MAINGUI2.this.profilenodes, MAINGUI2.this.thegeneplotpanel, MAINGUI2.this.cf);
                            PCanvas.CURRENT_ZCANVAS = null;
                            if (MAINGUI2.this.profilesortframe != null) {
                                sortTable = (SortTable)MAINGUI2.this.profilesortframe.getContentPane();
                                if (sortTable.defineframe != null) {
                                    defineGeneSet = (DefineGeneSet)sortTable.defineframe.getContentPane();
                                    defineGeneSet.selectgenesButton.setEnabled(true);
                                }
                            }
                            if (MAINGUI2.this.clustersortframe != null) {
                                sortTable = (SortTable)MAINGUI2.this.clustersortframe.getContentPane();
                                if (sortTable.defineframe != null) {
                                    defineGeneSet = (DefineGeneSet)sortTable.defineframe.getContentPane();
                                    defineGeneSet.selectgenesButton.setEnabled(true);
                                }
                            }
                            MAINGUI2.this.thecomparegui.setDefaultCloseOperation(2);
                            MAINGUI2.this.thecomparegui.setLocation(35, 80);
                            MAINGUI2.this.thecomparegui.setVisible(true);
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(null, exception.getMessage(), "Exception thrown", 0);
                            exception.printStackTrace(System.out);
                        }
                    }
                });
                this.theOptions.setVisible(false);
                this.theOptions.dispose();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, exception.getMessage(), "Exception thrown", 0);
                exception.printStackTrace(System.out);
            }
        }
    }

    protected void makeComparePanel(Container container) {
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.thespinnersigLevel.getEditor();
        DecimalFormat decimalFormat = numberEditor.getFormat();
        decimalFormat.setMaximumFractionDigits(4);
        this.thespinnersigLevel.setPreferredSize(new Dimension(60, 24));
        this.thespinnersigLevel.setMaximumSize(new Dimension(60, 24));
        BoxLayout boxLayout = new BoxLayout(container, 1);
        container.setLayout(boxLayout);
        container.setBackground(ST.lightBlue);
        JPanel jPanel = new JPanel(new SpringLayout());
        jPanel.add(this.compare1Label);
        this.compare1Field.setColumns(ST.NUMCOLS);
        jPanel.add(this.compare1Field);
        jPanel.add(this.browse1Button);
        this.compare1HButton.addActionListener(this);
        jPanel.add(this.compare1HButton);
        SpringUtilities.makeCompactGrid(jPanel, 1, 4, 6, 6, 6, 6);
        jPanel.setBackground(ST.lightBlue);
        container.add(jPanel);
        JPanel jPanel2 = new JPanel(new SpringLayout());
        if (ST.vRepeatCompareDEF.size() >= 1) {
            this.repeatButton.setBackground(ST.buttonColor);
        }
        jPanel2.add(this.viewButton);
        jPanel2.add(this.viewHButton);
        jPanel2.add(this.repeatButton);
        jPanel2.add(this.compare2HButton);
        this.repeatButton.addActionListener(this);
        this.viewButton.addActionListener(this);
        this.viewHButton.addActionListener(this);
        this.compare2HButton.addActionListener(this);
        jPanel2.setBackground(ST.lightBlue);
        SpringUtilities.makeCompactGrid(jPanel2, 2, 2, 6, 6, 6, 6);
        container.add(jPanel2);
        this.browse1Button.addActionListener(this);
        JPanel jPanel3 = new JPanel(new SpringLayout());
        jPanel3.setBackground(ST.lightBlue);
        jPanel3.add(this.sigLevelLabel);
        this.thespinnernumgenes.setPreferredSize(new Dimension(60, 24));
        this.thespinnernumgenes.setMaximumSize(new Dimension(60, 24));
        jPanel3.add(this.thespinnersigLevel);
        this.sigLevelHButton.addActionListener(this);
        jPanel3.add(this.sigLevelHButton);
        jPanel3.add(this.numgenesLabel);
        jPanel3.add(this.thespinnernumgenes);
        this.numgenesHButton.addActionListener(this);
        jPanel3.add(this.numgenesHButton);
        SpringUtilities.makeCompactGrid(jPanel3, 2, 3, 6, 6, 6, 6);
        container.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBackground(ST.lightBlue);
        this.compareButtonDialog.setBackground(ST.buttonColor);
        this.compareButtonDialog.addActionListener(this);
        this.compareButtonDialog.setPreferredSize(new Dimension(250, 30));
        this.compareButtonDialog.setMinimumSize(new Dimension(250, 30));
        this.compareButtonDialog.setMaximumSize(new Dimension(300, 30));
        this.executecompareHButton.addActionListener(this);
        jPanel4.add(this.compareButtonDialog);
        jPanel4.add(this.executecompareHButton);
        container.add(jPanel4);
    }

    public void printDefaults(PrintWriter printWriter) {
        int n;
        printWriter.println("#Main Input:");
        printWriter.println("Data_File\t" + this.theDataSet.szInputFile);
        printWriter.println("Gene_Annotation_Source\t" + this.theDataSet.tga.szorganismsourceval);
        printWriter.println("Gene_Annotation_File\t" + this.theDataSet.tga.szGoFile);
        printWriter.println("Cross_Reference_Source\t" + this.theDataSet.tga.szxrefsourceval);
        printWriter.println("Cross_Reference_File\t" + this.theDataSet.tga.szxrefval);
        printWriter.println("Gene_Location_Source\t" + this.cf.genomeParser.szchromsourceval);
        printWriter.println("Gene_Location_File\t" + this.cf.genomeParser.szchromval);
        if (this.theDataSet.bkmeans) {
            printWriter.println("Clustering_Method[STEM Clustering Method,K-means]\tK-means");
            printWriter.println("Number_of_Clusters_K\t" + this.theDataSet.nmaxprofiles);
            printWriter.println("Number_of_Random_Starts\t" + this.theDataSet.nmaxchange);
        } else {
            printWriter.println("Clustering_Method[STEM Clustering Method,K-means]\tSTEM Clustering Method");
            printWriter.println("Maximum_Number_of_Model_Profiles\t" + this.theDataSet.nmaxprofiles);
            printWriter.println("Maximum_Unit_Change_in_Model_Profiles_between_Time_Points\t" + this.theDataSet.nmaxchange);
        }
        printWriter.print("Normalize_Data[Log normalize data,Normalize data,No normalization/add 0]\t");
        if (this.theDataSet.btakelog) {
            printWriter.println("Log normalize data");
        } else if (this.theDataSet.badd0) {
            printWriter.println("No normalization/add 0");
        } else {
            printWriter.println("Normalize data");
        }
        printWriter.println("Spot_IDs_included_in_the_data_file\t" + this.theDataSet.bspotincluded);
        printWriter.println();
        printWriter.println("#Repeat data");
        printWriter.print("Repeat_Data_Files(comma delimited list)\t");
        if (this.theDataSet.otherInputFiles != null) {
            for (n = 0; n < this.theDataSet.otherInputFiles.length; ++n) {
                printWriter.print(this.theDataSet.otherInputFiles[n]);
                if (n >= this.theDataSet.otherInputFiles.length - 1) continue;
                printWriter.print(",");
            }
        }
        printWriter.println();
        printWriter.print("Repeat_Data_is_from[Different time periods,The same time period]\t");
        if (this.theDataSet.bfullrepeat) {
            printWriter.println("Different time periods");
        } else {
            printWriter.println("The same time period");
        }
        printWriter.println();
        printWriter.println("#Comparison Data:");
        if (this.thecomparegui != null) {
            printWriter.println("Comparison_Data_File\t" + this.thecomparegui.theCompareInfo.comparesetfmnel.szInputFile);
            printWriter.print("Comparison_Repeat_Data_Files(comma delimited list)\t");
            if (this.theDataSet.otherInputFiles != null) {
                for (n = 0; n < this.theDataSet.otherInputFiles.length; ++n) {
                    printWriter.print(this.thecomparegui.theCompareInfo.comparesetfmnel.otherInputFiles[n]);
                    if (n >= this.thecomparegui.theCompareInfo.comparesetfmnel.otherInputFiles.length - 1) continue;
                    printWriter.print(",");
                }
            }
            printWriter.println();
            printWriter.print("Comparison_Repeat_Data_is_from[Different time periods,The same time period]\t");
            if (this.thecomparegui.theCompareInfo.comparesetfmnel.bfullrepeat) {
                printWriter.println("Different time periods");
            } else {
                printWriter.println("The same time period");
            }
            printWriter.println("Comparison_Minimum_Number_of_genes_in_intersection\t" + this.thecomparegui.theCompareInfo.nminnumgenes);
            printWriter.println("Comparison_Maximum_Uncorrected_Intersection_pvalue\t" + this.thecomparegui.theCompareInfo.dmaxpval);
        } else {
            printWriter.println("Comparison_Data_File\t" + ST.szCompareDEF);
            printWriter.print("Comparison_Repeat_Data_Files(comma delimited list)\t");
            if (this.theDataSet.otherInputFiles != null) {
                n = ST.vRepeatCompareDEF.size();
                for (int i = 0; i < n; ++i) {
                    printWriter.print(ST.vRepeatCompareDEF.get(i));
                    if (i >= n - 1) continue;
                    printWriter.print(",");
                }
            }
            printWriter.println();
            printWriter.print("Comparison_Repeat_Data_is_from[Different time periods,The same time period]\t");
            if (ST.bcomparealltimeDEF) {
                printWriter.println("Different time periods");
            } else {
                printWriter.println("The same time period");
            }
            printWriter.println("Comparison_Minimum_Number_of_genes_in_intersection\t" + ST.nCompareMinGenesDEF);
            printWriter.println("Comparison_Maximum_Uncorrected_Intersection_pvalue\t" + ST.dCompareMinpvalDEF);
        }
        printWriter.println();
        printWriter.println("#Filtering:");
        printWriter.println("Maximum_Number_of_Missing_Values\t" + this.theDataSet.nmaxmissing);
        printWriter.println("Minimum_Correlation_between_Repeats\t" + this.theDataSet.dmincorrelation);
        printWriter.println("Minimum_Absolute_Log_Ratio_Expression\t" + this.theDataSet.dthresholdvalue);
        printWriter.print("Change_should_be_based_on[Maximum-Minimum,Difference From 0]\t");
        if (this.theDataSet.bmaxminval) {
            printWriter.println("Maximum-Minimum");
        } else {
            printWriter.println("Difference From 0");
        }
        printWriter.println("Pre-filtered_Gene_File\t" + this.theDataSet.tga.szextraval);
        printWriter.println();
        if (!this.theDataSet.bkmeans) {
            printWriter.println("#Model Profiles");
            printWriter.println("Maximum_Correlation\t" + this.theDataSet.dmaxcorrmodel);
            printWriter.println("Number_of_Permutations_per_Gene\t" + this.theDataSet.nsamplesgene);
            printWriter.println("Maximum_Number_of_Candidate_Model_Profiles\t" + this.theDataSet.nsamplesmodel);
            printWriter.println("Significance_Level\t" + this.theDataSet.alpha);
            printWriter.print("Correction_Method[Bonferroni,False Discovery Rate,None]\t");
            if (this.theDataSet.nfdr == 0) {
                printWriter.println("None");
            } else if (this.theDataSet.nfdr == 1) {
                printWriter.println("False Discovery Rate");
            } else if (this.theDataSet.nfdr == 2) {
                printWriter.println("Bonferroni");
            }
            printWriter.println("Permutation_Test_Should_Permute_Time_Point_0\t" + this.theDataSet.ballpermuteval);
            printWriter.println();
            printWriter.println("#Clustering Profiles:");
            printWriter.println("Clustering_Minimum_Correlation\t" + this.theDataSet.dminclustdist);
            printWriter.println("Clustering_Minimum_Correlation_Percentile\t" + this.theDataSet.dpercentileclust);
            printWriter.println();
        }
        printWriter.println("#Gene Annotations:");
        printWriter.println("Category_ID_File\t" + this.theDataSet.tga.szcategoryIDval);
        printWriter.println("Include_Biological_Process\t" + this.theDataSet.tga.bpontoval);
        printWriter.println("Include_Molecular_Function\t" + this.theDataSet.tga.bfontoval);
        printWriter.println("Include_Cellular_Process\t" + this.theDataSet.tga.bcontoval);
        printWriter.println("Only_include_annotations_with_these_evidence_codes\t" + this.theDataSet.tga.szevidenceval);
        printWriter.println("Only_include_annotations_with_these_taxon_IDs\t" + this.theDataSet.tga.sztaxonval);
        printWriter.println();
        printWriter.println("#GO Analysis:");
        printWriter.print("Multiple_hypothesis_correction_method_enrichment[Bonferroni,Randomization]\t");
        if (this.theDataSet.tga.brandomgoval) {
            printWriter.println("Randomization");
        } else {
            printWriter.println("Bonferroni");
        }
        printWriter.println("Minimum_GO_level\t" + this.theDataSet.tga.nmingolevel);
        printWriter.println("GO_Minimum_number_of_genes\t" + this.theDataSet.tga.nmingo);
        printWriter.println("Number_of_samples_for_randomized_multiple_hypothesis_correction\t" + this.theDataSet.tga.nsamplespval);
        printWriter.println();
        printWriter.println("#Interface Options");
        printWriter.print("Gene_display_policy_on_main_interface[Do not display,Display only selected,Display all]\t");
        if (this.ngenedisplay == 0) {
            printWriter.println("Do not display");
        } else if (this.ngenedisplay == 1) {
            printWriter.println("Display only selected");
        } else {
            printWriter.println("Display all");
        }
        printWriter.println("Gene_Color(R,G,B)\t" + this.thegenecolor.getRed() + "," + this.thegenecolor.getGreen() + "," + this.thegenecolor.getBlue());
        try {
            this.thegeneplotpanel.thespinnerminy.commitEdit();
            this.thegeneplotpanel.thespinnermaxy.commitEdit();
            this.thegeneplotpanel.thespinnertick.commitEdit();
            this.thegeneplotpanel.thespinnertickmain.commitEdit();
        }
        catch (ParseException parseException) {
            System.out.println("Warning could not correctly parse y-axis parameters");
        }
        double d = (Double)this.thegeneplotpanel.thespinnerminy.getValue();
        double d2 = (Double)this.thegeneplotpanel.thespinnermaxy.getValue();
        double d3 = (Double)this.thegeneplotpanel.thespinnertick.getValue();
        double d4 = (Double)this.thegeneplotpanel.thespinnertickmain.getValue();
        if (this.theDataSet.bkmeans) {
            printWriter.println("Display_Cluster_Mean\t" + this.bdisplayprofileline);
            printWriter.println("Display_K-Means_Cluster_ID\t" + this.bdisplayID);
        } else {
            printWriter.println("Display_Model_Profile\t" + this.bdisplayprofileline);
            printWriter.println("Display_Profile_ID\t" + this.bdisplayID);
        }
        printWriter.println("Display_details_when_ordering\t" + this.bdisplaydetail);
        printWriter.println("Show_Main_Y-axis_gene_tick_marks\t" + this.bdisplaymaintick);
        printWriter.println("Main_Y-axis_gene_tick_interval\t" + d4);
        if (this.theDataSet.bkmeans) {
            printWriter.print("Y-axis_scale_for_genes_on_k-means_main_interface_should_be[Cluster specific,Global]\t");
        } else {
            printWriter.print("Y-axis_scale_for_genes_on_main_interface_should_be[Gene specific,Profile specific,Global]\t");
        }
        if (this.ngenescale == 0) {
            printWriter.println("Gene specific");
        } else if (this.ngenescale == 1) {
            printWriter.println("Profile specific");
        } else {
            printWriter.println("Global");
        }
        printWriter.println("Scale_should_be_based_on_only_selected_genes\t" + this.bscalevisible);
        boolean bl = this.thegeneplotpanel.automaticButton.isSelected();
        printWriter.print("Y-axis_scale_on_details_windows_should_be[Determined automatically,Fixed]\t");
        if (bl) {
            printWriter.println("Determined automatically");
        } else {
            printWriter.println("Fixed");
        }
        printWriter.println("Y_Scale_Min\t" + d);
        printWriter.println("Y_Scale_Max\t" + d2);
        printWriter.println("Tick_interval\t" + d3);
        printWriter.print("X-axis_scale_should_be[Uniform,Based on real time]\t");
        if (this.buniformXaxis) {
            printWriter.println("Uniform");
        } else {
            printWriter.println("Based on real time");
        }
        printWriter.close();
    }

    public static class ProfilesigComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            ProfileSortRec profileSortRec = (ProfileSortRec)object;
            ProfileSortRec profileSortRec2 = (ProfileSortRec)object2;
            if (profileSortRec.dpval < profileSortRec2.dpval) {
                return -1;
            }
            if (profileSortRec.dpval > profileSortRec2.dpval) {
                return 1;
            }
            if (profileSortRec.dgenes < profileSortRec2.dgenes) {
                return 1;
            }
            if (profileSortRec.dgenes > profileSortRec2.dgenes) {
                return -1;
            }
            if (profileSortRec.dexpectedgenes < profileSortRec2.dexpectedgenes) {
                return -1;
            }
            if (profileSortRec.dexpectedgenes > profileSortRec2.dexpectedgenes) {
                return 1;
            }
            if (profileSortRec.nprofileindex < profileSortRec2.nprofileindex) {
                return -1;
            }
            if (profileSortRec.nprofileindex > profileSortRec2.nprofileindex) {
                return 1;
            }
            return 0;
        }
    }

    public static class ProfileexpComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            ProfileSortRec profileSortRec = (ProfileSortRec)object;
            ProfileSortRec profileSortRec2 = (ProfileSortRec)object2;
            if (profileSortRec.dexpectedgenes < profileSortRec2.dexpectedgenes) {
                return 1;
            }
            if (profileSortRec.dexpectedgenes > profileSortRec2.dexpectedgenes) {
                return -1;
            }
            if (profileSortRec.nprofileindex < profileSortRec2.nprofileindex) {
                return -1;
            }
            if (profileSortRec.nprofileindex > profileSortRec2.nprofileindex) {
                return 1;
            }
            return 0;
        }
    }

    public static class ProfilenumComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            ProfileSortRec profileSortRec = (ProfileSortRec)object;
            ProfileSortRec profileSortRec2 = (ProfileSortRec)object2;
            if (profileSortRec.dgenes < profileSortRec2.dgenes) {
                return 1;
            }
            if (profileSortRec.dgenes > profileSortRec2.dgenes) {
                return -1;
            }
            if (profileSortRec.nprofileindex < profileSortRec2.nprofileindex) {
                return -1;
            }
            if (profileSortRec.nprofileindex > profileSortRec2.nprofileindex) {
                return 1;
            }
            return 0;
        }
    }

    public static class ProfileIDComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            ProfileSortRec profileSortRec = (ProfileSortRec)object;
            ProfileSortRec profileSortRec2 = (ProfileSortRec)object2;
            if (profileSortRec.nprofileindex < profileSortRec2.nprofileindex) {
                return -1;
            }
            if (profileSortRec.nprofileindex > profileSortRec2.nprofileindex) {
                return 1;
            }
            return 0;
        }
    }

    public static class ProfileComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            ProfileSortRec profileSortRec = (ProfileSortRec)object;
            ProfileSortRec profileSortRec2 = (ProfileSortRec)object2;
            if (profileSortRec.ncluster < profileSortRec2.ncluster) {
                return -1;
            }
            if (profileSortRec.ncluster > profileSortRec2.ncluster) {
                return 1;
            }
            if (profileSortRec.dpval < profileSortRec2.dpval) {
                return -1;
            }
            if (profileSortRec.dpval > profileSortRec2.dpval) {
                return 1;
            }
            if (profileSortRec.dgenes > profileSortRec2.dgenes) {
                return -1;
            }
            if (profileSortRec.dgenes < profileSortRec2.dgenes) {
                return 1;
            }
            if (profileSortRec.dexpectedgenes < profileSortRec2.dexpectedgenes) {
                return -1;
            }
            if (profileSortRec.dexpectedgenes > profileSortRec2.dexpectedgenes) {
                return 1;
            }
            if (profileSortRec.nprofileindex < profileSortRec2.nprofileindex) {
                return -1;
            }
            if (profileSortRec.nprofileindex > profileSortRec2.nprofileindex) {
                return 1;
            }
            return 0;
        }
    }

    static class ProfileSortRec {
        int ncluster;
        double dgenes;
        int nprofileindex;
        double dpval;
        double dexpectedgenes;

        ProfileSortRec(int n, int n2, double d, double d2, double d3) {
            this.ncluster = n;
            this.nprofileindex = n2;
            this.dpval = d;
            this.dgenes = d2;
            this.dexpectedgenes = d3;
        }
    }
}

