/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.stem;

import edu.cmu.cs.sb.chromviewer.ChromFrame;
import edu.cmu.cs.sb.core.TableModelST;
import edu.cmu.cs.sb.core.TableSorter;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.stem.STEM_DataSet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class GOGeneTable
extends JPanel
implements ActionListener {
    private boolean DEBUG = false;
    ChromFrame cf;
    STEM_DataSet theDataSet;
    int nprofilecluster;
    ArrayList clusterprofiles;
    String szHeaderInfo;
    String szGoID;
    String szGoCombined;
    boolean bqueryset;
    Vector columnNames;
    Vector tabledata;
    JButton saveButton;
    JButton savenamesButton;
    JButton copyButton;
    JButton copynamesButton;
    JButton chromButton;
    TableSorter sorter;
    HashSet htinames;
    String szTitle;
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    JFrame theFrame;
    boolean bjustgo;

    public GOGeneTable(JFrame jFrame, STEM_DataSet sTEM_DataSet, String string, String string2, int n, String string3, ArrayList arrayList, boolean bl, HashSet hashSet, String string4, boolean bl2, ChromFrame chromFrame) {
        Object object;
        int n2;
        int n3;
        this.theFrame = jFrame;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bg);
        this.setForeground(fg);
        this.bqueryset = bl;
        this.bjustgo = bl2;
        this.theDataSet = sTEM_DataSet;
        this.nprofilecluster = n;
        this.szHeaderInfo = string3;
        this.clusterprofiles = arrayList;
        this.htinames = hashSet;
        this.szGoID = string;
        this.szGoCombined = string2;
        this.szTitle = string4;
        this.cf = chromFrame;
        this.columnNames = new Vector();
        if (bl2) {
            n3 = 2;
        } else {
            n3 = 4;
            this.columnNames.add("Selected");
            this.columnNames.add("Weight");
        }
        this.columnNames.add(sTEM_DataSet.szGeneHeader);
        this.columnNames.add(sTEM_DataSet.szProbeHeader);
        for (n2 = 0; n2 < sTEM_DataSet.numcols; ++n2) {
            this.columnNames.add("" + sTEM_DataSet.dsamplemins[n2]);
        }
        this.tabledata = new Vector();
        n2 = 0;
        if (arrayList == null) {
            this.loadTable(sTEM_DataSet.profilesAssigned[n]);
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (STEM_DataSet.ProfileRec)arrayList.get(i);
                this.loadTable(sTEM_DataSet.profilesAssigned[((STEM_DataSet.ProfileRec)object).nprofileindex]);
            }
        }
        this.sorter = new TableSorter(new TableModelST(this.tabledata, this.columnNames));
        JTable jTable = new JTable(this.sorter);
        this.sorter.setTableHeader(jTable.getTableHeader());
        jTable.setPreferredScrollableViewportSize(new Dimension(800, Math.min((jTable.getRowHeight() + jTable.getRowMargin()) * jTable.getRowCount(), 300)));
        if (bl2) {
            object = jTable.getColumnModel().getColumn(0);
            ((TableColumn)object).setPreferredWidth(200);
            object = jTable.getColumnModel().getColumn(1);
            ((TableColumn)object).setPreferredWidth(100);
        } else {
            object = jTable.getColumnModel().getColumn(0);
            ((TableColumn)object).setPreferredWidth(40);
            object = jTable.getColumnModel().getColumn(1);
            ((TableColumn)object).setPreferredWidth(40);
            object = jTable.getColumnModel().getColumn(2);
            ((TableColumn)object).setPreferredWidth(200);
            object = jTable.getColumnModel().getColumn(3);
            ((TableColumn)object).setPreferredWidth(150);
        }
        for (int i = 0; i < sTEM_DataSet.numcols; ++i) {
            object = jTable.getColumnModel().getColumn(i + n3);
            ((TableColumn)object).setPreferredWidth(45);
        }
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.add(jScrollPane);
        this.copyButton = new JButton("Copy Table", Util.createImageIcon("Copy16.gif"));
        this.copyButton.setActionCommand("copy");
        this.copyButton.setMinimumSize(new Dimension(800, 20));
        this.copyButton.addActionListener(this);
        this.saveButton = new JButton("Save Table", Util.createImageIcon("Save16.gif"));
        this.saveButton.setActionCommand("save");
        this.saveButton.setMinimumSize(new Dimension(800, 20));
        this.saveButton.addActionListener(this);
        this.savenamesButton = new JButton("Save Gene Names", Util.createImageIcon("Save16.gif"));
        this.savenamesButton.setActionCommand("savenames");
        this.savenamesButton.setMinimumSize(new Dimension(800, 20));
        this.savenamesButton.addActionListener(this);
        this.copynamesButton = new JButton("Copy Gene Names", Util.createImageIcon("Copy16.gif"));
        this.copynamesButton.setActionCommand("copynames");
        this.copynamesButton.setMinimumSize(new Dimension(800, 20));
        this.copynamesButton.addActionListener(this);
        this.chromButton = new JButton("Chromosome View");
        if (chromFrame == null || chromFrame.genomeParser == null || chromFrame.genomeParser.szchromval.equals("")) {
            this.chromButton.setEnabled(false);
        } else {
            this.chromButton.setEnabled(true);
        }
        this.chromButton.setActionCommand("chromview");
        this.chromButton.setMinimumSize(new Dimension(800, 20));
        this.chromButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.copyButton);
        jPanel.add(this.saveButton);
        jPanel.setBackground(Color.white);
        jPanel.add(this.copynamesButton);
        jPanel.add(this.savenamesButton);
        jPanel.add(this.chromButton);
        JButton jButton = new JButton(Util.createImageIcon("Help16.gif"));
        jButton.addActionListener(this);
        jButton.setActionCommand("help");
        jPanel.add(jButton);
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("chromview")) {
            this.chromView();
        } else if (string.equals("copynames")) {
            this.writenamesToClipboard();
        } else if (string.equals("copy")) {
            this.writeToClipboard();
        } else if (string.equals("save") || string.equals("savenames")) {
            try {
                int n = Util.theChooser.showSaveDialog(this);
                if (n == 0) {
                    File file = Util.theChooser.getSelectedFile();
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                    if (string.equals("save")) {
                        this.printFile(printWriter);
                    } else {
                        this.printGeneNames(printWriter);
                    }
                    printWriter.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace(System.out);
            }
        } else if (string.equals("help")) {
            String string2 = "The table contains genes assigned to the selected GO Category and ";
            string2 = this.clusterprofiles == null ? (this.theDataSet.bkmeans ? string2 + "K-means cluster" : string2 + "profile") : string2 + "cluster of profiles (any profile the same color as this one)";
            if (this.htinames != null) {
                string2 = this.theDataSet.bkmeans ? string2 + " and to the K-means cluster to the immediate left of the yellow column in the comparison display" : string2 + " and to the profile to the immediate left of the yellow column in the comparison display";
            } else if (this.bqueryset) {
                string2 = string2 + " and also the query set";
            }
            String string3 = "";
            if (this.theDataSet.btakelog) {
                string3 = "log base two ";
            }
            string2 = this.bjustgo ? string2 + ".\n\n The first two columns of the table are: \n" : (this.theDataSet.bkmeans ? string2 + ".\n\n The first four columns of the table are: \n*  Selected - contains a 'Yes' if the gene is part the GO Category or Query Set that the K-means clusters were ordered by, otherwise is blank.\n*  Weight - Weight of the gene assignment, which is 1/(number of K-means clusters to which the gene was assigned)\n" : string2 + ".\n\n The first four columns of the table are: \n*  Selected - contains a 'Yes' if the gene is part the GO Category or Query Set that the profiles or cluster of profiles were ordered by, otherwise is blank.\n*  Weight - Weight of the gene assignment, which is 1/(number of profiles to which the gene was assigned)\n");
            string2 = string2 + "*  " + this.theDataSet.szGeneHeader + " - The name of the gene.\n" + "*  " + this.theDataSet.szProbeHeader + " - The spot ID(s) associated with the gene.\n\n";
            if (this.bjustgo) {
                if (this.columnNames.size() == 3) {
                    string2 = string2 + "The remaining column contains the " + string3 + "expression change relative to the first time point.\n\n";
                }
            } else {
                string2 = string2 + "The remaining columns contain the " + string3 + "expression change relative to the first time point.\n\n";
            }
            string2 = string2 + "Note:\n+The table can be sorted by any of the columns by clicking on the column's header.\nUsing the 'Copy Table' the entire table can be copied to the clipboard, or with the 'Copy Gene Names' button just the gene names.\n+Using the 'Copy Table' the entire table can be copied to the clipboard, or with the 'Copy Gene Names' button just the gene names.\n+Using the 'Save Table' button the entire table can be saved, or using the 'Save Gene Names' button just the gene names.\n+'Chromosome View' button plots the genes in the table on the Chromosome Viewer and makes the viewer visible if not already so. If the button is inactive then no chromosome locations were specified.";
            Util.renderDialog(this.theFrame, string2);
        }
    }

    public void printFile(PrintWriter printWriter) {
        int n;
        int n2;
        int n3;
        if (!this.bjustgo) {
            if (this.clusterprofiles == null) {
                printWriter.print(this.szTitle + " (");
                for (n3 = 0; n3 < this.theDataSet.numcols - 1; ++n3) {
                    printWriter.print(this.theDataSet.modelprofiles[this.nprofilecluster][n3] + ",");
                }
                printWriter.println(this.theDataSet.modelprofiles[this.nprofilecluster][this.theDataSet.numcols - 1] + ")");
            } else {
                printWriter.println(this.szTitle + ":");
                for (n3 = 0; n3 < this.clusterprofiles.size(); ++n3) {
                    STEM_DataSet.ProfileRec profileRec = (STEM_DataSet.ProfileRec)this.clusterprofiles.get(n3);
                    printWriter.print("\t Profile " + profileRec.nprofileindex + " (");
                    for (n2 = 0; n2 < this.theDataSet.numcols - 1; ++n2) {
                        printWriter.print(this.theDataSet.modelprofiles[profileRec.nprofileindex][n2] + ",");
                    }
                    printWriter.println(this.theDataSet.modelprofiles[profileRec.nprofileindex][this.theDataSet.numcols - 1] + ")");
                }
            }
        }
        printWriter.println("#genes category\t#genes assigned\t#genes expected\t#genes enriched\tp-value\tcorrected p-value");
        printWriter.println(this.szHeaderInfo);
        printWriter.println("-------");
        n3 = this.columnNames.size() - 1;
        for (n = 0; n < n3; ++n) {
            printWriter.print(this.columnNames.get(n) + "\t");
        }
        printWriter.println(this.columnNames.get(n3));
        for (n = 0; n < this.tabledata.size(); ++n) {
            for (n2 = 0; n2 < n3; ++n2) {
                printWriter.print(this.sorter.getValueAt(n, n2) + "\t");
            }
            printWriter.println(this.sorter.getValueAt(n, n3));
        }
    }

    public void writeToClipboard() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.columnNames.size() - 1;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(this.columnNames.get(n) + "\t");
        }
        stringBuffer.append(this.columnNames.get(n2) + "\n");
        for (n = 0; n < this.tabledata.size(); ++n) {
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(this.sorter.getValueAt(n, i) + "\t");
            }
            stringBuffer.append(this.sorter.getValueAt(n, n2) + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    public void printGeneNames(PrintWriter printWriter) {
        int n = this.tabledata.size();
        int n2 = this.bjustgo ? 0 : 2;
        for (int i = 0; i < n; ++i) {
            printWriter.println(this.sorter.getValueAt(i, n2));
        }
    }

    public void writenamesToClipboard() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.tabledata.size();
        int n2 = this.bjustgo ? 0 : 2;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.sorter.getValueAt(i, n2) + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    public void chromView() {
        int n = this.tabledata.size();
        int n2 = this.bjustgo ? 0 : 2;
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)this.sorter.getValueAt(i, n2);
        }
        this.cf.drawGenes(stringArray);
        this.cf.setVisible(true);
    }

    public void loadTable(ArrayList arrayList) {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Vector<String> vector = new Vector<String>(3);
            int n2 = (Integer)arrayList.get(i);
            String string = this.theDataSet.genenames[n2];
            HashSet hashSet = this.theDataSet.tga.labelsForID(string);
            if (hashSet.size() < 1 || !hashSet.contains(this.szGoID) || !(!this.bqueryset && this.htinames == null || this.htinames != null && this.htinames.contains(this.theDataSet.genenames[n2])) && (this.htinames != null || !this.theDataSet.tga.isOrder(this.theDataSet.genenames[n2]))) continue;
            if (!this.bjustgo) {
                if (this.bqueryset || this.htinames != null || this.theDataSet.tga.isOrder(this.theDataSet.genenames[n2])) {
                    vector.add("Yes");
                } else {
                    vector.add("");
                }
                vector.add(numberFormat.format(1.0 / (double)this.theDataSet.bestassignments[n2].size()));
            }
            vector.add(this.theDataSet.genenames[n2]);
            vector.add(this.theDataSet.probenames[n2]);
            for (int j = 0; j < this.theDataSet.numcols; ++j) {
                if (this.theDataSet.pmavalues[n2][j] == 0) {
                    vector.add("");
                    continue;
                }
                vector.add(numberFormat.format(this.theDataSet.data[n2][j]));
            }
            this.tabledata.add(vector);
        }
    }
}

