/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.stem;

import edu.cmu.cs.sb.core.TableModelST;
import edu.cmu.cs.sb.core.TableSorter;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.stem.STEM_DataSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public class FilteredTable
extends JPanel
implements ActionListener {
    STEM_DataSet theDataSet;
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    String[] columnNames;
    String[][] tabledata;
    JButton saveButton;
    JButton savenamesButton;
    JButton copyButton;
    JButton copynamesButton;
    JFrame theFrame;
    TableSorter sorter;

    public FilteredTable(JFrame jFrame, STEM_DataSet sTEM_DataSet) {
        Object object;
        Object object2;
        this.theFrame = jFrame;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bg);
        this.setForeground(fg);
        this.theDataSet = sTEM_DataSet;
        this.columnNames = new String[3];
        this.columnNames[0] = "Selected";
        this.columnNames[1] = sTEM_DataSet.szGeneHeader;
        this.columnNames[2] = sTEM_DataSet.szProbeHeader;
        this.tabledata = new String[sTEM_DataSet.htFiltered.size()][this.columnNames.length];
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        Iterator iterator = sTEM_DataSet.htFiltered.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = (String)sTEM_DataSet.htFiltered.get(object2);
            this.tabledata[n][1] = object2;
            this.tabledata[n][2] = object;
            this.tabledata[n][0] = sTEM_DataSet.tga.isOrder((String)object2) ? "Yes" : "";
            ++n;
        }
        this.sorter = new TableSorter(new TableModelST(this.tabledata, this.columnNames));
        object2 = new JTable(this.sorter);
        this.sorter.setTableHeader(((JTable)object2).getTableHeader());
        ((JTable)object2).setPreferredScrollableViewportSize(new Dimension(800, Math.min((((JTable)object2).getRowHeight() + ((JTable)object2).getRowMargin()) * ((JTable)object2).getRowCount(), 400)));
        object = ((JTable)object2).getColumnModel().getColumn(0);
        ((TableColumn)object).setPreferredWidth(100);
        object = ((JTable)object2).getColumnModel().getColumn(1);
        ((TableColumn)object).setPreferredWidth(350);
        object = ((JTable)object2).getColumnModel().getColumn(2);
        ((TableColumn)object).setPreferredWidth(300);
        JScrollPane jScrollPane = new JScrollPane((Component)object2);
        this.add(jScrollPane);
        ((JTable)object2).setSelectionMode(0);
        this.copyButton = new JButton("Copy Table", Util.createImageIcon("Copy16.gif"));
        this.copyButton.setActionCommand("copy");
        this.copyButton.setMinimumSize(new Dimension(800, 20));
        this.copyButton.addActionListener(this);
        this.saveButton = new JButton("Save Table", Util.createImageIcon("Save16.gif"));
        this.saveButton.setActionCommand("save");
        this.saveButton.setMinimumSize(new Dimension(800, 20));
        this.saveButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.copyButton);
        jPanel.add(this.saveButton);
        jPanel.setBackground(Color.white);
        this.copynamesButton = new JButton("Copy Gene Names", Util.createImageIcon("Copy16.gif"));
        this.copynamesButton.setActionCommand("copynames");
        this.copynamesButton.setMinimumSize(new Dimension(800, 20));
        this.copynamesButton.addActionListener(this);
        this.savenamesButton = new JButton("Save Gene Names", Util.createImageIcon("Save16.gif"));
        this.savenamesButton.setActionCommand("savenames");
        this.savenamesButton.setMinimumSize(new Dimension(800, 20));
        this.savenamesButton.addActionListener(this);
        jPanel.add(this.copynamesButton);
        jPanel.add(this.savenamesButton);
        JButton jButton = new JButton(Util.createImageIcon("Help16.gif"));
        jButton.addActionListener(this);
        jButton.setActionCommand("help");
        jPanel.add(jButton);
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("copy")) {
            this.writeToClipboard();
        } else if (string.equals("copynames")) {
            this.writenamesToClipboard();
        } else if (string.equals("save") || string.equals("savenames")) {
            try {
                int n = Util.theChooser.showSaveDialog(this);
                if (n == 0) {
                    File file = Util.theChooser.getSelectedFile();
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                    if (string.equals("save")) {
                        this.printFile(printWriter);
                    } else {
                        this.printGeneList(printWriter);
                    }
                    printWriter.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                final FileNotFoundException fileNotFoundException2 = fileNotFoundException;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, fileNotFoundException2.getMessage(), "Exception thrown", 0);
                    }
                });
                fileNotFoundException.printStackTrace(System.out);
            }
        } else if (string.equals("help")) {
            String string2 = this.theDataSet.bkmeans ? "The table contains genes included in the data set file, but that did not pass filter according to filtering criteria specified under the advanced options. \n\nThe table has three columns: \n*  Selected - contains a 'Yes' if the gene is part the GO Category or Query Set that the K-means clusters are currently ordered by.\n*  " + this.theDataSet.szGeneHeader + " - The name of the gene.\n" + "*  " + this.theDataSet.szProbeHeader + " - The spot ID(s) associated with the gene.\n\n" + "Note:\n" + "+The table can be sorted by any of the columns by clicking on the column's header.\n" + "+Using the 'Copy Table' the entire table can be copied to the clipboard, or " + "with the 'Copy Gene Names' button just the gene names.\n" + "+Using the 'Save Table' button the entire table can be saved, or using the " + "'Save Gene Names' button just the gene names." : "The table contains genes included in the data set file, but that did not pass filter according to filtering criteria specified under the advanced options. \n\nThe table has three columns: \n*  Selected - contains a 'Yes' if the gene is part the GO Category or Query Set that the profiles or cluster of profiles are currently ordered by, otherwise is blank.\n*  " + this.theDataSet.szGeneHeader + " - The name of the gene.\n" + "*  " + this.theDataSet.szProbeHeader + " - The spot ID(s) associated with the gene.\n\n" + "Note:\n" + "+The table can be sorted by any of the columns by clicking on the column's header.\n" + "+Using the 'Copy Table' the entire table can be copied to the clipboard, or " + "with the 'Copy Gene Names' button just the gene names.\n" + "+Using the 'Save Table' button the entire table can be saved, or using the " + "'Save Gene Names' button just the gene names.";
            Util.renderDialog(this.theFrame, string2);
        }
    }

    public void printGeneList(PrintWriter printWriter) {
        for (int i = 0; i < this.tabledata.length; ++i) {
            printWriter.println(this.sorter.getValueAt(i, 1));
        }
    }

    public void writenamesToClipboard() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.tabledata.length; ++i) {
            stringBuffer.append(this.sorter.getValueAt(i, 1) + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    public void printFile(PrintWriter printWriter) {
        int n;
        printWriter.println("Table of Genes Filtered");
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            printWriter.print(this.columnNames[n] + "\t");
        }
        printWriter.println(this.columnNames[this.columnNames.length - 1]);
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                printWriter.print(this.sorter.getValueAt(n, i) + "\t");
            }
            printWriter.println(this.sorter.getValueAt(n, this.columnNames.length - 1));
        }
    }

    public void writeToClipboard() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            stringBuffer.append(this.columnNames[n] + "\t");
        }
        stringBuffer.append(this.columnNames[this.columnNames.length - 1] + "\n");
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                stringBuffer.append(this.sorter.getValueAt(n, i) + "\t");
            }
            stringBuffer.append(this.sorter.getValueAt(n, this.columnNames.length - 1) + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }
}

