/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.stem;

import edu.cmu.cs.sb.core.GoAnnotations;
import edu.cmu.cs.sb.core.TableModelSetST;
import edu.cmu.cs.sb.core.TableSorter;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.stem.MAINGUI2;
import edu.cmu.cs.sb.stem.ST;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableColumn;

public class DefineGeneSet
extends JPanel
implements ActionListener {
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    GoAnnotations tga;
    TableModelSetST tms;
    MAINGUI2 maingui;
    JFrame theFrame;
    static int NMAXBAD = 30;
    TableSorter sorter;
    ListSelectionModel rowSM;
    JButton selectgenesButton;
    boolean bkmeans;
    JSpinner thespinnerprofiles;

    public DefineGeneSet(JFrame jFrame, MAINGUI2 mAINGUI2, GoAnnotations goAnnotations, ListSelectionModel listSelectionModel, boolean bl) {
        this.theFrame = jFrame;
        this.tga = goAnnotations;
        this.maingui = mAINGUI2;
        this.rowSM = listSelectionModel;
        this.bkmeans = bl;
        this.makewindow();
    }

    void setAll(boolean bl) {
        for (int i = 0; i < this.tms.data.length; ++i) {
            this.tms.setValueAt(bl, i, 1);
        }
    }

    void loadProfile(int n) {
        Object object;
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (n >= 0) {
            object = this.maingui.theDataSet.otherset.profilesAssigned[n];
            int n2 = ((ArrayList)object).size();
            for (int i = 0; i < n2; ++i) {
                int n3 = (Integer)((ArrayList)object).get(i);
                hashMap.put(this.maingui.theDataSet.otherset.genenames[n3], true);
            }
        } else {
            object = this.maingui.theDataSet.otherset.htFiltered.keySet().iterator();
            while (object.hasNext()) {
                hashMap.put((String)object.next(), true);
            }
        }
        for (int i = 0; i < this.tms.data.length; ++i) {
            if (hashMap.get(this.tms.data[i][0]) == null) continue;
            this.tms.setValueAt(true, i, 1);
        }
        this.sorter.setSortingStatus(1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = 0;
        if (string.equals("selectgenes")) {
            int n2 = (Integer)this.thespinnerprofiles.getValue();
            this.loadProfile(n2);
        } else if (string.equals("selectall")) {
            this.setAll(true);
        } else if (string.equals("selectnone")) {
            this.setAll(false);
        } else if (string.equals("query")) {
            this.tga.szsortcommand = this.tga.bactual || this.tga.bcluster ? "define" : "expdefine";
            this.rowSM.clearSelection();
            this.tga.szSelectedGO = null;
            this.maingui.drawmain();
        } else if (string.equals("save")) {
            try {
                int n3 = Util.theChooser.showSaveDialog(this);
                if (n3 == 0) {
                    File file = Util.theChooser.getSelectedFile();
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                    this.printFile(printWriter);
                    printWriter.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace(System.out);
            }
        } else if (string.equals("load")) {
            this.setAll(false);
            int n4 = ST.fc.showOpenDialog(this);
            String string2 = "";
            StringBuffer stringBuffer = new StringBuffer();
            if (n4 == 0) {
                BufferedReader bufferedReader = null;
                try {
                    String string3;
                    File file = ST.fc.getSelectedFile();
                    FileReader fileReader = new FileReader(file);
                    bufferedReader = new BufferedReader(fileReader);
                    HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                    HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
                    while ((string3 = bufferedReader.readLine()) != null) {
                        String string4 = string3.trim().toUpperCase(Locale.ENGLISH);
                        if (this.tga.htGeneNames.get(string4) != null) {
                            hashMap.put(string4, true);
                            continue;
                        }
                        if (string4.equals("0") || hashMap2.get(string4) != null || n >= NMAXBAD) continue;
                        stringBuffer.append(string3 + "\n");
                        hashMap2.put(string4, true);
                        ++n;
                    }
                    string2 = stringBuffer.toString();
                    for (int i = 0; i < this.tms.data.length; ++i) {
                        if (hashMap.get(this.tms.data[i][0]) == null) continue;
                        this.tms.setValueAt(true, i, 1);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    JOptionPane.showMessageDialog(this, fileNotFoundException.getMessage(), "Exception thrown", 0);
                    fileNotFoundException.printStackTrace(System.out);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, iOException.getMessage(), "Exception thrown", 0);
                    iOException.printStackTrace(System.out);
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(this, iOException.getMessage(), "Exception thrown", 0);
                            iOException.printStackTrace(System.out);
                        }
                    }
                }
                this.sorter.setSortingStatus(1, -1);
            }
            if (!string2.equals("")) {
                string2 = n < NMAXBAD ? "The following genes from the loaded gene set are not in the data file:\n" + string2 : "The following are the first " + NMAXBAD + " genes from the loaded gene " + "set that are not in the data file:\n" + string2;
                JOptionPane.showMessageDialog(this, string2, "Genes Not in the Data File", 2);
            }
        } else if (string.equals("help")) {
            String string5 = this.maingui.theDataSet.bkmeans ? "This window allows one to select a set of genes to query.  When the 'Query Gene Set' button is pressed K-means clusters are reordered based on enrichment of the query set of genes. Also the number of genes from the query set assigned to each cluster and the p-value of the enrichment will appear in the lower left hand corner of the cluster boxes.\n\nThe genes that form a query set can be specified in one of several ways:\n*The genes that define a query set can be selected or unselected by manually checking or unchecking the boxes next to their name in the list.\n*All the genes can be selected with the 'Select All' button.\n*All the genes can be set to unselected with the 'Unselect All' button.\n*A gene set can be loaded from a file through the 'Load Gene Set' option.  Each gene to be included in the query set should appear in a file one per line.\n*If a comparison set has been specified through the 'Compare...' option on the main window, then the genes in the comparison set assigned to one or more specific clusters can be selected by choosing the cluster ID and then pressing 'Select Genes'.  Likewise if the current set of clusters is from a comparison experiment, the set of genes assigned to cluster(s) in the original experiment can be loaded in the same manner.  To select all the genes filtered in the other experiment set the cluster ID to -1 and then press 'Select Genes'.\n\nNote:\n+The table can be sorted by any of the columns by clicking on the column's header.\n+Using the 'Save Gene Set' button the set of selected genes can be saved.  A saved gene list can then be loaded at a later time through the 'Load Gene Set' option.\n" : "This window allows one to select a set of genes to query.  When the 'Query Gene Set' button is pressed profiles are reordered based on enrichment of the query set of genes. Also the number of genes from the query set assigned to each profile and the p-value of the enrichment will appear in the lower left hand corner of the profile boxes.\n\nThe genes that form a query set can be specified in one of several ways:\n*The genes that define a query set can be selected or unselected by manually checking or unchecking the boxes next to their name in the list.\n*All the genes can be selected with the 'Select All' button.\n*All the genes can be set to unselected with the 'Unselect All' button.\n*A gene set can be loaded from a file through the 'Load Gene Set' option.  Each gene to be included in the query set should appear in a file one per line.\n*If a comparison set has been specified through the 'Compare...' option on the main window, then the genes in the comparison set assigned to one or more specific profiles can be selected by choosing the profile ID and then pressing 'Select Genes'.  Likewise if the current set of profiles is from a comparison experiment, the set of genes assigned to profile(s) in the original experiment can be loaded in the same manner.  To select all the genes filtered in the other experiment set the profile ID to -1 and then press 'Select Genes'.\n\nNote:\n+The table can be sorted by any of the columns by clicking on the column's header.\n+Using the 'Save Gene Set' button the set of selected genes can be saved.  A saved gene list can then be loaded at a later time through the 'Load Gene Set' option.\n";
            Util.renderDialog(this.theFrame, string5, -200, -100);
        }
    }

    public void printFile(PrintWriter printWriter) {
        for (int i = 0; i < this.tms.data.length; ++i) {
            if (!((Boolean)this.tms.data[i][1]).booleanValue()) continue;
            printWriter.println(this.tms.data[i][0]);
        }
    }

    public void makewindow() {
        int n;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bg);
        this.setForeground(fg);
        Iterator iterator = this.tga.htGeneNames.keySet().iterator();
        int n2 = this.tga.htGeneNames.size();
        Object[][] objectArray = new Object[n2][2];
        String[] stringArray = new String[]{"Gene Name", "In Gene Set"};
        Object[] objectArray2 = new String[n2];
        for (n = 0; n < n2; ++n) {
            objectArray2[n] = (String)iterator.next();
        }
        Arrays.sort(objectArray2);
        n = 0;
        for (int i = 0; i < n2; ++i) {
            objectArray[i][0] = objectArray2[i];
            objectArray[i][1] = this.tga.htGeneNames.get(objectArray2[i]);
            n = n != 0 || (Boolean)objectArray[i][1] != false ? 1 : 0;
        }
        this.tms = new TableModelSetST(objectArray, stringArray, this.tga);
        this.sorter = new TableSorter(this.tms);
        if (n != 0) {
            this.sorter.setSortingStatus(1, -1);
        }
        JTable jTable = new JTable(this.sorter);
        this.sorter.setTableHeader(jTable.getTableHeader());
        jTable.setPreferredScrollableViewportSize(new Dimension(425, 300));
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(200);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(50);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.add(jScrollPane);
        String string = this.bkmeans ? "Cluster" : "Profile";
        JLabel jLabel = this.maingui.theDataSet.otherset != null && this.maingui.theDataSet.bothersetorigset ? new JLabel(string + " ID in Original Set: ") : new JLabel(string + " ID in Comparison Set: ");
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        int n3 = this.maingui.theDataSet.modelprofiles.length / 2;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(new Integer(n3), new Integer(-1), new Integer(this.maingui.theDataSet.modelprofiles.length - 1), new Integer(1));
        this.thespinnerprofiles = new JSpinner(spinnerNumberModel);
        this.selectgenesButton = new JButton("Select Genes");
        if (this.maingui.theDataSet.otherset == null) {
            this.selectgenesButton.setEnabled(false);
        }
        jPanel.add(jLabel);
        jPanel.add(this.thespinnerprofiles);
        this.selectgenesButton.setActionCommand("selectgenes");
        this.selectgenesButton.addActionListener(this);
        jPanel.add(this.selectgenesButton);
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        JButton jButton = new JButton("Unselect All");
        jButton.setActionCommand("selectnone");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        JButton jButton2 = new JButton("Select All");
        jButton2.setActionCommand("selectall");
        jButton2.addActionListener(this);
        jPanel2.add(jButton2);
        jPanel2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(Color.white);
        JButton jButton3 = new JButton("Query Gene Set");
        jButton3.setActionCommand("query");
        jButton3.addActionListener(this);
        jPanel3.add(jButton3);
        JButton jButton4 = new JButton("Load Gene Set", Util.createImageIcon("Open16.gif"));
        jButton4.setActionCommand("load");
        jButton4.addActionListener(this);
        jPanel3.add(jButton4);
        JButton jButton5 = new JButton("Save Gene Set", Util.createImageIcon("Save16.gif"));
        jButton5.setActionCommand("save");
        jButton5.addActionListener(this);
        jPanel3.add(jButton5);
        JButton jButton6 = new JButton(Util.createImageIcon("Help16.gif"));
        jButton6.addActionListener(this);
        jButton6.setActionCommand("help");
        jPanel3.add(jButton6);
        jPanel3.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel3);
    }
}

