/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.stem;

import edu.cmu.cs.sb.chromviewer.ChromFrame;
import edu.cmu.cs.sb.core.StatUtil;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.stem.MAINGUI2;
import edu.cmu.cs.sb.stem.ST;
import edu.cmu.cs.sb.stem.STEM_DataSet;
import edu.umd.cs.piccolo.PCanvas;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class CompareInfo {
    STEM_DataSet origset;
    STEM_DataSet comparesetfmnel;
    double dmaxpval;
    int nminnumgenes;
    ArrayList sigrows;
    ArrayList sigrowsswap;
    MAINGUI2 compareframe;

    public CompareInfo(STEM_DataSet sTEM_DataSet, String string, String string2, String string3, Vector vector, boolean bl, ChromFrame chromFrame) throws Exception {
        this.origset = sTEM_DataSet;
        this.dmaxpval = Double.parseDouble(string2);
        this.nminnumgenes = Integer.parseInt(string3);
        this.sigrows = new ArrayList();
        this.comparesetfmnel = ST.buildset(chromFrame.genomeParser.szchromval, sTEM_DataSet.tga.szxrefval, string, sTEM_DataSet.tga.szGoFile, sTEM_DataSet.tga.szGoCategoryFile, sTEM_DataSet.nmaxmissing, sTEM_DataSet.dthresholdvalue, sTEM_DataSet.dmincorrelation, sTEM_DataSet.dminclustdist, sTEM_DataSet.alpha, sTEM_DataSet.dpercentileclust, sTEM_DataSet.nmaxchange, sTEM_DataSet.nmaxprofiles, sTEM_DataSet.dmaxcorrmodel, sTEM_DataSet.nsamplesgene, sTEM_DataSet.tga.nsamplespval, sTEM_DataSet.nsamplesmodel, sTEM_DataSet.tga.nmingo, sTEM_DataSet.nfdr, sTEM_DataSet.tga.nmingolevel, sTEM_DataSet.tga.szextraval, bl, vector, sTEM_DataSet.btakelog, sTEM_DataSet.bspotincluded, sTEM_DataSet.badd0, sTEM_DataSet.tga.szcategoryIDval, sTEM_DataSet.tga.szevidenceval, sTEM_DataSet.tga.sztaxonval, sTEM_DataSet.tga.bpontoval, sTEM_DataSet.tga.bcontoval, sTEM_DataSet.tga.bfontoval, sTEM_DataSet.tga.brandomgoval, sTEM_DataSet.bkmeans, sTEM_DataSet.bmaxminval, sTEM_DataSet.ballpermuteval, sTEM_DataSet.tga.szorganismsourceval, sTEM_DataSet.tga.szxrefsourceval, chromFrame.genomeParser.szchromsourceval);
        if (this.comparesetfmnel.numcols != sTEM_DataSet.numcols) {
            throw new IllegalArgumentException("Compare data set must have same number of columns as original, expecting " + sTEM_DataSet.numcols + " found " + this.comparesetfmnel.numcols + " in the comparison set");
        }
        this.compareframe = new MAINGUI2(this.comparesetfmnel);
        this.compareframe.cf = chromFrame;
        PCanvas.CURRENT_ZCANVAS = null;
        this.compareframe.setLocation(25, 60);
        this.compareframe.setDefaultCloseOperation(2);
        this.compareframe.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CompareInfo.this.compareframe.closeSortWindows();
            }

            public void windowClosed(WindowEvent windowEvent) {
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        System.gc();
                    }
                });
                thread.start();
            }
        });
        this.compareframe.setVisible(true);
        this.findsigcompare();
    }

    private int countintersect(HashMap hashMap, HashMap hashMap2) {
        Iterator iterator = hashMap.keySet().iterator();
        int n = hashMap2.size();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (hashMap2.get(string) != null) continue;
            ++n;
        }
        return n;
    }

    public void findsigcompare() {
        int n;
        int n2;
        ArrayList[] arrayListArray = new ArrayList[this.comparesetfmnel.modelprofiles.length];
        ArrayList[] arrayListArray2 = new ArrayList[this.comparesetfmnel.modelprofiles.length];
        double[] dArray = new double[this.comparesetfmnel.modelprofiles.length];
        double[] dArray2 = new double[this.comparesetfmnel.modelprofiles.length];
        for (n2 = 0; n2 < arrayListArray.length; ++n2) {
            arrayListArray[n2] = new ArrayList();
            arrayListArray2[n2] = new ArrayList();
            dArray[n2] = 1.0;
            dArray2[n2] = 1.0;
        }
        n2 = this.countintersect(this.origset.tga.htGeneNames, this.comparesetfmnel.tga.htGeneNames);
        System.out.println("Number of genes in the union of the original and comparison set is " + n2);
        for (n = 0; n < this.origset.modelprofiles.length; ++n) {
            HashSet<String> hashSet = new HashSet<String>();
            int n3 = this.origset.profilesAssigned[n].size();
            for (int i = 0; i < n3; ++i) {
                int n4 = (Integer)this.origset.profilesAssigned[n].get(i);
                hashSet.add(this.origset.genenames[n4]);
            }
            ArrayList<CompareInfoRec> arrayList = new ArrayList<CompareInfoRec>();
            ArrayList arrayList2 = new ArrayList();
            double d = 1.0;
            double d2 = 1.0;
            for (int i = 0; i < this.comparesetfmnel.modelprofiles.length; ++i) {
                double d3;
                HashSet<String> hashSet2 = new HashSet<String>();
                double d4 = 0.0;
                int n5 = this.comparesetfmnel.profilesAssigned[i].size();
                for (int j = 0; j < n5; ++j) {
                    int n6 = (Integer)this.comparesetfmnel.profilesAssigned[i].get(j);
                    String string = this.comparesetfmnel.genenames[n6];
                    if (!hashSet.contains(string)) continue;
                    hashSet2.add(string);
                    d4 += 1.0 / (double)this.comparesetfmnel.bestassignments[n6].size();
                }
                double d5 = StatUtil.hypergeometrictail((int)Math.ceil(d4 - 1.0), n3, (int)Math.floor(n2 - n3), n5);
                if (!(d4 >= (double)this.nminnumgenes) || !(d5 <= this.dmaxpval)) continue;
                if (d5 < d) {
                    d = d5;
                }
                if (d5 < dArray2[i]) {
                    dArray2[i] = d5;
                }
                if ((d3 = Util.correlation(this.origset.modelprofiles[n], this.comparesetfmnel.modelprofiles[i])) < d2) {
                    d2 = d3;
                }
                if (d3 < dArray[i]) {
                    dArray[i] = d3;
                }
                arrayList.add(new CompareInfoRec(d4, d5, d3, i, hashSet2));
                arrayListArray[i].add(new CompareInfoRec(d4, d5, d3, n, hashSet2));
            }
            if (arrayList.size() < 1) continue;
            this.sigrows.add(new CompareInfoRow(n, d2, d, arrayList));
        }
        this.sigrowsswap = new ArrayList();
        for (n = 0; n < arrayListArray.length; ++n) {
            if (arrayListArray[n].size() < 1) continue;
            this.sigrowsswap.add(new CompareInfoRow(n, dArray[n], dArray2[n], arrayListArray[n]));
        }
    }

    static class CompareInfoRow {
        int nprofile;
        double dmincorr;
        double dminpval;
        ArrayList sigprofiles;

        CompareInfoRow(int n, double d, double d2, ArrayList arrayList) {
            this.dmincorr = d;
            this.dminpval = d2;
            this.nprofile = n;
            this.sigprofiles = arrayList;
        }
    }

    static class CompareInfoRec {
        double dmatch;
        double dpval;
        double dcorrval;
        int nprofile;
        HashSet inames;

        CompareInfoRec(double d, double d2, double d3, int n, HashSet hashSet) {
            this.dmatch = d;
            this.dpval = d2;
            this.dcorrval = d3;
            this.nprofile = n;
            this.inames = hashSet;
        }
    }
}

