/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.stem;

import edu.cmu.cs.sb.chromviewer.ChromFrame;
import edu.cmu.cs.sb.core.SpringUtilities;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.stem.CompareInfo;
import edu.cmu.cs.sb.stem.GenePlotPanel;
import edu.cmu.cs.sb.stem.MAINGUI2;
import edu.cmu.cs.sb.stem.ProfileGui;
import edu.cmu.cs.sb.stem.ST;
import edu.cmu.cs.sb.stem.STEM_DataSet;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.PFrame;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;

public class CompareGui
extends PFrame {
    static int SCREENWIDTH = 800;
    static int SCREENHEIGHT = 600;
    static int BUFFER = 135;
    static int CAPOFFSET = 20;
    static int SORTID = 0;
    static int SORTSIG = 1;
    static int SORTSUPRISE = 2;
    private PCanvas canvas;
    CompareInfo theCompareInfo = null;
    private PNode[] profilenodes;
    private int nsort = 0;
    private boolean bswap = false;
    private Object swaplock = new Object();
    private String szother;
    private String szprofileclusterCAP;
    private GenePlotPanel thegeneplotpanel;
    private GenePlotPanel rowplotpanel;
    private GenePlotPanel colplotpanel;
    private ChromFrame cf;

    public CompareGui(CompareInfo compareInfo, PNode[] pNodeArray, GenePlotPanel genePlotPanel, ChromFrame chromFrame) throws Exception {
        super("Comparison - Significant Intersections");
        this.theCompareInfo = compareInfo;
        this.profilenodes = pNodeArray;
        this.thegeneplotpanel = genePlotPanel;
        this.cf = chromFrame;
        this.szprofileclusterCAP = compareInfo.origset.bkmeans ? "Clusters" : "Profiles";
    }

    public void beforeInitialize() {
        this.setSize(SCREENWIDTH, SCREENHEIGHT);
    }

    public void initialize() {
        this.drawcomparemain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawcomparemain() {
        Cloneable cloneable;
        PNode pNode;
        Object object;
        PNode pNode2;
        Object object2;
        Object object3;
        String string;
        String string2;
        PNode[] pNodeArray;
        PNode[] pNodeArray2;
        STEM_DataSet sTEM_DataSet;
        STEM_DataSet sTEM_DataSet2;
        ArrayList arrayList;
        this.canvas = this.getCanvas();
        this.canvas.getLayer().removeAllChildren();
        int n = 0;
        float f = 150.0f;
        int n2 = 0;
        Object object4 = this.swaplock;
        synchronized (object4) {
            if (this.bswap) {
                arrayList = this.theCompareInfo.sigrowsswap;
                sTEM_DataSet2 = this.theCompareInfo.origset;
                sTEM_DataSet = this.theCompareInfo.comparesetfmnel;
                this.rowplotpanel = this.theCompareInfo.compareframe.thegeneplotpanel;
                this.colplotpanel = this.thegeneplotpanel;
                pNodeArray2 = this.profilenodes;
                pNodeArray = this.theCompareInfo.compareframe.profilenodes;
                string2 = "Original Set " + this.szprofileclusterCAP;
                string = "Comparison Set " + this.szprofileclusterCAP;
                this.szother = "comparison";
            } else {
                arrayList = this.theCompareInfo.sigrows;
                sTEM_DataSet = this.theCompareInfo.origset;
                sTEM_DataSet2 = this.theCompareInfo.comparesetfmnel;
                pNodeArray = this.profilenodes;
                pNodeArray2 = this.theCompareInfo.compareframe.profilenodes;
                this.colplotpanel = this.theCompareInfo.compareframe.thegeneplotpanel;
                this.rowplotpanel = this.thegeneplotpanel;
                string = "Original Set " + this.szprofileclusterCAP;
                string2 = "Comparison Set " + this.szprofileclusterCAP;
                this.szother = "original";
            }
        }
        object4 = new PText(string2);
        ((PText)object4).setFont(new Font("times", 0, 14));
        ((PNode)object4).translate(3.0 * (double)SCREENWIDTH / 18.0, 0.0);
        this.canvas.getLayer().addChild((PNode)object4);
        PText pText = new PText(string);
        pText.setFont(new Font("times", 0, 14));
        pText.translate(0.0, (double)SCREENHEIGHT / 2.0);
        pText.rotate(-1.5707963267948966);
        this.canvas.getLayer().addChild(pText);
        int n3 = arrayList.size();
        if (n3 >= 2) {
            PText pText2 = new PText(string2);
            pText2.setFont(new Font("times", 0, 14));
            pText2.translate(12.0 * (double)SCREENWIDTH / 18.0, 0.0);
            this.canvas.getLayer().addChild(pText2);
            object3 = new PText(string);
            ((PText)object3).setFont(new Font("times", 0, 14));
            ((PNode)object3).translate((double)SCREENWIDTH / 2.0 + (double)CAPOFFSET, (double)SCREENHEIGHT / 2.0);
            ((PNode)object3).rotate(-1.5707963267948966);
            this.canvas.getLayer().addChild((PNode)object3);
        }
        for (int i = 0; i < n3; ++i) {
            object3 = (CompareInfo.CompareInfoRow)arrayList.get(i);
            if (((CompareInfo.CompareInfoRow)object3).sigprofiles.size() < n) continue;
            n = ((CompareInfo.CompareInfoRow)object3).sigprofiles.size();
        }
        CompareInfo.CompareInfoRow[] compareInfoRowArray = new CompareInfo.CompareInfoRow[n3];
        for (int i = 0; i < compareInfoRowArray.length; ++i) {
            compareInfoRowArray[i] = (CompareInfo.CompareInfoRow)arrayList.get(i);
        }
        if (this.nsort == SORTSIG) {
            Arrays.sort(compareInfoRowArray, new SigRowComparator());
        } else if (this.nsort == SORTSUPRISE) {
            Arrays.sort(compareInfoRowArray, new SupriseRowComparator());
        }
        double d = 20.0;
        if (n3 > 0) {
            d = Math.max(Math.min((SCREENHEIGHT - BUFFER) * 2 / n3, (SCREENWIDTH / 2 - BUFFER) / (n + 1)), 20);
        }
        for (int i = 0; i < n3; ++i) {
            int n4;
            Object object5;
            Object object6;
            Object object7;
            double d2;
            double d3;
            object2 = compareInfoRowArray[i];
            pNode2 = (PNode)pNodeArray[((CompareInfo.CompareInfoRow)object2).nprofile].clone();
            pNode2.scale(d / (pNode2.getScale() * pNode2.getHeight()));
            if ((double)i < Math.ceil((double)n3 / 2.0)) {
                d3 = (double)CAPOFFSET / pNode2.getScale();
                d2 = pNode2.getHeight() * (double)i + (double)CAPOFFSET / pNode2.getScale();
            } else {
                d3 = 1.0 / pNode2.getScale() * (double)SCREENWIDTH / 2.0 + (double)(2 * CAPOFFSET) / pNode2.getScale();
                d2 = pNode2.getHeight() * ((double)i - Math.ceil((double)n3 / 2.0)) + (double)CAPOFFSET / pNode2.getScale();
            }
            object = "" + (int)sTEM_DataSet.countassignments[((CompareInfo.CompareInfoRow)object2).nprofile];
            pNode = new PText((String)object);
            ((PText)pNode).setFont(new Font("times", 0, (int)Math.ceil(pNode2.getHeight() / 6.0)));
            pNode.translate(1.0, pNode2.getHeight() - pNode2.getHeight() / 4.0);
            pNode2.addChild(pNode);
            pNode2.translate(d3, d2);
            if (i == 0) {
                double d4 = (float)(pNode2.getWidth() * pNode2.getScale());
                double d5 = Math.ceil((double)n3 / 2.0) * (double)((float)(pNode2.getHeight() * pNode2.getScale()));
                object7 = PPath.createRectangle((float)((double)CAPOFFSET + d4 + 1.5 * pNode2.getScale()), CAPOFFSET, (float)(6.0 * pNode2.getScale()), (float)d5);
                ((PNode)object7).setPaint(ST.buttonColor);
                this.canvas.getLayer().addChild((PNode)object7);
            } else if ((double)i == Math.ceil((double)n3 / 2.0)) {
                double d6 = pNode2.getScale();
                double d7 = (float)(pNode2.getWidth() * d6);
                double d8 = ((double)n3 - Math.ceil((double)n3 / 2.0)) * (double)((float)(pNode2.getHeight() * d6));
                object6 = PPath.createRectangle((float)((double)(2 * CAPOFFSET) + d7 + (double)SCREENWIDTH / 2.0 + 1.5 * d6), CAPOFFSET, (float)(6.0 * d6), (float)d8);
                ((PNode)object6).setPaint(ST.buttonColor);
                this.canvas.getLayer().addChild((PNode)object6);
                float f2 = (float)(((double)CAPOFFSET / d6 + 10.0 + pNode2.getHeight() * (double)(n + 1)) * d6);
                float f3 = (float)((double)f2 + ((double)SCREENWIDTH / 2.0 + (double)CAPOFFSET / d6 - (double)f2) / 2.0);
                object5 = PPath.createRectangle(f3, 5.0f, (float)(6.0 * d6), SCREENHEIGHT - BUFFER + 15);
                ((PNode)object5).setPaint(ST.lightBlue);
                this.canvas.getLayer().addChild((PNode)object5);
            }
            pNode2.addInputEventListener(new PBasicInputEventHandler((CompareInfo.CompareInfoRow)object2){
                final /* synthetic */ CompareInfo.CompareInfoRow val$cir;
                {
                    this.val$cir = compareInfoRow;
                }

                public void mousePressed(PInputEvent pInputEvent) {
                    if (pInputEvent.getButton() == 1) {
                        ProfileGui profileGui = new ProfileGui(sTEM_DataSet, this.val$cir.nprofile, null, null, -1, null, null, null, CompareGui.this.rowplotpanel, CompareGui.this.cf);
                        profileGui.setLocation(20, 50);
                        profileGui.setDefaultCloseOperation(2);
                        profileGui.setSize(new Dimension(SCREENWIDTH, SCREENHEIGHT));
                        profileGui.setVisible(true);
                    }
                }
            });
            this.canvas.getLayer().addChild(pNode2);
            cloneable = ((CompareInfo.CompareInfoRow)object2).sigprofiles;
            int n5 = ((ArrayList)cloneable).size();
            CompareInfo.CompareInfoRec[] compareInfoRecArray = new CompareInfo.CompareInfoRec[n5];
            for (n4 = 0; n4 < compareInfoRecArray.length; ++n4) {
                compareInfoRecArray[n4] = (CompareInfo.CompareInfoRec)((ArrayList)cloneable).get(n4);
            }
            if (this.nsort == SORTSIG) {
                Arrays.sort(compareInfoRecArray, new SigComparator());
            } else if (this.nsort == SORTSUPRISE) {
                Arrays.sort(compareInfoRecArray, new SupriseComparator(((CompareInfo.CompareInfoRow)object2).nprofile));
            }
            for (n4 = 0; n4 < n5; ++n4) {
                object7 = compareInfoRecArray[n4];
                PNode pNode3 = (PNode)pNodeArray2[((CompareInfo.CompareInfoRec)object7).nprofile].clone();
                pNode3.scale(d / (pNode3.getScale() * pNode3.getHeight()));
                pNode3.translate(10.0 + d3 + pNode3.getHeight() * (double)(n4 + 1), d2);
                object6 = (int)((CompareInfo.CompareInfoRec)object7).dmatch + ";" + MAINGUI2.doubleToSz(((CompareInfo.CompareInfoRec)object7).dpval);
                PText pText3 = new PText((String)object6);
                pText3.setFont(new Font("times", 0, (int)Math.ceil(pNode3.getHeight() / 6.0)));
                pText3.translate(1.0, 3.0 * pNode3.getHeight() / 4.0);
                pNode3.addChild(pText3);
                NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
                numberFormat.setMinimumFractionDigits(2);
                numberFormat.setMaximumFractionDigits(2);
                object5 = numberFormat.format(((CompareInfo.CompareInfoRec)object7).dcorrval);
                PText pText4 = new PText((String)object5);
                pText4.setFont(new Font("times", 0, (int)Math.ceil(pNode3.getHeight() / 6.0)));
                pText4.translate(4.0 * pNode3.getWidth() / 7.0, -1.0);
                pNode3.addChild(pText4);
                String string3 = MAINGUI2.doubleToSz(((CompareInfo.CompareInfoRec)object7).dmatch) + " of the " + MAINGUI2.doubleToSz(sTEM_DataSet.countassignments[((CompareInfo.CompareInfoRow)object2).nprofile]) + " genes assigned to Profile " + ((CompareInfo.CompareInfoRow)object2).nprofile + " in the " + this.szother + " experiment were also assigned to this profile (p-value =" + MAINGUI2.doubleToSz(((CompareInfo.CompareInfoRec)object7).dpval) + ")";
                pNode3.addInputEventListener(new PBasicInputEventHandler((CompareInfo.CompareInfoRec)object7, (CompareInfo.CompareInfoRow)object2, string3){
                    final /* synthetic */ CompareInfo.CompareInfoRec val$cirec;
                    final /* synthetic */ CompareInfo.CompareInfoRow val$cir;
                    final /* synthetic */ String val$szIntersect;
                    {
                        this.val$cirec = compareInfoRec;
                        this.val$cir = compareInfoRow;
                        this.val$szIntersect = string;
                    }

                    public void mousePressed(PInputEvent pInputEvent) {
                        if (pInputEvent.getButton() == 1) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    ProfileGui profileGui = new ProfileGui(sTEM_DataSet2, val$cirec.nprofile, null, val$cirec.inames, val$cir.nprofile, val$szIntersect, null, null, CompareGui.this.colplotpanel, CompareGui.this.cf);
                                    profileGui.setLocation(20, 50);
                                    profileGui.setDefaultCloseOperation(2);
                                    profileGui.setSize(new Dimension(SCREENWIDTH, SCREENHEIGHT));
                                    profileGui.setVisible(true);
                                }
                            });
                        }
                    }
                });
                this.canvas.getLayer().addChild(pNode3);
            }
        }
        PPath pPath = PPath.createRectangle(0.0f, 0.0f, f, 18.0f);
        pPath.translate(4 * (SCREENWIDTH + n2) / 5 - 100, SCREENHEIGHT - 65);
        PText pText5 = new PText("Order By Correlation");
        pText5.setFont(new Font("times", 0, 12));
        pText5.translate(23.0, 2.0);
        pPath.setPaint(ST.buttonColor);
        pPath.addChild(pText5);
        this.canvas.getLayer().addChild(pPath);
        pPath.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                CompareGui.this.nsort = SORTSUPRISE;
                CompareGui.this.drawcomparemain();
            }
        });
        PImage pImage = new PImage(Util.getImageURL("Help24.gif"));
        this.canvas.getLayer().addChild(pImage);
        pImage.translate(SCREENWIDTH - 70, SCREENHEIGHT - 68);
        final CompareGui compareGui = this;
        pImage.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JDialog jDialog = new JDialog(compareGui, "Help", false);
                        Container container = jDialog.getContentPane();
                        jDialog.setBackground(Color.white);
                        container.setBackground(Color.white);
                        String string = sTEM_DataSet.bkmeans ? "The display shows to the left of the yellow line a K-means cluster from one of the data sets.  To the right of the yellow line are K-means clusters from the other data set for which a significant number of genes assigned to the cluster on left were also assigned to it.  The p-value of the number of genes in the intersection is computed using the hypergeometric distribution based on the number of total genes assigned to each of the two clusters, and the total number of genes on the array.\n\nThe display is split in half by a blue line, there is no difference between clusters to the left and right of the blue line.  The clusters in the display can be reordered based on the significance through the 'Order by Significance' option.  Within each row the clusters are ordered in decreasing order of significance.  The rows are reordered based on decreasing significance of the most significant intersection for the row.  'Order by Correlation' is similar but instead of re-ordering based on significance, the re-ordering is done based on correlation, so that one can quickly identify dissimilar pairs of clusters.  'Order by ID' is the default method to order clusters, based on increasing cluster ID.  'Swap Rows and Columns' swaps which data set has clusters to the left of the yellow line and which data set has clusters organized in columns to the right of the yellow line.\n\nNote also the main interface is zoomable and pannable, hold the right button down to zoom or the left to pan while moving the mouse." : "The display shows to the left of the yellow line a profile from one of the data sets.  To the right of the yellow line are profiles from the other data set for which a significant number of genes assigned to the profile on left were also assigned to it.  The p-value of the number of genes in the intersection is computed using the hypergeometric distribution based on the number of total genes assigned to each of the two profiles, and the total number of genes on the array.\n\nThe display is split in half by a blue line, there is no difference between profiles to the left and right of the blue line.  The profiles in the display can be reordered based on the significance through the 'Order by Significance' option.  Within each row the profiles are ordered in decreasing order of significance.  The rows are reordered based on decreasing significance of the most significant intersection for the row.  'Order by Correlation' is similar but instead of re-ordering based on significance, the re-ordering is done based on correlation, so that one can quickly identify dissimilar pairs of profiles.  'Order by ID' is the default method to order profiles, based on increasing profile ID.  'Swap Rows and Columns' swaps which data set has profiles to the left of the yellow line and which data set has profiles organized in columns to the right of the yellow line.\n\nNote also the main interface is zoomable and pannable, hold the right button down to zoom or the left to pan while moving the mouse.";
                        JTextArea jTextArea = new JTextArea(string, 9, 60);
                        jTextArea.setLineWrap(true);
                        jTextArea.setWrapStyleWord(true);
                        jTextArea.setBackground(Color.white);
                        jTextArea.setEditable(false);
                        ImageIcon imageIcon = sTEM_DataSet.bkmeans ? Util.createImageIcon("p6_2.png") : Util.createImageIcon("p38_13.png");
                        JLabel jLabel = new JLabel(imageIcon);
                        container.add(jLabel);
                        JPanel jPanel = new JPanel();
                        jPanel.setLayout(new SpringLayout());
                        jPanel.setBackground(Color.white);
                        jPanel.add(jLabel);
                        JScrollPane jScrollPane = new JScrollPane(jTextArea);
                        jPanel.add(jScrollPane);
                        SpringUtilities.makeCompactGrid(jPanel, 2, 1, 2, 2, 2, 2);
                        JScrollPane jScrollPane2 = new JScrollPane(jPanel);
                        container.add(jScrollPane2);
                        container.setSize(800, 600);
                        container.validate();
                        jDialog.setLocation(compareGui.getX() + 25, compareGui.getY() + 25);
                        jDialog.setSize(800, 600);
                        jDialog.setDefaultCloseOperation(2);
                        jDialog.setVisible(true);
                    }
                });
            }
        });
        PPath pPath2 = PPath.createRectangle(0.0f, 0.0f, f, 18.0f);
        pPath2.translate(2 * (SCREENWIDTH + n2) / 5 - 100, SCREENHEIGHT - 65);
        object2 = new PText("Order By Profile ID");
        ((PText)object2).setFont(new Font("times", 0, 12));
        ((PNode)object2).translate(25.0, 2.0);
        pPath2.setPaint(ST.buttonColor);
        pPath2.addChild((PNode)object2);
        pPath2.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                CompareGui.this.nsort = SORTID;
                CompareGui.this.drawcomparemain();
            }
        });
        this.canvas.getLayer().addChild(pPath2);
        this.canvas.getLayer().addChild(pPath2);
        pNode2 = PPath.createRectangle(0.0f, 0.0f, f, 18.0f);
        pNode2.translate(3 * (SCREENWIDTH + n2) / 5 - 100, SCREENHEIGHT - 65);
        object = new PText("Order By Significance");
        ((PText)object).setFont(new Font("times", 0, 12));
        ((PNode)object).translate(20.0, 2.0);
        pNode2.setPaint(ST.buttonColor);
        pNode2.addChild((PNode)object);
        this.canvas.getLayer().addChild(pNode2);
        pNode2.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                CompareGui.this.nsort = SORTSIG;
                CompareGui.this.drawcomparemain();
            }
        });
        pNode = PPath.createRectangle(0.0f, 0.0f, f, 18.0f);
        pNode.translate(1 * (SCREENWIDTH + n2) / 5 - 100, SCREENHEIGHT - 65);
        cloneable = new PText("Swap Rows and Columns");
        ((PText)cloneable).setFont(new Font("times", 0, 12));
        ((PNode)cloneable).translate(6.0, 2.0);
        pNode.setPaint(ST.buttonColor);
        pNode.addChild((PNode)cloneable);
        this.canvas.getLayer().addChild(pNode);
        pNode.addInputEventListener(new PBasicInputEventHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mousePressed(PInputEvent pInputEvent) {
                Object object = CompareGui.this.swaplock;
                synchronized (object) {
                    CompareGui.this.bswap = !CompareGui.this.bswap;
                }
                CompareGui.this.drawcomparemain();
            }
        });
    }

    public static class SupriseRowComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            CompareInfo.CompareInfoRow compareInfoRow = (CompareInfo.CompareInfoRow)object;
            CompareInfo.CompareInfoRow compareInfoRow2 = (CompareInfo.CompareInfoRow)object2;
            if (compareInfoRow.dmincorr < compareInfoRow2.dmincorr) {
                return -1;
            }
            if (compareInfoRow.dmincorr > compareInfoRow2.dmincorr) {
                return 1;
            }
            if (compareInfoRow.nprofile < compareInfoRow2.nprofile) {
                return -1;
            }
            if (compareInfoRow.nprofile > compareInfoRow2.nprofile) {
                return 1;
            }
            return 0;
        }
    }

    public class SupriseComparator
    implements Comparator {
        int norigprofile;

        SupriseComparator(int n) {
            this.norigprofile = n;
        }

        public int compare(Object object, Object object2) {
            double d;
            CompareInfo.CompareInfoRec compareInfoRec = (CompareInfo.CompareInfoRec)object;
            CompareInfo.CompareInfoRec compareInfoRec2 = (CompareInfo.CompareInfoRec)object2;
            double d2 = Util.correlation(CompareGui.this.theCompareInfo.origset.modelprofiles[this.norigprofile], CompareGui.this.theCompareInfo.comparesetfmnel.modelprofiles[compareInfoRec.nprofile]);
            if (d2 < (d = Util.correlation(CompareGui.this.theCompareInfo.origset.modelprofiles[this.norigprofile], CompareGui.this.theCompareInfo.comparesetfmnel.modelprofiles[compareInfoRec2.nprofile]))) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            if (compareInfoRec.nprofile < compareInfoRec2.nprofile) {
                return -1;
            }
            if (compareInfoRec.nprofile > compareInfoRec2.nprofile) {
                return 1;
            }
            return 0;
        }
    }

    public static class SigComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            CompareInfo.CompareInfoRec compareInfoRec = (CompareInfo.CompareInfoRec)object;
            CompareInfo.CompareInfoRec compareInfoRec2 = (CompareInfo.CompareInfoRec)object2;
            if (compareInfoRec.dpval < compareInfoRec2.dpval) {
                return -1;
            }
            if (compareInfoRec.dpval > compareInfoRec2.dpval) {
                return 1;
            }
            if (compareInfoRec.nprofile < compareInfoRec2.nprofile) {
                return -1;
            }
            if (compareInfoRec.nprofile > compareInfoRec2.nprofile) {
                return 1;
            }
            return 0;
        }
    }

    public static class SigRowComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            CompareInfo.CompareInfoRow compareInfoRow = (CompareInfo.CompareInfoRow)object;
            CompareInfo.CompareInfoRow compareInfoRow2 = (CompareInfo.CompareInfoRow)object2;
            if (compareInfoRow.dminpval < compareInfoRow2.dminpval) {
                return -1;
            }
            if (compareInfoRow.dminpval > compareInfoRow2.dminpval) {
                return 1;
            }
            if (compareInfoRow.nprofile < compareInfoRow2.nprofile) {
                return -1;
            }
            if (compareInfoRow.nprofile > compareInfoRow2.nprofile) {
                return 1;
            }
            return 0;
        }
    }
}

