/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.drem;

import edu.cmu.cs.sb.core.DataSetCore;
import edu.cmu.cs.sb.drem.DREM_DataSet;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegulatorBindingData {
    public double[][][] gene2RegBinding;
    public int[][][] gene2RegBindingSigned;
    public double[][][] reg2GeneBinding;
    public int[][][] reg2GeneBindingSigned;
    public int[][][] reg2GeneBindingIndex;
    public int[][][] gene2RegBindingIndex;
    public double[][] gene2RegMaxBinding;
    public int[][] gene2RegMaxBindingIndex;
    public double[][] reg2GeneMaxBinding;
    public int[][] reg2GeneMaxBindingIndex;
    public int numberRegs;
    public int numberGenes;
    public String[] regNames;
    public HashMap<String, HashSet<String>> regSyns;
    public static final int TF = 0;
    public static final int MIRNA = 1;
    public static final String[] REGTYPE = new String[]{"TF", "MIRNA"};
    public int[] regTypes;
    public HashMap<String, Integer> regTypeMap;
    public HashMap<String, Integer> regRowMap;
    public HashSet<Integer> existingRegTypes;
    public double[] regPriors;
    public HashSet<Double> existingBindingValuesUnsorted;
    public double[] existingBindingValuesSorted;
    public int[] signedBindingValuesSorted;
    public HashSet<Integer> signedBindingValuesUnsorted;
    public HashMap<String, BindingGeneRec> geneID2RegBinding;
    public double[][][][] theInstances;
    public int[][][][] theInstancesIndex;
    public double[][][][] theInstancesReg;
    public int[][][][] theInstancesRegIndex;
    public int[][][] ylabels;
    public int timepoints;
    public int nbinding;
    public boolean[] bbindingdata;
    static final double ACTIVITY_EPSILON = 1.0E-8;
    static final double DEFAULTREGSCORE = 0.5;
    private String SZDELIM;
    private boolean BDEBUG;
    private boolean BFILTERBINDING;

    public RegulatorBindingData(String string, String string2, boolean bl, DREM_DataSet dREM_DataSet, String string3, boolean bl2, String string4, String string5, HashMap<String, Integer> hashMap) throws IOException {
        int n;
        Object object;
        int n2;
        int n3;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n4;
        this.SZDELIM = string3;
        this.geneID2RegBinding = new HashMap();
        this.existingBindingValuesUnsorted = new HashSet();
        this.BDEBUG = bl2;
        this.BFILTERBINDING = bl;
        this.numberRegs = 0;
        this.timepoints = dREM_DataSet.numcols;
        this.numberGenes = dREM_DataSet.numrows;
        this.regNames = new String[0];
        this.regTypes = new int[0];
        int n5 = 0;
        String[] stringArray = new String[]{string, string2};
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            if (stringArray[n4] == null || stringArray[n4].equals("")) continue;
            object5 = null;
            try {
                object5 = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(stringArray[n4]))));
            }
            catch (IOException iOException) {
                object5 = new BufferedReader(new FileReader(stringArray[n4]));
            }
            object4 = ((BufferedReader)object5).readLine();
            object3 = new StringTokenizer((String)object4, "\t");
            object2 = "";
            if (object4 == null) {
                throw new IllegalArgumentException("Empty regulator-gene interaction input file found!");
            }
            if (((String)object4).startsWith("\t")) {
                n3 = ((StringTokenizer)object3).countTokens();
            } else {
                n3 = ((StringTokenizer)object3).countTokens() - 1;
                object2 = ((StringTokenizer)object3).nextToken();
            }
            String[] stringArray2 = new String[n3];
            int n6 = 0;
            while (((StringTokenizer)object3).hasMoreTokens()) {
                stringArray2[n6] = ((StringTokenizer)object3).nextToken();
                ++n6;
            }
            n6 = (n3 == 2 || n3 == 3) && ((String)object2).equalsIgnoreCase(REGTYPE[n4]) && stringArray2[0].equalsIgnoreCase("GENE") ? 1 : 0;
            int n7 = n2 = n6 != 0 && n3 == 3 ? 1 : 0;
            if (n6 != 0) {
                this.parseThreeColFormat((BufferedReader)object5, n5, n4, n2 != 0, hashMap);
            } else {
                int n8;
                int n9;
                this.numberRegs = n5 + n3;
                object = new String[n5 + n3];
                for (n9 = 0; n9 < n5; ++n9) {
                    object[n9] = this.regNames[n9];
                }
                for (n9 = n5; n9 < this.numberRegs; ++n9) {
                    object[n9] = stringArray2[n9 - n5];
                }
                this.regNames = object;
                int[] nArray = new int[n5 + n3];
                for (n8 = 0; n8 < n5; ++n8) {
                    nArray[n8] = this.regTypes[n8];
                }
                for (n8 = n5; n8 < this.numberRegs; ++n8) {
                    nArray[n8] = n4;
                }
                this.regTypes = nArray;
                this.numberRegs = this.regNames.length;
                this.parseGridFormat((BufferedReader)object5, n5, n3);
            }
            n5 = this.numberRegs;
        }
        this.existingBindingValuesUnsorted.add(new Double(0.0));
        if (this.BFILTERBINDING) {
            int n10;
            this.nbinding = 0;
            n4 = 0;
            object5 = new BindingGeneRec[dREM_DataSet.data.length];
            for (n10 = 0; n10 < dREM_DataSet.data.length; ++n10) {
                object3 = this.getBindingObject(dREM_DataSet.genenames[n10], dREM_DataSet.probenames[n10]);
                if (object3 != null) {
                    object5[n10] = object3;
                    ++this.nbinding;
                    continue;
                }
                object5[n10] = null;
                ++n4;
            }
            System.out.println("filtering " + n4 + " genes");
            if (this.BDEBUG) {
                System.out.println("nbinding = " + this.nbinding);
            }
            this.gene2RegBinding = new double[this.timepoints][this.nbinding][];
            this.gene2RegBindingIndex = new int[this.timepoints][this.nbinding][];
            n10 = 0;
            System.out.println("nbinding: " + this.nbinding);
            this.bbindingdata = new boolean[dREM_DataSet.data.length];
            for (int i = 0; i < dREM_DataSet.data.length; ++i) {
                if (object5[i] != null) {
                    object2 = object5[i];
                    for (n3 = 0; n3 < this.timepoints; ++n3) {
                        this.gene2RegBinding[n3][n10] = ((BindingGeneRec)object2).gene2RegulatorBindingRec[n3];
                        if (((BindingGeneRec)object2).gene2RegulatorBindingRecIndex[n3] == null) {
                            System.out.println("ERROR BINDING REC INDEX IS NULL");
                        }
                        this.gene2RegBindingIndex[n3][n10] = ((BindingGeneRec)object2).gene2RegulatorBindingRecIndex[n3];
                        for (int j = 0; j < ((BindingGeneRec)object2).gene2RegulatorBindingRec[n3].length; ++j) {
                            this.existingBindingValuesUnsorted.add(new Double(((BindingGeneRec)object2).gene2RegulatorBindingRec[n3][j]));
                        }
                    }
                    ++n10;
                    this.bbindingdata[i] = true;
                    continue;
                }
                this.bbindingdata[i] = false;
            }
            System.out.println("Final nbindingindex: " + n10);
            System.out.println();
        } else {
            this.gene2RegBinding = new double[this.timepoints][dREM_DataSet.data.length][];
            this.gene2RegBindingIndex = new int[this.timepoints][dREM_DataSet.data.length][];
            for (n4 = 0; n4 < this.timepoints; ++n4) {
                for (int i = 0; i < dREM_DataSet.data.length; ++i) {
                    object4 = this.getBindingObject(dREM_DataSet.genenames[i], dREM_DataSet.probenames[i]);
                    if (object4 != null) {
                        object3 = (BindingGeneRec)object4;
                        this.gene2RegBinding[n4][i] = ((BindingGeneRec)object3).gene2RegulatorBindingRec[n4];
                        this.gene2RegBindingIndex[n4][i] = ((BindingGeneRec)object3).gene2RegulatorBindingRecIndex[n4];
                        for (int j = 0; j < ((BindingGeneRec)object3).gene2RegulatorBindingRec[n4].length; ++j) {
                            this.existingBindingValuesUnsorted.add(new Double(((BindingGeneRec)object3).gene2RegulatorBindingRec[n4][j]));
                        }
                        continue;
                    }
                    this.gene2RegBinding[n4][i] = new double[0];
                    this.gene2RegBindingIndex[n4][i] = new int[0];
                }
            }
        }
        this.reg2GeneBindingIndex = new int[this.timepoints][this.numberRegs][];
        this.reg2GeneBinding = new double[this.timepoints][this.numberRegs][];
        this.gene2RegBindingSigned = new int[this.timepoints][][];
        this.reg2GeneBindingSigned = new int[this.timepoints][][];
        for (n4 = 0; n4 < this.timepoints; ++n4) {
            this.makeRegulatorIndex(this.gene2RegBinding[n4], this.gene2RegBindingIndex[n4], this.reg2GeneBinding[n4], this.reg2GeneBindingIndex[n4]);
        }
        this.makeSigned(this.gene2RegBinding, this.gene2RegBindingSigned);
        this.makeSigned(this.reg2GeneBinding, this.reg2GeneBindingSigned);
        n4 = 0;
        this.existingBindingValuesSorted = new double[this.existingBindingValuesUnsorted.size()];
        for (Double d : this.existingBindingValuesUnsorted) {
            this.existingBindingValuesSorted[n4] = d;
            ++n4;
        }
        Arrays.sort(this.existingBindingValuesSorted);
        this.signedBindingValuesUnsorted = new HashSet();
        for (Double d : this.existingBindingValuesUnsorted) {
            this.signedBindingValuesUnsorted.add(new Integer((int)Math.signum(d)));
        }
        this.signedBindingValuesSorted = new int[this.signedBindingValuesUnsorted.size()];
        int n11 = 0;
        for (Integer n12 : this.signedBindingValuesUnsorted) {
            this.signedBindingValuesSorted[n11] = n12;
            ++n11;
        }
        Arrays.sort(this.signedBindingValuesSorted);
        HashSet hashSet = new HashSet();
        this.regSyns = new HashMap();
        if (string5 != null && !string5.equals("")) {
            for (int i = 0; i < this.regNames.length; ++i) {
                hashSet.add(this.regNames[i].toUpperCase());
                this.regSyns.put(this.regNames[i].toUpperCase(), new HashSet());
            }
            this.buildxref(hashSet, this.regSyns, string5);
        }
        this.regRowMap = new HashMap();
        for (int i = 0; i < this.regNames.length; ++i) {
            this.regRowMap.put(this.regNames[i], i);
        }
        if (string4 != null && !string4.equals("")) {
            String string6;
            this.regPriors = new double[this.numberRegs];
            boolean[] blArray = new boolean[this.numberRegs];
            double d = 0.0;
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string4))));
            }
            catch (IOException iOException) {
                bufferedReader = new BufferedReader(new FileReader(string4));
            }
            while ((string6 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string6, "\t");
                if (stringTokenizer.countTokens() != 2) {
                    throw new IOException("The regulator score file should have two columns: <regulator>\t<score>");
                }
                object = stringTokenizer.nextToken();
                double d2 = Double.parseDouble(stringTokenizer.nextToken());
                Integer n13 = this.regRowMap.get(object);
                if (n13 == null) {
                    if (this.regSyns.containsKey(object)) {
                        String string7;
                        Iterator<String> iterator = this.regSyns.get(object).iterator();
                        while (iterator.hasNext() && (n13 = this.regRowMap.get(string7 = iterator.next())) == null) {
                        }
                    }
                    if (n13 == null) {
                        throw new IOException("All regulators in the regulator score should either be in or have a synonym in the regulator binding data file.");
                    }
                }
                this.regPriors[n13.intValue()] = d2;
                blArray[n13.intValue()] = true;
                d = Math.max(d, d2);
            }
            if (d > 1.0) {
                int n14 = 0;
                while (n14 < this.regPriors.length) {
                    int n15 = n14++;
                    this.regPriors[n15] = this.regPriors[n15] / d;
                }
            }
            for (n2 = 0; n2 < this.regPriors.length; ++n2) {
                if (blArray[n2]) {
                    if (this.regPriors[n2] > 1.0E-8) {
                        int n16 = n2;
                        this.regPriors[n16] = this.regPriors[n16] - 1.0E-8;
                        continue;
                    }
                    this.regPriors[n2] = 0.0;
                    continue;
                }
                this.regPriors[n2] = 0.5;
            }
        }
        this.existingRegTypes = new HashSet();
        for (n = 0; n < this.regTypes.length; ++n) {
            this.existingRegTypes.add(this.regTypes[n]);
        }
        this.regTypeMap = new HashMap();
        for (n = 0; n < this.regTypes.length; ++n) {
            this.regTypeMap.put(this.regNames[n], this.regTypes[n]);
        }
        this.gene2RegMaxBinding = new double[this.gene2RegBinding[0].length][];
        this.gene2RegMaxBindingIndex = new int[this.gene2RegBinding[0].length][];
        for (n = 0; n < this.gene2RegBinding[0].length; ++n) {
            int n17;
            double[] dArray = new double[this.numberRegs];
            n3 = 0;
            for (n17 = 0; n17 < this.gene2RegBinding.length; ++n17) {
                for (int i = 0; i < this.gene2RegBinding[n17][n].length; ++i) {
                    if (this.gene2RegBinding[n17][n][i] == 0.0) continue;
                    n2 = this.gene2RegBindingIndex[n17][n][i];
                    if (dArray[n2] == 0.0) {
                        ++n3;
                        dArray[n2] = this.gene2RegBinding[n17][n][i];
                        continue;
                    }
                    if (!(Math.abs(this.gene2RegBinding[n17][n][i]) > Math.abs(dArray[n2]))) continue;
                    dArray[n2] = this.gene2RegBinding[n17][n][i];
                }
            }
            this.gene2RegMaxBinding[n] = new double[n3];
            this.gene2RegMaxBindingIndex[n] = new int[n3];
            n17 = 0;
            for (int i = 0; i < this.numberRegs; ++i) {
                if (dArray[i] == 0.0) continue;
                this.gene2RegMaxBinding[n][n17] = dArray[i];
                this.gene2RegMaxBindingIndex[n][n17] = i;
                ++n17;
            }
        }
        this.reg2GeneMaxBinding = new double[this.numberRegs][];
        this.reg2GeneMaxBindingIndex = new int[this.numberRegs][];
        this.makeRegulatorIndex(this.gene2RegMaxBinding, this.gene2RegMaxBindingIndex, this.reg2GeneMaxBinding, this.reg2GeneMaxBindingIndex);
    }

    public RegulatorBindingData(RegulatorBindingData regulatorBindingData, boolean[] blArray, int n, boolean bl) {
        if (bl) {
            int n2;
            this.timepoints = regulatorBindingData.timepoints;
            this.gene2RegBinding = new double[this.timepoints][n][];
            this.gene2RegBindingIndex = new int[this.timepoints][n][];
            this.existingBindingValuesUnsorted = new HashSet();
            for (n2 = 0; n2 < this.timepoints; ++n2) {
                int n3 = 0;
                for (int i = 0; i < blArray.length; ++i) {
                    if (!blArray[i]) continue;
                    this.gene2RegBinding[n2][n3] = new double[regulatorBindingData.gene2RegBinding[n2][i].length];
                    this.gene2RegBindingIndex[n2][n3] = new int[regulatorBindingData.gene2RegBindingIndex[n2][i].length];
                    for (int j = 0; j < regulatorBindingData.gene2RegBinding[n2][i].length; ++j) {
                        this.gene2RegBinding[n2][n3][j] = regulatorBindingData.gene2RegBinding[n2][i][j];
                        this.gene2RegBindingIndex[n2][n3][j] = regulatorBindingData.gene2RegBindingIndex[n2][i][j];
                        this.existingBindingValuesUnsorted.add(this.gene2RegBinding[n2][n3][j]);
                    }
                    ++n3;
                }
            }
            this.numberRegs = regulatorBindingData.numberRegs;
            this.reg2GeneBinding = new double[this.timepoints][this.numberRegs][];
            this.reg2GeneBindingIndex = new int[this.timepoints][this.numberRegs][];
            this.gene2RegBindingSigned = new int[this.timepoints][][];
            this.reg2GeneBindingSigned = new int[this.timepoints][][];
            for (n2 = 0; n2 < this.timepoints; ++n2) {
                this.makeRegulatorIndex(this.gene2RegBinding[n2], this.gene2RegBindingIndex[n2], this.reg2GeneBinding[n2], this.reg2GeneBindingIndex[n2]);
            }
            this.makeSigned(this.gene2RegBinding, this.gene2RegBindingSigned);
            this.makeSigned(this.reg2GeneBinding, this.reg2GeneBindingSigned);
            this.regNames = new String[this.numberRegs];
            this.regTypes = new int[this.numberRegs];
            if (regulatorBindingData.regPriors != null) {
                this.regPriors = new double[this.numberRegs];
                for (n2 = 0; n2 < this.numberRegs; ++n2) {
                    this.regPriors[n2] = regulatorBindingData.regPriors[n2];
                }
            }
            this.existingRegTypes = new HashSet();
            this.regRowMap = new HashMap();
            for (n2 = 0; n2 < this.numberRegs; ++n2) {
                this.regNames[n2] = regulatorBindingData.regNames[n2];
                this.regTypes[n2] = regulatorBindingData.regTypes[n2];
                this.existingRegTypes.add(this.regTypes[n2]);
                this.regRowMap.put(this.regNames[n2], n2);
            }
            this.existingBindingValuesSorted = new double[this.existingBindingValuesUnsorted.size()];
            n2 = 0;
            for (Double d : this.existingBindingValuesUnsorted) {
                this.existingBindingValuesSorted[n2] = d;
                ++n2;
            }
            Arrays.sort(this.existingBindingValuesSorted);
            this.signedBindingValuesUnsorted = new HashSet();
            for (Double d : this.existingBindingValuesUnsorted) {
                this.signedBindingValuesUnsorted.add((int)Math.signum(d));
            }
            this.signedBindingValuesSorted = new int[this.signedBindingValuesUnsorted.size()];
            int n4 = 0;
            for (Integer n5 : this.signedBindingValuesUnsorted) {
                this.signedBindingValuesSorted[n4] = n5;
                ++n4;
            }
            Arrays.sort(this.signedBindingValuesSorted);
            this.regSyns = regulatorBindingData.regSyns;
            this.regTypeMap = regulatorBindingData.regTypeMap;
            this.numberGenes = n;
            this.gene2RegMaxBinding = new double[n][];
            this.gene2RegMaxBindingIndex = new int[n][];
            for (int i = 0; i < n; ++i) {
                int n6;
                int n7;
                double[] dArray = new double[this.numberRegs];
                int n8 = 0;
                for (n7 = 0; n7 < this.timepoints; ++n7) {
                    for (n6 = 0; n6 < this.gene2RegBinding[n7][i].length; ++n6) {
                        if (this.gene2RegBinding[n7][i][n6] == 0.0) continue;
                        int n9 = this.gene2RegBindingIndex[n7][i][n6];
                        if (dArray[n9] == 0.0) {
                            ++n8;
                            dArray[n9] = this.gene2RegBinding[n7][i][n6];
                            continue;
                        }
                        if (!(Math.abs(this.gene2RegBinding[n7][i][n6]) > Math.abs(dArray[n9]))) continue;
                        dArray[n9] = this.gene2RegBinding[n7][i][n6];
                    }
                }
                this.gene2RegMaxBinding[i] = new double[n8];
                this.gene2RegMaxBindingIndex[i] = new int[n8];
                n7 = 0;
                for (n6 = 0; n6 < this.numberRegs; ++n6) {
                    if (dArray[n6] == 0.0) continue;
                    this.gene2RegMaxBinding[i][n7] = dArray[n6];
                    this.gene2RegMaxBindingIndex[i][n7] = n6;
                    ++n7;
                }
            }
        } else {
            int n10;
            int n11;
            int n12;
            System.out.println("FILTERING MIRNA");
            for (int i = 0; i < blArray.length; ++i) {
                System.out.println("Reg: " + regulatorBindingData.regNames[i]);
                System.out.println("\tKeeping? " + blArray[i]);
            }
            this.numberGenes = regulatorBindingData.numberGenes;
            this.timepoints = regulatorBindingData.timepoints;
            this.existingBindingValuesUnsorted = new HashSet();
            int[] nArray = new int[blArray.length];
            int n13 = 0;
            for (n12 = 0; n12 < nArray.length; ++n12) {
                if (blArray[n12]) {
                    nArray[n12] = n13++;
                    System.out.println("New index for " + n12 + " is " + nArray[n12]);
                    continue;
                }
                nArray[n12] = -1;
            }
            this.numberRegs = n13;
            this.gene2RegBinding = new double[this.timepoints][this.numberGenes][];
            this.gene2RegBindingIndex = new int[this.timepoints][this.numberGenes][];
            for (n12 = 0; n12 < regulatorBindingData.gene2RegBinding.length; ++n12) {
                for (n11 = 0; n11 < regulatorBindingData.gene2RegBinding[n12].length; ++n11) {
                    int n14;
                    int n15 = 0;
                    for (n14 = 0; n14 < regulatorBindingData.gene2RegBinding[n12][n11].length; ++n14) {
                        if (!blArray[regulatorBindingData.gene2RegBindingIndex[n12][n11][n14]]) continue;
                        ++n15;
                    }
                    this.gene2RegBinding[n12][n11] = new double[n15];
                    this.gene2RegBindingIndex[n12][n11] = new int[n15];
                    n15 = 0;
                    for (n14 = 0; n14 < regulatorBindingData.gene2RegBinding[n12][n11].length; ++n14) {
                        if (!blArray[regulatorBindingData.gene2RegBindingIndex[n12][n11][n14]]) continue;
                        this.gene2RegBinding[n12][n11][n15] = regulatorBindingData.gene2RegBinding[n12][n11][n14];
                        this.gene2RegBindingIndex[n12][n11][n15] = nArray[regulatorBindingData.gene2RegBindingIndex[n12][n11][n14]];
                        this.existingBindingValuesUnsorted.add(regulatorBindingData.gene2RegBinding[n12][n11][n14]);
                        ++n15;
                    }
                }
            }
            for (n12 = 0; n12 < this.gene2RegBinding[0].length; ++n12) {
                System.out.println("Gene " + n12);
                for (n11 = 0; n11 < this.gene2RegBinding[0][n12].length; ++n11) {
                    System.out.println("\tReg " + this.gene2RegBindingIndex[0][n12][n11]);
                }
            }
            this.reg2GeneBinding = new double[this.timepoints][this.numberRegs][];
            this.reg2GeneBindingIndex = new int[this.timepoints][this.numberRegs][];
            this.gene2RegBindingSigned = new int[this.timepoints][][];
            this.reg2GeneBindingSigned = new int[this.timepoints][][];
            for (n12 = 0; n12 < this.timepoints; ++n12) {
                this.makeRegulatorIndex(this.gene2RegBinding[n12], this.gene2RegBindingIndex[n12], this.reg2GeneBinding[n12], this.reg2GeneBindingIndex[n12]);
            }
            this.makeSigned(this.gene2RegBinding, this.gene2RegBindingSigned);
            this.makeSigned(this.reg2GeneBinding, this.reg2GeneBindingSigned);
            this.regNames = new String[this.numberRegs];
            this.regTypes = new int[this.numberRegs];
            if (regulatorBindingData.regPriors != null) {
                this.regPriors = new double[this.numberRegs];
                for (n12 = 0; n12 < regulatorBindingData.numberRegs; ++n12) {
                    if (!blArray[n12]) continue;
                    this.regPriors[nArray[n12]] = regulatorBindingData.regPriors[n12];
                }
            }
            this.existingRegTypes = new HashSet();
            this.regRowMap = new HashMap();
            for (n12 = 0; n12 < regulatorBindingData.numberRegs; ++n12) {
                if (!blArray[n12]) continue;
                this.regNames[nArray[n12]] = regulatorBindingData.regNames[n12];
                this.regTypes[nArray[n12]] = regulatorBindingData.regTypes[n12];
                this.existingRegTypes.add(this.regTypes[nArray[n12]]);
                this.regRowMap.put(this.regNames[nArray[n12]], nArray[n12]);
            }
            this.existingBindingValuesSorted = new double[this.existingBindingValuesUnsorted.size()];
            n12 = 0;
            for (Double d : this.existingBindingValuesUnsorted) {
                this.existingBindingValuesSorted[n12] = d;
                ++n12;
            }
            Arrays.sort(this.existingBindingValuesSorted);
            this.signedBindingValuesUnsorted = new HashSet();
            for (Double d : this.existingBindingValuesUnsorted) {
                this.signedBindingValuesUnsorted.add((int)Math.signum(d));
            }
            this.signedBindingValuesSorted = new int[this.signedBindingValuesUnsorted.size()];
            int n16 = 0;
            for (Integer n17 : this.signedBindingValuesUnsorted) {
                this.signedBindingValuesSorted[n16] = n17;
                ++n16;
            }
            Arrays.sort(this.signedBindingValuesSorted);
            this.regSyns = regulatorBindingData.regSyns;
            this.regTypeMap = regulatorBindingData.regTypeMap;
            this.numberGenes = regulatorBindingData.numberGenes;
            this.gene2RegMaxBinding = new double[this.numberGenes][];
            this.gene2RegMaxBindingIndex = new int[this.numberGenes][];
            for (n10 = 0; n10 < this.numberGenes; ++n10) {
                int n18;
                int n19;
                double[] dArray = new double[this.numberRegs];
                int n20 = 0;
                for (n19 = 0; n19 < this.timepoints; ++n19) {
                    for (n18 = 0; n18 < this.gene2RegBinding[n19][n10].length; ++n18) {
                        if (this.gene2RegBinding[n19][n10][n18] == 0.0) continue;
                        int n21 = this.gene2RegBindingIndex[n19][n10][n18];
                        if (dArray[n21] == 0.0) {
                            ++n20;
                            dArray[n21] = this.gene2RegBinding[n19][n10][n18];
                            continue;
                        }
                        if (!(Math.abs(this.gene2RegBinding[n19][n10][n18]) > Math.abs(dArray[n21]))) continue;
                        dArray[n21] = this.gene2RegBinding[n19][n10][n18];
                    }
                }
                this.gene2RegMaxBinding[n10] = new double[n20];
                this.gene2RegMaxBindingIndex[n10] = new int[n20];
                n19 = 0;
                for (n18 = 0; n18 < this.numberRegs; ++n18) {
                    if (dArray[n18] == 0.0) continue;
                    this.gene2RegMaxBinding[n10][n19] = dArray[n18];
                    this.gene2RegMaxBindingIndex[n10][n19] = n18;
                    ++n19;
                }
            }
            System.out.println("FILTERING FINISHED");
            System.out.println("Number regs: " + this.numberRegs);
            for (n16 = 0; n16 < this.regNames.length; ++n16) {
                System.out.println("Reg: " + this.regNames[n16]);
                System.out.println("Binding for reg " + n16 + ":");
                for (n10 = 0; n10 < this.reg2GeneBinding[0][n16].length; ++n10) {
                    System.out.println("\tBinds " + this.reg2GeneBindingIndex[0][n16][n10]);
                }
            }
        }
    }

    private void parseThreeColFormat(BufferedReader bufferedReader, int n, int n2, boolean bl, HashMap<String, Integer> hashMap) throws IOException {
        Object object;
        Object object2;
        RegulatorRec[] regulatorRecArray;
        Object object3;
        Object object42;
        String string;
        HashMap<GeneAndTimepoint, ArrayList<RegulatorRec>> hashMap2 = new HashMap<GeneAndTimepoint, ArrayList<RegulatorRec>>();
        HashMap<Object, Integer> hashMap3 = new HashMap<Object, Integer>();
        int n3 = n;
        while ((string = bufferedReader.readLine()) != null) {
            int n4;
            double d;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            object42 = stringTokenizer.nextToken();
            object3 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                regulatorRecArray = stringTokenizer.nextToken();
                try {
                    d = Double.parseDouble((String)regulatorRecArray);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException((String)regulatorRecArray + " is not a" + " valid score for a regulator-gene interaction");
                }
            } else {
                d = 1.0;
            }
            regulatorRecArray = -1;
            if (bl) {
                object2 = "";
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new IOException("Timepoints should be associated with every entry.");
                }
                object2 = stringTokenizer.nextToken();
                regulatorRecArray = hashMap.get(((String)object2).toUpperCase());
                if (regulatorRecArray == null && object2 == "0") {
                    regulatorRecArray = 0;
                }
                if (regulatorRecArray == null) {
                    throw new IOException("Please annotate all binding data with a timepoint from the expression data.  " + regulatorRecArray + " is not a valid timepoint.");
                }
            }
            if ((object2 = (Integer)hashMap3.get(object42)) == null) {
                n4 = n3;
                hashMap3.put(object42, new Integer(n3));
                ++n3;
            } else {
                n4 = (Integer)object2;
            }
            GeneAndTimepoint geneAndTimepoint = new GeneAndTimepoint((String)object3, regulatorRecArray.intValue());
            object = (ArrayList<RegulatorRec>)hashMap2.get(geneAndTimepoint);
            if (object == null) {
                object = new ArrayList<RegulatorRec>();
            }
            ((ArrayList)object).add(new RegulatorRec(n4, d));
            hashMap2.put(geneAndTimepoint, (ArrayList<RegulatorRec>)object);
        }
        bufferedReader.close();
        if (n > 0) {
            int n5 = hashMap3.size();
            object42 = new String[n + n5];
            for (int i = 0; i < n; ++i) {
                object42[i] = this.regNames[i];
            }
            this.regNames = object42;
            object3 = new int[n + n5];
            for (int i = 0; i < n; ++i) {
                object3[i] = this.regTypes[i];
            }
            this.regTypes = (int[])object3;
            this.numberRegs = this.regNames.length;
        } else {
            this.numberRegs = hashMap3.size();
            this.regNames = new String[this.numberRegs];
            this.regTypes = new int[this.numberRegs];
        }
        for (Object object42 : hashMap3.keySet()) {
            int n6 = (Integer)hashMap3.get(object42);
            this.regNames[n6] = object42;
            this.regTypes[n6] = n2;
        }
        for (GeneAndTimepoint geneAndTimepoint : hashMap2.keySet()) {
            ArrayList arrayList = (ArrayList)hashMap2.get(geneAndTimepoint);
            int n7 = arrayList.size();
            regulatorRecArray = new RegulatorRec[n7];
            for (int i = 0; i < n7; ++i) {
                regulatorRecArray[i] = (RegulatorRec)arrayList.get(i);
            }
            Arrays.sort(regulatorRecArray, new RegulatorRecCompare());
            object2 = new int[n7];
            double[] dArray = new double[n7];
            for (int i = 0; i < n7; ++i) {
                object = regulatorRecArray[i];
                object2[i] = ((RegulatorRec)object).nRegulatorIndex;
                dArray[i] = ((RegulatorRec)object).nRegVal;
            }
            this.loadBinding(geneAndTimepoint.gene, (int[])object2, dArray, n7, geneAndTimepoint.timepoint);
        }
    }

    private void parseGridFormat(BufferedReader bufferedReader, int n, int n2) throws IOException {
        String string;
        int[] nArray = new int[n2];
        double[] dArray = new double[n2];
        while ((string = bufferedReader.readLine()) != null) {
            int n3 = 0;
            if (string.trim().equals("")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            int n4 = stringTokenizer.countTokens();
            if (n2 != n4 - 1) {
                throw new IllegalArgumentException("Found a line with " + (n4 - 1) + " entries, expecting " + this.numberRegs);
            }
            String string2 = stringTokenizer.nextToken();
            for (int i = 0; i < n2; ++i) {
                String string3 = stringTokenizer.nextToken();
                try {
                    double d = Double.parseDouble(string3);
                    if (d == 0.0) continue;
                    nArray[n3] = n + i;
                    dArray[n3] = d;
                    ++n3;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.numberRegs == 2 && i == 0) {
                        throw new IllegalArgumentException("If regulator-gene data is in column format, then the first two columns must have the headers 'Regulator Type' and 'Gene'");
                    }
                    throw new IllegalArgumentException(string3 + " is not a valid value for a " + "regulator-gene interaction!");
                }
            }
            this.loadBinding(string2, nArray, dArray, n3, -1);
        }
        bufferedReader.close();
    }

    public void loadBinding(String string, int[] nArray, double[] dArray, int n, int n2) {
        String string2 = string.toUpperCase(Locale.ENGLISH);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, this.SZDELIM);
        BindingGeneRec bindingGeneRec = new BindingGeneRec();
        bindingGeneRec.gene2RegulatorBindingRecIndex = new int[this.timepoints][n];
        bindingGeneRec.gene2RegulatorBindingRec = new double[this.timepoints][n];
        for (int i = 0; i < this.timepoints; ++i) {
            if (n2 == -1 || i == n2) {
                for (int j = 0; j < n; ++j) {
                    bindingGeneRec.gene2RegulatorBindingRecIndex[i][j] = nArray[j];
                    bindingGeneRec.gene2RegulatorBindingRec[i][j] = dArray[j];
                }
                continue;
            }
            bindingGeneRec.gene2RegulatorBindingRec[i] = new double[0];
            bindingGeneRec.gene2RegulatorBindingRecIndex[i] = new int[0];
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            BindingGeneRec bindingGeneRec2 = this.geneID2RegBinding.get(string3);
            if (bindingGeneRec2 != null) {
                bindingGeneRec = this.mergeArrays(bindingGeneRec.gene2RegulatorBindingRec, bindingGeneRec.gene2RegulatorBindingRecIndex, bindingGeneRec2.gene2RegulatorBindingRec, bindingGeneRec2.gene2RegulatorBindingRecIndex);
            }
            if (bindingGeneRec.gene2RegulatorBindingRec == null) {
                System.out.println("ERROR binding array is null");
            }
            if (bindingGeneRec.gene2RegulatorBindingRecIndex == null) {
                System.out.println("ERROR index array is null");
            }
            for (int i = 0; i < bindingGeneRec.gene2RegulatorBindingRec.length; ++i) {
                if (bindingGeneRec.gene2RegulatorBindingRec[i] == null) {
                    System.out.println("ERROR binding " + i + " array is null");
                }
                if (bindingGeneRec.gene2RegulatorBindingRecIndex[i] != null) continue;
                System.out.println("ERROR index " + i + " array is null");
            }
            this.geneID2RegBinding.put(string3, bindingGeneRec);
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "_");
            if (stringTokenizer2.countTokens() <= 1) continue;
            String string4 = stringTokenizer2.nextToken();
            bindingGeneRec2 = this.geneID2RegBinding.get(string4);
            if (bindingGeneRec2 != null) {
                bindingGeneRec = this.mergeArrays(bindingGeneRec.gene2RegulatorBindingRec, bindingGeneRec.gene2RegulatorBindingRecIndex, bindingGeneRec2.gene2RegulatorBindingRec, bindingGeneRec2.gene2RegulatorBindingRecIndex);
            }
            if (bindingGeneRec.gene2RegulatorBindingRec == null) {
                System.out.println("ERROR array is null");
            }
            if (bindingGeneRec.gene2RegulatorBindingRecIndex == null) {
                System.out.println("ERROR index array is null");
            }
            for (int i = 0; i < bindingGeneRec.gene2RegulatorBindingRec.length; ++i) {
                if (bindingGeneRec.gene2RegulatorBindingRec[i] == null) {
                    System.out.println("ERROR binding " + i + " array is null");
                }
                if (bindingGeneRec.gene2RegulatorBindingRecIndex[i] != null) continue;
                System.out.println("ERROR index " + i + " array is null");
            }
            this.geneID2RegBinding.put(string4, bindingGeneRec);
        }
    }

    public BindingGeneRec getBindingObject(String string, String string2) {
        String string3;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, this.SZDELIM);
        BindingGeneRec bindingGeneRec = null;
        while (stringTokenizer.hasMoreTokens() && bindingGeneRec == null) {
            string3 = stringTokenizer.nextToken();
            bindingGeneRec = this.geneID2RegBinding.get(string3);
        }
        if (bindingGeneRec == null) {
            stringTokenizer = new StringTokenizer(string, this.SZDELIM);
            while (stringTokenizer.hasMoreTokens() && bindingGeneRec == null) {
                string3 = stringTokenizer.nextToken();
                bindingGeneRec = this.geneID2RegBinding.get(string3);
            }
        }
        return bindingGeneRec;
    }

    private BindingGeneRec mergeArrays(double[][] dArray, int[][] nArray, double[][] dArray2, int[][] nArray2) {
        BindingGeneRec bindingGeneRec = new BindingGeneRec();
        bindingGeneRec.gene2RegulatorBindingRec = new double[this.timepoints][];
        bindingGeneRec.gene2RegulatorBindingRecIndex = new int[this.timepoints][];
        for (int i = 0; i < this.timepoints; ++i) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n < nArray[i].length && n2 < nArray2[i].length) {
                if (nArray[i][n] == nArray2[i][n2]) {
                    ++n3;
                    ++n;
                    ++n2;
                    continue;
                }
                if (nArray[i][n] < nArray2[i][n2]) {
                    ++n;
                    continue;
                }
                if (nArray2[i][n2] >= nArray[i][n]) continue;
                ++n2;
            }
            int n4 = nArray[i].length + nArray2[i].length - n3;
            bindingGeneRec.gene2RegulatorBindingRec[i] = new double[n4];
            bindingGeneRec.gene2RegulatorBindingRecIndex[i] = new int[n4];
            int n5 = 0;
            n = 0;
            n2 = 0;
            while (n < nArray[i].length && n2 < nArray2[i].length) {
                if (nArray[i][n] == nArray2[i][n2]) {
                    bindingGeneRec.gene2RegulatorBindingRec[i][n5] = Math.max(dArray[i][n], dArray2[i][n2]);
                    bindingGeneRec.gene2RegulatorBindingRecIndex[i][n5] = nArray2[i][n2];
                    ++n;
                    ++n2;
                } else if (nArray[i][n] < nArray2[i][n2]) {
                    bindingGeneRec.gene2RegulatorBindingRec[i][n5] = dArray[i][n];
                    bindingGeneRec.gene2RegulatorBindingRecIndex[i][n5] = nArray[i][n];
                    ++n;
                } else if (nArray2[i][n2] < nArray[i][n]) {
                    bindingGeneRec.gene2RegulatorBindingRec[i][n5] = dArray2[i][n2];
                    bindingGeneRec.gene2RegulatorBindingRecIndex[i][n5] = nArray2[i][n2];
                    ++n2;
                }
                ++n5;
            }
            while (n2 < nArray2[i].length) {
                bindingGeneRec.gene2RegulatorBindingRec[i][n5] = dArray2[i][n2];
                bindingGeneRec.gene2RegulatorBindingRecIndex[i][n5] = nArray2[i][n2];
                ++n5;
                ++n2;
            }
            while (n < nArray[i].length) {
                bindingGeneRec.gene2RegulatorBindingRec[i][n5] = dArray[i][n];
                bindingGeneRec.gene2RegulatorBindingRecIndex[i][n5] = nArray[i][n];
                ++n5;
                ++n;
            }
        }
        return bindingGeneRec;
    }

    public void makeRegulatorIndex(double[][] dArray, int[][] nArray, double[][] dArray2, int[][] nArray2) {
        int n;
        int n2;
        int[] nArray3 = new int[dArray2.length];
        int n3 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] == null) {
                System.out.println("Null index is: " + n2);
            }
            for (n = 0; n < nArray[n2].length; ++n) {
                int n4 = nArray[n2][n];
                nArray3[n4] = nArray3[n4] + 1;
                ++n3;
            }
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            dArray2[n2] = new double[nArray3[n2]];
            nArray2[n2] = new int[nArray3[n2]];
        }
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            nArray3[n2] = 0;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            for (n = 0; n < nArray[n2].length; ++n) {
                int n5 = nArray[n2][n];
                int n6 = nArray3[nArray[n2][n]];
                dArray2[n5][n6] = dArray[n2][n];
                nArray2[n5][n6] = n2;
                int n7 = n5;
                nArray3[n7] = nArray3[n7] + 1;
            }
        }
    }

    public void makeSigned(double[][][] dArray, int[][][] nArray) {
        for (int i = 0; i < this.timepoints; ++i) {
            nArray[i] = new int[dArray[i].length][];
            for (int j = 0; j < dArray[i].length; ++j) {
                nArray[i][j] = new int[dArray[i][j].length];
                for (int k = 0; k < dArray[i][j].length; ++k) {
                    nArray[i][j][k] = (int)Math.signum(dArray[i][j][k]);
                }
            }
        }
    }

    public void buildxref(HashSet<String> hashSet, HashMap<String, HashSet<String>> hashMap, String string) throws FileNotFoundException, IOException {
        if (string != null && !string.equals("")) {
            String string2;
            BufferedReader bufferedReader;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string))));
            }
            catch (IOException iOException) {
                bufferedReader = new BufferedReader(new FileReader(string));
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                HashSet<Object> hashSet2 = new HashSet<Object>(3);
                HashSet<Object> hashSet3 = new HashSet<Object>();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\"\t;|,");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken().trim().toUpperCase();
                    hashSet3.add(string3);
                    if (!hashSet.contains(string3)) continue;
                    hashSet2.add(string3);
                }
                if (hashSet2.isEmpty()) continue;
                for (String string4 : hashSet3) {
                    HashSet<String> hashSet4 = hashMap.get(string4);
                    if (hashSet4 == null) {
                        hashSet4 = new HashSet();
                    }
                    hashSet4.addAll(hashSet2);
                    hashMap.put(string4, hashSet4);
                }
            }
            bufferedReader.close();
        }
    }

    public void adjustBindingData(HashMap<String, Integer> hashMap, DREM_DataSet dREM_DataSet, DataSetCore dataSetCore, boolean bl, boolean bl2, double d, double d2) {
        for (int i = 0; i < dREM_DataSet.numcols; ++i) {
            for (int j = 0; j < this.gene2RegBinding[i].length; ++j) {
                for (int k = 0; k < this.gene2RegBindingIndex[i][j].length; ++k) {
                    double d3 = this.gene2RegBinding[i][j][k];
                    int n = this.gene2RegBindingIndex[i][j][k];
                    Integer n2 = hashMap.get(this.regNames[n].toUpperCase());
                    if (d3 == 0.0) {
                        this.gene2RegBinding[i][j][k] = 0.0;
                    } else if (this.regTypes[n] == 1 && n2 != null && bl && i < this.timepoints - 1) {
                        this.gene2RegBinding[i][j][k] = this.logitShiftZeroNegative(dataSetCore.data[n2][i + 1] - dataSetCore.data[n2][i], d);
                    } else if (this.regTypes[n] == 0 && n2 != null && bl2 && i < this.timepoints - 1) {
                        double d4 = this.logitShiftZeroNegative(dREM_DataSet.data[n2][i + 1] - dREM_DataSet.data[n2][i], d);
                        if (Math.abs(d4) < d2) {
                            d4 = d2 * Math.signum(d4);
                        }
                        this.gene2RegBinding[i][j][k] = d4;
                    } else {
                        this.gene2RegBinding[i][j][k] = d3;
                    }
                    if (this.regPriors == null) continue;
                    double[] dArray = this.gene2RegBinding[i][j];
                    int n3 = k;
                    dArray[n3] = dArray[n3] * this.regPriors[k];
                }
            }
            this.makeRegulatorIndex(this.gene2RegBinding[i], this.gene2RegBindingIndex[i], this.reg2GeneBinding[i], this.reg2GeneBindingIndex[i]);
        }
    }

    public double logit(double d, double d2) {
        return 1.0 / (1.0 + Math.exp(-d2 * d));
    }

    public double logitShiftZeroNegative(double d, double d2) {
        if (d == 0.0) {
            return 0.0;
        }
        return Math.signum(d) * ((this.logit(Math.abs(d), d2) - 0.5) * 2.0);
    }

    public void loadInstances(int n, int n2) {
        this.theInstances = new double[this.timepoints][n - 1][][];
        this.ylabels = new int[this.timepoints][n - 1][];
        this.theInstancesIndex = new int[this.timepoints][n - 1][][];
        this.theInstancesReg = new double[this.timepoints][n - 1][][];
        this.theInstancesRegIndex = new int[this.timepoints][n - 1][][];
        for (int i = 2; i <= n; ++i) {
            for (int j = 0; j < this.timepoints; ++j) {
                this.theInstancesIndex[j][i - 2] = new int[i * this.gene2RegBindingIndex[j].length][];
                this.theInstancesRegIndex[j][i - 2] = new int[i * n2][];
                this.theInstances[j][i - 2] = new double[i * this.gene2RegBinding[j].length][];
                this.theInstancesReg[j][i - 2] = new double[i * n2][];
                this.ylabels[j][i - 2] = new int[i * this.gene2RegBinding[j].length];
                int n3 = 0;
                for (int k = 0; k < this.gene2RegBinding[j].length; ++k) {
                    int n4 = 0;
                    while (n4 < i) {
                        this.theInstances[j][i - 2][n3] = this.gene2RegBinding[j][k];
                        this.theInstancesIndex[j][i - 2][n3] = this.gene2RegBindingIndex[j][k];
                        this.ylabels[j][i - 2][n3] = n4++;
                        ++n3;
                    }
                }
                this.makeRegulatorIndex(this.theInstances[j][i - 2], this.theInstancesIndex[j][i - 2], this.theInstancesReg[j][i - 2], this.theInstancesRegIndex[j][i - 2]);
            }
        }
    }

    static class BindingGeneRec {
        double[][] gene2RegulatorBindingRec;
        int[][] gene2RegulatorBindingRecIndex;

        BindingGeneRec() {
        }
    }

    class GeneAndTimepoint {
        String gene;
        int timepoint;

        public GeneAndTimepoint(String string, int n) {
            this.gene = string;
            this.timepoint = n;
        }

        public int hashCode() {
            return this.gene.hashCode() + this.timepoint * 23;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RegulatorRecCompare
    implements Comparator<RegulatorRec> {
        private RegulatorRecCompare() {
        }

        @Override
        public int compare(RegulatorRec regulatorRec, RegulatorRec regulatorRec2) {
            if (regulatorRec.nRegulatorIndex < regulatorRec2.nRegulatorIndex) {
                return -1;
            }
            if (regulatorRec.nRegulatorIndex > regulatorRec2.nRegulatorIndex) {
                return 1;
            }
            return 0;
        }
    }

    private static class RegulatorRec {
        int nRegulatorIndex;
        double nRegVal;

        RegulatorRec(int n, double d) {
            this.nRegulatorIndex = n;
            this.nRegVal = d;
        }
    }
}

