/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.drem;

public final class DREM_FastLogistic2 {
    static final double EPSILON1 = 0.01;
    static final int MAXITERATIONS = 1000;
    static final double LAMBDA = 1.0;
    double[][] traindata;
    int[][] traindataindex;
    int[][] traindataTFindex;
    double[][] traindataTF;
    double[] initbeta;
    int[] y;
    double[] dyerror;
    double[] dipcache;
    double[][] dipcachemulti;
    double[] dtrainweight;
    double[] dbeta;
    double dridge = 1.0;
    double[] dcoeff;
    int numclasses;
    int numels;
    double doldcoeff;
    int numrows;
    double[] B;
    double[] g;
    int numcols;
    int[] regulatorTypes;
    int childExpStatus;

    public DREM_FastLogistic2() {
    }

    public DREM_FastLogistic2(int[][] nArray, double[][] dArray, int[][] nArray2, double[][] dArray2, int[] nArray3, int n, double[] dArray3, int n2, int[] nArray4) {
        this.traindataindex = nArray;
        this.traindata = dArray;
        this.traindataTF = dArray2;
        this.traindataTFindex = nArray2;
        this.numrows = dArray.length;
        this.y = nArray3;
        this.regulatorTypes = nArray4;
        this.numclasses = n;
        this.dcoeff = dArray3;
        this.numcols = n2 + 1;
        this.numels = (n - 1) * this.numcols;
        this.g = new double[this.numels];
        this.B = new double[this.numcols];
    }

    public DREM_FastLogistic2(int[][] nArray, double[][] dArray, int[][] nArray2, double[][] dArray2, int[] nArray3, double[] dArray3, int n, int n2, int[] nArray4) {
        this.traindataindex = nArray;
        this.traindata = dArray;
        this.traindataTFindex = nArray2;
        this.traindataTF = dArray2;
        this.numrows = dArray.length;
        this.y = nArray3;
        this.dtrainweight = dArray3;
        this.numclasses = n;
        this.regulatorTypes = nArray4;
        this.dyerror = new double[dArray3.length];
        if (n == 2) {
            this.dipcache = new double[dArray3.length];
        } else {
            this.dipcachemulti = new double[n - 1][dArray3.length];
        }
        this.numcols = n2 + 1;
        this.numels = (n - 1) * this.numcols;
        this.g = new double[this.numels];
        this.dcoeff = new double[this.numels];
        this.B = new double[this.numcols];
    }

    public Object clone() {
        DREM_FastLogistic2 dREM_FastLogistic2 = new DREM_FastLogistic2();
        dREM_FastLogistic2.traindata = this.traindata;
        dREM_FastLogistic2.traindataTF = this.traindataTF;
        dREM_FastLogistic2.traindataindex = this.traindataindex;
        dREM_FastLogistic2.traindataTFindex = this.traindataTFindex;
        dREM_FastLogistic2.initbeta = this.initbeta;
        dREM_FastLogistic2.y = this.y;
        dREM_FastLogistic2.dtrainweight = this.dtrainweight;
        dREM_FastLogistic2.dbeta = this.dbeta;
        dREM_FastLogistic2.dridge = this.dridge;
        dREM_FastLogistic2.dcoeff = new double[this.dcoeff.length];
        for (int i = 0; i < this.dcoeff.length; ++i) {
            dREM_FastLogistic2.dcoeff[i] = this.dcoeff[i];
        }
        dREM_FastLogistic2.numclasses = this.numclasses;
        dREM_FastLogistic2.numcols = this.numcols;
        dREM_FastLogistic2.numels = this.numels;
        dREM_FastLogistic2.g = this.g;
        dREM_FastLogistic2.dyerror = this.dyerror;
        dREM_FastLogistic2.dipcache = this.dipcache;
        dREM_FastLogistic2.dipcachemulti = this.dipcachemulti;
        dREM_FastLogistic2.numrows = this.traindata.length;
        dREM_FastLogistic2.B = this.B;
        return dREM_FastLogistic2;
    }

    public void setRidge(double d) {
        this.dridge = d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Coefficients: ");
        if (this.dcoeff == null) {
            stringBuffer.append("Not initialized yet!");
        } else {
            for (int i = 0; i < this.dcoeff.length; ++i) {
                stringBuffer.append("(" + i + "," + this.dcoeff[i] + ")\t");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String saveClassifier(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.dcoeff.length; ++i) {
            if (i % (stringArray.length + 1) == 0) {
                stringBuffer.append("INTERCEPT\t" + this.dcoeff[i]);
            } else {
                stringBuffer.append(stringArray[i % (stringArray.length + 1) - 1] + "\t" + this.dcoeff[i]);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void reinit(int[][] nArray, double[][] dArray, int[][] nArray2, double[][] dArray2, int[] nArray3, double[] dArray3, int n, int[] nArray4) {
        this.traindataindex = nArray;
        this.traindata = dArray;
        this.traindataTFindex = nArray2;
        this.traindataTF = dArray2;
        this.numrows = dArray.length;
        this.y = nArray3;
        this.regulatorTypes = nArray4;
        if (this.dtrainweight == null || this.dtrainweight.length != dArray3.length) {
            this.dyerror = new double[dArray3.length];
            if (n == 2) {
                this.dipcache = new double[dArray3.length];
            } else {
                this.dipcachemulti = new double[n - 1][dArray3.length];
            }
        }
        this.dtrainweight = dArray3;
        if (this.numclasses != n) {
            this.numclasses = n;
            this.numels = (n - 1) * this.numcols;
            this.dcoeff = new double[this.numels];
            this.g = new double[this.numels];
        }
    }

    public double soft(double d, double d2) {
        double d3 = Math.abs(d) - d2;
        if (d3 <= 0.0) {
            return 0.0;
        }
        if (d >= 0.0) {
            return d3;
        }
        return -d3;
    }

    public double unidirectionalsoft(double d, double d2, int n) {
        double d3 = Math.abs(d) - d2;
        if (n == -1) {
            if (d3 >= 0.0 || d < 0.0) {
                return 0.0;
            }
            return -d3;
        }
        if (d3 >= 0.0 || d > 0.0) {
            return 0.0;
        }
        return d3;
    }

    private void fillMultiCache() {
        int n = this.numclasses - 1;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.traindata.length; ++i) {
            double[] dArray = this.traindata[i];
            for (int j = 0; j < n; ++j) {
                int n2 = j * this.numcols;
                double d3 = this.dcoeff[n2];
                for (int k = 0; k < this.traindataindex[i].length; ++k) {
                    int n3 = this.traindataindex[i][k];
                    d3 += dArray[k] * this.dcoeff[n3 + n2 + 1];
                }
                if (d != d3) {
                    d2 = Math.exp(d3);
                    d = d3;
                }
                this.dipcachemulti[j][i] = d2;
            }
        }
    }

    public double p(int n, int n2) {
        double d;
        double d2;
        if (n == this.numclasses - 1) {
            d2 = 1.0;
            d = 1.0;
        } else {
            d2 = this.dipcachemulti[n][n2];
            d = 1.0 + d2;
        }
        for (int i = 0; i < this.numclasses - 1; ++i) {
            if (n == i) continue;
            d += this.dipcachemulti[i][n2];
        }
        double d3 = d2 / d;
        return d3;
    }

    public void computeG(int n, boolean bl, boolean bl2) {
        int n2 = this.numclasses - 1;
        int n3 = n % this.numcols;
        if (bl || n3 == 0) {
            this.g[n] = 0.0;
            if (n3 == 0) {
                double d = Double.POSITIVE_INFINITY;
                double d2 = Double.POSITIVE_INFINITY;
                int n4 = n / this.numcols;
                for (int i = 0; i < this.traindata.length; ++i) {
                    double[] dArray = this.traindata[i];
                    for (int j = 0; j < n2; ++j) {
                        int n5 = j * this.numcols;
                        double d3 = this.dcoeff[n5];
                        for (int k = 0; k < this.traindataindex[i].length; ++k) {
                            int n6 = this.traindataindex[i][k];
                            d3 += dArray[k] * this.dcoeff[n6 + n5 + 1];
                        }
                        if (d != d3) {
                            d2 = Math.exp(d3);
                            d = d3;
                        }
                        this.dipcachemulti[j][i] = d2;
                    }
                    double d4 = this.p(n4, i);
                    this.dyerror[i] = this.y[i] == n4 ? this.dtrainweight[i] * (1.0 - d4) : -this.dtrainweight[i] * d4;
                    int n7 = n;
                    this.g[n7] = this.g[n7] + this.dyerror[i];
                }
            } else {
                int n8 = n / this.numcols;
                if (n3 == 1) {
                    int n9;
                    double d = this.dcoeff[n - 1] - this.doldcoeff;
                    double d5 = Math.exp(d);
                    for (n9 = 0; n9 < this.traindata.length; ++n9) {
                        double[] dArray = this.dipcachemulti[n8];
                        int n10 = n9;
                        dArray[n10] = dArray[n10] * d5;
                        double d6 = this.p(n8, n9);
                        this.dyerror[n9] = this.y[n9] == n8 ? this.dtrainweight[n9] * (1.0 - d6) : -this.dtrainweight[n9] * d6;
                    }
                    for (n9 = 0; n9 < this.traindataTFindex[0].length; ++n9) {
                        int n11 = n;
                        this.g[n11] = this.g[n11] + this.dyerror[this.traindataTFindex[0][n9]] * this.traindataTF[0][n9];
                    }
                } else {
                    int n12;
                    int n13 = n - 1;
                    int n14 = n3 - 1;
                    int n15 = n3 - 2;
                    double d = this.dcoeff[n13] - this.doldcoeff;
                    double d7 = Math.exp(d);
                    for (n12 = 0; n12 < this.traindataTFindex[n15].length; ++n12) {
                        double d8;
                        int n16 = this.traindataTFindex[n15][n12];
                        if (this.traindataTF[n15][n12] == 1.0) {
                            double[] dArray = this.dipcachemulti[n8];
                            int n17 = n16;
                            dArray[n17] = dArray[n17] * d7;
                        } else if (this.traindataTF[n15][n12] == -1.0) {
                            double[] dArray = this.dipcachemulti[n8];
                            int n18 = n16;
                            dArray[n18] = dArray[n18] / d7;
                        } else {
                            d8 = d * this.traindataTF[n15][n12];
                            double[] dArray = this.dipcachemulti[n8];
                            int n19 = n16;
                            dArray[n19] = dArray[n19] * Math.exp(d8);
                        }
                        d8 = this.p(n8, n16);
                        this.dyerror[n16] = this.y[n16] == n8 ? this.dtrainweight[n16] * (1.0 - d8) : -this.dtrainweight[n16] * d8;
                    }
                    for (n12 = 0; n12 < this.traindataTFindex[n14].length; ++n12) {
                        int n20 = n;
                        this.g[n20] = this.g[n20] + this.dyerror[this.traindataTFindex[n14][n12]] * this.traindataTF[n14][n12];
                    }
                }
            }
        } else {
            this.g[n] = 0.0;
            if (n3 == 0) {
                for (int i = 0; i < this.traindata.length; ++i) {
                    int n21 = n;
                    this.g[n21] = this.g[n21] + this.dyerror[i];
                }
            } else {
                int n22 = n3 - 1;
                for (int i = 0; i < this.traindataTFindex[n22].length; ++i) {
                    int n23 = n;
                    this.g[n23] = this.g[n23] + this.dyerror[this.traindataTFindex[n22][i]] * this.traindataTF[n22][i];
                }
            }
        }
        if (Double.isNaN(this.g[n])) {
            System.out.println("computeG\t" + this.g[n] + "\t" + this.dcoeff[n] + "\t" + this.dridge + "\t" + n + "\t" + bl + "\t" + bl2);
        }
    }

    public void computeGbin(int n, boolean bl, boolean bl2) {
        int n2 = this.numcols - 2;
        if (bl) {
            this.g[n] = 0.0;
            if (n == 0) {
                if (bl2) {
                    double d = Double.POSITIVE_INFINITY;
                    double d2 = Double.POSITIVE_INFINITY;
                    for (int i = 0; i < this.traindata.length; ++i) {
                        double d3 = this.dcoeff[0];
                        double[] dArray = this.traindata[i];
                        int[] nArray = this.traindataindex[i];
                        for (int j = 0; j < nArray.length; ++j) {
                            int n3 = nArray[j];
                            d3 += dArray[j] * this.dcoeff[n3 + 1];
                        }
                        if (d != d3) {
                            d2 = Math.exp(d3);
                            d = d3;
                        }
                        this.dipcache[i] = d2;
                        double d4 = d2 / (1.0 + d2);
                        this.dyerror[i] = this.y[i] == 0 ? this.dtrainweight[i] * (1.0 - d4) : -this.dtrainweight[i] * d4;
                        this.g[0] = this.g[0] + this.dyerror[i];
                    }
                } else {
                    double d = this.dcoeff[this.dcoeff.length - 1] - this.doldcoeff;
                    double d5 = Math.exp(d);
                    int n4 = 0;
                    for (int i = 0; i < this.traindataTFindex[n2].length; ++i) {
                        double d6;
                        int n5 = this.traindataTFindex[n2][i];
                        while (n4 < n5) {
                            this.g[0] = this.g[0] + this.dyerror[n4];
                            ++n4;
                        }
                        ++n4;
                        if (this.traindataTF[n2][i] == 1.0) {
                            int n6 = n5;
                            this.dipcache[n6] = this.dipcache[n6] * d5;
                        } else if (this.traindataTF[n2][i] == -1.0) {
                            int n7 = n5;
                            this.dipcache[n7] = this.dipcache[n7] / d5;
                        } else {
                            d6 = d * this.traindataTF[n2][i];
                            int n8 = n5;
                            this.dipcache[n8] = this.dipcache[n8] * Math.exp(d6);
                        }
                        d6 = this.dipcache[n5];
                        double d7 = d6 / (1.0 + d6);
                        this.dyerror[n5] = this.y[n5] == 0 ? this.dtrainweight[n5] * (1.0 - d7) : -this.dtrainweight[n5] * d7;
                        this.g[0] = this.g[0] + this.dyerror[n5];
                    }
                    while (n4 < this.traindata.length) {
                        this.g[0] = this.g[0] + this.dyerror[n4];
                        ++n4;
                    }
                }
            } else if (n == 1) {
                int n9;
                double d = this.dcoeff[0] - this.doldcoeff;
                double d8 = Math.exp(d);
                for (n9 = 0; n9 < this.traindata.length; ++n9) {
                    int n10 = n9;
                    this.dipcache[n10] = this.dipcache[n10] * d8;
                    double d9 = this.dipcache[n9];
                    double d10 = d9 / (1.0 + d9);
                    this.dyerror[n9] = this.y[n9] == 0 ? this.dtrainweight[n9] * (1.0 - d10) : -this.dtrainweight[n9] * d10;
                }
                for (n9 = 0; n9 < this.traindataTFindex[0].length; ++n9) {
                    int n11 = n;
                    this.g[n11] = this.g[n11] + this.dyerror[this.traindataTFindex[0][n9]] * this.traindataTF[0][n9];
                }
            } else {
                int n12;
                int n13 = n - 2;
                int n14 = n - 1;
                double d = this.dcoeff[n14] - this.doldcoeff;
                double d11 = Math.exp(d);
                for (n12 = 0; n12 < this.traindataTFindex[n13].length; ++n12) {
                    double d12;
                    int n15 = this.traindataTFindex[n13][n12];
                    if (this.traindataTF[n13][n12] == 1.0) {
                        int n16 = n15;
                        this.dipcache[n16] = this.dipcache[n16] * d11;
                    } else if (this.traindataTF[n13][n12] == -1.0) {
                        int n17 = n15;
                        this.dipcache[n17] = this.dipcache[n17] / d11;
                    } else {
                        d12 = d * this.traindataTF[n13][n12];
                        int n18 = n15;
                        this.dipcache[n18] = this.dipcache[n18] * Math.exp(d12);
                    }
                    d12 = this.dipcache[n15];
                    double d13 = d12 / (1.0 + d12);
                    this.dyerror[n15] = this.y[n15] == 0 ? this.dtrainweight[n15] * (1.0 - d13) : -this.dtrainweight[n15] * d13;
                }
                for (n12 = 0; n12 < this.traindataTFindex[n14].length; ++n12) {
                    int n19 = n;
                    this.g[n19] = this.g[n19] + this.dyerror[this.traindataTFindex[n14][n12]] * this.traindataTF[n14][n12];
                }
            }
        } else {
            this.g[n] = 0.0;
            if (n == 0) {
                for (int i = 0; i < this.traindata.length; ++i) {
                    this.g[0] = this.g[0] + this.dyerror[i];
                }
            } else {
                int n20 = n - 1;
                for (int i = 0; i < this.traindataTFindex[n20].length; ++i) {
                    int n21 = n;
                    this.g[n21] = this.g[n21] + this.dyerror[this.traindataTFindex[n20][i]] * this.traindataTF[n20][i];
                }
            }
        }
        if (Double.isNaN(this.g[n])) {
            System.out.println("computeG\t" + this.g[n] + "\t" + this.dcoeff[n] + "\t" + (this.dcoeff[n - 1] - this.doldcoeff) + "\t" + this.dridge + "\t" + n + "\t" + bl + "\t" + bl2);
        }
    }

    public boolean nextw(int n, boolean bl, boolean bl2) {
        this.computeG(n, bl, bl2);
        this.doldcoeff = this.dcoeff[n];
        int n2 = n % this.numcols;
        this.dcoeff[n] = this.B[n2] == 0.0 ? 0.0 : (n % this.numcols == 0 ? this.dcoeff[n] - this.g[n] / this.B[n2] : (this.regulatorTypes[n2 - 1] == 0 ? this.soft(this.dcoeff[n] - this.g[n] / this.B[n2], -this.dridge / this.B[n2]) : this.unidirectionalsoft(this.dcoeff[n] - this.g[n] / this.B[n2], -this.dridge / this.B[n2], 1)));
        if (Math.abs(this.dcoeff[n]) > 10.0) {
            this.dcoeff[n] = 0.0;
        }
        if (Double.isNaN(this.dcoeff[n])) {
            System.out.println("nextw\t" + this.dcoeff[n] + "\t" + this.g[n] + "\t" + this.B[n2] + "\t" + this.dridge);
        }
        return this.doldcoeff != this.dcoeff[n];
    }

    public boolean nextwbin(int n, boolean bl, boolean bl2) {
        this.computeGbin(n, bl, bl2);
        this.doldcoeff = this.dcoeff[n];
        if (this.B[n] == 0.0) {
            this.dcoeff[n] = 0.0;
        } else if (n == 0) {
            this.dcoeff[n] = this.dcoeff[n] - this.g[n] / this.B[n];
        } else if (this.regulatorTypes[n - 1] == 0) {
            this.dcoeff[n] = this.soft(this.dcoeff[n] - this.g[n] / this.B[n], -this.dridge / this.B[n]);
        } else {
            switch (this.childExpStatus) {
                case -1: {
                    this.dcoeff[n] = this.unidirectionalsoft(this.dcoeff[n] - this.g[n] / this.B[n], -this.dridge / this.B[n], this.childExpStatus);
                    break;
                }
                case 1: {
                    this.dcoeff[n] = this.unidirectionalsoft(this.dcoeff[n] - this.g[n] / this.B[n], -this.dridge / this.B[n], this.childExpStatus);
                    break;
                }
                case 2: {
                    if (this.traindataTF[n - 1][0] < 0.0) {
                        this.dcoeff[n] = this.soft(this.dcoeff[n] - this.g[n] / this.B[n], -this.dridge / this.B[n]);
                        break;
                    }
                    this.dcoeff[n] = 0.0;
                    break;
                }
                case -2: {
                    if (this.traindataTF[n - 1][0] > 0.0) {
                        this.dcoeff[n] = this.soft(this.dcoeff[n] - this.g[n] / this.B[n], -this.dridge / this.B[n]);
                        break;
                    }
                    this.dcoeff[n] = 0.0;
                    break;
                }
                default: {
                    System.out.println("No valid case for childExpStatus in nextwbin");
                    System.exit(1);
                }
            }
        }
        if (Math.abs(this.dcoeff[n]) > 10.0) {
            this.dcoeff[n] = 0.0;
        }
        return this.doldcoeff != this.dcoeff[n];
    }

    private void computeB() {
        int n;
        for (n = 0; n < this.numcols; ++n) {
            this.B[n] = 0.0;
        }
        for (n = 0; n < this.traindataindex.length; ++n) {
            this.B[0] = this.B[0] + this.dtrainweight[n];
            for (int i = 0; i < this.traindataindex[n].length; ++i) {
                int n2 = this.traindataindex[n][i] + 1;
                this.B[n2] = this.B[n2] + this.traindata[n][i] * this.traindata[n][i] * this.dtrainweight[n];
            }
        }
        double d = -0.5 + 0.5 / (double)this.numclasses;
        int n3 = 0;
        while (n3 < this.B.length) {
            int n4 = n3++;
            this.B[n4] = this.B[n4] * d;
        }
    }

    public double[] distributionForInstance(int[] nArray) {
        double[] dArray = new double[this.numclasses];
        if (this.numclasses == 2) {
            double d;
            double d2 = this.dcoeff[0];
            for (int i = 0; i < nArray.length; ++i) {
                d2 += this.dcoeff[i + 1] * (double)nArray[i];
            }
            dArray[0] = d = 1.0 / (1.0 + Math.exp(-d2));
            dArray[1] = 1.0 - d;
        } else {
            int n;
            double d = 1.0;
            int n2 = 0;
            for (n = 0; n < this.numclasses - 1; ++n) {
                double d3;
                double d4 = this.dcoeff[n2];
                ++n2;
                for (int i = 0; i < nArray.length; ++i) {
                    d4 += (double)nArray[i] * this.dcoeff[n2];
                    ++n2;
                }
                dArray[n] = d3 = Math.exp(d4);
                d += d3;
            }
            n = 0;
            while (n < dArray.length - 1) {
                int n3 = n++;
                dArray[n3] = dArray[n3] / d;
            }
            dArray[dArray.length - 1] = 1.0 / d;
        }
        return dArray;
    }

    public double[] distributionForInstance(int[] nArray, double[] dArray) {
        double[] dArray2 = new double[this.numclasses];
        if (this.numclasses == 2) {
            double d;
            double d2 = this.dcoeff[0];
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                d2 += this.dcoeff[n + 1] * dArray[i];
            }
            dArray2[0] = d = 1.0 / (1.0 + Math.exp(-d2));
            dArray2[1] = 1.0 - d;
        } else {
            int n;
            double d = 1.0;
            for (n = 0; n < this.numclasses - 1; ++n) {
                double d3;
                int n2 = n * this.numcols;
                double d4 = this.dcoeff[n2];
                for (int i = 0; i < nArray.length; ++i) {
                    int n3 = nArray[i];
                    d4 += dArray[i] * this.dcoeff[n3 + n2 + 1];
                }
                dArray2[n] = d3 = Math.exp(d4);
                d += d3;
            }
            n = 0;
            while (n < dArray2.length - 1) {
                int n4 = n++;
                dArray2[n4] = dArray2[n4] / d;
            }
            dArray2[dArray2.length - 1] = 1.0 / d;
        }
        return dArray2;
    }

    public void train() {
        if (this.numclasses == 2) {
            this.trainbin();
        } else {
            this.trainmulti();
        }
    }

    public void trainmulti() {
        double d;
        int n;
        this.computeB();
        this.fillMultiCache();
        double d2 = 0.0;
        for (n = 0; n < this.numrows; ++n) {
            d = this.p(this.y[n], n);
            d2 += this.dtrainweight[n] * Math.log(d);
        }
        n = 0;
        boolean bl = true;
        do {
            boolean bl2 = true;
            for (int i = 0; i < this.numels; ++i) {
                bl2 = this.nextw(i, bl2, bl);
            }
            double d3 = 0.0;
            for (int i = 0; i < this.numrows; ++i) {
                double d4 = this.p(this.y[i], i);
                d3 += this.dtrainweight[i] * Math.log(d4);
            }
            d = Math.abs(d2 - d3) / Math.abs(d3);
            d2 = d3;
        } while (d > 0.01 && ++n <= 1000);
    }

    public void trainbin() {
        int n;
        double d;
        int n2;
        this.computeB();
        double d2 = 0.0;
        for (n2 = 0; n2 < this.numrows; ++n2) {
            d = this.dcoeff[0];
            for (int i = 0; i < this.traindataindex[n2].length; ++i) {
                n = this.traindataindex[n2][i];
                d += this.traindata[n2][i] * this.dcoeff[n + 1];
            }
            double d3 = 1.0 / (1.0 + Math.exp(-d));
            if (this.y[n2] == 1) {
                d2 += this.dtrainweight[n2] * Math.log(1.0 - d3);
                continue;
            }
            d2 += this.dtrainweight[n2] * Math.log(d3);
        }
        n2 = 0;
        boolean bl = true;
        do {
            n = 1;
            for (int i = 0; i < this.numcols; ++i) {
                n = this.nextwbin(i, n != 0, bl);
            }
            bl = false;
            double d4 = 0.0;
            for (int i = 0; i < this.numrows; ++i) {
                double d5 = this.dcoeff[0];
                double[] dArray = this.traindata[i];
                int[] nArray = this.traindataindex[i];
                for (int j = 0; j < nArray.length; ++j) {
                    int n3 = nArray[j];
                    d5 += dArray[j] * this.dcoeff[n3 + 1];
                }
                double d6 = 1.0 / (1.0 + Math.exp(-d5));
                if (this.y[i] == 1) {
                    d4 += this.dtrainweight[i] * Math.log(1.0 - d6);
                    continue;
                }
                d4 += this.dtrainweight[i] * Math.log(d6);
            }
            d = Math.abs((d2 - d4) / d4);
            d2 = d4;
        } while (d > 0.01 && ++n2 <= 1000);
    }
}

