/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.drem;

import edu.cmu.cs.sb.drem.DREMGui;
import edu.cmu.cs.sb.drem.DREM_Timeiohmm;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DREMGui_SaveModel
extends JPanel {
    static final String SYN_FILE = "../testData/binding/SGD_standardToOrf.txt";
    private static HashMap<String, String> synMap = null;
    static final Color bgColor = Color.white;
    static final Color fgColor = Color.black;
    final DREM_Timeiohmm theTimeiohmm;
    final DREM_Timeiohmm.Treenode treecopy;
    final JFileChooser theChooser;

    public DREMGui_SaveModel(final DREM_Timeiohmm dREM_Timeiohmm, final DREM_Timeiohmm.Treenode treenode, final JFrame jFrame, final DREMGui dREMGui) {
        this.theTimeiohmm = dREM_Timeiohmm;
        this.treecopy = treenode;
        this.setLayout(new BoxLayout(this, 3));
        this.setForeground(fgColor);
        this.theChooser = new JFileChooser();
        this.add(this.theChooser);
        this.theChooser.setDialogType(1);
        this.theChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("CancelSelection")) {
                    jFrame.setVisible(false);
                    jFrame.dispose();
                } else if (string.equals("ApproveSelection")) {
                    File file = DREMGui_SaveModel.this.theChooser.getSelectedFile();
                    try {
                        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                        printWriter.print(dREM_Timeiohmm.saveString(treenode));
                        printWriter.println("COLORS");
                        printWriter.print(dREMGui.saveColors());
                        printWriter.close();
                        DREMGui_SaveModel.saveActivityScoresDynamic(file, dREM_Timeiohmm, treenode);
                        DREMGui_SaveModel.saveActivityScores(file, dREM_Timeiohmm);
                    }
                    catch (IOException iOException) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                JOptionPane.showMessageDialog(null, iOException.getMessage(), "Exception thrown", 0);
                            }
                        });
                        iOException.printStackTrace(System.out);
                    }
                    dREMGui.bsavedchange = true;
                    jFrame.setVisible(false);
                    jFrame.dispose();
                }
            }
        });
    }

    public void batchSave(String string) {
        this.theChooser.setSelectedFile(new File(string + ".model"));
        this.theChooser.approveSelection();
    }

    public static synchronized void saveActivityScores(File file, DREM_Timeiohmm dREM_Timeiohmm) throws IOException {
        if (synMap == null) {
            synMap = DREMGui_SaveModel.loadMap(SYN_FILE, 1, 0, false);
        }
        String string = file.getAbsolutePath() + ".activities";
        PrintWriter printWriter = new PrintWriter(new FileWriter(string));
        String string2 = file.getAbsolutePath() + ".activitiesStd";
        PrintWriter printWriter2 = new PrintWriter(new FileWriter(string2));
        for (int i = 0; i < dREM_Timeiohmm.bindingData.regNames.length; ++i) {
            String string3;
            double d = dREM_Timeiohmm.dMaxTFActivityScore[i];
            String string4 = string3 = dREM_Timeiohmm.bindingData.regNames[i].toUpperCase();
            if (synMap != null && synMap.containsKey(string3)) {
                String string5 = synMap.get(string3);
                if (string5.contains("|")) {
                    string5 = string5.substring(0, string5.indexOf(124));
                }
                string3 = string5;
            }
            printWriter.println(string3 + "\t" + d);
            printWriter2.println(string4 + "\t" + d);
        }
        printWriter.close();
        printWriter2.close();
    }

    public static synchronized void saveActivityScoresDynamic(File file, DREM_Timeiohmm dREM_Timeiohmm, DREM_Timeiohmm.Treenode treenode) throws IOException {
        if (synMap == null) {
            synMap = DREMGui_SaveModel.loadMap(SYN_FILE, 1, 0, false);
        }
        String string = file.getAbsolutePath() + ".activitiesDynamic";
        PrintWriter printWriter = new PrintWriter(new FileWriter(string));
        printWriter.print(dREM_Timeiohmm.saveActivityScores(treenode));
        printWriter.close();
    }

    private static synchronized HashMap<String, String> loadMap(String string, int n, int n2, boolean bl) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (bl) {
                bufferedReader.readLine();
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split("\t");
                if (stringArray.length > Math.max(n, n2)) {
                    String string3 = stringArray[n].toUpperCase();
                    String string4 = stringArray[n2].toUpperCase();
                    if (string4.equals("-") || string4.equals("")) continue;
                    if (hashMap.containsKey(string3)) {
                        String string5 = hashMap.get(string3);
                        hashMap.put(string3, string5 + "|" + string4);
                        continue;
                    }
                    hashMap.put(string3, string4);
                    continue;
                }
                System.err.println("Not enough columns: " + string2);
            }
            bufferedReader.close();
            return hashMap;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

