/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.drem;

import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.drem.DREMGui;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DREMGui_InterfaceOptions
extends JPanel
implements ChangeListener,
ItemListener,
ActionListener {
    static final Color bgColor = Color.white;
    static final Color fgColor = Color.black;
    JSlider theSlider;
    JSlider theSliderX;
    JSlider theColorSlider;
    JSlider theNodeSlider;
    JFrame theFrame;
    JButton hideButton;
    Hashtable theDictionary;
    DREMGui theDREMGui;
    JLabel pvalLabel;
    JLabel pvalLabelX;
    JLabel nodeLabel;
    JCheckBox attachBox;
    ButtonGroup group = new ButtonGroup();
    JRadioButton uniformButton;
    JRadioButton realButton;
    ButtonGroup autogroup = new ButtonGroup();
    JRadioButton holdButton;
    JRadioButton autoButton;

    public DREMGui_InterfaceOptions(JFrame jFrame, DREMGui dREMGui) {
        this.theFrame = jFrame;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bgColor);
        this.setForeground(fgColor);
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("Gene colors should be based on edge:");
        jPanel.setBackground(new Color(0.0f, 1.0f, 0.0f, 0.4f));
        jPanel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        this.add(jPanel);
        int n = dREMGui.theTimeiohmm.theDataSet.data[0].length - 1;
        this.theColorSlider = new JSlider(0, n, dREMGui.ncolortime);
        this.theDictionary = new Hashtable();
        this.theDictionary.put(new Integer(0), new JLabel("Rand."));
        for (int i = 1; i <= n; ++i) {
            this.theDictionary.put(new Integer(i), new JLabel("" + i));
        }
        this.theColorSlider.setLabelTable(this.theDictionary);
        this.theColorSlider.setMinimumSize(new Dimension(800, 600));
        this.theColorSlider.setMajorTickSpacing(1);
        this.theColorSlider.setSnapToTicks(true);
        this.theColorSlider.setPaintTicks(true);
        this.theColorSlider.setPaintLabels(true);
        this.theColorSlider.addChangeListener(this);
        this.theColorSlider.setPaintTicks(true);
        this.theColorSlider.setAlignmentX(0.0f);
        this.add(this.theColorSlider);
        this.autogroup = new ButtonGroup();
        this.holdButton = new JRadioButton("Hold Fixed");
        this.autoButton = new JRadioButton("Automatically Adjust");
        this.autogroup.add(this.holdButton);
        this.autogroup.add(this.autoButton);
        if (dREMGui.bholdedge) {
            this.holdButton.setSelected(true);
        } else {
            this.autoButton.setSelected(true);
        }
        this.holdButton.setBackground(Color.white);
        this.autoButton.setBackground(Color.white);
        this.holdButton.addItemListener(this);
        this.autoButton.addItemListener(this);
        this.add(this.holdButton);
        this.add(this.autoButton);
        JLabel jLabel2 = new JLabel("             Scale Y-axis by the factor:              ");
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add(jLabel2);
        jPanel2.setBackground(new Color(0.0f, 1.0f, 0.0f, 0.4f));
        this.add(jPanel2);
        this.theSlider = new JSlider(0, 100, (int)(dREMGui.dscaley * 10.0));
        this.theDictionary = new Hashtable();
        for (int i = 0; i <= 10; ++i) {
            this.theDictionary.put(new Integer(i * 10), new JLabel("" + i));
        }
        this.theSlider.setLabelTable(this.theDictionary);
        this.theSlider.setMinimumSize(new Dimension(800, 600));
        this.theDREMGui = dREMGui;
        this.theSlider.setMajorTickSpacing(10);
        this.theSlider.setMinorTickSpacing(2);
        this.theSlider.setPaintTicks(true);
        this.theSlider.setPaintLabels(true);
        this.theSlider.addChangeListener(this);
        this.theSlider.setPaintTicks(true);
        this.theSlider.setAlignmentX(0.0f);
        this.add(this.theSlider);
        JPanel jPanel3 = new JPanel();
        this.pvalLabel = new JLabel("Y-axis scale factor is " + DREMGui_InterfaceOptions.doubleToSz(dREMGui.dscaley));
        jPanel3.setAlignmentX(0.0f);
        jPanel3.add(this.pvalLabel);
        jPanel3.setBackground(Color.white);
        this.add(jPanel3);
        JLabel jLabel3 = new JLabel("             Scale X-axis by the factor:              ");
        JPanel jPanel4 = new JPanel();
        jPanel4.setAlignmentX(0.0f);
        jPanel4.add(jLabel3);
        jPanel4.setBackground(new Color(0.0f, 1.0f, 0.0f, 0.4f));
        this.add(jPanel4);
        this.theSliderX = new JSlider(0, 100, (int)(dREMGui.dscalex * 10.0));
        this.theSliderX.setLabelTable(this.theDictionary);
        this.theSliderX.setMinimumSize(new Dimension(800, 600));
        this.theSliderX.setMajorTickSpacing(10);
        this.theSliderX.setMinorTickSpacing(2);
        this.theSliderX.setPaintTicks(true);
        this.theSliderX.setPaintLabels(true);
        this.theSliderX.addChangeListener(this);
        this.theSliderX.setPaintTicks(true);
        this.theSliderX.setAlignmentX(0.0f);
        this.add(this.theSliderX);
        JPanel jPanel5 = new JPanel();
        this.pvalLabelX = new JLabel("X-axis scale factor is " + DREMGui_InterfaceOptions.doubleToSz(dREMGui.dscalex));
        jPanel5.setAlignmentX(0.0f);
        jPanel5.add(this.pvalLabelX);
        jPanel5.setBackground(Color.white);
        this.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBackground(new Color(0.0f, 1.0f, 0.0f, 0.4f));
        this.add(jPanel6);
        JLabel jLabel4 = new JLabel("           X-axis scale should be:            ");
        this.add(jLabel4);
        this.group = new ButtonGroup();
        this.realButton = new JRadioButton("Based on Real Time");
        this.uniformButton = new JRadioButton("Uniform");
        this.group.add(this.realButton);
        this.group.add(this.uniformButton);
        if (dREMGui.brealXaxis) {
            this.realButton.setSelected(true);
        } else {
            this.uniformButton.setSelected(true);
        }
        if (dREMGui.binvalidreal) {
            this.realButton.setEnabled(false);
        }
        this.uniformButton.setBackground(Color.white);
        this.realButton.setBackground(Color.white);
        this.uniformButton.addItemListener(this);
        this.realButton.addItemListener(this);
        this.add(this.uniformButton);
        this.add(this.realButton);
        JLabel jLabel5 = new JLabel("             Scale node areas by the factor:              ");
        JPanel jPanel7 = new JPanel();
        jPanel7.setAlignmentX(0.0f);
        jPanel7.add(jLabel5);
        jPanel7.setBackground(new Color(0.0f, 1.0f, 0.0f, 0.4f));
        this.add(jPanel7);
        this.theNodeSlider = new JSlider(0, 50, (int)(dREMGui.dnodek * 10.0));
        this.theNodeSlider.setLabelTable(this.theDictionary);
        this.theNodeSlider.setMinimumSize(new Dimension(800, 600));
        this.theNodeSlider.setMajorTickSpacing(10);
        this.theNodeSlider.setMinorTickSpacing(1);
        this.theNodeSlider.setPaintTicks(true);
        this.theNodeSlider.setPaintLabels(true);
        this.theNodeSlider.addChangeListener(this);
        this.theNodeSlider.setPaintTicks(true);
        this.theNodeSlider.setAlignmentX(0.0f);
        this.add(this.theNodeSlider);
        JPanel jPanel8 = new JPanel();
        this.nodeLabel = new JLabel("Node area scale factor is " + DREMGui_InterfaceOptions.doubleToSz(dREMGui.dnodek));
        jPanel8.setAlignmentX(0.0f);
        jPanel8.add(this.nodeLabel);
        jPanel8.setBackground(Color.white);
        this.add(jPanel8);
        JPanel jPanel9 = new JPanel();
        jPanel9.setBackground(new Color(0.0f, 1.0f, 0.0f, 0.4f));
        this.add(jPanel9);
        this.attachBox = new JCheckBox("Hide All Labels When Hiding Nodes");
        this.attachBox.setBackground(Color.white);
        this.attachBox.setSelected(dREMGui.battachlabels);
        this.attachBox.addActionListener(this);
        JPanel jPanel10 = new JPanel();
        jPanel10.setBackground(Color.white);
        jPanel10.add(this.attachBox);
        JButton jButton = new JButton(Util.createImageIcon("Help16.gif"));
        jButton.addActionListener(this);
        jButton.setActionCommand("help");
        jPanel10.add(jButton);
        jPanel10.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        jPanel10.setAlignmentX(0.0f);
        this.add(jPanel10);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.theDREMGui.battachlabels = this.attachBox.isSelected();
        String string = actionEvent.getActionCommand();
        if (string.equals("help")) {
            String string2 = "The first option is 'Gene colors should be based on edge' determines the color of the time series on the main interface. By default all time series have random colors. If this parameter is set to 1, then the time series of the genes have the same color as the edge between time point 0 and the next time point of the path on the DREM map to which the genes were assigned. In general if the parameter is set to i every time series has the same color as the ith edge of the path to which it is assigned in the DREM map. The next option determines whether DREM should 'Hold Fixed' the Gene colors should be based on edge parameter value or 'Automatically Adjust' it based on the edge or a node of the DREM map a user clicked. If 'Automatically Adjust' is selected the value of the parameter will be set to correspond to the node or edge the user clicked on.  The next two options,' Scale Y-axis by the factor' and 'Scale X-axis by the factor', allow one to adjust the y-scale and x-scale of the main window. The default scale for the x and y-axes are multiplied proportional to the value of this parameter.  The 'X-axis scale should be' option can either be set to 'Uniform' in which case each time point is uniformly spaced on the screen independent of the real sampling rate or it can be 'Based on Real Time' in which case the spacing of time points is based proportional to the sampling rate.  The 'Scale node areas by the factor' slider allows a user to scale the area of the nodes on the main interface proportional to the value of this parameter. Each individual node will continue to have an area proportional to the standard deviation of the distribution of genes associated with it.  The final option 'Hide All Labels When Hiding Nodes' determines if the labels are also hidden when a user presses the 'Hide Nodes' button on the main interface. If the box is not checked then just the nodes and edges will be hidden, but not the labels.";
            Util.renderDialog(this.theFrame, string2, -350, -100);
        }
        if (this.theDREMGui.battachlabels && !this.theDREMGui.bglobalnode) {
            this.theDREMGui.hidelabels();
        } else if (!this.theDREMGui.battachlabels) {
            this.theDREMGui.showlabels();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.theDREMGui.brealXaxis = this.realButton.isSelected();
        this.theDREMGui.bholdedge = this.holdButton.isSelected();
        this.theDREMGui.drawmain();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (!jSlider.getValueIsAdjusting()) {
            if (jSlider == this.theSlider) {
                this.theDREMGui.dscaley = (double)jSlider.getValue() / 10.0;
                this.pvalLabel.setText("Y-axis scale factor is " + DREMGui_InterfaceOptions.doubleToSz(this.theDREMGui.dscaley));
                this.theDREMGui.drawmain();
            } else if (jSlider == this.theSliderX) {
                this.theDREMGui.dscalex = (double)jSlider.getValue() / 10.0;
                this.pvalLabelX.setText("X-axis scale factor is " + DREMGui_InterfaceOptions.doubleToSz(this.theDREMGui.dscalex));
                this.theDREMGui.drawmain();
            } else if (jSlider == this.theNodeSlider) {
                this.theDREMGui.dnodek = (double)jSlider.getValue() / 10.0;
                this.nodeLabel.setText("Node area scale factor " + DREMGui_InterfaceOptions.doubleToSz(this.theDREMGui.dnodek));
                this.theDREMGui.drawmain();
            } else if (jSlider == this.theColorSlider) {
                this.theDREMGui.ncolortime = jSlider.getValue();
                this.theDREMGui.setGeneColors();
            }
        }
    }

    public static String doubleToSz(double d) {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(1);
        numberFormat.setMaximumFractionDigits(1);
        String string = numberFormat.format(d);
        return string;
    }
}

