/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.drem;

import edu.cmu.cs.sb.core.TableModelST;
import edu.cmu.cs.sb.core.TableSorter;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.drem.DREMGui_StaticSummaryTable;
import edu.cmu.cs.sb.drem.DREM_DataSet;
import edu.cmu.cs.sb.drem.DREM_IO;
import edu.cmu.cs.sb.drem.DREM_Timeiohmm;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;

public class DREMGui_GeneTable
extends JPanel
implements ActionListener,
ChangeListener {
    DREM_DataSet theDataSet;
    int ntabledatasize;
    String[] columnNames;
    String[][] tabledata;
    double[][] maxUnionBindingData;
    int[][] maxUnionBindingIndex;
    double[][][] bindingpval;
    int[][][] bindingpvalIndex;
    double[][][] bindingpvalTF;
    int[][][] bindingpvalTFIndex;
    double[] davg;
    double[] dstd;
    String[] tfNames;
    JTable theTable;
    JScrollPane scrollPane;
    JButton saveButton;
    JButton staticButton;
    JButton copyButton;
    JButton savenamesButton;
    JButton copynamesButton;
    TableSorter sorter;
    static final Color bgColor = Color.white;
    static final Color fgColor = Color.black;
    JFrame theFrame;
    boolean[] include;
    int timepoint;
    String[] timepoints;
    JSpinner timepointSpinner;
    DREM_Timeiohmm theTimeiohmm;

    public DREMGui_GeneTable(JFrame jFrame, DREM_DataSet dREM_DataSet, DREM_Timeiohmm dREM_Timeiohmm, double[][][] dArray, int[][][] nArray, double[][][] dArray2, int[][][] nArray2, double[][] dArray3, int[][] nArray3, String[] stringArray, boolean[] blArray) {
        this.theFrame = jFrame;
        this.theDataSet = dREM_DataSet;
        this.include = blArray;
        this.bindingpval = dArray;
        this.bindingpvalIndex = nArray;
        this.bindingpvalTF = dArray2;
        this.bindingpvalTFIndex = nArray2;
        this.tfNames = stringArray;
        this.theTimeiohmm = dREM_Timeiohmm;
        this.maxUnionBindingData = dArray3;
        this.maxUnionBindingIndex = nArray3;
        this.geneTableHelper();
    }

    private void geneTableHelper() {
        int n;
        int n2;
        int n3;
        int n4;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bgColor);
        this.setForeground(fgColor);
        this.timepoint = -1;
        int n5 = this.theDataSet.numcols + 2 + this.tfNames.length;
        this.columnNames = new String[n5];
        this.columnNames[0] = this.theDataSet.szGeneHeader;
        this.columnNames[1] = this.theDataSet.szProbeHeader;
        for (n4 = 0; n4 < this.theDataSet.numcols; ++n4) {
            this.columnNames[n4 + 2] = "" + this.theDataSet.dsamplemins[n4];
        }
        n4 = this.theDataSet.numcols + 2;
        for (int i = 0; i < this.tfNames.length; ++i) {
            this.columnNames[n4 + i] = "" + this.tfNames[i];
        }
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        this.ntabledatasize = 0;
        for (n3 = 0; n3 < this.include.length; ++n3) {
            if (!this.include[n3]) continue;
            ++this.ntabledatasize;
        }
        this.tabledata = new String[this.ntabledatasize][this.columnNames.length];
        n3 = 0;
        this.davg = new double[this.theDataSet.numcols];
        this.dstd = new double[this.theDataSet.numcols];
        double[] dArray = new double[this.theDataSet.numcols];
        double[] dArray2 = new double[this.theDataSet.numcols];
        int[] nArray = new int[this.theDataSet.numcols];
        for (n2 = 0; n2 < this.include.length; ++n2) {
            if (!this.include[n2]) continue;
            this.tabledata[n3][0] = this.theDataSet.genenames[n2];
            this.tabledata[n3][1] = this.theDataSet.probenames[n2];
            for (n = 0; n < this.theDataSet.numcols; ++n) {
                if (this.theDataSet.pmavalues[n2][n] == 0) {
                    this.tabledata[n3][n + 2] = "";
                    continue;
                }
                int n6 = n;
                dArray[n6] = dArray[n6] + this.theDataSet.data[n2][n];
                int n7 = n;
                dArray2[n7] = dArray2[n7] + this.theDataSet.data[n2][n] * this.theDataSet.data[n2][n];
                int n8 = n;
                nArray[n8] = nArray[n8] + 1;
                this.tabledata[n3][n + 2] = numberFormat.format(this.theDataSet.data[n2][n]);
            }
            for (n = 0; n < this.tfNames.length; ++n) {
                this.tabledata[n3][n + n4] = "0";
            }
            for (n = 0; n < this.maxUnionBindingData[n2].length; ++n) {
                this.tabledata[n3][this.maxUnionBindingIndex[n2][n] + n4] = "" + this.maxUnionBindingData[n2][n];
            }
            ++n3;
        }
        for (n2 = 0; n2 < this.davg.length; ++n2) {
            this.davg[n2] = dArray[n2] / (double)nArray[n2];
            this.dstd[n2] = Math.sqrt((dArray2[n2] - (double)nArray[n2] * this.davg[n2] * this.davg[n2]) / (double)(nArray[n2] - 1));
        }
        this.sorter = new TableSorter(new TableModelST(this.tabledata, this.columnNames));
        this.theTable = new JTable(this.sorter);
        this.sorter.setTableHeader(this.theTable.getTableHeader());
        this.theTable.setPreferredScrollableViewportSize(new Dimension(800, Math.min((this.theTable.getRowHeight() + this.theTable.getRowMargin()) * this.theTable.getRowCount(), 400)));
        this.theTable.setAutoResizeMode(0);
        TableColumn tableColumn = this.theTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(150);
        tableColumn = this.theTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(100);
        for (n = 0; n < this.theDataSet.numcols; ++n) {
            tableColumn = this.theTable.getColumnModel().getColumn(n + 2);
            tableColumn.setPreferredWidth(45);
        }
        for (n = 0; n < this.tfNames.length; ++n) {
            tableColumn = this.theTable.getColumnModel().getColumn(n + n4);
            tableColumn.setPreferredWidth(45);
        }
        this.scrollPane = new JScrollPane(this.theTable);
        this.add(this.scrollPane);
        JPanel jPanel = new JPanel();
        String string = "Total number of genes selected is " + this.tabledata.length;
        JLabel jLabel = new JLabel(string);
        jPanel.setBackground(Color.white);
        jPanel.add(jLabel);
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        String string2 = "Average expression (" + numberFormat.format(this.davg[0]);
        for (int i = 1; i < this.davg.length; ++i) {
            string2 = string2 + ", " + numberFormat.format(this.davg[i]);
        }
        string2 = string2 + ")";
        JLabel jLabel2 = new JLabel(string2);
        jPanel2.setBackground(Color.white);
        jPanel2.add(jLabel2);
        jPanel2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        String string3 = "Standard Deviation expression (" + numberFormat.format(this.davg[0]);
        for (int i = 1; i < this.davg.length; ++i) {
            string3 = string3 + ", " + numberFormat.format(this.dstd[i]);
        }
        string3 = string3 + ")";
        JLabel jLabel3 = new JLabel(string3);
        jPanel3.setBackground(Color.white);
        jPanel3.add(jLabel3);
        jPanel3.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel3);
        this.copyButton = new JButton("Copy Table", Util.createImageIcon("Copy16.gif"));
        this.copyButton.setActionCommand("copy");
        this.copyButton.setMinimumSize(new Dimension(800, 20));
        this.copyButton.addActionListener(this);
        this.saveButton = new JButton("Save Table", Util.createImageIcon("Save16.gif"));
        this.saveButton.setActionCommand("save");
        this.saveButton.setMinimumSize(new Dimension(800, 20));
        this.saveButton.addActionListener(this);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBackground(Color.white);
        jPanel4.add(this.copyButton);
        jPanel4.add(this.saveButton);
        this.copynamesButton = new JButton("Copy Gene Names", Util.createImageIcon("Copy16.gif"));
        this.copynamesButton.setActionCommand("copynames");
        this.copynamesButton.setMinimumSize(new Dimension(800, 20));
        this.copynamesButton.addActionListener(this);
        this.savenamesButton = new JButton("Save Gene Names", Util.createImageIcon("Save16.gif"));
        this.savenamesButton.setActionCommand("savenames");
        this.savenamesButton.setMinimumSize(new Dimension(800, 20));
        this.savenamesButton.addActionListener(this);
        jPanel4.add(this.copynamesButton);
        jPanel4.add(this.savenamesButton);
        this.staticButton = new JButton("TF Summary");
        this.staticButton.setActionCommand("staticsummary");
        this.staticButton.setMinimumSize(new Dimension(800, 20));
        this.staticButton.addActionListener(this);
        jPanel4.add(this.staticButton);
        JButton jButton = new JButton(Util.createImageIcon("Help16.gif"));
        jButton.addActionListener(this);
        jButton.setActionCommand("help");
        jPanel4.add(jButton);
        jPanel4.add(new JLabel("Timepoint:"));
        this.timepoints = new String[this.theDataSet.numcols + 1];
        for (int i = 1; i < this.timepoints.length; ++i) {
            this.timepoints[i] = "" + (i - 1);
        }
        this.timepoints[0] = "Union";
        this.timepointSpinner = new JSpinner(new SpinnerListModel(this.timepoints));
        this.timepointSpinner.setValue("Union");
        this.timepointSpinner.addChangeListener(this);
        jPanel4.add(this.timepointSpinner);
        jPanel4.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel4);
    }

    public void printFile(PrintWriter printWriter) {
        int n;
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            printWriter.print(this.columnNames[n] + "\t");
        }
        printWriter.println(this.columnNames[this.columnNames.length - 1]);
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                printWriter.print(this.sorter.getValueAt(n, i) + "\t");
            }
            printWriter.println(this.sorter.getValueAt(n, this.columnNames.length - 1));
        }
    }

    public void writeToClipboard() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            stringBuffer.append(this.columnNames[n] + "\t");
        }
        stringBuffer.append(this.columnNames[this.columnNames.length - 1] + "\n");
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                stringBuffer.append(this.sorter.getValueAt(n, i) + "\t");
            }
            stringBuffer.append(this.sorter.getValueAt(n, this.columnNames.length - 1) + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    public void printGeneList(PrintWriter printWriter) {
        for (int i = 0; i < this.tabledata.length; ++i) {
            printWriter.println(this.sorter.getValueAt(i, 0));
        }
    }

    public void writenamesToClipboard() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.tabledata.length; ++i) {
            stringBuffer.append(this.sorter.getValueAt(i, 0) + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("staticsummary")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = "Transcription Factor Summary";
                    JFrame jFrame = new JFrame(string);
                    jFrame.setDefaultCloseOperation(2);
                    jFrame.setLocation(40, 80);
                    DREMGui_StaticSummaryTable dREMGui_StaticSummaryTable = new DREMGui_StaticSummaryTable(DREMGui_GeneTable.this.theFrame, DREMGui_GeneTable.this.theDataSet, DREMGui_GeneTable.this.theTimeiohmm, DREMGui_GeneTable.this.maxUnionBindingData, DREMGui_GeneTable.this.maxUnionBindingIndex, DREMGui_GeneTable.this.tfNames, DREMGui_GeneTable.this.include, DREMGui_GeneTable.this.ntabledatasize);
                    dREMGui_StaticSummaryTable.setOpaque(true);
                    jFrame.setContentPane(dREMGui_StaticSummaryTable);
                    jFrame.pack();
                    jFrame.setVisible(true);
                }
            });
        } else if (string.equals("copy")) {
            this.writeToClipboard();
        } else if (string.equals("copynames")) {
            this.writenamesToClipboard();
        } else if (string.equals("save") || string.equals("savenames")) {
            try {
                int n = DREM_IO.theChooser.showSaveDialog(this);
                if (n == 0) {
                    File file = DREM_IO.theChooser.getSelectedFile();
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                    if (string.equals("save")) {
                        this.printFile(printWriter);
                    } else {
                        this.printGeneList(printWriter);
                    }
                    printWriter.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                final FileNotFoundException fileNotFoundException2 = fileNotFoundException;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, fileNotFoundException2.getMessage(), "Exception thrown", 0);
                    }
                });
                fileNotFoundException.printStackTrace(System.out);
            }
        } else if (string.equals("help")) {
            String string2 = "The table contains the currently displayed genes ";
            String string3 = "";
            if (this.theDataSet.btakelog) {
                string3 = "log base two ";
            }
            string2 = string2 + ".\n\n The first two columns of the table are: \n*  " + this.theDataSet.szGeneHeader + " - The name of the gene.\n" + "*  " + this.theDataSet.szProbeHeader + " - The spot ID(s) associated with the gene.\n" + "The remaining columns contain the " + string3 + "expression change relative to the first time point.\n\n" + "Note:\n" + "+The table can be sorted by any of the columns by clicking on the column's header.\n" + "+Using the 'Save Table' button the entire table can be saved, or just the gene names " + "with the 'Save Gene Names' button.";
            Util.renderDialog(this.theFrame, string2);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int[][] nArray;
        double[][] dArray;
        try {
            this.timepointSpinner.commitEdit();
        }
        catch (ParseException parseException) {
            System.out.println("Please input the index of a timepoint or \"Union\".");
        }
        try {
            this.timepoint = Integer.parseInt((String)this.timepointSpinner.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            this.timepoint = -1;
        }
        int n = 0;
        int n2 = this.theDataSet.numcols + 2;
        if (this.timepoint > 0) {
            dArray = this.bindingpval[this.timepoint];
            nArray = this.bindingpvalIndex[this.timepoint];
        } else {
            dArray = this.maxUnionBindingData;
            nArray = this.maxUnionBindingIndex;
        }
        for (int i = 0; i < this.include.length; ++i) {
            int n3;
            if (!this.include[i]) continue;
            for (n3 = n2; n3 < this.theTable.getColumnCount(); ++n3) {
                this.tabledata[n][n3] = "0";
            }
            for (n3 = 0; n3 < dArray[i].length; ++n3) {
                this.tabledata[n][nArray[i][n3] + n2] = "" + dArray[i][n3];
            }
            ++n;
        }
        this.theTable = new JTable(new TableSorter(new TableModelST(this.tabledata, this.columnNames)));
        this.scrollPane.repaint();
    }
}

